<?php

namespace Application\Form;

use Zend\Form\Form;
use Zend\Form\Element\{Checkbox, Text, Submit, Hidden, Textarea};
use Zend\Validator\{Digits, EmailAddress, NotEmpty, StringLength};
use Zend\InputFilter\InputFilterProviderInterface;

class ContactForm extends Form implements InputFilterProviderInterface {

    public function __construct($name = null) {

        parent::__construct('contact-form');

        /**
         * Name
         */
        $this->add([
            'name' => 'contact_name',
            'type' => Text::class,
            'attributes' => [
                'id' => 'contact-name',
                'placeholder' => 'Name',
                'class' => 'form-control',
                'onkeypress' => "return isAlphaNumber(event)",
                'maxlength' => 35
            ],
            'options' => [
                'label' => 'Name<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         * Email ID
         */
        $this->add([
            'name' => 'contact_email',
            'type' => Text::class,
            'attributes' => [
                'id' => 'contact-email',
                'placeholder' => 'Email',
                'class' => 'form-control'
            ],
            'options' => [
                'label' => 'Email<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         * Mobile No
         */
        $this->add([
            'name' => 'contact_mobile',
            'type' => Text::class,
            'attributes' => [
                'id' => 'contact-mobile',
                'placeholder' => 'Mobile No.',
                'class' => 'form-control',
                'maxlength' =>10,
                'onkeypress'=>'return isNumber(event)'
            ],
            'options' => [
                'label' => 'Mobile No<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         * Company Name
         */
        $this->add([
            'name' => 'contact_comp_name',
            'type' => Text::class,
            'attributes' => [
                'id' => 'contact-comp-name',
                'placeholder' => 'Company Name',
                'class' => 'form-control',
                'onkeypress' => "return isAlphaNumber(event)",
                'maxlength' => 50
            ],
            'options' => [
                'label' => 'Company Name<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         * Subject
         */
        $this->add([
            'name' => 'contact_subject',
            'type' => Text::class,
            'attributes' => [
                'id' => 'contact-subject',
                'placeholder' => 'Subject',
                'class' => 'form-control',
                'onkeypress' => "return isAlphaNumber(event)",
                'maxlength' => 80
            ],
            'options' => [
                'label' => 'Subject<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
                
        /**
         * Message
         */
        $this->add([
            'name' => 'contact_msg',
            'type' => Textarea::class,
            'attributes' => [
                'id' => 'contact-msg',
                'placeholder' => 'Message',
                'class' => 'form-control',
                'rows'=>8,
            ],
            'options' => [
                'label' => 'Message<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);


        /**
         * Guest Submit
         */
        $this->add([
            'name' => 'contact_submit',
            'type' => Submit::class,
            'attributes' => [
                'value' => 'Submit Message',
                'id' => 'contact-submit',
                'class' => 'btn btn-primary btn-lg'
            ],
        ]);

    }

    public function getInputFilterSpecification() {
        return [
            'contact_name' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please enter Name'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'contact_email' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please enter Email Id',
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ],
                    ['name' => 'EmailAddress',
                        'options' => [
                            'messages' => [
                                EmailAddress::INVALID => 'Please enter Valid Email Id',
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'contact_mobile' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please enter Mobile No.'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ],
                    ['name' => 'Digits',
                        'options' => [
                            'messages' => [
                                Digits::NOT_DIGITS => 'Please enter Numeric value only',
                            ],
                        ],
                        'break_chain_on_failure' => true,
                    ],
                    ['name' => 'StringLength',
                        'options' => [
                            'min' => 10,
                            'max' => 10,
                            'messages' => [
                                StringLength::TOO_LONG => 'Please enter Less than 10 Digits',
                                StringLength::TOO_SHORT => 'Please enter greater than 9 Digits',
                            ],
                        ],
                        'break_chain_on_failure' => true
                    ],
                ]
            ],
           'contact_comp_name' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please enter Company Name'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'contact_subject' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please enter Subject'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'contact_msg' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please enter Message'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'g-recaptcha-response' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please enter recaptcha'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ]
        ];
    }

}
