<?php

namespace AirportTransfer\Form;

use Zend\Form\Form;
use Zend\Form\Element\{
    Checkbox,
    Text,
    Submit,
    Hidden
};
use Zend\Validator\{
    Digits,
    EmailAddress,
    NotEmpty,
    StringLength
};
use Zend\InputFilter\InputFilterProviderInterface;

class GuestForm extends Form implements InputFilterProviderInterface {

    public function __construct($name = null) {

        parent::__construct('guest-form');

        /**
         * First Name
         */
        $this->add([
            'name' => 'first_name',
            'type' => Text::class,
            'attributes' => [
                'id' => 'first-name',
                'placeholder' => 'First Name',
                'class' => 'inputMaterial'
            ],
            'options' => [
                'label' => 'First Name<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         * Last Name
         */
        $this->add([
            'name' => 'last_name',
            'type' => Text::class,
            'attributes' => [
                'id' => 'last-name',
                'class' => 'inputMaterial'
            ],
            'options' => [
                'label' => 'Last Name<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         * Email ID
         */
        $this->add([
            'name' => 'email',
            'type' => Text::class,
            'attributes' => [
                'id' => 'email',
                'class' => 'inputMaterial'
            ],
            'options' => [
                'label' => 'Email Id<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         * Mobile No
         */
        $this->add([
            'name' => 'mobile',
            'type' => Text::class,
            'attributes' => [
                'id' => 'mobile',
                'class' => 'inputMaterial'
            ],
            'options' => [
                'label' => 'Mobile No<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         * Alt Mobile No
         */
        $this->add([
            'name' => 'alt_mobile_no',
            'type' => Text::class,
            'attributes' => [
                'id' => 'alt-mobile-no',
                'class' => 'inputMaterial'
            ],
            'options' => [
                'label' => 'Alt Mobile No<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         * GST
         */
        $this->add([
            'name' => 'gst',
            'type' => Checkbox::class,
            'attributes' => [
                'id' => 'gst',
            ],
            'options' => [
                'checked_value' => '1',
                'unchecked_value' => '0',
                'use_hidden_element' => true
            ],
        ]);

        /**
         * GST Registration Number
         */
        $this->add([
            'name' => 'gst_registration_number',
            'type' => Text::class,
            'attributes' => [
                'id' => 'gst-registration-number',
                'class' => 'inputMaterial'
            ],
            'options' => [
                'label' => 'Registration Number<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         * GST Registered Company Name
         */
        $this->add([
            'name' => 'gst_registered_company_name',
            'type' => Text::class,
            'attributes' => [
                'id' => 'gst-registered-company-name',
                'class' => 'inputMaterial'
            ],
            'options' => [
                'label' => 'Registration Company Name<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         * Guest Submit
         */
        $this->add([
            'name' => 'guest-submit',
            'type' => Submit::class,
            'attributes' => [
                'value' => 'Book Now',
                'id' => 'guest-submit',
                'class' => 'btn btn-primary btn-lg guest-submit'
            ],
        ]);

        /**
         * Form Type
         */
        $this->add([
            'name' => 'form_type',
            'type' => Hidden::class,
            'attributes' => [
                'value' => 'guest_form',
                'id' => 'form-type'
            ],
        ]);
    }

    public function getInputFilterSpecification() {
        return [
            'first_name' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please enter First Name'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'last_name' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please enter Last Name'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'email' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please enter Email Id',
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ],
                    ['name' => 'EmailAddress',
                        'options' => [
                            'messages' => [
                                EmailAddress::INVALID => 'Please enter Valid Email Id',
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'mobile' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please enter Mobile No.'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ],
                    ['name' => 'Digits',
                        'options' => [
                            'messages' => [
                                Digits::NOT_DIGITS => 'Please enter Numeric value only',
                            ],
                        ],
                        'break_chain_on_failure' => true,
                    ],
                    ['name' => 'StringLength',
                        'options' => [
                            'min' => 10,
                            'max' => 10,
                            'messages' => [
                                StringLength::TOO_LONG => 'Please enter Less than 10 Digits',
                                StringLength::TOO_SHORT => 'Please enter greater than 9 Digits',
                            ],
                        ],
                        'break_chain_on_failure' => true
                    ],
                ]
            ],
            'alt_mobile_no' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please enter Alt Mobile No.'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ],
                    ['name' => 'Digits',
                        'options' => [
                            'messages' => [
                                Digits::NOT_DIGITS => 'Please enter Numeric value only',
                            ],
                        ],
                        'break_chain_on_failure' => true,
                    ],
                    ['name' => 'StringLength',
                        'options' => [
                            'min' => 10,
                            'max' => 10,
                            'messages' => [
                                StringLength::TOO_LONG => 'Please enter Less than 10 Digits',
                                StringLength::TOO_SHORT => 'Please enter Greater than 9 Digits',
                            ],
                        ],
                        'break_chain_on_failure' => true
                    ],
                ]
            ],
            'gst_registration_number' => [
                'required' => false,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please enter Registration Number'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ],
                ]
            ],
            'gst_registered_company_name' => [
                'required' => false,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please enter Registration Company Name'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ]
        ];
    }

}
