$(function () {
    var dateFormat = "y-m-d",
      from = $( ".from" )
        .datepicker({
          defaultDate: "+1w",
          changeMonth: true,
          numberOfMonths: 1,
          dateFormat: "yy-mm-dd",
        })
        .on( "change", function() {
          to.datepicker( "option", "minDate", getDate( this ) );
        }),
      to = $( ".to" ).datepicker({
        defaultDate: "+1w",
        changeMonth: true,
        numberOfMonths: 1,
        dateFormat: "yy-mm-dd",
      })
      .on( "change", function() {
        from.datepicker( "option", "maxDate", getDate( this ) );
      });
 
    function getDate( element ) {
      var date;
      try {
        date = $.datepicker.parseDate( dateFormat, element.value );
      } catch( error ) {
        date = null;
      }
 
      return date;
    }
    
    
    ////////////////////
    
    var dateFormat1 = "d-m-yy",
      pickup_date = $( "#pickup-date" )
        .datepicker({
          minDate: 0,
          changeYear: true,
          changeMonth: true,
          showOn: "both",
          buttonImage: "/images/b_calendar.png",
          buttonImageOnly: true,
          buttonText: "Select date",
          yearRange: "-100:+20",
          dateFormat: "d-m-yy",
        })
        .on( "change", function() {
          $(this).addClass('test');
          return_date.datepicker( "option", "minDate", getDate1( this ) );
        })
      var return_date = $( "#return-date" ).datepicker({
        //defaultDate: "+1w",
        minDate: 0,
        changeYear: true,
        changeMonth: true,
        yearRange: "-100:+20",
        dateFormat: "d-m-yy",
        showOn: "both",
        buttonImage: "/images/b_calendar.png",
        buttonImageOnly: true,
        buttonText: "Select date"
      })
      .on( "change", function() {
        $(this).addClass('test');
        pickup_date.datepicker( "option", "maxDate", getDate1( this ) );
      });
 
    function getDate1( element ) {
      var date;
      try {
        date = $.datepicker.parseDate( dateFormat1, element.value );
      } catch( error ) {
        date = null;
      }
 
      return date;
    }
    //////////////////
    
    ////////////////////
    var dateFormat2 = "d-m-yy",    
      pickup_date = $( "#pickup-date0" )
        .datepicker({
          minDate: 0,
          changeYear: true,
          changeMonth: true,
          yearRange: "-100:+20",
          dateFormat: "d-m-yy",
          //showOn: "both",
          //buttonImage: "/images/b_calendar.png",
          buttonImageOnly: true,
          buttonText: "Select date"
        })
        .on( "change", function() {
          $(this).addClass('test');
          return_date.datepicker( "option", "minDate", getDate2( this ) );
        })
        var return_date = $( "#pickup-date1" ).datepicker({
        minDate: 0,
        changeYear: true,
        changeMonth: true,
        yearRange: "-100:+20",
        dateFormat: "d-m-yy",
        //showOn: "both",
        //buttonImage: "/images/b_calendar.png",
        buttonImageOnly: true,
        buttonText: "Select date"
      })
      .on( "change", function() {
        //alert(11);
        $(this).addClass('test');
        pickup_date.datepicker( "option", "maxDate", getDate2( this ) );
      });
      
    function getDate2( element ) {
      var date;
      try {
        date = $.datepicker.parseDate( dateFormat2, element.value );
      } catch( error ) {
        date = null;
      }
 
      return date;
    }
    //////////////////
});

///new calendar///////////////

$(function () {
    $(".departuredate").datepicker({
        beforeShow: addCustomInformation,
        //---^----------- if closed by default (when you're using <input>)
        beforeShowDay: function (date) {
            return [true, date.getDay() === 5 || date.getDay() === 6 ? "weekend" : "weekday"];
        },
        onChangeMonthYear: addCustomInformation,
        onSelect: addCustomInformation
    });
    addCustomInformation(); // if open by default (when you're using <div>)


    $(".datepicker").datepicker({
        changeYear: true,
        changeMonth: true,
        showOn: "both",
        buttonImage: "/images/b_calendar.png",
        buttonImageOnly: true,
        buttonText: "Select date",
        minDate: 0,
        yearRange: "-100:+20",
        dateFormat: "d-m-yy",
    });

    $(".date").datepicker({
        changeYear: true,
        changeMonth: true,
        yearRange: "-100:+20",
        dateFormat: "d-m-yy",
        minDate: "01-01-2010",

    });

    $(".dob").datepicker({
        changeYear: true,
        changeMonth: true,
        yearRange: "-69:-16",
        dateFormat: "dd-mm-yy",
        minDate: "01-01-1950",
        maxDate: "31-12-2003",

    });

});
function addCustomInformation() {
    setTimeout(function () {
        $(".ui-datepicker-calendar td").filter(function () {
            var date = $(this).text();
            return /\d/.test(date);
        }).find("a").attr('data-custom', 110); // Add custom data here
    }, 0)
}