/**
 * AdminLTE Demo Menu
 * ------------------
 * You should not use this file in production.
 * This file is for demo purposes only.
 */
(function ($, AdminLTE) {

    "use strict";

    /**
     * List of all the available skins
     *
     * @type Array
     */
    var my_skins = [
        "skin-blue",
        "skin-black",
        "skin-red",
        "skin-yellow",
        "skin-purple",
        "skin-green",
        "skin-blue-light",
        "skin-black-light",
        "skin-red-light",
        "skin-yellow-light",
        "skin-purple-light",
        "skin-green-light"
    ];

    //Create the new tab
    var tab_pane = $("<div />", {
        "id": "control-sidebar-theme-demo-options-tab",
        "class": "tab-pane active"
    });

    //Create the tab button
    var tab_button = $("<li />", {"class": "active"})
            .html("<a href='#control-sidebar-theme-demo-options-tab' data-toggle='tab'>"
                    + "<i class='fa fa-wrench'></i>"
                    + "</a>");

    //Add the tab button to the right sidebar tabs
    $("[href='#control-sidebar-home-tab']")
            .parent()
            .before(tab_button);

    //Create the menu
    var demo_settings = $("<div />");

    //Layout options
    demo_settings.append(
            "<h4 class='control-sidebar-heading'>"
            + "Layout Options"
            + "</h4>"
            //Fixed layout
            + "<div class='form-group'>"
            + "<label class='control-sidebar-subheading'>"
            + "<input type='checkbox' data-layout='fixed' class='pull-right'/> "
            + "Fixed layout"
            + "</label>"
            + "<p>Activate the fixed layout. You can't use fixed and boxed layouts together</p>"
            + "</div>"
            //Boxed layout
            + "<div class='form-group'>"
            + "<label class='control-sidebar-subheading'>"
            + "<input type='checkbox' data-layout='layout-boxed'class='pull-right'/> "
            + "Boxed Layout"
            + "</label>"
            + "<p>Activate the boxed layout</p>"
            + "</div>"
            //Sidebar Toggle
            + "<div class='form-group'>"
            + "<label class='control-sidebar-subheading'>"
            + "<input type='checkbox' data-layout='sidebar-collapse' class='pull-right'/> "
            + "Toggle Sidebar"
            + "</label>"
            + "<p>Toggle the left sidebar's state (open or collapse)</p>"
            + "</div>"
            //Sidebar mini expand on hover toggle
            + "<div class='form-group'>"
            + "<label class='control-sidebar-subheading'>"
            + "<input type='checkbox' data-enable='expandOnHover' class='pull-right'/> "
            + "Sidebar Expand on Hover"
            + "</label>"
            + "<p>Let the sidebar mini expand on hover</p>"
            + "</div>"
            //Control Sidebar Toggle
            + "<div class='form-group'>"
            + "<label class='control-sidebar-subheading'>"
            + "<input type='checkbox' data-controlsidebar='control-sidebar-open' class='pull-right'/> "
            + "Toggle Right Sidebar Slide"
            + "</label>"
            + "<p>Toggle between slide over content and push content effects</p>"
            + "</div>"
            //Control Sidebar Skin Toggle
            + "<div class='form-group'>"
            + "<label class='control-sidebar-subheading'>"
            + "<input type='checkbox' data-sidebarskin='toggle' class='pull-right'/> "
            + "Toggle Right Sidebar Skin"
            + "</label>"
            + "<p>Toggle between dark and light skins for the right sidebar</p>"
            + "</div>"
            );
    var skins_list = $("<ul />", {"class": 'list-unstyled clearfix'});

    //Dark sidebar skins
    var skin_blue =
            $("<li />", {style: "float:left; width: 33.33333%; padding: 5px;"})
            .append("<a href='javascript:void(0);' data-skin='skin-blue' style='display: block; box-shadow: 0 0 3px rgba(0,0,0,0.4)' class='clearfix full-opacity-hover'>"
                    + "<div><span style='display:block; width: 20%; float: left; height: 7px; background: #367fa9;'></span><span class='bg-light-blue' style='display:block; width: 80%; float: left; height: 7px;'></span></div>"
                    + "<div><span style='display:block; width: 20%; float: left; height: 20px; background: #222d32;'></span><span style='display:block; width: 80%; float: left; height: 20px; background: #f4f5f7;'></span></div>"
                    + "</a>"
                    + "<p class='text-center no-margin'>Blue</p>");
    skins_list.append(skin_blue);
    var skin_black =
            $("<li />", {style: "float:left; width: 33.33333%; padding: 5px;"})
            .append("<a href='javascript:void(0);' data-skin='skin-black' style='display: block; box-shadow: 0 0 3px rgba(0,0,0,0.4)' class='clearfix full-opacity-hover'>"
                    + "<div style='box-shadow: 0 0 2px rgba(0,0,0,0.1)' class='clearfix'><span style='display:block; width: 20%; float: left; height: 7px; background: #fefefe;'></span><span style='display:block; width: 80%; float: left; height: 7px; background: #fefefe;'></span></div>"
                    + "<div><span style='display:block; width: 20%; float: left; height: 20px; background: #222;'></span><span style='display:block; width: 80%; float: left; height: 20px; background: #f4f5f7;'></span></div>"
                    + "</a>"
                    + "<p class='text-center no-margin'>Black</p>");
    skins_list.append(skin_black);
    var skin_purple =
            $("<li />", {style: "float:left; width: 33.33333%; padding: 5px;"})
            .append("<a href='javascript:void(0);' data-skin='skin-purple' style='display: block; box-shadow: 0 0 3px rgba(0,0,0,0.4)' class='clearfix full-opacity-hover'>"
                    + "<div><span style='display:block; width: 20%; float: left; height: 7px;' class='bg-purple-active'></span><span class='bg-purple' style='display:block; width: 80%; float: left; height: 7px;'></span></div>"
                    + "<div><span style='display:block; width: 20%; float: left; height: 20px; background: #222d32;'></span><span style='display:block; width: 80%; float: left; height: 20px; background: #f4f5f7;'></span></div>"
                    + "</a>"
                    + "<p class='text-center no-margin'>Purple</p>");
    skins_list.append(skin_purple);
    var skin_green =
            $("<li />", {style: "float:left; width: 33.33333%; padding: 5px;"})
            .append("<a href='javascript:void(0);' data-skin='skin-green' style='display: block; box-shadow: 0 0 3px rgba(0,0,0,0.4)' class='clearfix full-opacity-hover'>"
                    + "<div><span style='display:block; width: 20%; float: left; height: 7px;' class='bg-green-active'></span><span class='bg-green' style='display:block; width: 80%; float: left; height: 7px;'></span></div>"
                    + "<div><span style='display:block; width: 20%; float: left; height: 20px; background: #222d32;'></span><span style='display:block; width: 80%; float: left; height: 20px; background: #f4f5f7;'></span></div>"
                    + "</a>"
                    + "<p class='text-center no-margin'>Green</p>");
    skins_list.append(skin_green);
    var skin_red =
            $("<li />", {style: "float:left; width: 33.33333%; padding: 5px;"})
            .append("<a href='javascript:void(0);' data-skin='skin-red' style='display: block; box-shadow: 0 0 3px rgba(0,0,0,0.4)' class='clearfix full-opacity-hover'>"
                    + "<div><span style='display:block; width: 20%; float: left; height: 7px;' class='bg-red-active'></span><span class='bg-red' style='display:block; width: 80%; float: left; height: 7px;'></span></div>"
                    + "<div><span style='display:block; width: 20%; float: left; height: 20px; background: #222d32;'></span><span style='display:block; width: 80%; float: left; height: 20px; background: #f4f5f7;'></span></div>"
                    + "</a>"
                    + "<p class='text-center no-margin'>Red</p>");
    skins_list.append(skin_red);
    var skin_yellow =
            $("<li />", {style: "float:left; width: 33.33333%; padding: 5px;"})
            .append("<a href='javascript:void(0);' data-skin='skin-yellow' style='display: block; box-shadow: 0 0 3px rgba(0,0,0,0.4)' class='clearfix full-opacity-hover'>"
                    + "<div><span style='display:block; width: 20%; float: left; height: 7px;' class='bg-yellow-active'></span><span class='bg-yellow' style='display:block; width: 80%; float: left; height: 7px;'></span></div>"
                    + "<div><span style='display:block; width: 20%; float: left; height: 20px; background: #222d32;'></span><span style='display:block; width: 80%; float: left; height: 20px; background: #f4f5f7;'></span></div>"
                    + "</a>"
                    + "<p class='text-center no-margin'>Yellow</p>");
    skins_list.append(skin_yellow);

    //Light sidebar skins
    var skin_blue_light =
            $("<li />", {style: "float:left; width: 33.33333%; padding: 5px;"})
            .append("<a href='javascript:void(0);' data-skin='skin-blue-light' style='display: block; box-shadow: 0 0 3px rgba(0,0,0,0.4)' class='clearfix full-opacity-hover'>"
                    + "<div><span style='display:block; width: 20%; float: left; height: 7px; background: #367fa9;'></span><span class='bg-light-blue' style='display:block; width: 80%; float: left; height: 7px;'></span></div>"
                    + "<div><span style='display:block; width: 20%; float: left; height: 20px; background: #f9fafc;'></span><span style='display:block; width: 80%; float: left; height: 20px; background: #f4f5f7;'></span></div>"
                    + "</a>"
                    + "<p class='text-center no-margin' style='font-size: 12px'>Blue Light</p>");
    skins_list.append(skin_blue_light);
    var skin_black_light =
            $("<li />", {style: "float:left; width: 33.33333%; padding: 5px;"})
            .append("<a href='javascript:void(0);' data-skin='skin-black-light' style='display: block; box-shadow: 0 0 3px rgba(0,0,0,0.4)' class='clearfix full-opacity-hover'>"
                    + "<div style='box-shadow: 0 0 2px rgba(0,0,0,0.1)' class='clearfix'><span style='display:block; width: 20%; float: left; height: 7px; background: #fefefe;'></span><span style='display:block; width: 80%; float: left; height: 7px; background: #fefefe;'></span></div>"
                    + "<div><span style='display:block; width: 20%; float: left; height: 20px; background: #f9fafc;'></span><span style='display:block; width: 80%; float: left; height: 20px; background: #f4f5f7;'></span></div>"
                    + "</a>"
                    + "<p class='text-center no-margin' style='font-size: 12px'>Black Light</p>");
    skins_list.append(skin_black_light);
    var skin_purple_light =
            $("<li />", {style: "float:left; width: 33.33333%; padding: 5px;"})
            .append("<a href='javascript:void(0);' data-skin='skin-purple-light' style='display: block; box-shadow: 0 0 3px rgba(0,0,0,0.4)' class='clearfix full-opacity-hover'>"
                    + "<div><span style='display:block; width: 20%; float: left; height: 7px;' class='bg-purple-active'></span><span class='bg-purple' style='display:block; width: 80%; float: left; height: 7px;'></span></div>"
                    + "<div><span style='display:block; width: 20%; float: left; height: 20px; background: #f9fafc;'></span><span style='display:block; width: 80%; float: left; height: 20px; background: #f4f5f7;'></span></div>"
                    + "</a>"
                    + "<p class='text-center no-margin' style='font-size: 12px'>Purple Light</p>");
    skins_list.append(skin_purple_light);
    var skin_green_light =
            $("<li />", {style: "float:left; width: 33.33333%; padding: 5px;"})
            .append("<a href='javascript:void(0);' data-skin='skin-green-light' style='display: block; box-shadow: 0 0 3px rgba(0,0,0,0.4)' class='clearfix full-opacity-hover'>"
                    + "<div><span style='display:block; width: 20%; float: left; height: 7px;' class='bg-green-active'></span><span class='bg-green' style='display:block; width: 80%; float: left; height: 7px;'></span></div>"
                    + "<div><span style='display:block; width: 20%; float: left; height: 20px; background: #f9fafc;'></span><span style='display:block; width: 80%; float: left; height: 20px; background: #f4f5f7;'></span></div>"
                    + "</a>"
                    + "<p class='text-center no-margin' style='font-size: 12px'>Green Light</p>");
    skins_list.append(skin_green_light);
    var skin_red_light =
            $("<li />", {style: "float:left; width: 33.33333%; padding: 5px;"})
            .append("<a href='javascript:void(0);' data-skin='skin-red-light' style='display: block; box-shadow: 0 0 3px rgba(0,0,0,0.4)' class='clearfix full-opacity-hover'>"
                    + "<div><span style='display:block; width: 20%; float: left; height: 7px;' class='bg-red-active'></span><span class='bg-red' style='display:block; width: 80%; float: left; height: 7px;'></span></div>"
                    + "<div><span style='display:block; width: 20%; float: left; height: 20px; background: #f9fafc;'></span><span style='display:block; width: 80%; float: left; height: 20px; background: #f4f5f7;'></span></div>"
                    + "</a>"
                    + "<p class='text-center no-margin' style='font-size: 12px'>Red Light</p>");
    skins_list.append(skin_red_light);
    var skin_yellow_light =
            $("<li />", {style: "float:left; width: 33.33333%; padding: 5px;"})
            .append("<a href='javascript:void(0);' data-skin='skin-yellow-light' style='display: block; box-shadow: 0 0 3px rgba(0,0,0,0.4)' class='clearfix full-opacity-hover'>"
                    + "<div><span style='display:block; width: 20%; float: left; height: 7px;' class='bg-yellow-active'></span><span class='bg-yellow' style='display:block; width: 80%; float: left; height: 7px;'></span></div>"
                    + "<div><span style='display:block; width: 20%; float: left; height: 20px; background: #f9fafc;'></span><span style='display:block; width: 80%; float: left; height: 20px; background: #f4f5f7;'></span></div>"
                    + "</a>"
                    + "<p class='text-center no-margin' style='font-size: 12px;'>Yellow Light</p>");
    skins_list.append(skin_yellow_light);

    demo_settings.append("<h4 class='control-sidebar-heading'>Skins</h4>");
    demo_settings.append(skins_list);

    tab_pane.append(demo_settings);
    $("#control-sidebar-home-tab").after(tab_pane);

    setup();

    /**
     * Toggles layout classes
     *
     * @param String cls the layout class to toggle
     * @returns void
     */
    function change_layout(cls) {
        $("body").toggleClass(cls);
        AdminLTE.layout.fixSidebar();
        //Fix the problem with right sidebar and layout boxed
        if (cls == "layout-boxed")
            AdminLTE.controlSidebar._fix($(".control-sidebar-bg"));
        if ($('body').hasClass('fixed') && cls == 'fixed') {
            AdminLTE.pushMenu.expandOnHover();
            AdminLTE.layout.activate();
        }
        AdminLTE.controlSidebar._fix($(".control-sidebar-bg"));
        AdminLTE.controlSidebar._fix($(".control-sidebar"));
    }

    /**
     * Replaces the old skin with the new skin
     * @param String cls the new skin class
     * @returns Boolean false to prevent link's default action
     */
    function change_skin(cls) {
        $.each(my_skins, function (i) {
            $("body").removeClass(my_skins[i]);
        });

        $("body").addClass(cls);
        store('skin', cls);
        return false;
    }

    /**
     * Store a new settings in the browser
     *
     * @param String name Name of the setting
     * @param String val Value of the setting
     * @returns void
     */
    function store(name, val) {
        if (typeof (Storage) !== "undefined") {
            localStorage.setItem(name, val);
        } else {
            window.alert('Please use a modern browser to properly view this template!');
        }
    }

    /**
     * Get a prestored setting
     *
     * @param String name Name of of the setting
     * @returns String The value of the setting | null
     */
    function get(name) {
        if (typeof (Storage) !== "undefined") {
            return localStorage.getItem(name);
        } else {
            window.alert('Please use a modern browser to properly view this template!');
        }
    }

    /**
     * Retrieve default settings and apply them to the template
     *
     * @returns void
     */
    function setup() {
        var tmp = get('skin');
        if (tmp && $.inArray(tmp, my_skins))
            change_skin(tmp);

        //Add the change skin listener
        $("[data-skin]").on('click', function (e) {
            e.preventDefault();
            change_skin($(this).data('skin'));
        });

        //Add the layout manager
        $("[data-layout]").on('click', function () {
            change_layout($(this).data('layout'));
        });

        $("[data-controlsidebar]").on('click', function () {
            change_layout($(this).data('controlsidebar'));
            var slide = !AdminLTE.options.controlSidebarOptions.slide;
            AdminLTE.options.controlSidebarOptions.slide = slide;
            if (!slide)
                $('.control-sidebar').removeClass('control-sidebar-open');
        });

        $("[data-sidebarskin='toggle']").on('click', function () {
            var sidebar = $(".control-sidebar");
            if (sidebar.hasClass("control-sidebar-dark")) {
                sidebar.removeClass("control-sidebar-dark")
                sidebar.addClass("control-sidebar-light")
            } else {
                sidebar.removeClass("control-sidebar-light")
                sidebar.addClass("control-sidebar-dark")
            }
        });

        $("[data-enable='expandOnHover']").on('click', function () {
            $(this).attr('disabled', true);
            AdminLTE.pushMenu.expandOnHover();
            if (!$('body').hasClass('sidebar-collapse'))
                $("[data-layout='sidebar-collapse']").click();
        });

        // Reset options
        if ($('body').hasClass('fixed')) {
            $("[data-layout='fixed']").attr('checked', 'checked');
        }
        if ($('body').hasClass('layout-boxed')) {
            $("[data-layout='layout-boxed']").attr('checked', 'checked');
        }
        if ($('body').hasClass('sidebar-collapse')) {
            $("[data-layout='sidebar-collapse']").attr('checked', 'checked');
        }

    }
})(jQuery, $.AdminLTE);


$("#add_company").click(function () {
    $("#company_add").toggle(200);

});


$("#add_fare").click(function () {
    $("#fare_search").hide();
    $("#fare_add").show();
    $("#fare_form").show(200);

});


$("#back_fare").click(function () {
    $("#fare_search").show();
    $("#fare_add").hide();

});



$("#add_price").click(function () {
    $("#fare_form").show(200);
    //$("#fare_add").hide();

});

$("#permaling-edit").click(function () {
    $("#permaling-edit-box").show();
    $("#permaling-edit-text").hide();

});


$("#add_user").click(function () {
    $("#user_div").show(500);
    $("#search_div").hide(500);
    $("#search_user").show(500);
    $("#add_user").hide(500);

});


$("#search_user").click(function () {
    $("#user_div").hide(500);
    $("#search_div").show(500);
    $("#search_user").hide(500);
    $("#add_user").show(500);

});


$(".edit_user").click(function () {
    $("#user_div").show(500);
    $("#search_div").hide(500);


});



$(".menu-edit-but").click(function () {
    $(this).parent().parent().find('.menu-edit-div').show();
    $(this).parent().parent().find('.menu-edit-but').addClass('display-none');
    $(this).parent().parent().find('.menu-cancel-but').removeClass('display-none');
});

$(".menu-cancel-but").click(function () {
    $(this).parent().parent().find('.menu-edit-div').hide();
    $(this).parent().parent().find('.menu-edit-but').removeClass('display-none');
    $(this).parent().parent().find('.menu-cancel-but').addClass('display-none');

});





//function myFunction() {
// var x = document.getElementById("menuDIV");
//  if (x.style.display === "none") {
//   x.style.display = "block";
//  } else {
//      x.style.display = "none";
//  }
//}



function control(id) {
    //debugger;
    //alert(id);
    document.getElementById("cph_main_drpPaymentMode");
    if (id == "Cheque") {
        document.getElementById("chequeno").style.display = 'block';
        document.getElementById("trans").style.display = 'none';
        document.getElementById("fileupload").style.display = 'block';
    }
    if (id == "Demand Draft") {
        document.getElementById("chequeno").style.display = 'block';
        document.getElementById("trans").style.display = 'none';
        document.getElementById("fileupload").style.display = 'block';
    }
    if (id == "Online Transfer") {
        document.getElementById("chequeno").style.display = 'none';
        document.getElementById("trans").style.display = 'block';
        document.getElementById("fileupload").style.display = 'none';
    }
    if (id == "Cash Deposit") {
        document.getElementById("chequeno").style.display = 'none';
        document.getElementById("trans").style.display = 'none';
        document.getElementById("fileupload").style.display = 'block';
    }


}


//set image coordinates
function updateCoords(im, obj) {
    $('#x').val(obj.x1);
    $('#y').val(obj.y1);
    $('#w').val(obj.width);
    $('#h').val(obj.height);
}

//check coordinates
function checkCoords() {
    if (parseInt($('#w').val()))
        return true;
    alert('Please select a crop region then press submit.');
    return false;
}

$(document).ready(function () {
    //prepare instant image preview
    var p = $("#filePreview");
    var p1 = $("#filePreview1");
    $("#fileInput").change(function () {
        //fadeOut or hide preview
        p.fadeOut();

        //prepare HTML5 FileReader
        var oFReader = new FileReader();
        oFReader.readAsDataURL(document.getElementById("fileInput").files[0]);

        oFReader.onload = function (oFREvent) {
            p.attr('src', oFREvent.target.result).fadeIn();
        };
    });

    //implement imgAreaSelect plugin
    $('img#filePreview').imgAreaSelect({
        onSelectEnd: updateCoords
    });


    $("#fileInput1").change(function () {
        //fadeOut or hide preview
        p1.fadeOut();

        //prepare HTML5 FileReader
        var oFReader = new FileReader();
        oFReader.readAsDataURL(document.getElementById("fileInput1").files[0]);

        oFReader.onload = function (oFREvent) {
            p1.attr('src', oFREvent.target.result).fadeIn();
        };
    });

    //implement imgAreaSelect plugin
    $('img#filePreview1').imgAreaSelect({
        onSelectEnd: updateCoords
    });

});


jQuery('<div class="quantity-nav"><div class="quantity-button quantity-up"></div><div class="quantity-button quantity-down"></div></div>').insertAfter('.quantity input');
jQuery('.quantity').each(function () {
    var spinner = jQuery(this),
            input = spinner.find('input[type="number"]'),
            btnUp = spinner.find('.quantity-up'),
            btnDown = spinner.find('.quantity-down'),
            min = input.attr('min'),
            max = input.attr('max');

    btnUp.click(function () {
        var oldValue = parseFloat(input.val());
        if (oldValue >= max) {
            var newVal = oldValue;
        } else {
            var newVal = oldValue + 1;
        }
        spinner.find("input").val(newVal);
        spinner.find("input").trigger("change");
    });

    btnDown.click(function () {
        var oldValue = parseFloat(input.val());
        if (oldValue <= min) {
            var newVal = oldValue;
        } else {
            var newVal = oldValue - 1;
        }
        spinner.find("input").val(newVal);
        spinner.find("input").trigger("change");
    });

});

function control1(id) {
    //debugger;
    //alert(id);
    document.getElementById("debittype");
    if (id == "Debit Cheque") {

        document.getElementById("debitcash").style.display = 'none';
        document.getElementById("debitbank").style.diswiseplay = 'block';
        document.getElementById("debitChequeno").style.display = 'block';
        document.getElementById("debit-but").style.display = 'none';
    }

    if (id == "Debit Online") {

        document.getElementById("debitcash").style.display = 'none';
        document.getElementById("debitbank").style.display = 'none';
        document.getElementById("debitChequeno").style.display = 'none';
        document.getElementById("debit-but").style.display = 'block';
    }
    if (id == "Debit Cash") {

        document.getElementById("debitcash").style.display = 'block';
        document.getElementById("debitbank").style.display = 'none';
        document.getElementById("debitChequeno").style.display = 'none';
        document.getElementById("debit-but").style.display = 'none';
    }


}


function control(id) {
    //debugger;
    //alert(id);
    document.getElementById("paymenttype-booking");
    if (id == "Credit Cheque") {

        document.getElementById("creditcash").style.display = 'none';
        document.getElementById("creditbank").style.display = 'block';
        document.getElementById("creditChequeno").style.display = 'block';
        document.getElementById("credittrans").style.display = 'none';

    }

    if (id == "Credit Online") {

        document.getElementById("creditcash").style.display = 'none';
        document.getElementById("creditbank").style.display = 'block';
        document.getElementById("credittrans").style.display = 'block';
        document.getElementById("creditChequeno").style.display = 'none';
    }
    if (id == "Credit Cash") {

        document.getElementById("creditcash").style.display = 'block';
        document.getElementById("creditbank").style.display = 'none';
        document.getElementById("credittrans").style.display = 'none';
        document.getElementById("creditChequeno").style.display = 'block';
    }


}

/* */

var clientFare = $("#client-fare-selected").val();
var publicFare = $("#client-fare-selected").val();

if (clientFare == 1) {
    $("#public-fare").prop("checked", false);
    $("#client-fare").prop("checked", true);
    $(".client_fare").show();
    $('#client-fare-selected').attr('value', '');
}
if (publicFare == 0) {
    $("#public-fare").prop("checked", true);
    $("#client-fare").prop("checked", false);
    $(".client_fare").hide();
    $('#public-fare-selected').attr('value', '');
}

$(".public-fare").click(function () {
    $("#client-id").val('');
    $(".client_fare").hide();
});

$(".client-fare").click(function () {
    $(".client_fare").show();
});

/* */

var pointDispatch = $("#garage-dispatch-selected").val();
var garageDispatch = $("#garage-dispatch-selected").val();

if (pointDispatch == 1) {
    //alert(1);
    $("#point-to-point-dispatch").prop("checked", false);
    $("#garage-to-garage-dispatch").prop("checked", true);
    $("#garage").show();
    $('#point-dispatch-selected').attr('value', '');
    $("#own-address").hide();
    $("#company-address").hide();
}
if (garageDispatch == 0) {
    //alert(2);
    $("#point-to-point-dispatch").prop("checked", true);
    $("#garage-to-garage-dispatch").prop("checked", false);
    $("#garage").hide();
    $('#garage-dispatch-selected').attr('value', '');
    $("#own-address").hide();
    $("#company-address").hide();
}


$("#point-to-point-dispatch").click(function () {
    $("#dishpatch-garage-own").prop("checked", false);
    $("#garage").hide();
    $("#own-address").hide();
    $("#company-address").hide();
});


$("#garage-to-garage-dispatch").click(function () {
    $("#garage").show();
    $("#dishpatch-garage-own").prop("checked", true);
    $("#own-address").show();
});


/* */
$("#dishpatch-garage-own").prop("checked", false);
$("#own-address").hide();
var ownGarage = $("#comp-garage-selected").val();
var compGarage = $("#comp-garage-selected").val();

if (ownGarage == 1) {
    //alert(3);
    $("#dishpatch-garage-own").prop("checked", false);
    $("#dishpatch-garage-company").prop("checked", true);
    if (garageDispatch == 0) {
        $("#own-address").hide();
        $("#company-address").hide();
    } else {
        $("#own-address").hide();
        $("#company-address").show();
    }
    $('#own-garage-selected').attr('value', '');
}
if (compGarage == 0) {
    //alert(4);
    //$("#dishpatch-garage-own").prop("checked", true);
    $("#dishpatch-garage-company").prop("checked", false);
    if (garageDispatch == 0) {
        $("#own-address").hide();
        $("#company-address").hide();
    } else {
        $("#own-address").show();
        $("#company-address").hide();
    }
    $('#comp-garage-selected').attr('value', '');
}


$("#dishpatch-garage-own").click(function () {
    $("#own-address").show();
    $("#company-address").hide();
});

$("#dishpatch-garage-company").click(function () {
    $("#own-address").hide();
    $("#company-address").show();
});

/*  */

var netRate = $("#commission-rate-selected").val();
var commissionRate = $("#commission-rate-selected").val();

if (netRate == 1) {
    $("#net-rate").prop("checked", false);
    $("#commission-rate").prop("checked", true);
    $("#type_of_commission").show();
    $('#commission-rate-selected').attr('value', '');
}
if (commissionRate == 0) {
    $("#net-rate").prop("checked", true);
    $("#commission-rate").prop("checked", false);
    $("#type_of_commission").hide();
    $('#net-rate-selected').attr('value', '');
}

$("#commission-rate").click(function () {
    $("#type_of_commission").show();
});


$("#net-rate").click(function () {
    $("#type_of_commission").hide();
});

//code by Mihir

function printFunction() {
    window.print();
}

//$(document).on('click','.clickme',function(){
//    $('.remove').remove();
//    $(this).closest('tr').after('<tr class="remove"><td colspan="13"><div id="div1">xcvcxcx</div></td></tr>');
//    $("#div1").load("booking-detail.phtml");
//});


$(document).ready(function () {

    $("#search_user").click(function () {
        $("#user_div").hide(500);
        $("#search_div").show(500);
        $("#search_user").hide(500);
        $("#add_user").show(500);
    });


    $(".edit_user").click(function () {
        $("#user_div").show(500);
        $("#search_div").hide(500);
    });


    $("#creat-debit-note").click(function () {
        $("#debit-note-list").show(500);
        $("#btn-payment-debit").show(500);
    });

    var date = new Date();
    var dd = date.getDate();
    var mm = date.getMonth() + 1; //January is 0!
    var yyyy = date.getFullYear();
    if (dd < 10) {
        dd = '0' + dd;
    }
    if (mm < 10) {
        mm = '0' + mm;
    }
    var today = yyyy + '-' + mm + '-' + dd;
    countDays(today, '');

});


function printFunction() {
    window.print();
}


/////////////////
var myVar;
var myVar2;
var table;



$(document).on('click', '.clickme', function () {
    i = 1;
    clearInterval(myVar2);
    clearInterval(myVar);
    i = 0;
    if ($(this).hasClass('open'))
    {
        myVar2 = setInterval(function () {
            myTimer2()
        }, 30000);
        $(".remove div:first").slideUp(400, function () {
            $('.remove').remove();
        });
        $(this).removeClass('open');
    } else {
        $('.remove').remove();
        $(this).addClass('open');
        $(this).parent().parent().after('<tr class="remove" ><td colspan="13"><div style="display:none"> <div class=""> <!--<div class="portlet portlet-default"> <div class="portlet-heading"> <div class="portlet-title"></div>--> <div class="clearfix"></div> </div> <div class="portlet-body"> <ul id="myTab" class="nav nav-tabs tabsdesign"> <li class="active"><a href="#home1" data-toggle="tab"><i class="fa fa-list" style="color:#; margin:5px"></i>Status</a> </li> <li><a href="#bookinginfo" data-toggle="tab"><i class="fa fa-user" style="color:#; margin:5px"></i>Booking Details</a> </li><li><a href="#payment" data-toggle="tab"><i class="fa fa-user" style="color:#; margin:5px"></i> Payment Details</a> </li><li><a href="#driver_alloc" data-toggle="tab"><i class="fa fa-user" style="color:#; margin:5px"></i>Driver Allocation</a> </li><li><a href="#way_point" data-toggle="tab" class="way_points_show"><i class="fa fa-user" style="color:#; margin:5px"></i>Way Points</a> </li></li></ul> <div id="myTabContent" class="tab-content contantboxoftabs"> <div class="tab-pane fade in active" id="home1"><h5 class="h4text" style="background: #E2E2E2;padding:7px;margin: 0;">Status</h5><table id="example2" class="table table-striped table-responsive"><thead> <tr> <th style="width:33%;">Date</th> <th style="width:33%;">State</th> <th style="width:33%;">Text</th> </tr> </thead> <tbody> </tbody> </table></div><div class="tab-pane fade" id="payment"><h5 class="h4text" style="background: #E2E2E2;padding:7px;margin: 0;">Payment Details</h5><table id="paymentdetail" class="table table-responsive table-striped"></table></div><div class="tab-pane fade" id="bookinginfo"><h5 class="h4text" style="background: #E2E2E2;padding:7px;margin: 0;">Booking Information</h5><table id="bookinf" class="table table-responsive table-striped"></table></div><div id="driver_alloc" class="tab-pane fade"><h5 class="h4text" style="background: #E2E2E2;padding:7px;margin: 0;">Driver Allocation</h5><table id="driver_alloc_2" class="table table-striped table-responsive"><thead> <tr> <th>Driver</th> <th>Vehicle</th> <th>Created</th><th>Allocation Status</th> </tr> </thead> <tbody> </tbody> </table></div><div id="way_point" class="tab-pane fade"><h5 class="h4text" style="background: #E2E2E2;padding:7px;margin: 0;">Way Points</h5><div id="map"></div></div></div></td></tr>');
        data = $(this).attr("data");
        rel = $(this).attr("rel");
        $.ajax({
            url: '<?php echo $this->basePath();?>' + "/tunnel/admin/booking_information?booking_id=" + data,
            cache: false,
            dataType: "json"
        })
                .done(function (html) {
                    $('#example2 tbody').html('');
                    for (var i = 0; i < html.data.length; i++)
                    {
                        $('#example2 tbody').append('<tr><td>' + html.data[i].time + '</td><td>' + html.data[i].status + '</td><td>' + html.data[i].message + '</td></tr>');
                    }
                });
        $.ajax({
            url: '<?php echo $this->basePath();?>' + "/tunnel/admin/payment_information?booking_id=" + data,
            cache: false,
            dataType: "json"
        })
                .done(function (html) {
                    $('#paymentdetail').append('<tr><th></th><th>Created At</th><td>' + html.data[0].created_at + '</td></tr><tr><th></th><th>Is Paid</th><td>' + html.data[0].is_paid + '</td></tr><tr><th></th><th>Paid At</th><td>' + html.data[0].paid_at + '</td></tr><tr><th>Price</th><th>Currency</th><td>' + html.data[0].currency + '</td></tr><tr><th></th><th>Invoice Number</th><td>' + html.data[0].invoice_number + '</td></tr><tr><th></th><th>External Refernece</th><td></td></tr><tr><th></th><th>Payment Type</th><td>' + html.data[0].payment_type + '</td></tr><tr><th></th><th>Fees</th><td>' + html.data[0].fees + '</td></tr><tr><th></th><th>Total Tax Price</th><td>' + html.data[0].total_tax_price + '</td></tr><tr><th></th><th>Total Price </th><td>' + html.data[0].total_price + '</td></tr><tr><th></th><th>Total Discount </th><td>' + html.data[0].total_discount + '</td></tr><tr><th></th><th>Total Price After Discount </th><td>' + html.data[0].total_price_after_dicount + '</td></tr><tr><th></th><th>Paid Amount (%) </th><td>' + html.data[0].paid_amt_percentage + '</td></tr><tr><th></th><th>Paid Amount</th><td>' + html.data[0].paid_amount + '</td></tr><tr><th></th><th>Balance Amount</th><td>' + html.data[0].balance_amount + '</td></tr>');
                    $('#bookinf').append('<tr><th colspan="2">In</th><th colspan="2">Out</th><th colspan="2">Driver</th><th colspan="2">Client</th></tr><tr><td style="width:15%;">Booking Id</td><td style="width:15%;">' + html.data[0].book_ref + '</td><th style="width:20%;">External Booking Reference</th><td style="width:12.5%;">N/A</td><th style="width:10%;">Rating</th><td style="width:10%;">' + html.data[0].driver_rating + '</td><th style="width:12.5%;">Rating</th><td style="width:12.5%;">' + html.data[0].client_rating + '</td></tr><tr><th>UserAgent</th><td>' + html.data[0].useragent + '</td><th>Arrival Time Pre</th><td>' + html.data[0].arrival_time_pre + '</td><th>Reason</th><th></th><th>Reason</th><th></th></tr><tr><th>Comments for the client</th><td></td><th>Arrival Time Post</th><td>' + html.data[0].arrival_time_post + '</td><th>Comment</th><td></td><th>Comment</th><td></td></tr><tr><th>Comment For the driver</th><td></td><th>Arrival Time Actual</th><td>' + html.data[0].arrival_time_actual + '</td><th></th><th></th><th></th><th></th></tr><tr><th>Drivers Note</th><td>' + html.data[0].driver_note + '</td><th>Expiration Time</th><td>' + html.data[0].expiration_time + '</td><th></th><th></th><th></th><th></th></tr><tr><th>Clients Note</th><td>' + html.data[0].client_note + '</td><th>Actual Driving Duration</th><td>' + html.data[0].actual_driven_duration + '</td><th></th><th></th><th></th><th></th></tr><tr><th>Features</th><td>' + html.data[0].features + '</td><th>Actual Waiting Distance</th><td>' + html.data[0].actual_waiting_distance + '</td><th></th><th></th><th></th><th></th></tr><tr><th>Vehicle Type</th><td>' + html.data[0].cab_name + '</td><th>Actual Distance</th><td>' + html.data[0].actual_distance + '</td><th></th><th></th><th></th><th></th></tr><tr><th>Is account booking</th><td>' + html.data[0].is_account_booking + '</td><th>Booking Type</th><td>' + html.data[0].bookingtype + '</td><th></th><th></th><th></th><th></th></tr><tr><th>Is Corporate Booking</th><td>' + html.data[0].is_corporate_booking + '</td><th>Booking Date</th><td>' + html.data[0].bookingdate + '</td><th></th><th></th><th></th><th></th></tr><tr><th>Is account booking</th><td>' + html.data[0].is_account_booking + '</td><th>Pickup Date</th><td>' + html.data[0].pickupdate + '</td><th></th><th></th><th></th><th></th></tr><tr><th>Is credit card Available</th><td></td><th>Pickup Area</th><td>' + html.data[0].pickuparea + '</td><th></th><th></th><th></th><th></th></tr><tr><th>Voucher Id</th><td>' + html.data[0].voucher_id + '</td><th>Pickup Address</th><td>' + html.data[0].pickupaddress + '</td><th></th><th></th><th></th><th></th></tr><tr><th>Voucher Type</th><td>' + html.data[0].voucher_type + '</td><th>Drop Address</th><td>' + html.data[0].dropaddress + '</td><th></th><th></th><th></th><th></th></tr><tr><th>Voucher Amount</th><td></td><th>Drop Area</th><td>' + html.data[0].droparea + '</td><th></th><th></th><th></th><th></th></tr><tr><th>Estimated Distance</th><td>' + html.data[0].estimated_distance + '</td><th></th><th></th><th></th><th></th><th></th><th></th></tr><tr><th>Estimated Time</th><td>' + html.data[0].estimated_time + '</td><th></th><th></th><th></th><th></th><th></th><th></th></tr><tr><th>Estimated Price</th><td>' + html.data[0].estimated_price + '</td><th></th><th></th><th></th><th></th><th></th><th></th></tr>');
                    $('#bookinginfo').append('<div class="col-sm-12 marginbottom20" style="margin-top: 25px;"><a href="#" class="btn btn-default marginright" id="export_booking_info"><i class="fa fa-download marginright"></i>Download CSV</a></div>');
                    //initMap();
                });
        $.ajax({
            url: '<?php echo $this->basePath();?>' + "/tunnel/admin/driver_alloc?booking_id=" + data,
            cache: false,
            dataType: "json"
        })
                .done(function (html) {
                    $('#driver_alloc_2 tbody').html('');
                    for (var i = 0; i < html.data.length; i++)
                    {
                        $('#driver_alloc_2').append('<tr><td>' + html.data[i].driver_name + '</td><td>' + html.data[i].vehicle + '</td><td>' + html.data[i].created + '</td><td>' + html.data[i].status + '</td></tr>');
                    }
                });

////////Code for Way Points Starts Here ////

        $.ajax({
            url: '<?php echo $this->basePath();?>' + "/tunnel/admin/waypoint_info",
            cache: false,
            dataType: "json",
            data: {
                booking_id: data,
                driver_id: rel
            },
        })

                .done(function (data) {
                    //alert(data.status);
                    if (data.status == "true") {
                        //alert('Mohit');
                        var way_points = JSON.stringify(data.data);
                        var way_points1 = jQuery.parseJSON(way_points);
                        var start_lat = way_points1[0].lat;
                        var start_lng = way_points1[0].lng;
                        ///
                        var end_lat = data.end_lat;
                        var end_long = data.end_long;

                        var pickup_lat = data.pickup_lat;
                        var pickup_lng = data.pickup_lng;



                        debugger;
                        alert(way_points);
                        var map = new google.maps.Map(document.getElementById('map'), {
                            zoom: 16,
                            //center: {lat: 0, lng: -180},
                            center: {lat: start_lat, lng: start_lng},
                            mapTypeId: google.maps.MapTypeId.DRIVING
                        });

                        var userCoor = [["Driver Pickup", start_lat, start_lng],
                            ["Driver Drop", end_lat, end_long],
                            ["Booking Pickup", pickup_lat, pickup_lng]];

                        var flightPlanCoordinates = way_points1;
                        var flightPath = new google.maps.Polyline({
                            path: flightPlanCoordinates,
                            geodesic: true,
                            strokeColor: '#0000FF',
                            strokeOpacity: 1.0,
                            strokeWeight: 3,
                            fillColor: '#0000FF',
                            fillOpacity: 0.1
                        });

                        flightPath.setMap(map);

                        var flightPlanCoordinates1 = [
                            {lat: start_lat, lng: start_lng},
                            {lat: pickup_lat, lng: pickup_lng}
                        ];


                        var flightPath1 = new google.maps.Polyline({
                            path: flightPlanCoordinates1,
                            geodesic: true,
                            strokeColor: '#FF0000',
                            strokeOpacity: 1.0,
                            strokeWeight: 3,
                            fillColor: '#FF0000',
                            fillOpacity: 0.1
                        });

                        flightPath1.setMap(map);

                        var infowindow = new google.maps.InfoWindow();

                        var marker, i;

                        for (i = 0; i < userCoor.length; i++) {
                            marker = new google.maps.Marker({
                                position: new google.maps.LatLng(userCoor[i][1], userCoor[i][2]),
                                map: map
                            });


                            google.maps.event.addListener(marker, 'click', (function (marker, i) {
                                return function () {
                                    infowindow.setContent(userCoor[i][0]);
                                    infowindow.open(map, marker);
                                }
                            })(marker, i));

                        }
                        ///


                    }
                });

/////// Code for Way Points Ends Here //////

        myVar = setInterval(function () {
            myTimer()
        }, 30000);
        function myTimer() {

            $.ajax({
                url: '<?php echo $this->basePath();?>' + "/tunnel/admin/booking_information?booking_id=" + data,
                cache: false,
                dataType: "json"
            })
                    .done(function (html) {
                        $('#example2 tbody').html('');
                        for (var i = 0; i < html.data.length; i++)
                        {
                            $('#example2 tbody').append('<tr><td>' + html.data[i].time + '</td><td>' + html.data[i].status + '</td><td>' + html.data[i].message + '</td></tr>');
                        }
                    });
            $.ajax({
                url: '<?php echo $this->basePath();?>' + "/tunnel/admin/driver_alloc?booking_id=" + data,
                cache: false,
                dataType: "json"
            })
                    .done(function (html) {
                        $('#driver_alloc_2 tbody').html('');
                        for (var i = 0; i < html.data.length; i++)
                        {
                            $('#driver_alloc_2').append('<tr><td>' + html.data[i].driver_name + '</td><td>' + html.data[i].vehicle + '</td><td>' + html.data[i].created + '</td><td>' + html.data[i].status + '</td></tr>');
                        }
                    });


        }

        $(".remove div:first").slideDown(400, function () {
            //e.preventDefault();
        }
        );
    }
});



////////////////

$(document).on('click', '.date', function () {
    clearInterval(myVar2);
    $('.remove').remove();
    $('.hour').removeClass('activecol');
    $('.date').removeClass('activecol');
    $('.book_type').removeClass('activecol');
    $(this).addClass('activecol');
    // alert($(this).attr('data'));
    $('.hour>span').html('');
    date = $(this).attr("data");
    contentType = 'application/x-www-form-urlencoded; charset=UTF-8';
    $("body").mLoading('show');
    $.ajax({
        url: "/bookinghistory/bookingList",
        type: "post",
        dataType: 'html',
        contentType: contentType,
        data: {'date': date},
        success: function (result) {
            $("body").mLoading('hide');
            $('.listing-data').html(result);
            $('#myTable').DataTable({
                order: [],
                columnDefs: [{orderable: false, targets: [0]}]
            });
        },
        error: function (error) {
            console.log(error);
        }
    });

    countDays(date, '');

});


/////////////////



$(document).on('click', '.hour', function () {
    //debugger;
    var date = $(".activecol").attr('data');
    var hour = $(this).attr("data");
    $('.remove').remove();
    $('.hour').removeClass('activecol');
    $('.book_type').removeClass('activecol');
    $(this).addClass('activecol');
    $('.hour_wise').addClass('hide');
    contentType = 'application/x-www-form-urlencoded; charset=UTF-8';
    $("body").mLoading('show');
    $.ajax({
        url: "/bookinghistory/bookingList",
        type: "post",
        dataType: 'html',
        contentType: contentType,
        data: {'date': date, 'hour': hour},
        success: function (result) {
            $("body").mLoading('hide');
            $('.listing-data').html(result);
            $('#myTable').DataTable({
                order: [],
                columnDefs: [{orderable: false, targets: [0]}]
            });
        },
        error: function (error) {
            console.log(error);
        }
    });
    countDays(date, hour);
});

///////////////////////


$(document).on('click', '.book_type', function () {
    clearInterval(myVar2);
    $('.remove').remove();
    $('.book_type').removeClass('activecol');
    $(this).addClass('activecol');
    booking_type = $(this).attr("data");
    var booking_type = booking_type.split("_");
    var date = $(this).attr("booking_type_date");
    contentType = 'application/x-www-form-urlencoded; charset=UTF-8';
    $("body").mLoading('show');
    $.ajax({
        url: "/bookinghistory/bookingList",
        type: "post",
        dataType: 'html',
        contentType: contentType,
        data: {'date': date, 'booking_type': booking_type[1]},
        success: function (result) {
            $("body").mLoading('hide');
            $('.listing-data').html(result);
            $('#myTable').DataTable({
                order: [],
                columnDefs: [{orderable: false, targets: [0]}]
            });
        },
        error: function (error) {
            console.log(error);
        }
    });
    countDays(date, '');
});

/////////////////////////

function countDays(date, hour) {
    contentType = 'application/x-www-form-urlencoded; charset=UTF-8';
    $.ajax({
        url: "/bookinghistory/daysWise",
        type: "post",
        dataType: 'json',
        contentType: contentType,
        data: {'date': date, 'hour': hour},
        success: function (data) {
            $('.hour_wise').remove();
            $('#span_1').html("0");
            $('#span_2').html("0");
            $('#span_3').html("0");
            $('#span_4').html("0");
            $('.book_1,.book_2,.book_3,.book_4').attr('booking_type_date', date);
            for (key in data.hour) {
                var infoJSON = data.hour[key];
                $('#' + key + '>span').html('(' + infoJSON + ')');
            }
            for (i = 0; i < data.booking_type.length; i++)
            {
                $('#span_' + data.booking_type[i].booking_type).html(data.booking_type[i].no);
            }
            $('.hour_wise_0').removeClass('hide');
            $('#' + date).find('span').text('');
            if (data.total_booking > 0) {
                $('#' + date).find('span').text(' (' + data.total_booking + ')');
            }
        },
        error: function (error) {
            console.log(error);
        }
    });
}

$(document).ready(function () {
    $('#lang-button').click(function () {
        $('.lang-box:first').clone().insertAfter(".lang-box:last");
        $('.apned-div:last').append("<div><button class='btn btn-danger remove_locale remove-lang'><i class='glyphicon glyphicon-trash'></i></button></div>");
        $('.lang-box:last').find('.dafault_btn').text('Set as Default');
    });
});

$(document).on('click', '.remove-lang', function (event) {
    $(this).closest('.lang-box').remove();
    return false;
});

$("#group-tour").click(function () {
    if ($(this).is(":checked")) {

        $(".fixed-tour").show();
        //$("#add-transfer").show();
    } else {
        $(".fixed-tour").hide();
        // $("#AddPassport").show();
    }
});

$(document).on('click', '.add-departure', function () {
    $(".fixed-tour:last").clone().appendTo("#add-depart-date");
    //$(".dvaddcab:first").remove().parent();
    //$(".select-flight") .show();


});
// --------Add city night-----

$("#add-city-night").click(function () {
    $(".city-list").show();
    $("#city-itinerary").show();
    $("#introduction").show();

});

$(".add-flight").click(function () {
    $(".dvaddflight:last").clone().appendTo("#add-cab-flight");
    //$(".dvaddcab:first").remove().parent();
    $(".select-flight").show();


});

$(function () {
    $("#chkcab").click(function () {
        if ($(this).is(":checked")) {
            $(".dvcab").show();
            $("#add-transfer").show()
        } else {
            $(".dvcab").hide();
            // $("#AddPassport").show();
        }
    });

    $("#chksic").click(function () {
        if ($(this).is(":checked")) {
            $(".dvsic").show();
            $("#add-transfer").show()
        } else {
            $(".dvsic").hide();
            $("#add-transfer").hide();
        }
    });

    $("#chkbus").click(function () {
        if ($(this).is(":checked")) {
            $(".dvbus").show();
            $("#add-transfer").show()
        } else {
            $(".dvbus").hide();
            // $("#AddPassport").show();
        }
    });

    $("#chktrain").click(function () {
        if ($(this).is(":checked")) {
            $(".dvtrain").show();
            $("#add-transfer").show();
        } else {
            $(".dvtrain").hide();
            // $("#AddPassport").show();
        }
    });


    $("#group-tour").click(function () {
        if ($(this).is(":checked")) {
            $(".fixed-tour").show();
            //$("#add-transfer").show();
        } else {
            $(".fixed-tour").hide();
            // $("#AddPassport").show();
        }
    });

    $(".dvaddflight:last").clone().appendTo("#add-cab-flight");
    //$(".dvaddcab:first").remove().parent();
    $(".select-flight").show();

});

$(".add-cab").click(function () {
    $(".dvaddcab:last").clone().appendTo("#add-cab-div");
    //$(".dvaddcab:first").remove().parent();
    $(".select-cab").show();
});

$(document).ready(function () {
    $("#but_facilityType").click(function () {
        $("#add-facility").show();

    });
    $("#but_add").click(function () {
        $("#add-facility").hide();

    });
    $("#add-sightseeing-detail").click(function () {
        $("#add-detail-field").toggle();
    });

    $("#add-city-night").click(function () {
        $(".city-list").show();
        $("#city-itinerary").show();
    });

    $("#but_roomType").click(function () {
        $("#add_roomType").show();
        $("#searchDIV").hide();
    });
    $(".add-cab").click(function () {
        $(".dvaddcab:last").clone().appendTo("#add-cab-div");
        //$(".dvaddcab:first").remove().parent();
        $(".select-cab").show();
    });

    $(".add-flight").click(function () {
        $(".dvaddflight:last").clone().appendTo("#add-cab-flight");
        //$(".dvaddcab:first").remove().parent();
        $(".select-flight").show();
    });

    $(document).on('click', '.add-departure', function () {
        $(".fixed-tour:last").clone().appendTo("#add-depart-date");
        //$(".dvaddcab:first").remove().parent();
        //$(".select-flight") .show();
    });
});

$(document).on('click', '.trip-detail', function () {
    
  var id= $(this).attr("rel");
   $('.removetrip').html('');
        $.ajax({
            type: "POST",
            url: '/bookinghistory/tripDetailsList',
            data: {id: id},
            dataType: "html",
            success: function (result) {
                $('#removetrip-'+id).html(result);
            }
        });
});
 