/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
var modalTarget = $('#ajax-modal');
var modalContent = $('.modal-content');
function openAjaxModal(method, url, requestData) {
    $.ajax({
        type: method,
        url: url,
        data: requestData,
        async: false,
        dataType: 'html'
    }).done(function (data) {
        modalContent.html(data);
    }).fail(function () {
        modalContent.html('There is an error to load the modal.');
    });
    modalTarget.modal({backdrop: 'static', keyboard: false});
}
$(document).ready(function () {
    //$('.select-car').contents().first()[0].textContent='Selected';
    //$('#pickup-city').addClass('test');
    /**  Desc - For inputbox title up and down  */
    $(document).on('blur', '.inputMaterial', function () {
        var val = $(this).val();
        if (val != "") {
            // alert(1);
            $(this).addClass('test');
        } else {
            $(this).removeClass('test');
        }
    });
    $(".inputMaterial").each(function () {
        var val = $(this).val();
        if (val != "") {
            $(this).addClass("test");
        }
        if (val == "0") {
            $(this).removeClass("test");
        }
    });
    $(document).on('click', 'a[data-toggle="tab"]', function (event) {
        event.preventDefault();
        console.log($(this).attr('href'));//return false;
        var url = $(this).attr('href');
        var targetDiv = $(this).attr('data-target');
        var contentType = 'application/x-www-form-urlencoded; charset=UTF-8';
        $.ajax({
            type: "GET",
            url: url,
            async: false,
            dataType: 'html',
            contentType: contentType,
            context: this
        }).done(function (data) {
            $(targetDiv).html(null);
            $(targetDiv).html(data);
        }).fail(function (response) {

        }).always(function () {
            $(this).tab('show');
            return false;
        });
    });
    $(document).on('click', '.dropdown-menu li a', function () {
        $('#selected-city').text($(this).text());
    });
    $(document).on('click', '#cash-payment', function () {
        var ckbox = $('#cash-payment');
        if (ckbox.is(':checked')) {
            $("#wallet-amount").prop("checked", false);
            $(".booking_amt_details").hide();
        } else {
            $("#wallet-amount").prop("checked", true);
            $(".booking_amt_details").show();
        }

    });
    $(document).on('click', '#wallet-amount', function () {
        var ckbox = $('#wallet-amount');
        if (ckbox.is(':checked')) {
            $("#cash-payment").prop("checked", false);
            $(".booking_amt_details").show();
        } else {
            $("#cash-payment").prop("checked", true);
            $(".booking_amt_details").hide();
        }

    });
    $(document).on('click', '.search_but', function (event) {
        event.preventDefault();
        var city_name = $("#service_city").val();
        city_name = city_name.split('(');
        city_name = city_name[0];
        if (city_name == "") {
            $(".error-msg").text('Please enter city');
        } else {
            $(".error-msg").text('');
            var data = {city_name: city_name}

            contentType = 'application/x-www-form-urlencoded; charset=UTF-8';
            $('#service_city').addClass('loading');
            $.ajax({
                type: "POST",
                url: '/application/get-service-type',
                data: data,
                async: false,
                dataType: 'json',
                contentType: contentType,
            }).done(function (response) {
                //alert(response.data);
                //$('#service-module').html(response);
                window.location = response.data;
            }).fail(function (response) {
                console.log("There is some error!!");
            }).always(function () {
                $('#service_city').removeClass('loading');
            });
        }
    });
    $(document).on('click', '.search_module_but', function (event) {
        event.preventDefault();
        var city_name = $("#module_city").val();
        city_name = city_name.split('(');
        city_name = city_name[0];
        if (city_name == "") {
            $(".error-msg1").text('Please enter city');
        } else {
            $(".error-msg1").text('');
            var data = {city_name: city_name}

            contentType = 'application/x-www-form-urlencoded; charset=UTF-8';
            $('#module_city').addClass('loading');
            $.ajax({
                type: "POST",
                url: '/application/get-service-type',
                data: data,
                async: false,
                dataType: 'json',
                contentType: contentType,
            }).done(function (response) {
                window.location = response.data;
                //$('#service-module1').html(response);
            }).fail(function (response) {
                console.log("There is some error!!");
            }).always(function () {
                $('#module_city').removeClass('loading');
            });
        }
    });
    $("#service_city").autocomplete({
        source: function (request, response) {
            contentType = 'application/x-www-form-urlencoded; charset=UTF-8';
            $('#service_city').addClass('loading');
            $.ajax({
                type: "POST",
                url: '/application/get-city-list',
                dataType: "json",
                data: {
                    term: request.term
                },
                success: function (data) {
                    $('#service_city').removeClass('loading');
                    response(data);
                },
                error: function () {
                    $('#service_city').removeClass('loading');
                }
            });
        },
        minLength: 1,
        delay: 300,
        focus: function (event, ui) {
            $(this).val(ui.item.label);
            return false;
        },
        select: function (event, ui) {
            $(this).val(ui.item.label);
            if (ui.item.city_id != "") {
                $('#service-city-value').val(ui.item.city_id);
                $('#service_city').val(ui.item.label);
                var data = {city_name: ui.item.city_name}
                $.ajax({
                    type: "POST",
                    url: '/application/get-services-type',
                    data: data,
                    dataType: 'html'
                }).done(function (response) {
                    $(".error-msg").text('');
                    $('#service-module').html(response);
                    window.location = '/city/' + ui.item.city_name;
                }).fail(function (response) {
                    console.log("There is some error!!");
                }).always(function () {
                    $('#service_city').removeClass('loading');
                });
            }
            return false;
        }
    });
    $("#module_city").autocomplete({
        source: function (request, response) {
            contentType = 'application/x-www-form-urlencoded; charset=UTF-8';
            $('#module_city').addClass('loading');
            $.ajax({
                type: "POST",
                url: '/application/get-city-list',
                dataType: "json",
                data: {
                    term: request.term
                },
                success: function (data) {
                    $('#module_city').removeClass('loading');
                    response(data);
                }
            });
        },
        minLength: 1,
        delay: 300,
        focus: function (event, ui) {
            $(this).val(ui.item.label);
            return false;
        },
        select: function (event, ui) {
            $(this).val(ui.item.label);
            if (ui.item.city_id != "") {
                $('#module-city-value').val(ui.item.city_id);
                $('#module_city').val(ui.item.label);
                var data = {city_name: ui.item.city_name}
                $.ajax({
                    type: "POST",
                    url: '/application/get-services-type',
                    data: data,
                    dataType: 'html'
                }).done(function (response) {
                    $(".error-msg1").text('');
                    $('#service-module1').html(response);
                    window.location = '/city/' + ui.item.city_name;
                }).fail(function (response) {
                    console.log("There is some error!!");
                }).always(function () {
                    $('#module_city').removeClass('loading');
                });
            }
            return false;
        }
    });
    // Input type text In uppercase  //
    $('.inputuppercase').on('keypress', function (event) {
        var $this = $(this),
                val = $this.val(),
                regex = /\b[a-z]/g;
        var ID = $(this).attr("id");
        val = val.toLowerCase().replace(regex, function (letter) {
            return letter.toUpperCase();
        });
        // I want this value to be in the input field.
        $('#' + ID).val(val);
    });
    // END //
    // Inputtype text In lowercase //
    $('.inputlowercase').on('keypress', function (event) {
        var $this = $(this),
                val = $this.val(),
                regex = /\b[a-z]/g;
        var ID = $(this).attr("id");
        val = val.toLowerCase().replace(regex, function (letter) {
            return letter.toLowerCase();
        });
        // I want this value to be in the input field.
        $('#' + ID).val(val);
    });
    //END //
    $('.error,.success,.info', $('.server-error')).delay('3000').fadeOut('5000');
    $(document).on('click', '#refreshcaptcha', function () {
        var captcha = $('input[name="captcha[id]"]').val();
        var data = {captcha: captcha}
        $.ajax({
            type: "POST",
            url: '/refresh',
            dataType: 'json',
            data: data,
            success: function (data) {
                $('#personal-registration-form img').attr('src', data.src);
                $('input[name="captcha[id]"]').val(data.id);
            }
        });
    });
    $(document).on('click', '#travellercaptcha', function () {
        var captcha = $('input[name="travellercaptcha[id]"]').val();
        var data = {captcha: captcha}
        $.ajax({
            type: "POST",
            url: '/refresh',
            dataType: 'json',
            data: data,
            success: function (data) {
                $('#traveller-form img').attr('src', data.src);
                $('input[name="travellercaptcha[id]"]').val(data.id);
            }
        });
    });
    $(document).on('click', '#popuprefreshcaptcha', function () {
        var captcha = $('input[name="popupcaptcha[id]"]').val();
        var data = {captcha: captcha}
        $.ajax({
            type: "POST",
            url: '/refresh',
            dataType: 'json',
            data: data,
            success: function (data) {
                $('#popup-registration-form img').attr('src', data.src);
                $('input[name="popupcaptcha[id]"]').val(data.id);
            }
        });
    });
    // Common file upload using ajax --Added By (Mohit verma)
    $(document).on('change', '.common-upload-file', function () {
        var id = $(this).attr("id");
        var level_name = ($(this).attr("data-level-name"));

        var fd = new FormData();
        var files = $("#" + id)[0].files[0];
        fd.append('file', files);
        fd.set('fileuploadname', level_name);
        $.ajax({
            url: '/upload-file',
            type: 'post',
            dataType: 'json',
            data: fd,
            contentType: false,
            processData: false,
            success: function (response) {
                if (response.status != 'error') {
                    //alert('file uploaded successfully');
                    setTimeout(function () {
                        $("#" + id).after("<span class='text-success'>" + response.message + "</span><br/>");
                        $("#" + id).hide();
                        $("." + level_name).hide();
                    }, 2000);
                    $("#" + id).val('');
                    //$(".preview img").show(); // Display image element
                } else {
                    $("#" + id).after("<span class='success'>" + response.message + "</span><br/>");
                }
            },
        });
    });
    $(document).on('click', '#book-vehicle-user', function () {
        var ckbox = $('#book-vehicle-user');
        if (ckbox.is(':checked')) {
            $('#first-name').val('');
            $('#first-name').removeAttr('readonly');
            $('#last-name').val('');
            $('#last-name').removeAttr('readonly');
            $('#mobile').val('');
            $('#mobile').removeAttr('readonly');
            $('#alt-mobile-number').val('');
            $('#alt-mobile-number').removeAttr('readonly');
            $('#email').val('');
            $('#email').removeAttr('readonly');
        } else {
            $.ajax({
                type: "POST",
                url: '/get-user-data',
                dataType: 'json',
                data: {},
                success: function (data) {
                    $('#first-name').val(data.first_name);
                    $('#first-name').attr('readonly', 'true');
                    $('#last-name').val(data.last_name);
                    $('#last-name').attr('readonly', 'true');
                    $('#mobile').val(data.mobile);
                    $('#mobile').attr('readonly', 'true');
                    $('#alt-mobile-number').val(data.alt_mobile_number);
                    $('#alt-mobile-number').attr('readonly', 'true');
                    $('#email').val(data.email);
                    $('#email').attr('readonly', 'true');
                }
            });
        }
    });
    $(document).on('click', '.add_compare', function () {
        var s_id = $(this).attr('rel');
        var URL = "/sight-seeing/add-compare";
        contentType = 'application/x-www-form-urlencoded; charset=UTF-8';
        $.ajax({
            type: 'post',
            url: URL,
            data: {'s_id': s_id},
            async: false,
            dataType: 'json',
            contentType: contentType,
        }).done(function (data) {
            alert(data.msg);
            $('.sight-count').text('(' + data.count + ')')
        }).fail(function () {
            // alertm msg
        });
    });
});




// Prepare reset.
function resetFormErrors() {
    $('.form-group').removeClass('has-error');
    $('.form-group').find('.help-block-white').remove();
    $('.form-group').find('.help-block').remove();
}
function getFileExtension(fileName) {
    // Use a regular expression to trim everything before final dot
    var extension = fileName.replace(/^.*\./, '');
    // If there is no dot anywhere in filename, we would have extension == filename,
    // so we account for this possibility now
    if (extension === fileName) {
        extension = '';
    } else {
        // if there is an extension, we convert to lower case on the file upload.
        extension = extension.toLowerCase();
    }
    return extension;
}
function checkExtension(fileExtension) {
    switch (fileExtension) {
        case 'jpeg':
            return true;
        case 'jpg':
            return true;
        case 'png':
            return true;
        case 'csv':
            return true;
        case 'xls':
            return true;
        case 'xlsx':
            return true;
        default:
            return false;
    }
}
function htmlEntities(str) {
    return String(str).replace(/&/g, '&amp;').replace(/</g, '&lt;').replace(/>/g, '&gt;').replace(/"/g, '&quot;');
}
function isSet(variable) {
    return (variable !== "" && variable !== null && variable !== undefined && typeof (variable) !== "undefined") ? true : false;
} // Returns 1 if set, 0 false
function getCurrentDateTime() {
    var now = new Date();
    var datetime = now.getFullYear() + '-' + getTwoDigit(now.getMonth() + 1) + '-' + getTwoDigit(now.getDate());
    datetime += ' ' + getTwoDigit(now.getHours()) + ':' + getTwoDigit(now.getMinutes()) + ':' + getTwoDigit(now.getSeconds());
    return datetime;
}
// JavaScript Document
//fixed topbar
//$(function () {
//    var sidebar = $('.topbar');
//    var top = sidebar.offset().top - parseFloat(sidebar.css('margin-top'));
//
//    $(window).scroll(function (event) {
//        var y = $(this).scrollTop();
//        if (y >= top) {
//            sidebar.addClass('fixed');
//        } else {
//            sidebar.removeClass('fixed');
//        }
//    });
//});
//end fixed topbar
// start clockpicker
/*$('.clockpicker').clockpicker({
 placement: 'bottom',
 align: 'right',
 autoclose: true,
 'default': 'now'
 })
 .find('input').change(function () {
 console.log(this.value);
 });
 var input = $('#single-input').clockpicker({
 placement: 'bottom',
 align: 'left',
 autoclose: true,
 'default': 'now'
 });*/
$(document).ready(function () {
    $('#pickup-time').timepicker({'timeFormat': 'H:i', 'step': 15, 'scrollDefault': 'now'});
    $('#pickup_time').timepicker({'timeFormat': 'H:i', 'step': 15, 'scrollDefault': 'now'});
    $('#return-time').timepicker({'timeFormat': 'H:i', 'step': 15, 'scrollDefault': 'now'});
    $('.glyphicon-time').click(function () {
        $('#pickup-time').click();
        $('#pickup_time').click();
    });
    $('.return-time-icon').click(function () {
        $('#return-time').click();
    });
});
/*$(function () {
 $('.clockpicker').clockface();
 $('#pickup-time').clockface();
 $('#return-time').clockface();
 $('#pickup-time').addClass('test');
 });
 $('.glyphicon-time').click(function (e) {
 e.stopPropagation();
 $('#pickup-time').clockface('toggle');
 $('#pickup_time').clockface('toggle');
 $('#return-time').clockface('toggle');
 $('#return-time').addClass('test');
 });*/
// Manually toggle to the minutes view
$('#check-minutes').click(function (e) {
    // Have to stop propagation here
    e.stopPropagation();
    input.clockpicker('show')
            .clockpicker('toggleView', 'minutes');
});
//if (/mobile/i.test(navigator.userAgent)) {
//    $('input').prop('readOnly', true);
//}
//end clockpicker
//start picknow
$(document).ready(function () {
    $("#pickup-now").click(function () {
        $("#pickup-date").val("");
        $("#pickup-time").val("");
        $("#datetime").hide();
    });
    $("#pickup-later").click(function () {
        $("#datetime").show();
    });
    $("#owned").click(function () {
        //$("#pickup-date").val("");
        //$("#pickup-time").val("");
        $("#vehicle-attached").hide();
    });
    $("#attached").click(function () {
        $("#vehicle-attached").show();
    });
    $("#roundtrip").click(function () {
        $("#round_trip").show();
        $(".round_trip").show();
        $(".one_way").hide();
        $("#multy_Outstation").hide();
        $("#roundtrip_Outstation").show();
        //$("#one_way").hide();
    });
    $("#oneway").click(function () {
        $("#round_trip").hide();
        $("#roundtrip_Outstation").show();
        $("#multy_Outstation").hide();
        $(".round_trip").hide();
        $(".one_way").show();
        //$("#one_way").show();
    });
    $("#multicity").click(function () {
        $("#multy_guidefor").show();
        $("#multy_Outstation").show();
        $("#departure-local").hide();
        $("#roundtrip_Outstation").hide();
        $(".round_trip").hide();
    });
    $("#going-to").click(function () {
        $("#drop-area").val('');
        $("#drop-address").val('');
        $("#pickup_location").show();
        $("#pickup_address").show();
        $("#dropup_location").hide();
        $("#dropup_address").hide();
    });
    $("#coming-from").click(function () {
        $("#pickup-area").val('');
        $("#pickup-address").val('');
        $("#pickup_location").hide();
        $("#pickup_address").hide();
        $("#dropup_location").show();
        $("#dropup_address").show();
    });
    $("#add_markup").click(function () {
        $("#markup_div").show();
        $("#search_markup").hide();
    });
    $("#back_markup").click(function () {
        $("#search_markup").show();
        $("#markup_div").hide();
    });
    var ckbox = $('#gst');
    $('input').on('click', function () {
        if (ckbox.is(':checked')) {
            $("#gst_no").show();
        } else {
            $("#gst_no").hide();
        }
    });
});
//end picknow
$(function () {
    $('.minus,.add').on('click', function () {
        var $qty = $(this).closest('p').find('.qty'),
                currentVal = parseInt($qty.val()),
                isAdd = $(this).hasClass('add');
        !isNaN(currentVal) && $qty.val(
                isAdd ? ++currentVal : (currentVal > 0 ? --currentVal : currentVal)
                );
    });
});
$(function () {
    $("#flight-mode").click(function () {
        if ($(this).is(":checked")) {
            $("#flight-mode-div").show();
        } else {
            $("#flight-mode-div").hide();
        }
    });
});
function openCity(evt, cityName) {
    var i, tabcontent, tablinks;
    tabcontent = document.getElementsByClassName("tabcontent");
    for (i = 0; i < tabcontent.length; i++) {
        tabcontent[i].style.display = "none";
    }
    tablinks = document.getElementsByClassName("tablinks");
    for (i = 0; i < tablinks.length; i++) {
        tablinks[i].className = tablinks[i].className.replace(" active", "");
    }
    document.getElementById(cityName).style.display = "block";
    evt.currentTarget.className += " active";
}
//number-textbox
jQuery('<div class="quantity-nav"><div class="quantity-button quantity-up"></div><div class="quantity-button quantity-down"></div></div>').insertAfter('.quantity input');
jQuery('.quantity').each(function () {
    var spinner = jQuery(this),
            input = spinner.find('input[type="number"]'),
            btnUp = spinner.find('.quantity-up'),
            btnDown = spinner.find('.quantity-down'),
            min = input.attr('min'),
            max = input.attr('max');
    btnUp.click(function () {
        var oldValue = parseFloat(input.val());
        if (oldValue >= max) {
            var newVal = oldValue;
        } else {
            var newVal = oldValue + 1;
        }
        spinner.find("input").val(newVal);
        spinner.find("input").trigger("change");
    });
    btnDown.click(function () {
        var oldValue = parseFloat(input.val());
        if (oldValue <= min) {
            var newVal = oldValue;
        } else {
            var newVal = oldValue - 1;
        }
        spinner.find("input").val(newVal);
        spinner.find("input").trigger("change");
    });
});
function initPickAddress(lat, lng) {
    var options = {
        types: ['geocode'],
        types: ['address'],
        types: ['establishment'],
        trictBounds: true,
        componentRestrictions: {country: "in"},
    };
    var input = document.getElementById('pickup-address');
    var autocomplete = new google.maps.places.Autocomplete(input, options);
    var geolocation = {
        lat: parseFloat(lat),
        lng: parseFloat(lng)
    };
    //console.log(geolocation);
    var circle = new google.maps.Circle(
            {center: geolocation, radius: 100});
    autocomplete.setBounds(circle.getBounds());
}
//google.maps.event.addDomListener(window, 'load', initPickAddress);
/*$(document).on('blur', '#ptp-drop-address', function () {
    $('.pac-container').remove();
});*/
$(document).on('focus', '#pickup-address', function () {
    var northeast_lat = $("#city-northeast-latitude").val();
    var northeast_lng = $("#city-northeast-longitude").val();
    var southwest_lat = $("#city-southwest-latitude").val();
    var southwest_lng = $("#city-southwest-longitude").val();
    var lat = $("#city-latitude").val();
    var lng = $("#city-longitude").val();
    initPickAddress(lat, lng);
});
$(document).on('focus', '#ptp-drop-address', function () {
    var lat = $("#city-latitude").val();
    var lng = $("#city-longitude").val();
    initPTPDropAddress(lat, lng);
});
function initPTPDropAddress(lat, lng) {
    var options = {
        types: ['geocode'],
        types: ['address'],
        types: ['establishment'],
        trictBounds: true,
        componentRestrictions: {country: "in"},
    };
    var input = document.getElementById('ptp-drop-address');
    var autocomplete = new google.maps.places.Autocomplete(input, options);
    var geolocation = {
        lat: parseFloat(lat),
        lng: parseFloat(lng)
    };
    //console.log(geolocation);
    var circle = new google.maps.Circle(
            {center: geolocation, radius: 100});
    autocomplete.setBounds(circle.getBounds());
}
/*function initPTPDropAddress(northeast_lat, northeast_lng, southwest_lat, southwest_lng) {
    var bounds = new google.maps.LatLngBounds(
            new google.maps.LatLng(southwest_lat, southwest_lng), //southwest
            new google.maps.LatLng(northeast_lat, northeast_lng)); //northeast
    var options = {
        bounds: bounds,
        types: ['geocode'],
        strictBounds: true,
        componentRestrictions: {country: "in"},
    };
    var input = document.getElementById('ptp-drop-address');
    var autocomplete = new google.maps.places.Autocomplete(input, options);
}*/
//google.maps.event.addDomListener(window, 'load', initPTPDropAddress);
/*function initDropAddress() {
    var options = {
        componentRestrictions: {country: "in"},
    };
    var input = document.getElementById('drop-address');
    var autocomplete = new google.maps.places.Autocomplete(input, options);
}*/
function initDropAddress(lat, lng) {
    var options = {
        types: ['geocode'],
        types: ['address'],
        types: ['establishment'],
        trictBounds: true,
        componentRestrictions: {country: "in"},
    };
    var input = document.getElementById('drop-address');
    var autocomplete = new google.maps.places.Autocomplete(input, options);
    var geolocation = {
        lat: parseFloat(lat),
        lng: parseFloat(lng)
    };
    //console.log(geolocation);
    var circle = new google.maps.Circle(
            {center: geolocation, radius: 100});
    autocomplete.setBounds(circle.getBounds());
}
$(document).on('focus', '#drop-address', function () {
    var lat = $("#city-latitude").val();
    var lng = $("#city-longitude").val();
    initDropAddress(lat, lng);
});
//google.maps.event.addDomListener(window, 'load', initDropAddress);
var today = new Date().toISOString().split('T')[0];
$("#pickup-area").autocomplete({
    source: function (request, response) {
        var url = $("#vehicle-search-form").attr('action').split('/');
        //$("body").mLoading('show');
        $('#pickup-area').addClass('loading');
        $.ajax({
            url: '/' + url[1] + '/location',
            dataType: "json",
            type: "POST",
            data: {
                term: request.term,
                city: $("#city-id").val()
            },
            success: function (data) {
                //$("body").mLoading('hide');
                $('#pickup-area').removeClass('loading');
                response(data);
            }
        });
    },
    min_length: 3,
    delay: 300,
    focus: function (event, ui) {
        if (ui.item.label != "Not Exist") {
            $("#pickup-area").val(ui.item.label);
        }
        return false;
    },
    select: function (event, ui) {
        //alert(ui.item.label);
        if (ui.item.label != "Not Exist") {
            $("#drop-area").val('');
            //$("#pickup-address").val('');
            $("#pickup-area").val(ui.item.label);
            $("#pickup-area-value").val(ui.item.value);
            //$('#city-latitude').val(ui.item.lat);
            //$('#city-longitude').val(ui.item.lng);
            //initPickAddress(ui.item.lat, ui.item.lng);
        }
        return false;
    }
});
$("#drop-area").autocomplete({
    source: function (request, response) {
        var url = $("#vehicle-search-form").attr('action').split('/');
        //$("body").mLoading('show');
        $('#drop-area').addClass('loading');
        $.ajax({
            url: '/' + url[1] + '/location',
            dataType: "json",
            type: "POST",
            data: {
                term: request.term,
                city: $("#city-id").val()
            },
            success: function (data) {
                $('#drop-area').removeClass('loading');
                response(data);
            }
        });
    },
    min_length: 3,
    delay: 300,
    focus: function (event, ui) {
        if (ui.item.label != "Not Exist") {
            $("#drop-area").val(ui.item.label);
        }
        return false;
    },
    select: function (event, ui) {
        if (ui.item.label != "Not Exist") {
            $("#drop-area").val(ui.item.label);
            $("#drop-area-value").val(ui.item.value);
        }
        return false;
    }
});
$(function () {
    $(".pickup-city").autocomplete({
        source: function (request, response) {
            var url = $("#vehicle-search-form").attr('action').split('/');
            //$("body").mLoading('show');
            $('.pickup-city').addClass('loading');
            $.ajax({
                url: '/' + url[1] + '/getCityList',
                dataType: "json",
                type: "POST",
                data: {
                    term: request.term
                },
                success: function (data) {
                    $('.pickup-city').removeClass('loading');
                    response(data);
                    if (data[0].label == "Not Exist") {
                        $(".pickup-city").val("");
                    }
                }
            });
        },
        min_length: 3,
        delay: 300,
        focus: function (event, ui) {
            if (ui.item.label != "Not Exist") {
                $(this).val(ui.item.label);
            }
            return false;
        },
        select: function (event, ui) {
            var drop_city = $("#dropcity-id").val();
            if (drop_city == ui.item.city_id) {
                $(".drop-city-error").show();
                $(this).val('');
                $('#pickcity-id').val('');
            } else {
                $(".drop-city-error").hide();
                if (ui.item.label != "Not Exist") {
                    $(this).val(ui.item.label);
                    $('#pickcity-id').val(ui.item.city_id);
                }
            }
            //$(this).val(ui.item.label);
            if (ui.item.city_id != "") {
                $('#city-id').val(ui.item.city_id);
                $('#pickcity-id').val(ui.item.city_id);

                //////// Find Lat Long Starts here ////////////
                if (ui.item.latitude != "" && ui.item.longitude != "" && ui.item.north_east_latitude != "" && ui.item.north_east_longitude != "" && ui.item.south_west_latitude != "" && ui.item.south_west_longitude != "") {
                    $("#pickup-area").val('');
                    $("#drop-area").val('');
                    $("#pickup-address").val('');
                    $("#ptp-drop-address").val('');
                    $("#drop-address").val('');
                    $('#city-latitude').val(ui.item.latitude);
                    $('#city-longitude').val(ui.item.longitude);
                    $('#city-northeast-latitude').val(ui.item.north_east_latitude);
                    $('#city-northeast-longitude').val(ui.item.north_east_longitude);
                    $('#city-southwest-latitude').val(ui.item.south_west_latitude);
                    $('#city-southwest-longitude').val(ui.item.south_west_longitude);
                } else {
                    var url = $("#vehicle-search-form").attr('action').split('/');
                    var data = {
                        term: ui.item.label
                    }
                    $.ajax({
                        type: "POST",
                        url: '/' + url[1] + '/getLatLng',
                        data: data,
                        dataType: 'json'
                    }).done(function (resp) {
                        if (resp.status == true) {
                            $("#pickup-area").val('');
                            $("#drop-area").val('');
                            $("#pickup-address").val('');
                            $("#drop-address").val('');
                            $("#ptp-drop-address").val('');
                            $('#city-latitude').val(resp.data.lat);
                            $('#city-longitude').val(resp.data.lng);
                            $('#city-northeast-latitude').val(resp.data.north_east_lat);
                            $('#city-northeast-longitude').val(resp.data.north_east_lng);
                            $('#city-southwest-latitude').val(resp.data.south_west_lat);
                            $('#city-southwest-longitude').val(resp.data.south_west_lng);
                            initPickAddress(resp.data.north_east_lat, resp.data.north_east_lng, resp.data.south_west_lat, resp.data.south_west_lng);
                            initPTPDropAddress(resp.data.north_east_lat, resp.data.north_east_lng, resp.data.south_west_lat, resp.data.south_west_lng);

                        } else {
                        }
                    }).fail(function (response) {
                        console.log("There is some error!!");
                    }).always(function () {
                        $("body").mLoading('hide');
                    });
                }
                //////// Find Lat Long Ends here
                var master_package_type = $('#master-package-type').val();
                if (master_package_type == 1) {
                    var url = $("#vehicle-search-form").attr('action').split('/');
                    var data = {
                        city_id: ui.item.city_id,
                        master_package_type: master_package_type
                    }
                    $.ajax({
                        type: "POST",
                        url: '/' + url[1] + '/getAjaxPackageList',
                        data: data,
                        dataType: 'json'
                    }).done(function (resp) {
                        if (resp.status == true) {
                            $("#package-id").empty();
                            $("#package-id").append("<option value=''></option>");
                            $.each(resp.data, function (idx, obj) {
                                $("#package-id").append("<option value='" + obj["local_package_id"] + "'>" + obj["package_name"] + "</option>");
                            });
                            getLocalFare(url[1], ui.item.city_id, ui.item.label, master_package_type);
                        } else {
                            $("#package-id").empty();
                            $("#package-id").append("<option value=''></option>");
                            $(".vehicle-tarrif").html('');
                            alert("No Package are Available");
                        }
                    }).fail(function (response) {
                        console.log("There is some error!!");
                    }).always(function () {
                        $("body").mLoading('hide');
                    });
                }
                if (master_package_type == 3) {
                    var url = $("#vehicle-search-form").attr('action').split('/');
                    var data = {
                        city_id: ui.item.city_id,
                    }
                    $.ajax({
                        type: "POST",
                        url: '/' + url[1] + '/getAjaxAirportList',
                        data: data,
                        dataType: 'json'
                    }).done(function (resp) {
                        if (resp.status == true) {
                            $("#airport").empty();
                            $("#airport").append("<option value=''></option>");
                            $.each(resp.data, function (idx, obj) {
                                $("#airport").append("<option value='" + obj["id"] + "'>" + obj["package_name"] + "</option>");
                            });
                        } else {
                            $("#airport").empty();
                            $("#airport").append("<option value=''></option>");
                            alert("No Package are Available");
                        }
                    }).fail(function (response) {
                        console.log("There is some error!!");
                    }).always(function () {
                        $("body").mLoading('hide');
                    });
                }
            }
            return false;
        }
    });
});
$("#drop-city").autocomplete({
    source: function (request, response) {
        var url = $("#vehicle-search-form").attr('action').split('/');
        $('#drop-city').addClass('loading');
        $.ajax({
            url: '/' + url[1] + '/getToCityList',
            dataType: "json",
            type: "POST",
            data: {
                term: request.term
            },
            success: function (data) {
                $('#drop-city').removeClass('loading');
                response(data);
                // console.log(data); return false;
                if (data[0].label == "Not Exist") {
                    $("#drop-city").val("");
                }
            }
        });
    },
    min_length: 3,
    delay: 300,
    focus: function (event, ui) {
        if (ui.item.label != "Not Exist") {
            $(this).val(ui.item.label);
        }
        return false;
    },
    select: function (event, ui) {
        var pickup_city = $("#pickcity-id").val();
        if (pickup_city == ui.item.city_id) {
            $(".drop-city-error").show();
            $(this).val('');
            $('#dropcity-id').val('');
        } else {
            $(".drop-city-error").hide();
            if (ui.item.label != "Not Exist") {
                $(this).val(ui.item.label);
                $('#dropcity-id').val(ui.item.city_id);
            }
        }
        return false;
    }
});
function getLocalFare(url, city_id, city_name, master_package_type) {
    var data = {
        city_id: city_id,
        city_name: city_name,
        master_package_type: master_package_type
    }
    $.ajax({
        type: "POST",
        url: '/' + url + '/getLocalFareList',
        data: data,
        dataType: 'html'
    }).done(function (resp) {
        $(".vehicle-tarrif").html(resp);
        gridview();
    }).fail(function (response) {
        console.log("There is some error!!");
    }).always(function () {
        $("body").mLoading('hide');
    });
}
function gridview() {
    $("#list").click(function () {
        $(".price-list").show();
        $(".price-grid").hide();
    });
    $("#grid").click(function () {
        $(".price-list").hide();
        $(".price-grid").show();
    });
}
if ($(".vehicle-select").length > 0) {
    $('.vehicle-select').parent().contents().first()[0].textContent = 'Selected';
}
$(document).on('click', '.vehicle-select', function () {
    $('.car_select_but').removeClass('car_select_active');
    $('.select-car').each(function () {
        $(this).contents().first()[0].textContent = 'Select';
    });
    $(this).parent().parent().addClass('car_select_active');
    $(this).parent().contents().first()[0].textContent = 'Selected';
    var vehicleId = $(this).val();
    var currencyType = $('#currency-type').val();
    var data = {
        vehicle_id: vehicleId,
        currency_type: currencyType
    }
    var url = $("#vehicle-search-form").attr('action').split('/');
    contentType = 'application/x-www-form-urlencoded; charset=UTF-8';
    //document.querySelector("body").style.visibility = "hidden";
    //document.querySelector("#loader").style.visibility = "visible";
    $.ajax({
        type: "POST",
        url: '/' + url[1] + '/payment',
        data: data,
        async: true,
        dataType: 'json',
        contentType: contentType,
    }).done(function (response) {
        if (response.master_package_mode_id == '1') {
            $('.distance-fare').show();
            $('.hourly-fare').hide();
        }
        if (response.master_package_mode_id == '2') {
            $('.distance-fare').hide();
            $('.hourly-fare').show();
        }
        if (response.master_package_mode_id == '3') {
            $('.hourly-fare').show();
            $('.distance-fare').show();
        }
        if (response.master_package_mode_id == '4') {
            $('.hourly-fare').hide();
            $('.distance-fare').show();
        }
         var service_charge = $('#service-charge').val();
        if(service_charge){
            response.total_price = response.total_price - response.tax_price;
            response.total_price = Number(response.total_price) + Number(service_charge);
            response.tax_price = (response.total_price * response.tax_percentage/100);
            response.total_price = response.total_price + response.tax_price;
        }
        $('#coupon-code').val('');
        $('#master_package_mode_id').val(response.master_package_mode_id);
        $('.coupon-code-msg').html('');
        $('#total-discount').val(0);
        $('.total-discount').text(0);
        $('#base-fare').val(response.base_fare);
        $('.base-fare').text(response.base_fare);
        $('#per-km-price').val(response.per_km_price);
        $('.per-km-price').text(response.per_km_price);
        $('#min-distance').val(response.min_distance);
        $('.min-distance').text(response.min_distance);
        $('.min-hour').text(response.min_pkg_hrs);
        $('#min-hour').val(response.min_pkg_hrs);
        $('.per-hour-charge').text(response.per_hr_charge);
        $('#per-hour-charge').val(response.per_hr_charge);
        $('#running-amt').val(response.running_amt);
        $('.running-amt').text(response.running_amt);
        $('#peak-time-price').val(response.peak_time_price);
        $('.peak-time-price').text(response.peak_time_price);
        $('#night-charge').val(response.night_charge);
        $('.night-charge').text(response.night_charge);
        $('#extra-charge').val(response.extra_charge);
        $('.extra-charge').text(response.extra_charge);
        $('#price-before-tax').val(response.price_before_tax);
        $('.price-before-tax').text(response.price_before_tax);
        $('#tax-percentage').val(response.tax_percentage);
        $('.tax-percentage').text(response.tax_percentage);
        $('#tax-price').val(response.tax_price);
        $('.tax-price').text(response.tax_price);
        $('#markup-value').val(response.markup_value);
        $('.markup-value').text(response.markup_value);
        $('#markup-type').val(response.markup_type);
        $('.markup-type').text(response.markup_type);
        $('#markup-price').val(response.markup_price);
        $('.markup-price').text(response.markup_price);
        $('#markup-base').val(response.markup_base);
        $('#total-price,#total-charge').val(response.total_price);
        $('.total-price,.total-charge').text(response.total_price);
    }).fail(function (response) {
        console.log("There is some error!!");
    }).always(function () {
        //$("body").mLoading('hide');
         //document.querySelector("#loader").style.display = "none";
         //document.querySelector("body").style.visibility = "visible";
    });
});
$(document).on('click', '.apply-coupon', function () {
    $('.coupon-code-msg').html("");
    var couponCode = $('#coupon-code').val();
    var totalPrice = $('#total-price').val();
    var masterPackageId = $('#master-package-type').val();
    if (couponCode == "") {
        $('.coupon-code-msg').html("Please enter the Coupon Code");
        $('.coupon-code-msg').css("color", "red");
    } else {
        var data = {
            coupon_code: couponCode,
            total_price: totalPrice,
            master_package_id: masterPackageId
        }
        var url = $("#vehicle-search-form").attr('action').split('/');
        contentType = 'application/x-www-form-urlencoded; charset=UTF-8';
        //$("body").mLoading('show');
        $('#coupon-code').addClass('loading');
        $.ajax({
            type: "POST",
            url: '/' + url[1] + '/apply-coupon',
            data: data,
            async: false,
            dataType: 'json',
            contentType: contentType,
        }).done(function (response) {
            $('#coupon-code').removeClass('loading');
            if (response.status == true) {
                $('.coupon-code-msg').html(response.msg);
                $('.coupon-code-msg').css("color", "green");
                $('#total-charge').val(response.total_price);
                $('.total-charge').text(response.total_price);
                $('#total-discount').val(response.coupon_discount);
                $('.total-discount').text(response.coupon_discount);
                $('#coupon-code-id').val(response.coupon_id);
                $('#coupon-discount-type').val(response.coupon_discount_type);
                $('#coupon-discount-value').val(response.coupon_discount_value);
                //$('.coupon-code-div').hide();
                $('#coupon-code').attr('disabled', 'true');
                $('.apply-coupon').css('display', 'none');
                $('.coupon-discount-div').show();
            } else {
                $('.coupon-code-msg').html(response.msg);
                $('.coupon-code-msg').css("color", "red");
                $('#total-charge').val(response.total_price);
                $('.total-charge').text(response.total_price);
                $('#total-discount').val(response.coupon_discount);
                $('.total-discount').text(response.coupon_discount);
                $('#coupon-code-id').val('');
                $('#coupon-discount-type').val('');
                $('#coupon-discount-value').val('');
                //$('.coupon-code-div').show();
                $('.coupon-discount-div').hide();
            }
        }).fail(function (response) {
            console.log("There is some error!!");
        }).always(function () {
            //$("body").mLoading('hide');
            //$('#coupon-code').removeClass('loading');
        });
    }
});
$(document).on('click', '.remove-coupon', function () {
    $('.coupon-code-msg').html('');
    $('.coupon-code-div').show();
    $('#coupon-code').removeAttr('disabled');
    $('.apply-coupon').css('display', 'block');
    $('#coupon-code').val('');
    $('.coupon-discount-div').hide();
    var totalPrice = $('#total-price').val();
    $('#total-charge').val(totalPrice);
    $('.total-charge').text(totalPrice);
    $('#total-discount').val(0);
    $('.total-discount').text(0);
});

$(document).on('click', '#asguest', function () {
    var data = {}
    var url = $("#vehicle-search-form").attr('action').split('/');
    contentType = 'application/x-www-form-urlencoded; charset=UTF-8';
    $("body").mLoading('show');
    $.ajax({
        type: "POST",
        url: '/' + url[1] + '/guest',
        data: data,
        async: false,
        dataType: 'html',
        contentType: contentType,
    }).done(function (response) {
        $('#accordion-guest').html(response);
        $('#first-name').focus();
        var ckbox = $('#gst');
        $('input').on('click', function () {
            if (ckbox.is(':checked')) {
                $("#gst-number").show();
            } else {
                $("#gst-number").hide();
            }
        });
    }).fail(function (response) {
        console.log("There is some error!!");
    }).always(function () {
        $("body").mLoading('hide');
    });
});
$(document).on('click', '.guest-submit', function () {
    var module_form_type;
    var form_type;
    var url_type;
    var guestData = $("#guest-form").serialize();
    var localData = $("#vehicle-search-form").serialize();
    //alert(localData);
    var paymentData = $("#payment-detail-form").serialize();
    var vehicleId = $('input[name="vehicleid"]:checked').val();
    var dataArray = guestData + '&' + decodeURI(localData) + '&' + paymentData + '&vehicle_id=' + vehicleId;
    var data = dataArray.split("&");
    var obj = {};
    for (var key in data)
    {
        obj[data[key].split("=")[0]] = data[key].split("=")[1];
        obj[data[key].split("=")[0]] = decodeURIComponent((obj[data[key].split("=")[0]] + '').replace(/\+/g, '%20'));
    }
    var module_type = $("#module-type").val();
    if (module_type == 1) {
        module_form_type = 'one-way';
    } else if (module_type == 2) {
        module_form_type = 'round-trip';
    } else if (module_type == 3) {
        module_form_type = 'multi-city';
    }
    if (module_type == "1" || module_type == "2" || module_type == "3") {
        var url = $("#guest-form").attr('action').split('/');
        url = module_form_type + '-' + url[2];
    } else {
        var url = $("#guest-form").attr('action');
    }
    var redirectUrl = $("#guest-form").attr('action').split('/');
    $.ajax({
        url: url,
        type: "POST",
        dataType: "json",
        data: guestData,
        success: function (resp) {
            if (resp.status == "error") {
                $(".error").empty();
                $.each(resp.msg, function (key, value) {
                    $.each(value, function (k, val) {
                        $('input[name="' + key + '"]').after("");
                        $('input[name="' + key + '"]').after(("<ul class='error'><li>" + val + "</li></ul>"));
                    });
                });
            } else if (resp.status == "success") {
                if (resp.form_type == 1) {
                    form_type = 'one-way';
                } else if (resp.form_type == 2) {
                    form_type = 'round-trip';
                } else if (resp.form_type == 3) {
                    form_type = 'multi-city';
                }
                if (resp.form_type == "1" || resp.form_type == "2" || resp.form_type == "3") {
                    url_type = "/" + redirectUrl[1] + "/" + form_type + "-traveller";
                }
                else {
                    url_type = "/" + redirectUrl[1] + "/traveller";
                }
                url_redirect({url: url_type,
                    method: "post",
                    data: obj,
                });
            }
        },
        error: function (error) {
            console.log(error);
        }
    });
    return false;
});
$(document).on('click', '.continue-submit', function () {
    var module_form_type;
    var form_type;
    var url_type;
    var guestData = $("#continue-submit").serialize();
    var localData = $("#vehicle-search-form").serialize();
    var paymentData = $("#payment-detail-form").serialize();
    var vehicleId = $('input[name="vehicleid"]:checked').val();

    var i = 0;
    var vehicle_color_arr = [];
      $('.vehicle-color:checked').each(function () {
           vehicle_color_arr[i++] = $(this).val();
       });

    var j = 0;
    var vehicle_model_arr = [];
      $('.vehicle-model:checked').each(function () {
           vehicle_model_arr[j++] = $(this).val();
       });

    var k = 0;
    var vehicle_type_arr = [];
      $('.vehicle-type:checked').each(function () {
           vehicle_type_arr[k++] = $(this).val();
    });

    var l = 0;
    var vehicle_name_arr = [];
      $('.vehicle-name:checked').each(function () {
           vehicle_name_arr[l++] = $(this).val();
       });

     var m = 0;
    var fuel_type_arr = [];
      $('.fuel-type:checked').each(function () {
           fuel_type_arr[m++] = $(this).val();
       });
    var n = 0;
    var amenities_arr = [];
      $('.vehicle-amenities:checked').each(function () {
           amenities_arr[n++] = $(this).val();
       });

    var o = 0;
    var supplier_arr = [];
      $('.suplier-name:checked').each(function () {
        supplier_arr[o++] = $(this).val();
    });

    var dataArray = guestData + '&' + decodeURI(localData) + '&' + paymentData + '&vehicle_id=' + vehicleId+'&filter_vehicle_color='+vehicle_color_arr+'&filter_vehicle_model='+vehicle_model_arr+'&filter_vehicle_name='+vehicle_name_arr+'&filter_vehicle_type='+vehicle_type_arr+"&filter_fuel_type="+fuel_type_arr+'&filter_amenities='+amenities_arr+'&filter_supplier_name='+supplier_arr;
    var data = dataArray.split("&");
    var obj = {};
    for (var key in data)
    {
        obj[data[key].split("=")[0]] = data[key].split("=")[1];
        obj[data[key].split("=")[0]] = decodeURIComponent((obj[data[key].split("=")[0]] + '').replace(/\+/g, '%20'));
    }
    var module_type = $("#module-type").val();
    var redirectUrl = $("#continue-submit").attr('action').split('/');
    if (redirectUrl[1] == "guide-booking") {
        if (module_type == 1) {
            module_form_type = 'local-guide';
        } else if (module_type == 2) {
            module_form_type = 'multi-city';
        }
    } else {
        if (module_type == "") {
            module_form_type = 'one-way';
        } else if (module_type == 1) {
            module_form_type = 'round-trip';
        } else if (module_type == 2) {
            module_form_type = 'multi-city';
        }
    }
    var url = $("#continue-submit").attr('action');
    var redirectUrl = $("#continue-submit").attr('action').split('/');
    $.ajax({
        url: url,
        type: "POST",
        async: true,
        dataType: "json",
        contentType: 'application/json',
        data: guestData,
        success: function (resp) {
            if (resp.status == "success") {
                if (module_type == "") {
                    //form_type = 'one-way';
                    url_type = "/" + redirectUrl[1] + "/one-way-traveller";
                } else if (module_type == 1) {
                    //form_type = 'round-trip';
                    if (redirectUrl[1] == "guide-booking") {
                        url_type = "/" + redirectUrl[1] + "/local-guide-traveller";
                    } else {
                        url_type = "/" + redirectUrl[1] + "/round-trip-traveller";
                    }
                } else if (module_type == 2) {
                    //form_type = 'multi-city';
                    if (redirectUrl[1] == "guide-booking") {
                        url_type = "/" + redirectUrl[1] + "/multi-city-guide-traveller";
                    } else {
                        url_type = "/" + redirectUrl[1] + "/multi-city-traveller";
                    }
                }
                else {
                    url_type = "/" + redirectUrl[1] + "/traveller";
                }
                url_redirect({url: url_type,
                    method: "post",
                    data: obj,
                });
            }
        },
        error: function (error) {
            console.log(error);
        }
    });
    return false;
});
function url_redirect(options) {
    var $form = $("<form />");
    $form.attr("action", options.url);
    $form.attr("method", options.method);
    for (var data in options.data)
        $form.append('<input type="hidden" name="' + data + '" value="' + options.data[data] + '" />');
    $("body").append($form);
    $form.submit();
}
//pick later/now selected start
var picklater = $("#pickup-later-selected").val();
var picknow = $("#pickup-later-selected").val();
if (picklater == 1) {
    $("#pickup-now").prop("checked", false);
    $("#pickup-later").prop("checked", true);
    $("#datetime").show();
    $('#pickup-later-selected').attr('value', '');
}
if (picknow == 0) {
    $("#pickup-now").prop("checked", true);
    $("#pickup-later").prop("checked", false);
    $("#datetime").hide();
    $('#pickup-now-selected').attr('value', '');
}
//pick later/now selected end
function isNumberDecimal(evt) {
    evt = (evt) ? evt : window.event;
    var charCode = (evt.which) ? evt.which : evt.keyCode;
    if (charCode == 46) {
        return true;
    }
    if (charCode > 31 && (charCode < 48 || charCode > 57)) {
        return false;
    }
    return true;
}
function isNumber(evt) {
    evt = (evt) ? evt : window.event;
    var charCode = (evt.which) ? evt.which : evt.keyCode;
    if (charCode > 31 && (charCode < 48 || charCode > 57)) {
        return false;
    }
    return true;
}
function isAlphaNumber(evt) {
    evt = (evt) ? evt : window.event;
    var charCode = (evt.which) ? evt.which : evt.keyCode;
    if (charCode > 32 && (charCode < 65 || charCode > 90) && (charCode < 97 || charCode > 122) && (charCode < 48 || charCode > 57)) {
        return false;
    }
    return true;
}
function isAlpha(evt) {
    evt = (evt) ? evt : window.event;
    var charCode = (evt.which) ? evt.which : evt.keyCode;
    if (charCode > 32 && (charCode < 65 || charCode > 90) && (charCode < 97 || charCode > 122)) {
        return false;
    }
    return true;
}
function isDecimalNumber(txt, evt) {
    evt = (evt) ? evt : window.event;
    var charCode = (evt.which) ? evt.which : evt.keyCode;
    if (charCode == 46) {
        //Check if the text already contains the . character
        if (txt.value.indexOf('.') === -1) {
            return true;
        } else {
            return false;
        }
    } else {
        if (charCode > 31 && (charCode < 48 || charCode > 57))
            return false;
    }
    return true;
}
var loadAjax = true;
//function to form submit using Ajax
function submitForm(formSelector, e) {
    var loadAjax = true;
    e.preventDefault();
    var loadingText;
    var formObj = $(formSelector);
    var postData = formObj.serializeArray();
    var formURL = formObj.attr("action");
    var mess = '';
    var buttonval = $(formSelector + '-btn').val();
    if (loadAjax) {
        $.ajax({
            url: formURL,
            type: "POST",
            dataType: "json",
            data: postData,
            beforeSend: function () {
                loadAjax = false;
                $(formSelector + '-btn').val(loadingText);
                $(formSelector + '-btn').attr('disabled', true);
            },
            success: function (data, textStatus, jqXHR) {
                $(formSelector + '-btn').val(buttonval);
                $(formSelector + '-btn').attr('disabled', false);
                $('.elem-err').remove();
                if (data.data.error != '') {
                    $('.captcha-error').html(data.data.error);
                } else {
                    $('.captcha-error').html('');
                }
                if (!data.data.result) {
                    if (typeof data.data.message === 'object') {
                        jQuery.each(data.data.message, function (k, v) {
                            jQuery.each(v, function (kk, vv) {
                                mess += vv + '\n';
                            });
                            inpKey = k;
                            if (mess != '') {
                                if (formObj.find("[name='" + inpKey + "']").parents('.form-group:first').find('span.elem-err').length == 0) {
                                    formObj.find("[name='" + inpKey + "']").parents('.form-group:first').append('<div class="elem-err text-danger"><span>' + mess + '</span></div>');
                                } else {
                                    formObj.find("[name='" + inpKey + "']").parents('.form-group:first').append('span.elem-err').text(mess);
                                }
                            }
                            mess = '';
                        });
                    } else {
                        if (data.data.target !== undefined) {
                            showCustomMsg(data);
                        } else {
                            setErrorMessage(data.data.message, data.data.innerhtml);
                        }
                    }
                } else { // if details sucessfully submitted
                    if (data.data.displayTabActived) { // this code used for create exam form (tabs) only
                        //alert('success');
                        faremodeactivetab(data.data.booking_mode);
                    }
                    setSuccessMessage(data.data.message, data.data.innerhtml);
                    if (data.data.popup == '1') { // added this script to display successful registration popup
                        showotpwindow(data.data.mobile_no);
                    }
                    if (data.data.popup == 'show-otp') {
                        showticketotpwindow(data.data.mobile_no);
                    }
                    if (data.data.redirectUrl !== undefined) {
                        if (data.data.stdid !== undefined) {
                            $('#' + data.data.stdid).addClass('expanded');
                            $(document).find('.ekko-lightbox').modal('hide');
                            setTimeout(function () {
                                window.location.href = data.data.redirectUrl;
                            }, 300);
                        } else {
                            window.location.href = data.data.redirectUrl;
                        }
                    }
                    if (data.data.currentUrlRedirect == 'Y') {
                        window.location.href = currentUrl;
                    }
                    if (data.data.current_path_redirect == 'Y') {
                        window.location.href = currentUrl;
                    }
                    /** Only used for placement exam's pull PT-Test. */
                    if (data.data.isTestAdded !== undefined && data.data.isTestAdded === 'Y') {
                        console.log(data.data.examId);
                        if (data.data.is_publish === 'Y') {
                            displayCustomMessage(data.data.message, 'success', '#displayQuizMsg');
                        } else {
                            $('.publish_link').css('visibility', 'hidden');
                            $('button[name=publish_unpublish]').text('Publish');
                            $('button[name=publish_unpublish]').attr('onclick', "publishUnpublish('Y', " + data.data.examId + ")");
                            displayCustomMessage(data.data.message, 'success', '#displayQuizMsg');
                        }
                    } else if (data.data.isTestAdded !== undefined && data.data.isTestAdded === 'N') {
                        displayCustomMessage(data.data.message, 'error', '#displayQuizMsg');
                    }
                }
                loadAjax = true;
            },
            error: function (jqXHR, exception) {
                var msg = '';
                if (jqXHR.status === 0) {
                    msg = 'Not connect.\n Verify Network.';
                } else if (jqXHR.status == 404) {
                    msg = 'Requested page not found. [404]';
                } else if (jqXHR.status == 500) {
                    msg = 'Internal Server Error [500].';
                } else if (exception === 'parsererror') {
                    msg = 'Requested JSON parse failed.';
                } else if (exception === 'timeout') {
                    msg = 'Time out error.';
                } else if (exception === 'abort') {
                    msg = 'Ajax request aborted.';
                } else {
                    msg = 'Uncaught Error.\n' + jqXHR.responseText;
                }
                alert(msg);
            },
        });
    }
    return false;
}
function faremodeactivetab(booking_mode) {
    if (booking_mode == 1) {
        $("#fare_form").removeClass("div-disabled");
        $("#basicVehicle").removeClass('active');
        $("#distance-tab").removeClass('hide');
        $("#distanceVehicle").removeClass('hide');
        $("#distanceVehicle").addClass('active');
    } else if (booking_mode == 2) {
        $("#fare_form").removeClass("div-disabled");
        $("#basicVehicle").removeClass('active');
        $("#hour-tab").removeClass('hide');
        $("#HourVehicle").removeClass('hide');
        $("#HourVehicle").addClass('active');
    } else if (booking_mode == 3) {
        $("#fare_form").removeClass("div-disabled");
        $("#basicVehicle").removeClass('active');
        $("#distance-hour-tab").removeClass('hide');
        $("#Distance_Hour").removeClass('hide');
        $("#Distance_Hour").addClass('active');
    } else if (booking_mode == 4) {
        $("#fare_form").removeClass("div-disabled");
        $("#basicVehicle").removeClass('active');
        $("#distance-waiting-tab").removeClass('hide');
        $("#Distance_Waiting").removeClass('hide');
        $("#Distance_Waiting").addClass('active');
    }
}
function showotpwindow() {
    $('.otp_form').show();
    $('.login_form').hide();
}
function showguestwindow() {
    $('#first-name').attr('readonly', true);
    $('#last-name').attr('readonly', true);
    $('#email').attr('readonly', true);
    $('#contact-no').attr('readonly', true);
    $('.guest-login').hide();
    $('.guest-window').show();
    //$('.login_form').hide();
}
function showticketotpwindow(mobileno) {
    var mobileno = mobileno;
    var last3digit = mobileno.substr(10 - 3);
    var doted_string = "SMS sent on this mobile no xxxxxxx";
    var hidemoibleno = doted_string + '' + last3digit;
    $('#mobilelastdigit').html(hidemoibleno);
    $('.ticketotp-form').show();
    $('.ticket-form').hide();
}
function setSuccessMessage(msg, innerhtml) {
    if (!msg)
        return false;
    var strHtml = '<div class="alert alert-success no-border"><button type="button" class="close" data-dismiss="alert"><i class="icon-close2" ></i><span class="sr-only">Close</span></button><span class="text-semibold">' + msg + '</span></div>';
    if (innerhtml) {
        $('#displayMsg').html(strHtml);
    } else {
        var msgLength = $('#displayMsg').find('.alert-success').length;
        if (msgLength == 0)
            $('#displayMsg').prepend(strHtml);
    }
}
function setErrorMessage(msg, innerhtml) {
    if (!msg)
        return false;
    var strHtml = '<div class="alert alert-danger no-border"><button type="button" class="close" data-dismiss="alert"><i class="icon-close2" ></i><span class="sr-only">Close</span></button><span class="text-semibold">' + msg + '</span></div>';
    if (innerhtml) {
        $('#displayMsg').html(strHtml);
    } else {
        var msgLength = $('#displayMsg').find('.alert-danger').length;
        if (msgLength == 0)
            $('#displayMsg').prepend(strHtml);
    }
}
$(document).on('click', '.btn-guest', function () {
    var first_name = $('#first-name').val();
    var last_name = $('#last-name').val();
    var email = $('#email').val();
    var contact_no = $('#contact-no').val();
    var prefix_contact_no = $('#prefix-contact-no').val();
    $.ajax({
        url: '/guest-login',
        type: "POST",
        dataType: "json",
        data: {
            first_name: first_name,
            last_name: last_name,
            email: email,
            prefix_contact_no: prefix_contact_no,
            contact_no: contact_no
        },
        success: function (resp) {
            if (resp.status == "error") {
                $(".error-msg").html('');
                $(".error").empty();
                $(".error_msg_class").css('display', 'none');
                $(".error_msg_class").empty();
                $.each(resp.msg, function (key, value) {
                    $.each(value, function (k, val) {
                        $('input[name="' + key + '"]').after("");
                        $('select[name="' + key + '"]').after("");
                        $('input[name="' + key + '"]').after(("<ul class='error'><li>" + val + "</li></ul>"));
                        $('select[name="' + key + '"]').after(("<ul class='error'><li>" + val + "</li></ul>"));
                    });
                });
            } else if (resp.status == "error1") {
                $(".error").empty();
                $(".error_guest_msg_class1").css('display', 'block');
                $(".error_guest_msg_class1").text(resp.msg);
            } else if (resp.status == "success" || resp.status == "record_exist") {
                $(".error").empty();
                $(".error_guest_msg_class1").css('display', 'block');
                $(".error_guest_msg_class1").text(resp.msg);
                showguestwindow();
            } else if (resp.status == "successLogin") {
                $("#vehicle-search-form").submit();
            }
        },
        error: function (error) {
            console.log(error);
        }
    });
    return false;
});
$(document).on('click', '.btn-member', function () {
    $(".guest_login_window").hide();
    $(".user_login_window").show();
    $('#username_id').val($('#email').val());
    $('#username_id').focus();
});
$(document).on('click', '.btn-guest-login', function () {
    var first_name = $('#first-name').val();
    var last_name = $('#last-name').val();
    var email = $('#email').val();
    var contact_no = $('#contact-no').val();
    var prefix_contact_no = $('#prefix-contact-no').val();
    $.ajax({
        url: '/guest-auto-login',
        type: "POST",
        dataType: "json",
        data: {
            first_name: first_name,
            last_name: last_name,
            email: email,
            prefix_contact_no: prefix_contact_no,
            contact_no: contact_no
        },
        success: function (resp) {
            if (resp.status == "successLogin") {
                $("#vehicle-search-form").submit();
            }
        },
        error: function (error) {
            console.log(error);
        }
    });
    return false;
});
$(document).on('click', '.btn-login1', function () {
    var user_type_id = $('#user-type-id').val();
    var username = $('#username_id').val();
    var password = $('#password_id').val();
    //var redirectUrl = $("#guest-form").attr('action').split('/');
    $.ajax({
        url: '/login',
        type: "POST",
        dataType: "json",
        data: {
            user_type_id: user_type_id,
            username: username,
            password: password
        },
        success: function (resp) {
            if (resp.status == "error") {
                $(".error-msg").html('');
                $(".error").empty();
                $(".error_msg_class").css('display', 'none');
                $(".error_msg_class").empty();
                $.each(resp.msg, function (key, value) {
                    $.each(value, function (k, val) {
                        $('input[name="' + key + '"]').after("");
                        $('select[name="' + key + '"]').after("");
                        $('input[name="' + key + '"]').after(("<ul class='error'><li>" + val + "</li></ul>"));
                        $('select[name="' + key + '"]').after(("<ul class='error'><li>" + val + "</li></ul>"));
                    });
                });
            } else if (resp.status == "error1") {
                $(".error").empty();
                $(".error_msg_class").css('display', 'block');
                $(".error_msg_class").text(resp.msg);
            } else if (resp.status == "success") {
                $("#vehicle-search-form").submit();
            }
        },
        error: function (error) {
            console.log(error);
        }
    });
    return false;
});
$(document).on('click', '.btn-login', function () {
    var user_type_id = $('#user-type-id').val();
    var username = $('#username_id').val();
    var password = $('#password_id').val();
    var values = document.cookie;
    $.ajax({
        url: '/login',
        type: "POST",
        dataType: "json",
        data: {
            user_type_id: user_type_id,
            username: username,
            password: password
        },
        success: function (resp) {
            if (resp.status == "error") {
                $(".error-msg").html('');
                $(".error").empty();
                $(".error_msg_class").css('display', 'none');
                $(".error_msg_class").empty();
                $.each(resp.msg, function (key, value) {
                    $.each(value, function (k, val) {
                        $('input[name="' + key + '"]').after("");
                        $('select[name="' + key + '"]').after("");
                        $('input[name="' + key + '"]').after(("<ul class='error'><li>" + val + "</li></ul>"));
                        $('select[name="' + key + '"]').after(("<ul class='error'><li>" + val + "</li></ul>"));
                    });
                });
            } else if (resp.status == "error1") {
                $(".error").empty();
                $(".error_msg_class").css('display', 'block');
                $(".error_msg_class").text(resp.msg);
            } else if (resp.status == "success") {
                showotpwindow();
            } else if (resp.status == "successLogin") {
                $("#vehicle-search-form").submit();
            } else if (resp.signup_status != "10") {
                var redirecturl = resp.redirecturl;
                window.location.href = redirecturl;
            }
        },
        error: function (error) {
            console.log(error);
        }
    });
    return false;
});
$(document).on('click', '.confirm-btn', function () {
    var confirm_otp = $('#confirm-otp').val();
    $.ajax({
        url: '/confirmLoginOtp',
        type: "POST",
        dataType: "json",
        data: {
            confirm_otp: confirm_otp,
            type: 'confirm'
        },
        success: function (resp) {
            if (resp.status == "error") {
                $(".error-msg").html('');
                $(".error").empty();
                $(".error_msg_class").css('display', 'none');
                $(".error_msg_class").empty();
                $.each(resp.msg, function (key, value) {
                    $.each(value, function (k, val) {
                        $('input[name="' + key + '"]').after("");
                        $('input[name="' + key + '"]').after(("<ul class='error'><li>" + val + "</li></ul>"));
                    });
                });
            } else if (resp.status == "error1") {
                $(".error").empty();
                $(".error_msg_class").css('display', 'block');
                $(".error_msg_class").text(resp.msg);
            } else if (resp.status == "success") {
                $("#vehicle-search-form").submit();
            }
        },
        error: function (error) {
            console.log(error);
        }
    });
    return false;
});
$(document).on('click', '.resend-otp-btn', function () {
    var counter = $('#resend-counter').val();
    if (counter < 3) {
        $.ajax({
            url: '/confirmLoginOtp',
            type: "POST",
            dataType: "json",
            data: {
                type: 'resend'
            },
            success: function (resp) {
                if (resp.status == "success") {
                    counter = parseInt(counter) + 1;
                    $('#resend-counter').val(counter);
                    $(".error").empty();
                    $(".resend-otp-msg").css({"display": "block", "color": "green"});
                    $(".resend-otp-msg").text(resp.msg);
                }
            },
            error: function (error) {
                console.log(error);
            }
        });
    } else {
        $(".error").empty();
        $(".resend-otp-msg").css({"display": "block", "color": "red"});
        $(".resend-otp-msg").text('You have Exceed Limit of Resend Otp');
    }
    return false;
});
$(document).on('click', '.btn-search-login', function () {
    var username = $('#username_id').val();
    var password = $('#password_id').val();
    $.ajax({
        url: '/loginSearch',
        type: "POST",
        dataType: "json",
        data: {
            username: username,
            password: password
        },
        success: function (resp) {
            if (resp.status == "error") {
                $(".error-msg").html('');
                $(".error").empty();
                $(".error_msg_class").css('display', 'none');
                $(".error_msg_class").empty();
                $.each(resp.msg, function (key, value) {
                    $.each(value, function (k, val) {
                        $('input[name="' + key + '"]').after("");
                        $('input[name="' + key + '"]').after(("<ul class='error'><li>" + val + "</li></ul>"));
                    });
                });
            } else if (resp.status == "error1") {
                $(".error").empty();
                $(".error_msg_class").css('display', 'block');
                $(".error_msg_class").text(resp.msg);
            } else if (resp.status == "success") {
                $("#vehicle-search-form").submit();
                //window.location.reload();
            }
        },
        error: function (error) {
            console.log(error);
        }
    });
    return false;
});

/* Code to change the outstation Type Module */

$(window).load(function () {
    $('.outstation_type').click(function () {
        var outstation_type = $(this).attr('id');
        var url = $("#vehicle-search-form").attr('action').split('/');
        var redirecturl = '/' + url[1] + '/' + outstation_type;
        window.location.href = redirecturl;
    });
});
$(window).load(function () {
    $('.guide_type').click(function () {
        var guide_type = $(this).attr('id');
        var url = $("#vehicle-search-form").attr('action').split('/');
        var redirecturl = '/' + url[1] + '/' + guide_type;
        window.location.href = redirecturl;
    });
});
function inviteEmail() {
    $('.email_error').text('');
    var emailId = $("#email-id").val();
    if (emailId == "") {
        $('.email_error').text('Please enter Email');
    } else if (!validateEmail(emailId)) {
        $('.email_error').text('Please enter Valid Email');
    } else {
        contentType = 'application/x-www-form-urlencoded; charset=UTF-8';
        $('#email-id').addClass('loading');
        $.ajax({
            url: '/application/email-invite',
            type: "post",
            dataType: 'json',
            contentType: contentType,
            data: {'email_id': emailId},
        }).done(function (data) {
            $('#email-id').removeClass('loading');
            if (data.status == false) {
                $('.email_error').text('');
                $('.email_error').text('Email already Exist');
            } else {
                $("#email-id").val('');
                $('.email_error').text('');
                $('.email_error').text('Mail sent Successfully');
            }
        }).fail(function () {
        });
    }
}
function inviteSms() {
    $('.mobile_error').text('');
    var mobile_no = $("#mobile-no").val();
    if (mobile_no == "") {
        $('.mobile_error').text('Please enter Mobile No.');
    } else if (mobile_no.length != 10) {
        $('.mobile_error').text('Please enter Valid Mobile No.');
    } else {
        contentType = 'application/x-www-form-urlencoded; charset=UTF-8';
        $('#mobile-no').addClass('loading');
        $.ajax({
            url: '/application/mobile-invite',
            type: "post",
            dataType: 'json',
            contentType: contentType,
            data: {'mobile_no': mobile_no},
        }).done(function (data) {
            $('#mobile-no').removeClass('loading');
            if (data.status == false) {
                $('.mobile_error').text('');
                $('.mobile_error').text('Mobile No. already Exist');
            } else {
                $("#mobile-no").val('');
                $('.mobile_error').text('');
                $('.mobile_error').text('SMS sent Successfully');
            }
        }).fail(function () {
        });
    }
}
function generateTicket(type) {
    var selected = [];
    var URL = "/application/generate-ticket";
    contentType = 'application/x-www-form-urlencoded; charset=UTF-8';
    $.ajax({
        type: 'post',
        url: URL,
        data: {'type': type},
        async: false,
        dataType: 'html',
        contentType: contentType,
    }).done(function (data) {
        $('#ajax-modal').hide();
        $('#ajax-modal').removeClass('in');
        $('.modal-backdrop').addClass('disable_none');
        $('#ajax-modal').addClass('disable_none');
        $('#ajax-modal .modal-content').html('');
        //$('#ajax-modal').modal('close');
        $('#myModalprintsmscancle .modal-content').html(data);
    }).fail(function () {
        $('#myModalprintsmscancle .modal-content').html('There is an error to load the modal.');
    });
    $('#myModalprintsmscancle').modal({backdrop: 'static', keyboard: false});
}
function giveFeedback(type) {
    var selected = [];
    var URL = "/application/give-feedback";
    contentType = 'application/x-www-form-urlencoded; charset=UTF-8';
    $.ajax({
        type: 'post',
        url: URL,
        data: {'type': type},
        async: false,
        dataType: 'html',
        contentType: contentType,
    }).done(function (data) {
        $('#myModalfeedbackss .modal-content').html(data);
    }).fail(function () {
        $('#myModalfeedbackss .modal-content').html('There is an error to load the modal.');
    });
    $('#myModalfeedbackss').modal({backdrop: 'static', keyboard: false});
}
function termsCondition() {
    var selected = [];
    var URL = "/application/terms-condition";
    contentType = 'application/x-www-form-urlencoded; charset=UTF-8';
    $.ajax({
        type: 'post',
        url: URL,
        data: {},
        async: false,
        dataType: 'html',
        contentType: contentType,
    }).done(function (data) {
        $('#termsModal .modal-content').html(data);
    }).fail(function () {
        $('#termsModal .modal-content').html('There is an error to load the modal.');
    });
    $('#termsModal').modal({backdrop: 'static', keyboard: false});
}
function ticketSms() {
    $('.email_error').hide();
    $("#displayMsgTicket").fadeIn(2000);
    var URL = "/application/ticket-sms";
    contentType = 'application/x-www-form-urlencoded; charset=UTF-8';
    $.ajax({
        type: 'post',
        url: URL,
        data: {},
        async: false,
        dataType: 'json',
        contentType: contentType,
    }).done(function (data) {
        if (data.data.result == true) {
            $('html, body').animate({scrollTop: '0px'}, 800);
            setSuccessMessage(data.data.message, data.data.innerhtml);
        }
    }).fail(function () {
        //$('#termsModal .modal-content').html('There is an error to load the modal.');
    });
    $("#displayMsgTicket").fadeOut(3000);
}
function ticketMail() {
    var email = $('#email').val();
    if (email == '') {
        $('.email_error').show();
    } else if (!validateEmail(email)) {
        $('.email_error').text('Please enter Valid Email');
    } else {
        $("#displayMsgTicket").fadeIn(2000);
        var URL = "/application/ticket-mail";
        contentType = 'application/x-www-form-urlencoded; charset=UTF-8';
        $.ajax({
            type: 'post',
            url: URL,
            data: {'email': email},
            async: false,
            dataType: 'json',
            contentType: contentType,
        }).done(function (data) {
            $('.email_error').hide();
            $('.email_box').hide();
            if (data.data.result == true) {
                $('html, body').animate({scrollTop: '0px'}, 800);
                setSuccessMessage(data.data.message, data.data.innerhtml);
            }
        }).fail(function () {
            //$('#termsModal .modal-content').html('There is an error to load the modal.');
        });
        $("#displayMsgTicket").fadeOut(3000);
    }
}
function ticketCancel(booking_id) {
    $("#displayMsgTicket").fadeIn(2000);
    var URL = "/application/ticket-cancel";
    contentType = 'application/x-www-form-urlencoded; charset=UTF-8';
    $.ajax({
        type: 'post',
        url: URL,
        data: {'booking_id': booking_id},
        async: false,
        dataType: 'json',
        contentType: contentType,
    }).done(function (data) {
        if (data.data.result == true) {
            $('html, body').animate({scrollTop: '0px'}, 800);
            setSuccessMessage(data.data.message, data.data.innerhtml);
        }
    }).fail(function () {
        //$('#termsModal .modal-content').html('There is an error to load the modal.');
    });
    $("#displayMsgTicket").fadeOut(3000);
}
function changeTravelDate(val) {
    $('.booking_date_error').hide();
    $('.booking_time_error').hide();
    var booking_date = $('#booking-date').val();
    var booking_time = $('#booking-time').val();
    if (booking_date == '') {
        $('.booking_date_error').show();
    }
    if (booking_time == '') {
        $('.booking_time_error').show();
    } else {
        $("#displayMsgTicket").fadeIn(2000);
        var URL = "/application/change-travel-date";
        contentType = 'application/x-www-form-urlencoded; charset=UTF-8';
        $.ajax({
            type: 'post',
            url: URL,
            data: {'booking_date': booking_date, 'booking_time': booking_time, 'booking_id': val},
            async: false,
            dataType: 'json',
            contentType: contentType,
        }).done(function (data) {
            $('.booking_date_error').hide();
            $('.booking_time_error').hide();
            $('.date_box').hide();
            if (data.data.result == true) {
                $('html, body').animate({scrollTop: '0px'}, 800);
                setSuccessMessage(data.data.message, data.data.innerhtml);
            }
        }).fail(function () {
            //$('#termsModal .modal-content').html('There is an error to load the modal.');
        });
        $("#displayMsg").fadeOut(3000);
    }
}
function showMailBox() {
    $('#email').val('');
    $('.email_box').show();
}
function showDateBox() {
    $('#booking-date').val('');
    $('#booking-time').val('');
    $('.date_box').show();
}
$(document).on('blur', '.inputMaterial', function () {
    var val = $(this).val();
    if (val != "") {
        $(this).addClass('test');
    } else {
        $(this).removeClass('test');
    }
});
function resetPassword() {
    var email_id = $('#email-id').val();
    if (email_id == "") {
        $(".email_error").css('color', 'red');
        $(".email_error").text('Please enter Email Or Mobile Or Username');
    } else {
        contentType = 'application/x-www-form-urlencoded; charset=UTF-8';
        $('#email-id').addClass('loading');
        $.ajax({
            url: '/application/reset-password',
            type: "post",
            dataType: 'json',
            contentType: contentType,
            data: {'email_id': email_id},
        }).done(function (data) {
            $('#email-id').removeClass('loading');
            if (data.status == false) {
                $('.email_error').text('');
                $('.email_error').text(data.message);
            } else {
                $("#email-id").val('');
                $('.email_error').text('');
                $('.email_error').text(data.message);
            }
        }).fail(function () {
        });
    }
}
function holidayEnquiry() {
    var URL = "/application/holiday-enquiry";
    contentType = 'application/x-www-form-urlencoded; charset=UTF-8';
    $.ajax({
        type: 'post',
        url: URL,
        data: {},
        async: false,
        dataType: 'html',
        contentType: contentType,
    }).done(function (data) {
        $('#Modal-package .modal-content').html(data);
    }).fail(function () {
        $('#Modal-package .modal-content').html('There is an error to load the modal.');
    });
    $('#Modal-package').modal({backdrop: 'static', keyboard: false});
}
function offerEnquiry(type) {
    var URL = "/application/offer-enquiry";
    contentType = 'application/x-www-form-urlencoded; charset=UTF-8';
    $.ajax({
        type: 'post',
        url: URL,
        data: {'type': type},
        async: false,
        dataType: 'html',
        contentType: contentType,
    }).done(function (data) {
        $('#Modal-offerenquiry .modal-content').html(data);
        var dateFormat1 = "yy-mm-dd",
                pickup_date = $("#start-date")
                .datepicker({
                    minDate: 0,
                    changeYear: true,
                    changeMonth: true,
                    yearRange: "-100:+20",
                    dateFormat: "yy-mm-dd",
                })
                .on("change", function () {
                    $(this).addClass('test');
                    return_date.datepicker("option", "minDate", getDate1(this));
                }),
                return_date = $("#end-date").datepicker({
            //defaultDate: "+1w",
            minDate: 0,
            changeYear: true,
            changeMonth: true,
            yearRange: "-100:+20",
            dateFormat: "yy-mm-dd",
        })
                .on("change", function () {
                    $(this).addClass('test');
                    pickup_date.datepicker("option", "maxDate", getDate1(this));
                });
        function getDate1(element) {
            var date;
            try {
                date = $.datepicker.parseDate(dateFormat1, element.value);
            } catch (error) {
                date = null;
            }

            return date;
        }
        $('#start-time').timepicker({'timeFormat': 'H:i', 'step': 15});
        $('#end-time').timepicker({'timeFormat': 'H:i', 'step': 15});
        jQuery('<div class="quantity-nav"><div class="quantity-button quantity-up"></div><div class="quantity-button quantity-down"></div></div>').insertAfter('.quantity input');
        jQuery('.quantity').each(function () {
            var spinner = jQuery(this),
                    input = spinner.find('input[type="number"]'),
                    btnUp = spinner.find('.quantity-up'),
                    btnDown = spinner.find('.quantity-down'),
                    min = input.attr('min'),
                    max = input.attr('max');
            btnUp.click(function () {
                var oldValue = parseFloat(input.val());
                if (oldValue >= max) {
                    var newVal = oldValue;
                } else {
                    var newVal = oldValue + 1;
                }
                spinner.find("input").val(newVal);
                spinner.find("input").trigger("change");
            });
            btnDown.click(function () {
                var oldValue = parseFloat(input.val());
                if (oldValue <= min) {
                    var newVal = oldValue;
                } else {
                    var newVal = oldValue - 1;
                }
                spinner.find("input").val(newVal);
                spinner.find("input").trigger("change");
            });
            $("#origin-city").autocomplete({
                source: function (request, response) {
                    // alert('url'); return false;
                    var url = "/application/get-origin-list";

                    $('#origin-city').addClass('loading');
                    $.ajax({
                        url: url,
                        dataType: "json",
                        type: "POST",
                        data: {
                            term: request.term
                        },
                        success: function (data) {
                            $('#origin-city').removeClass('loading');
                            response(data);

                            if (data[0].label == "Not Exist") {
                                $("#origin-city").val("");
                            }
                        }
                    });
                },
                min_length: 3,
                delay: 300,
                focus: function (event, ui) {
                    if (ui.item.label != "Not Exist") {
                        $(this).val(ui.item.label);
                    }
                    return false;
                },
                select: function (event, ui) {
                    if (ui.item.label != "Not Exist") {
                        $(this).val(ui.item.label);
                        $('#origin-city-id').val(ui.item.city_id);
                    }
                    return false;
                }
            });
        });
    }).fail(function () {
        $('#Modal-offerenquiry .modal-content').html('There is an error to load the modal.');
    });
    $('#Modal-offerenquiry').modal({backdrop: 'static', keyboard: false});
}
$(document).on('click', '.filter-data', function () {
    var filter_id = $(this).val();
    var filter_type = $(this).attr('name');
    var data = {
        filter_id: filter_id,
        filter_type: filter_type,
    }
    var url = $("#vehicle-search-form").attr('action').split('/');
    contentType = 'application/x-www-form-urlencoded; charset=UTF-8';
    $.ajax({
        type: "POST",
        url: '/' + url[1] + '/filter-data',
        data: data,
        async: false,
        dataType: 'html',
        contentType: contentType,
    }).done(function (response) {
        $('#coupon-code').val('');
        $('.coupon-code-msg').html('');
        $('#total-discount').val(0);
        $('.total-discount').text(0);
        $('#base-fare').val(response.base_fare);
        $('.base-fare').text(response.base_fare);
        $('#per-km-price').val(response.per_km_price);
        $('.per-km-price').text(response.per_km_price);
        $('#min-distance').val(response.min_distance);
        $('.min-distance').text(response.min_distance);
        $('#running-amt').val(response.running_amt);
        $('.running-amt').text(response.running_amt);
        $('#peak-time-price').val(response.peak_time_price);
        $('.peak-time-price').text(response.peak_time_price);
        $('#night-charge').val(response.night_charge);
        $('.night-charge').text(response.night_charge);
        $('#extra-charge').val(response.extra_charge);
        $('.extra-charge').text(response.extra_charge);
        $('#price-before-tax').val(response.price_before_tax);
        $('.price-before-tax').text(response.price_before_tax);
        $('#tax-percentage').val(response.tax_percentage);
        $('.tax-percentage').text(response.tax_percentage);
        $('#tax-price').val(response.tax_price);
        $('.tax-price').text(response.tax_price);
        $('#markup-value').val(response.markup_value);
        $('.markup-value').text(response.markup_value);
        $('#markup-type').val(response.markup_type);
        $('.markup-type').text(response.markup_type);
        $('#markup-price').val(response.markup_price);
        $('.markup-price').text(response.markup_price);
        $('#markup-base').val(response.markup_base);
        $('#total-price,#total-charge').val(response.total_price);
        $('.total-price,.total-charge').text(response.total_price);
    }).fail(function (response) {
        console.log("There is some error!!");
    }).always(function () {
        //$("body").mLoading('hide');
    });
});
$(document).on('change', '.currency_convert', function () {
    var filter_id = $(this).val();
//    var data = {
//        currency_id: filter_id,
//    }
    $('#currency-id').val(filter_id);
    var url = $("#vehicle-search-form").attr('action').split('/');
    contentType = 'application/x-www-form-urlencoded; charset=UTF-8';
    $("#vehicle-search-form").submit();
    /*$.ajax({
        type: "POST",
        url: '/' + url[1] + '/currency-conversion',
        data: data,
        async: true,
        dataType: 'html',
        contentType: contentType,
    }).done(function (response) {
        //alert(response);
        $(".currency-filter").html(response);
    }).fail(function (response) {
        console.log("There is some error!!");
    }).always(function () {
        //$("body").mLoading('hide');
    });*/
});
function jobEnquiry(post_id, type) {
    if (type == "jd") {
        var URL = "/application/jd-details";
    } else {
        var URL = "/application/job-enquiry";
    }
    contentType = 'application/x-www-form-urlencoded; charset=UTF-8';
    $.ajax({
        type: 'post',
        url: URL,
        data: {'post_id': post_id},
        async: false,
        dataType: 'html',
        contentType: contentType,
    }).done(function (data) {
        $('#Modal-jddetails .modal-content').html(data);
    }).fail(function () {
        $('#Modal-jddetails .modal-content').html('There is an error to load the modal.');
    });
    $('#Modal-jddetails').modal({backdrop: 'static', keyboard: false});
}
function downloadfiledata(userid, filename) {
    if (userid > '0') {
        var URL = "/dashboard/download-file-data";
        $.ajax({
            type: 'POST',
            url: URL,
            data: {'userid': userid, filename: filename},
            dataType: 'json',
            success: function (data) {
                alert(data);
                //$('#popup-registration-form img').attr('src', data.src);
                //$('input[name="popupcaptcha[id]"]').val(data.id);
            }
        });
    }
}
$(document).on('click', '#forgot_form', function () {
    $(".forgot_form").show();
    $(".login_form").hide();
    return false;
});
$(document).on('click', '.back_btn', function () {
    $(".forgot_form").hide();
    $(".login_form").show();
    return false;
});
function deleteRecentlyViewed(id) {
    var URL = "/application/remove-recently-viewed";
    contentType = 'application/x-www-form-urlencoded; charset=UTF-8';
    $.ajax({
        type: 'post',
        url: URL,
        data: {'id': id},
        async: false,
        dataType: 'html',
        contentType: contentType,
    }).done(function (data) {
        //$(this).parent().parent('.nbs-flexisel-item').fadeOut('slowly');
        $('.recently-viewed-items').html(data);
        $("#flexiselDemorecentitems").flexisel({
            visibleItems: 6,
            animationSpeed: 1000,
            autoPlay: false,
            autoPlaySpeed: 3000,
            pauseOnHover: true,
            enableResponsiveBreakpoints: true,
            responsiveBreakpoints: {
                portrait: {
                    changePoint: 640,
                    visibleItems: 2
                },
                landscape: {
                    changePoint: 768,
                    visibleItems: 3
                },
                tablet: {
                    changePoint: 1200,
                    visibleItems: 2
                }
            }
        });
    }).fail(function () {
        // alert msg
    });
}
$(document).on('click', '.search_oneway', function () {
    var from_city = $("#oneway_from").val();
    var to_city = $("#oneway_to").val();
    var from_city_id = $("#oneway_from_id").val();
    var to_city_id = $("#oneway_to_id").val();
    if (from_city == "") {
        $("#oneway_from").focus();
    } else if (to_city == "") {
        $("#oneway_to").focus();
    } else {
        var data = {
            from_city: from_city,
            to_city: to_city,
            from_city_id: from_city_id,
            to_city_id: to_city_id
        }
        var URL = "/application/one-way-search";
        contentType = 'application/x-www-form-urlencoded; charset=UTF-8';
        $.ajax({
            type: "POST",
            url: URL,
            data: data,
            async: true,
            dataType: 'html',
            contentType: contentType,
        }).done(function (response) {
            //alert(response);
            $(".one-way-search-data").html(response);
            //$("#oneway_from").val('');
            //$("#oneway_to").val('');
        }).fail(function (response) {
            console.log("There is some error!!");
        }).always(function () {
            //$("body").mLoading('hide');
        });
    }
});
$("#oneway_from").autocomplete({
    source: function (request, response) {
        // alert('url'); return false;
        var url = "/application/get-city-list";
        $('#oneway_from').addClass('loading');
        $.ajax({
            url: url,
            dataType: "json",
            type: "POST",
            data: {
                term: request.term
            },
            success: function (data) {
                $('#oneway_from').removeClass('loading');
                response(data);

                if (data[0].label == "Not Exist") {
                    $("#oneway_from").val("");
                }
            }
        });
    },
    min_length: 3,
    delay: 300,
    focus: function (event, ui) {
        if (ui.item.label != "Not Exist") {
            $(this).val(ui.item.label);
        }
        return false;
    },
    select: function (event, ui) {

        if (ui.item.label != "Not Exist") {
            var label = ui.item.label.split("(");
            $(this).val(label[0]);
            $('#oneway_from_id').val(ui.item.city_id);
        }
        return false;
    }
});
$("#oneway_to").autocomplete({
    source: function (request, response) {
        // alert('url'); return false;
        var url = "/application/get-origin-list";
        $('#oneway_to').addClass('loading');
        $.ajax({
            url: url,
            dataType: "json",
            type: "POST",
            data: {
                term: request.term
            },
            success: function (data) {
                $('#oneway_to').removeClass('loading');
                response(data);

                if (data[0].label == "Not Exist") {
                    $("#oneway_to").val("");
                }
            }
        });
    },
    min_length: 3,
    delay: 300,
    focus: function (event, ui) {
        if (ui.item.label != "Not Exist") {
            $(this).val(ui.item.label);
        }
        return false;
    },
    select: function (event, ui) {

        if (ui.item.label != "Not Exist") {
            $(this).val(ui.item.label);
            $('#oneway_to_id').val(ui.item.city_id);
        }
        return false;
    }
});
function addWishList(bkg_type_id, s_id) {
    var URL = "/sight-seeing/add-wishlist";
    contentType = 'application/x-www-form-urlencoded; charset=UTF-8';
    $.ajax({
        type: 'post',
        url: URL,
        data: {'bkg_type_id': bkg_type_id, 's_id': s_id},
        async: false,
        dataType: 'json',
        contentType: contentType,
    }).done(function (data) {
        alert(data.msg);
    }).fail(function () {
        // alert msg
    });
}
$(document).on('click', '.btn-newsletter-subscribe', function () {
    var email_subscription = 0;
    var mobile_subscription = 0;
    var both_subscription = 0;
    var first_name = $('#sub-first-name').val();
    var last_name = $('#sub-last-name').val();
    var email = $('#sub-email').val();
    var contact_no = $('#sub-contact-no').val();
    if ($('#email-subscription').is(":checked")) {
        email_subscription = $('#email-subscription').val();
    }
    if ($('#mobile-subscription').is(":checked")) {
        mobile_subscription = $('#mobile-subscription').val();
    }
    if ($('#both-subscription').is(":checked")) {
        both_subscription = $('#both-subscription').val();
    }
    if (first_name == "") {
        $('#sub-first-name').focus();
        $('#sub-first-name').attr('placeholder', 'Please enter First Name');
    } else if (last_name == "") {
        $('#sub-last-name').focus();
        $('#sub-last-name').attr('placeholder', 'Please enter Last Name');
    } else if (email == "") {
        $('#sub-email').focus();
        $('#sub-email').attr('placeholder', 'Please enter Email');
    } else if (!validateEmail(email)) {
        $('#sub-email').val('');
        $('#sub-email').focus();
        $('#sub-email').attr('placeholder', 'Please enter Valid Email');
    } else if (contact_no == "") {
        $('#sub-contact-no').focus();
        $('#sub-contact-no').attr('placeholder', 'Please enter Mobile No.');
    } else if (contact_no.length != 10) {
        $('#sub-contact-no').val('');
        $('#sub-contact-no').focus();
        $('#sub-contact-no').attr('placeholder', 'Please enter Valid Mobile No.');
    } else {
        $.ajax({
            url: '/subscribe-newsletter',
            type: "POST",
            dataType: "json",
            data: {
                first_name: first_name,
                last_name: last_name,
                email: email,
                contact_no: contact_no,
                email_subscription: email_subscription,
                mobile_subscription: mobile_subscription,
                both_subscription: both_subscription
            },
            success: function (resp) {
                if (resp.status == "error") {
                    $(".error-msg").html('');
                    $(".error").empty();
                    $(".error_msg_class").css('display', 'none');
                    $(".error_msg_class").empty();
                    $.each(resp.msg, function (key, value) {
                        $.each(value, function (k, val) {
                            $('input[name="' + key + '"]').after("");
                            $('select[name="' + key + '"]').after("");
                            $('input[name="' + key + '"]').after(("<ul class='error'><li>" + val + "</li></ul>"));
                            $('select[name="' + key + '"]').after(("<ul class='error'><li>" + val + "</li></ul>"));
                        });
                    });
                } else if (resp.status == "error1") {
                    $(".error").empty();
                    $(".error_guest_msg_class1").css('display', 'block');
                    $(".error_guest_msg_class1").text(resp.msg);
                } else if (resp.status == "success") {
                    $(".error").empty();
                    $(".error_newsletter_subscription").css('display', 'block');
                    $(".error_newsletter_subscription").text(resp.msg);
                }
            },
            error: function (error) {
                console.log(error);
            }
        });
    }
    return false;
});

$(document).on('click', '.apply-service-charge  ', function () {

    var vehicleId = $('.vehicle-select').val();
    var currencyType = $('#currency-type').val();
    var data = {
        vehicle_id: vehicleId,
        currency_type: currencyType
    }
    var url = $("#vehicle-search-form").attr('action').split('/');
    contentType = 'application/x-www-form-urlencoded; charset=UTF-8';
    //document.querySelector("body").style.visibility = "hidden";
    //document.querySelector("#loader").style.visibility = "visible";
    $.ajax({
        type: "POST",
        url: '/' + url[1] + '/payment',
        data: data,
        async: true,
        dataType: 'json',
        contentType: contentType,
    }).done(function (response) {
        if (response.master_package_mode_id == '1') {
            $('.distance-fare').show();
            $('.hourly-fare').hide();
        }
        if (response.master_package_mode_id == '2') {
            $('.distance-fare').hide();
            $('.hourly-fare').show();
        }
        if (response.master_package_mode_id == '3') {
            $('.hourly-fare').show();
            $('.distance-fare').show();
        }
        if (response.master_package_mode_id == '4') {
            $('.hourly-fare').hide();
            $('.distance-fare').show();
        }
        var service_charge = $('#service-charge').val();
        if(service_charge>0){
            response.total_price = response.total_price - response.tax_price;
            response.total_price = Math.ceil(Number(response.total_price) + Number(service_charge));
            response.tax_price   = Math.ceil((response.total_price * response.tax_percentage/100));
            response.total_price = response.total_price + response.tax_price;
            $('#edit-total-value').val(response.total_price);
        }
        $('#coupon-code').val('');
        $('#master_package_mode_id').val(response.master_package_mode_id);
        $('.coupon-code-msg').html('');
        $('#total-discount').val(0);
        $('.total-discount').text(0);
        $('#base-fare').val(response.base_fare);
        $('.base-fare').text(response.base_fare);
        $('#per-km-price').val(response.per_km_price);
        $('.per-km-price').text(response.per_km_price);
        $('#min-distance').val(response.min_distance);
        $('.min-distance').text(response.min_distance);
        $('.min-hour').text(response.min_pkg_hrs);
        $('#min-hour').val(response.min_pkg_hrs);
        $('.per-hour-charge').text(response.per_hr_charge);
        $('#per-hour-charge').val(response.per_hr_charge);
        $('#running-amt').val(response.running_amt);
        $('.running-amt').text(response.running_amt);
        $('#peak-time-price').val(response.peak_time_price);
        $('.peak-time-price').text(response.peak_time_price);
        $('#night-charge').val(response.night_charge);
        $('.night-charge').text(response.night_charge);
        $('#extra-charge').val(response.extra_charge);
        $('.extra-charge').text(response.extra_charge);
        $('#price-before-tax').val(response.price_before_tax);
        $('.price-before-tax').text(response.price_before_tax);
        $('#tax-percentage').val(response.tax_percentage);
        $('.tax-percentage').text(response.tax_percentage);
        $('#tax-price').val(response.tax_price);
        $('.tax-price').text(response.tax_price);
        $('#markup-value').val(response.markup_value);
        $('.markup-value').text(response.markup_value);
        $('#markup-type').val(response.markup_type);
        $('.markup-type').text(response.markup_type);
        $('#markup-price').val(response.markup_price);
        $('.markup-price').text(response.markup_price);
        $('#markup-base').val(response.markup_base);
        $('#total-price,#total-charge').val(response.total_price);
        $('.total-price,.total-charge').text(response.total_price);
    }).fail(function (response) {
        console.log("There is some error!!");
    }).always(function () {
        //$("body").mLoading('hide');
         //document.querySelector("#loader").style.display = "none";
         //document.querySelector("body").style.visibility = "visible";
    });

});
$(document).on('click', '.edit-total-btn', function () {
    $('.edit-total-textbox').toggle();
});


$(document).on('click', '.edit-total-charge', function () {

    var vehicleId = $('.vehicle-select').val();
    var currencyType = $('#currency-type').val();
    var data = {
        vehicle_id: vehicleId,
        currency_type: currencyType
    }
    var url = $("#vehicle-search-form").attr('action').split('/');
    contentType = 'application/x-www-form-urlencoded; charset=UTF-8';
    //document.querySelector("body").style.visibility = "hidden";
    //document.querySelector("#loader").style.visibility = "visible";
    $.ajax({
        type: "POST",
        url: '/' + url[1] + '/payment',
        data: data,
        async: true,
        dataType: 'json',
        contentType: contentType,
    }).done(function (response) {
        if (response.master_package_mode_id == '1') {
            $('.distance-fare').show();
            $('.hourly-fare').hide();
        }
        if (response.master_package_mode_id == '2') {
            $('.distance-fare').hide();
            $('.hourly-fare').show();
        }
        if (response.master_package_mode_id == '3') {
            $('.hourly-fare').show();
            $('.distance-fare').show();
        }
        if (response.master_package_mode_id == '4') {
            $('.hourly-fare').hide();
            $('.distance-fare').show();
        }

        var editTotalCharge      = $('#edit-total-value').val();
        if(editTotalCharge>0){
            if(editTotalCharge  > response.total_price){
                var tax = 100 + response.tax_percentage;
                var total_charge = Math.floor(((editTotalCharge / tax)*100));
                var price_wihtout_tax = response.total_price - response.tax_price;

                response.tax_price = Math.ceil((total_charge * response.tax_percentage/100));

                var service_charge = total_charge - price_wihtout_tax;
                $('#service-charge').val(service_charge);

                response.total_price = Math.ceil(total_charge + response.tax_price);
            }else{
                $('#edit-total-value').val('');
                $('#error_total_charge').text("Price can't less then sale price");
            }
        }


        $('#coupon-code').val('');
        $('#master_package_mode_id').val(response.master_package_mode_id);
        $('.coupon-code-msg').html('');
        $('#total-discount').val(0);
        $('.total-discount').text(0);
        $('#base-fare').val(response.base_fare);
        $('.base-fare').text(response.base_fare);
        $('#per-km-price').val(response.per_km_price);
        $('.per-km-price').text(response.per_km_price);
        $('#min-distance').val(response.min_distance);
        $('.min-distance').text(response.min_distance);
        $('.min-hour').text(response.min_pkg_hrs);
        $('#min-hour').val(response.min_pkg_hrs);
        $('.per-hour-charge').text(response.per_hr_charge);
        $('#per-hour-charge').val(response.per_hr_charge);
        $('#running-amt').val(response.running_amt);
        $('.running-amt').text(response.running_amt);
        $('#peak-time-price').val(response.peak_time_price);
        $('.peak-time-price').text(response.peak_time_price);
        $('#night-charge').val(response.night_charge);
        $('.night-charge').text(response.night_charge);
        $('#extra-charge').val(response.extra_charge);
        $('.extra-charge').text(response.extra_charge);
        $('#price-before-tax').val(response.price_before_tax);
        $('.price-before-tax').text(response.price_before_tax);
        $('#tax-percentage').val(response.tax_percentage);
        $('.tax-percentage').text(response.tax_percentage);
        $('#tax-price').val(response.tax_price);
        $('.tax-price').text(response.tax_price);
        $('#markup-value').val(response.markup_value);
        $('.markup-value').text(response.markup_value);
        $('#markup-type').val(response.markup_type);
        $('.markup-type').text(response.markup_type);
        $('#markup-price').val(response.markup_price);
        $('.markup-price').text(response.markup_price);
        $('#markup-base').val(response.markup_base);
        $('#total-price,#total-charge').val(response.total_price);
        $('.total-price,.total-charge').text(response.total_price);
    }).fail(function (response) {
        console.log("There is some error!!");
    }).always(function () {
        //$("body").mLoading('hide');
         //document.querySelector("#loader").style.display = "none";
         //document.querySelector("body").style.visibility = "visible";
    });

});


function validateEmail($email) {
    var emailReg = /^([\w-\.]+@([\w-]+\.)+[\w-]{2,4})?$/;
    return emailReg.test($email);
}