<?php

use Zend\Mvc\Application;
use Zend\Stdlib\ArrayUtils;

//error_reporting(E_ALL);
//ini_set('display_errors', 'On');

/**
 * This makes our life easier when dealing with paths. Everything is relative
 * to the application root now.
 */

chdir(dirname(__DIR__));

// Decline static file requests back to the PHP built-in webserver
if (php_sapi_name() === 'cli-server') {
    $path = realpath(__DIR__ . parse_url($_SERVER['REQUEST_URI'], PHP_URL_PATH));
    if (__FILE__ !== $path && is_file($path)) {
        return false;
    }
    unset($path);
}

define('BASE_PATH', realpath(dirname(__DIR__)));
define('PUBLIC_PATH', BASE_PATH.'/public');
define('CAPTCHA_PATH', BASE_PATH.'/public/img/captcha/');
define('COMPANYSETUUP_IMAGE_PATH','/upload/company-setup/');
define('B2B_LINK', 'https://b2b.bookingcabs.com/');
define('B2B_IMAGE_LINK', 'https://b2b.bookingcabs.com/upload/');
define('CMS_IMAGE_PATH', 'https://b2b.bookingcabs.com/upload/cms_image/');
define('SIGHTSEEING_IMAGE_PATH', 'https://b2b.bookingcabs.com/upload/activity_image/');

// Composer autoloading
include __DIR__ . '/../vendor/autoload.php';

if (! class_exists(Application::class)) {
    throw new RuntimeException(
        "Unable to load application.\n"
        . "- Type `composer install` if you are developing locally.\n"
        . "- Type `vagrant ssh -c 'composer install'` if you are using Vagrant.\n"
        . "- Type `docker-compose run zf composer install` if you are using Docker.\n"
    );
}

// Retrieve configuration
$appConfig = require __DIR__ . '/../config/application.config.php';
if (file_exists(__DIR__ . '/../config/development.config.php')) {
    $appConfig = ArrayUtils::merge($appConfig, require __DIR__ . '/../config/development.config.php');
}

// Run the application!
Application::init($appConfig)->run();
