<?php

namespace User\Form;

use Zend\Form\Form;
use Zend\Form\Element\Select;
use Zend\Form\Element\Checkbox;
use Zend\Form\Element\Submit;
use \Zend\Form\Element\MultiCheckbox;

class VendorDutyRegistrationForm extends Form {


     public function __construct($name = null) {

        /**
         * Duty Info Form of Driver Registration
         */
        parent::__construct('driver-duty-info-registration-form');
        $this->setAttribute('method', 'post');

        /**
         * Pref City to Drive Cab
         */
        $this->add([
            'name' => 'preferred_city',
            'type' => Select::class,
            'attributes' => [
                'id' => 'preferred-city',
                'placeholder' => 'Select Shift of Login',
                'class' => 'demo-default select-state selectized form-control',
                 'multiple' => 'multiple',
            ],
            'options' => [
                'label' => 'Pref City to Drive Cab',
                 'empty_option' => '',
                 'value_options' => array(
                             '1' => 'gurgoan',
                             '2' => 'Noida',
                             '3' => 'Chandigarh',
                             '4' => 'Delhi'
                     ),
            ],
        ]);

        /**
         * Speak Language
         */
        $this->add([
            'name' => 'language_speak',
            'type' => Select::class,
            'attributes' => [
                'id' => 'language-speak',
                'class' => 'demo-default select-state selectized form-control',
                'multiple' => 'multiple',
            ],
            'options' => [
                'label' => 'Speak Language<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true],
                 'empty_option' => '',
                'value_options' => array(
                             '1' => 'Hindi',
                             '2' => 'Japnese',
                             '3' => 'Chinese',
                              '4' => 'English',
                     ),
            ],

        ]);

        /**
         * Write Language
         */
        $this->add([
            'name' => 'language_write',
            'type' => Select::class,
            'attributes' => [
                'id' => 'language-write',
                'class' => 'demo-default select-state selectized form-control',
                 'multiple' => 'multiple',
            ],
            'options' => [
                'label' => 'Write Language<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true],
                'empty_option' => '',
                 'value_options' => array(
                             '1' => 'Hindi',
                             '2' => 'Japnese',
                             '3' => 'Chinese',
                             '4' =>'english'
                     ),
            ],
        ]);

        /**
         * Shift of Login
         */
        $this->add([
            'name' => 'shift_of_login',
            'type' => Select::class,
            'attributes' => [
                'id' => 'shift-of-login',
                'class' => 'demo-default select-state selectized form-control',
                 'multiple' => 'multiple',
                
            ],
            'options' => [
                'label' => 'Shift of Login<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true],
                'empty_option' => '',
                 'value_options' => array(
                             '0' => 'Morning',
                             '1' => 'Evening',
                             '2' => 'Night',

                     ),
            ],

        ]);       
       
        /**
         * Continue
         */
        $this->add([
            'name' => 'driver_duty_info',
            'type' => Submit::class,
            'attributes' => [
                'value' => 'Continue',
                'id' => 'driver-duty-info',
                'class' => 'save_data_btn btn btn-primary btn-new-vehile butoon_save btn-warning'
            ],
        ]);

    }

     public function getInputFilterSpecification() {
   return [
     
      'preferred_city' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please enter city'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
       
       'language_speak' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please enter speak language'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
    
       'language_write' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please enter write language'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
       'shift_of_login' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please enter shift of login'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
       
      
   ];
   
   }

}
