<?php

namespace User\Form;

use Zend\Form\Form;
use Zend\Form\Element\{
    Checkbox,
    Text,
    Submit,
    Hidden,
    Select,
    Date,
    Email,
    File,
    Textarea,
    Button
};

use Zend\Validator\{
    EmailAddress,
    StringLength,
    NotEmpty,
    Digits,
    Identical
};
use Zend\InputFilter\InputFilterProviderInterface;
use Zend\Captcha\AdapterInterface as CaptchaAdapter;

class PopupRegistrationForm extends Form implements InputFilterProviderInterface {

    public static $nationalityList = [];

    public function __construct($name = null) {

        /**
         * Personal Detail Form of Driver Registration
         */
        //echo "niharika";die;
        parent::__construct('popup-registration-form');
        $this->setAttribute('method', 'post');
        $this->setAttribute('enctype', 'multipart/form-data');

        /**
         * First Name
         */
        $this->add([
            'name' => 'first_name',
            'type' => Text::class,
            'attributes' => [
                'id' => 'first-name',
                'placeholder' => 'First Name',
                'class' => 'form-control input-border inputuppercase',
                'onkeypress' => "return isAlphaNumber(event)",
                'maxlength' => 30,
            ],
            'options' => [
                'label' => 'First Name<span style="color: red"> *</span>',
                'class' => 'text-bold',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         * Last Name
         */
        $this->add([
            'name' => 'last_name',
            'type' => Text::class,
            'attributes' => [
                'maxlength' => 30,
                'onkeypress' => "return isAlphaNumber(event)",
                'id' => 'last-name',
                'placeholder' => 'Last Name',
                'class' => 'driver_name input-border col-sm-6 col-lg-5 inputfild form-control inputuppercase'
            ],
            'options' => [
                'label' => 'Last Name<span style="color: red"> *</span>',
                //'class' => 'control-label col-sm-3 col-lg-3',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         * Email
         */
        $this->add([
            'name' => 'email',
            'type' => Email::class,
            'attributes' => [
                'id' => 'email',
                'placeholder' => 'user@gmail.com',
                'class' => 'form-control input-border inputlowercase'
            ],
            'options' => [
                'label' => 'Email<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         * Password
         */
        $this->add([
            'name' => 'password',
            'type' => 'password',
            'attributes' => [
                'id' => 'password',
                'class' => 'form-control',
                'maxlength' => 30
            ],
            'options' => [
                'label' => 'Password<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         * Confirm Password
         */
        $this->add([
            'name' => 'confirm_password',
            'type' => 'password',
            'attributes' => [
                'id' => 'confirm-password',
                'class' => 'form-control',
                'maxlength' => 30
            ],
            'options' => [
                'label' => 'Confirm Password<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);


        /**
         * Mobile No Prefix
         */
        $this->add([
            'name' => 'prefix_contact_no',
            'type' => Text::class,
            'attributes' => [
                'id' => 'prefix-contact-no',
                'value' => '+91',
                'disabled' => true,
                'class' => 'form-control'
            ],
            'options' => [
                'label' => 'Mobile No<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         * Mobile No
         */
        $this->add([
            'name' => 'contact_no',
            'type' => Text::class,
            'attributes' => [
                'id' => 'contact-no',
                'class' => 'form-control input-border',
                'min' => 1,
                'max' => 10,
                'maxlength' => 10,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => 'Mobile <span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);





        /**
         * Nationality
         */
        $this->add([
            'name' => 'nationality',
            'type' => Select::class,
            'attributes' => [
                'id' => 'nationality',
                'class' => 'form-control form-control input-border'
            ],
            'options' => [
                'label' => 'Nationality  <span style="color: red"> *</span> ',
                'label_options' => ['disable_html_escape' => true],
                'value_options' => self::$nationalityList,
                'disable_inarray_validator' => true,
                'empty_option' => 'Select',
            ],
        ]);


       



        $this->add([
            'name' => 'signup',
            'type' => Submit::class,
            'attributes' => [
                'id' => 'popup-registration-form-btn',
                'class' => 'btn btn-primary pull-right',
                'value' => 'Submit',
                'onclick' => "submitForm('#popup-registration-form', event);"
            ],
        ]);

        /**
         *
         * button reset
         */
        $this->add([
            'name' => 'reset',
            'type' => Submit::class,
            'attributes' => [
                'id' => 'reset-id',
                'placeholder' => 'reset',
                'class' => 'btn btn-danger',
                'value' => 'Reset',
            ],
        ]);
    }

    public function getInputFilterSpecification() {
        return [
            'first_name' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please enter First Name'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'popupcaptcha' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please enter catcha'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'last_name' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please enter Last Name'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'email' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    [
                        'name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Enter Email',
                            ]
                        ],
                        'break_chain_on_failure' => false
                    ],
                    [
                        'name' => 'EmailAddress',
                        //'break_chain_on_failure' => true,
                        'options' => array(
                            'message' => 'Email address is invalid',
                        ),
                    ],
                ]
            ],
            'contact_no' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please enter Mobile No.'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ],
                    ['name' => 'Digits',
                        'options' => [
                            'messages' => [
                                Digits::NOT_DIGITS => 'Please enter Numeric value only',
                            ],
                        ],
                        'break_chain_on_failure' => true,
                    ],
                    ['name' => 'StringLength',
                        'options' => [
                            'min' => 10,
                            'max' => 10,
                            'messages' => [
                                StringLength::TOO_LONG => 'Please enter Less than 10 Digits',
                                StringLength::TOO_SHORT => 'Please enter greater than 9 Digits',
                            ],
                        ],
                        'break_chain_on_failure' => true
                    ],
                ]
            ],
            'password' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please enter password'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'confirm_password' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please enter confirm password'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ],
                    ['name' => 'Identical',
                        'options' => [
                            'token' => 'password',
                            'messages' => [
                                Identical::NOT_SAME => 'Please enter same password.'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ],
                ]
            ],
            'nationality' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please select Nationality'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
        ];
    }

}
