<?php

namespace User\Form;

use Zend\Form\Form;
use Zend\Form\Element\Select;
use Zend\Form\Element\Date;
use Zend\Form\Element\Email;
use Zend\Form\Element\Checkbox;

use Zend\Form\Element\File;
use Zend\Form\Element\Text;
use Zend\Form\Element\Textarea;
use Zend\Form\Element\Submit;
use Zend\Form\Element\Hidden;
//use Zend\Validator\Date;
use Zend\Validator\StringLength;
use Zend\Form\Element\Radio;
use Zend\Validator\{
    NotEmpty,
    Digits
};
use Zend\InputFilter\InputFilterProviderInterface;

class DriverVehicleRegistrationForm extends Form implements InputFilterProviderInterface{
    private  $listOfFleet = ['1' => '1', '2' => '2', '3' => '3', '4' => '4', '5' => '5'];
    private  $listOfIgnitionType = ['1' => 'Petrol', '2' => 'Diesel', '3' => 'CNG'];


    public function __construct($name = null) {

        /**
         * Vehicle Info Form of Driver Registration
         */  
        parent::__construct('driver-vehicle-info-registration-form');
        $this->setAttribute('method', 'post');        

        /**
         * No. of Fleet
         */
        $this->add([
            'name' => 'total_fleet_no',
            'type' => Select::class,
            'attributes' => [
                'id' => 'total-fleet-no',
                'class' => 'form-control text'
            ],
            'options' => [
                'label' => 'No. of Fleet<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true],
                'value_options' => $this->listOfFleet,
            ],
        ]);

        /**
         * Name of Vehicle
         */
        $this->add([
            'name' => 'name',
            'type' => Text::class,
            'attributes' => [
                'id' => 'name',
                'class' => 'form-control vehicle-name-class'
            ],
            'options' => [
                'label' => 'Name of Vehicle<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
            
        ]);     
        
        $this->add([
            'name' => 'vehicle_value',
            'type' => Hidden::class,
            'attributes' => [
                'value' => '',
                'id' => 'vehicle-value',
                'class'=>'vehicle-value'
            ],
        ]);
        
        
        //exist status
        $this->add([
            'name' => 'vehicle_exist_status',
            'type' => Hidden::class,
            'attributes' => [
                'value' => '',
                'id' => 'vehicle_exist_id',
                'class'=>'vehicle_exist_class'
            ],
        ]);
        /**
         * Ignition Type
         */
        $this->add([
            'name' => 'ignition_type_id',
            'type' => Select::class,
            'attributes' => [
                'id' => 'ignition-type-id',
                'class' => 'form-control'
            ],
            'options' => [
                'label' => 'Ignition Type<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true],
                'value_options' => $this->listOfIgnitionType,
            ],
        ]);
        
        /**
         * Vehicle Code
         */
        $this->add([
            'name' => 'vehicle_code',
            'type' => Text::class,
            'attributes' => [
                'id' => 'vehicle-code',
                'placeholder' => 'DL',
                'class' => 'form-control uppercase'
            ],
            'options' => [
                'label' => 'Vehicle No.<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
            
        ]);  
        
        /**
         * Vehicle No
         */
        $this->add([
            'name' => 'vehicle_number',
            'type' => Text::class,
            'attributes' => [
                'id' => 'vehicle-number',
                'placeholder' => '10F1530',
                'class' => 'form-control uppercase'
            ]            
            
        ]);  
        
        /**
         * Vehicle Color
         */
        $this->add([
            'name' => 'color',
            'type' => Text::class,
            'attributes' => [
                'id' => 'color',                
                'class' => 'form-control',
                'readonly'=>'true'
                
            ],
            'options' => [
                'label' => 'Vechicle Color<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
            
        ]);
        
        
        $this->add([
            'name' => 'vehicle_owner_type',
            'type' => Text::class,
            'attributes' => [
                'id' => 'vehicle-owner-type_id',                
                'class' => 'form-control'
            ],
            'options' => [
                'label' => 'Owner Type<span style="color: red"> *</span>',
//                'value_options' => array(
//                '0' => 'Attached',
//                '1' => 'Owned',
//            ),
                'label_options' => ['disable_html_escape' => true]
            ],
            
        ]);
        /**
         * Vehicle Owner Name
         */
        $this->add([
            'name' => 'vehicle_owner_name',
            'type' => Text::class,
            'attributes' => [
                'id' => 'vehicle-owner-name_id',                
                'class' => 'form-control'
            ],
            'options' => [
                'label' => 'Owner Name<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
            
        ]);
        
        /**
         * Vehicle Owner Cnt No
         */
        $this->add([
            'name' => 'vehicle_owner_cnt_no',
            'type' => Text::class,
            'attributes' => [
                'id' => 'vehicle-owner-cnt-no',                
                'class' => 'form-control'
            ],
            'options' => [
                'label' => 'Vehicle Owner Cnt No<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
            
        ]);

        
        /**
         * Permit Expiry Date
         */
       
        
        $this->add([
            'name' => 'permit_exp_date',
            'type' => Date::class,
            'attributes' => [
                'id' => 'permit_exp_date',                    
                'class' => 'form-control'
            ],
            'options' => [
                'label' => 'Permit Expiry Date<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
            
        ]); 
        
        /**
         * Upload Your RC Proof
         */
        $this->add([
            'name' => 'rc_proof',
            'type' => File::class,
            'attributes' => [
                'id' => 'rc-proof',                
                'class' => 'form-control'
            ]           
            
        ]);   
        
        /**
         * Upload Your Insurance Proof
         */
        $this->add([
            'name' => 'insurance_proof',
            'type' => File::class,
            'attributes' => [
                'id' => 'insurance-proof',                
                'class' => 'form-control'
            ]           
            
        ]);   
        
        /**
         * Upload Your Fitness Proof 
         */
        $this->add([
            'name' => 'fitness_proof',
            'type' => File::class,
            'attributes' => [
                'id' => 'fitness-proof',                
                'class' => 'form-control'
            ]           
            
        ]);   

        /**
         * Continue
         */
        $this->add([
            'name' => 'driver_vehicle_info',
            'type' => Submit::class,
            'attributes' => [
                'value' => 'Continue',
                'id' => 'driver-vehicle-info',
                'class' => 'save_data_btn btn btn-primary btn-new-vehile butoon_save btn-warning vehicle_detail'
                
            ],
        ]);
       
    }

    public function getInputFilterSpecification() {
        
        return [
            'name' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please enter vehicle name'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            
            'permit_exp_date' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please enter Permit Expiry Date'
                            ]
                        ],
                    ],
                    ['name' => 'Date',
                        'options' => [
                            'messages' => [
                                //Date::INVALID_DATE => '',
                                \Zend\Validator\Date::INVALID_DATE => '',
                            ],
                        ],
                        'break_chain_on_failure' => true
                    ],
                ]
            ],
         
//                'permit_exp_date'=>[
//            'required' => TRUE,
//            'filters' => [
//                ['name' => 'StripTags'],
//                ['name' => 'StringTrim']
//            ],
//            'validators' => [
//                [   'name' => 'NotEmpty',
//                    'options' => [
//                        'messages' => [
//                            NotEmpty::IS_EMPTY => 'Please select Permit Expiry Date'
//                        ]
//                    ],
//
//                ],
//                [   'name' => 'Date',
//                    'options' => [
//                        'messages' => [
//                            Date::INVALID_DATE => '',
//                        ],
//                    ],
//                    'break_chain_on_failure' => true
//                ],
//            ]
//        ],
//            
        'vehicle_code'=>[
            'required' => true,
            'filters' => [
                ['name' => 'StripTags'],
                ['name' => 'StringTrim']
            ],
            'validators' => [
                [   'name' => 'NotEmpty',
                    'options' => [
                        'messages' => [
                            NotEmpty::IS_EMPTY => 'Please enter Vehicle Code'
                        ]
                    ],
                    'break_chain_on_failure' => true
                ]
            ]
        ],
        
        /**
         * Vehicle No
         */
        
            'vehicle_number'=>[
            'required' => true,
            'filters' => [
                ['name' => 'StripTags'],
                ['name' => 'StringTrim']
            ],
            'validators' => [
                [   'name' => 'NotEmpty',
                    'options' => [
                        'messages' => [
                            NotEmpty::IS_EMPTY => 'Please enter Vehicle No'
                        ]
                    ],
                    'break_chain_on_failure' => true
                ]
            ]
        ],
            
         'vehicle_owner_name' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please enter vehicle owner name'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],   
            
           
            'vehicle_owner_cnt_no'=>[
            'required' => true,
            'filters' => [
                ['name' => 'StripTags'],
                ['name' => 'StringTrim']
            ],
            'validators' => [
                [   'name' => 'NotEmpty',
                    'options' => [
                        'messages' => [
                            NotEmpty::IS_EMPTY => 'Please enter Mobile No.'
                        ]
                    ],
                    'break_chain_on_failure' => true
                ],
                [   'name' => 'Digits',
                    'options' => [
                        'messages' => [
                            Digits::NOT_DIGITS => 'Please enter Numeric value only',
                        ],
                    ],
                    'break_chain_on_failure' => true,
                ],
                [   'name' => 'StringLength',
                    'options' => [
                        'min' => 10,
                        'max' => 10,
                        'messages' => [
                            StringLength::TOO_LONG => 'Please enter Less than 10 Digits',
                            StringLength::TOO_SHORT => 'Please enter greater than 9 Digits',
                        ],
                    ],
                    'break_chain_on_failure' => true
                ],
            ]
        ],
            
           'color' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please enter color'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ], 
            
          'rc_proof'=>[
            'required' => false,
            'filters' => [
                ['name' => 'StripTags'],
                ['name' => 'StringTrim']
            ],
            'validators' => [                
                [   'name' => 'NotEmpty',
                    'options' => [
                        'messages' => [
                            NotEmpty::IS_EMPTY => 'Please upload RC proof'
                        ]
                    ],
                    'break_chain_on_failure' => true
                ], 
                ['name'    => 'FileUploadFile'],
                [
                    'name'    => 'FileMimeType',                        
                    'options' => [                       
                        'mimeType'  => ['image/gif', 'image/png', 'image/jpg', 'image/jpeg']
                    ],
                    'break_chain_on_failure' => true
                ],
                ['name'    => 'FileIsImage'],
                [
                        'name'    => 'FileImageSize',                        
                        'options' => [                            
                            'minWidth'  => 128,
                            'minHeight' => 128,
                            'maxWidth'  => 4096,
                            'maxHeight' => 4096
                        ]
                ],     
            ]
        ],
            
            
            'insurance_proof'=>[
            'required' => true,
            'filters' => [
                ['name' => 'StripTags'],
                ['name' => 'StringTrim']
            ],
            'validators' => [                
                [   'name' => 'NotEmpty',
                    'options' => [
                        'messages' => [
                            NotEmpty::IS_EMPTY => 'Please upload RC proof'
                        ]
                    ],
                    'break_chain_on_failure' => true
                ], 
                ['name'    => 'FileUploadFile'],
                [
                    'name'    => 'FileMimeType',                        
                    'options' => [                       
                        'mimeType'  => ['image/gif', 'image/png', 'image/jpg', 'image/jpeg']
                    ],
                    'break_chain_on_failure' => true
                ],
                ['name'    => 'FileIsImage'],
                [
                        'name'    => 'FileImageSize',                        
                        'options' => [                            
                            'minWidth'  => 128,
                            'minHeight' => 128,
                            'maxWidth'  => 4096,
                            'maxHeight' => 4096
                        ]
                ],     
            ]
        ],
            
            'fitness_proof'=>[
            'required' => true,
            'filters' => [
                ['name' => 'StripTags'],
                ['name' => 'StringTrim']
            ],
            'validators' => [                
                [   'name' => 'NotEmpty',
                    'options' => [
                        'messages' => [
                            NotEmpty::IS_EMPTY => 'Please upload RC proof'
                        ]
                    ],
                    'break_chain_on_failure' => true
                ], 
                ['name'    => 'FileUploadFile'],
                [
                    'name'    => 'FileMimeType',                        
                    'options' => [                       
                        'mimeType'  => ['image/gif', 'image/png', 'image/jpg', 'image/jpeg']
                    ],
                    'break_chain_on_failure' => true
                ],
                ['name'    => 'FileIsImage'],
                [
                        'name'    => 'FileImageSize',                        
                        'options' => [                            
                            'minWidth'  => 128,
                            'minHeight' => 128,
                            'maxWidth'  => 4096,
                            'maxHeight' => 4096
                        ]
                ],     
            ]
        ],
            
            
            
            
        ];
    }
    
    
}
