<?php

namespace User;

use Zend\Router\Http\Literal;
use Zend\Router\Http\Segment;
use Zend\ServiceManager\Factory\InvokableFactory;

return [
    'router' => [
        'routes' => [
            'login' => [
                'type' => Literal::class,
                'options' => [
                    'route' => '/login',
                    'defaults' => [
                        'controller' => Controller\IndexController::class,
                        'action' => 'login',
                    ],
                ],
            ],

            'confirmLoginOtp' => [
                'type' => Literal::class,
                'options' => [
                    'route' => '/confirmLoginOtp',
                    'defaults' => [
                        'controller' => Controller\IndexController::class,
                        'action' => 'confirmLoginOtp',
                    ],
                ],
            ],
            'loginSearch' => [
                'type' => Literal::class,
                'options' => [
                    'route' => '/loginSearch',
                    'defaults' => [
                        'controller' => Controller\IndexController::class,
                        'action' => 'loginSearch',
                    ],
                ],
            ],
            'logout' => [
                'type' => Literal::class,
                'options' => [
                    'route' => '/logout',
                    'defaults' => [
                        'controller' => Controller\IndexController::class,
                        'action' => 'logout',
                    ],
                ],
            ],
            'user' => [
                'type' => Segment::class,
                'options' => [
                    'route' => '/signup[/:action][/:param]',
                    'defaults' => [
                        'controller' => Controller\IndexController::class,
                        'action' => 'index',
                    ],
                    'constraints' => [
                        'action' => '[a-zA-Z][a-zA-Z0-9_-]*',
                        'param' => '[a-zA-Z0-9]*'
                    ],
                ],
            ],
            'affilate-registration' => [
                'type' => Literal::class,
                'options' => [
                    'route' => '/partner',
                    'defaults' => [
                        'controller' => Controller\IndexController::class,
                        'action' => 'affilate-registration',
                    ],
                ],
            ],
            'partner' => [
                'type' => Segment::class,
                'options' => [
                    'route' => '/partner',
                    'defaults' => [
                        'controller' => Controller\IndexController::class,
                        'action' =>  'affilate-registration',
                    ],
                ],
            ],
            'driver' => [
                'type' => Segment::class,
                'options' => [
                    'route' => '/driver[/:action]',
                    'defaults' => [
                        'controller' => Controller\RegistrationController::class,
                        'action' => 'index',
                        //'action' => 'personal-info',
                    ],
                    'constraints' => [
                        'action' => '[a-zA-Z][a-zA-Z0-9_-]*',
                        'slug' => '[a-zA-Z][a-zA-Z0-9_-]*'
                    ],
                ],
            ],
            'normal-user' => [
                'type' => Segment::class,
                'options' => [
                    'route' => '/normal-user[/:action]',
                    'defaults' => [
                        'controller' => Controller\RegistrationController::class,
                        'action' => 'index',
                    ],
                    'constraints' => [
                        'action' => '[a-zA-Z][a-zA-Z0-9_-]*'
                    ],
                ],
            ],
            'corporate-user' => [
                'type' => Segment::class,
                'options' => [
                    'route' => '/corporate-user[/:action]',
                    'defaults' => [
                        'controller' => Controller\RegistrationController::class,
                        'action' => 'index',
                    ],
                    'constraints' => [
                        'action' => '[a-zA-Z][a-zA-Z0-9_-]*'
                    ],
                ],
            ],
            'travel-agent' => [
                'type' => Segment::class,
                'options' => [
                    'route' => '/travel-agent[/:action]',
                    'defaults' => [
                        'controller' => Controller\RegistrationController::class,
                        'action' => 'index',
                    ],
                    'constraints' => [
                        'action' => '[a-zA-Z][a-zA-Z0-9_-]*'
                    ],
                ],
            ],
            'vendor' => [
                'type' => Segment::class,
                'options' => [
                    'route' => '/vendor[/:action]',
                    'defaults' => [
                        'controller' => Controller\RegistrationController::class,
                        'action' => 'index',
                        //'action' => 'personal-info',
                    ],
                    'constraints' => [
                        'action' => '[a-zA-Z][a-zA-Z0-9_-]*'
                    ],
                ],
            ],
            'guide' => [
                'type' => Segment::class,
                'options' => [
                    'route' => '/guide[/:action]',
                    'defaults' => [
                        'controller' => Controller\RegistrationController::class,
                        'action' => 'index',
                        //'action' => 'personal-info',
                    ],
                    'constraints' => [
                        'action' => '[a-zA-Z][a-zA-Z0-9_-]*'
                    ],
                ],
            ],
            'hotel-user' => [
                'type' => Segment::class,
                'options' => [
                    'route' => '/hotel-user[/:action]',
                    'defaults' => [
                        'controller' => Controller\RegistrationController::class,
                        'action' => 'index',
                        //'action' => 'personal-info',
                    ],
                    'constraints' => [
                        'action' => '[a-zA-Z][a-zA-Z0-9_-]*'
                    ],
                ],
            ],
            'dmc-user' => [
                'type' => Segment::class,
                'options' => [
                    'route' => '/dmc-user[/:action]',
                    'defaults' => [
                        'controller' => Controller\RegistrationController::class,
                        'action' => 'index',
                        //'action' => 'personal-info',
                    ],
                    'constraints' => [
                        'action' => '[a-zA-Z][a-zA-Z0-9_-]*'
                    ],
                ],
            ],
            'cruise-user' => [
                'type' => Segment::class,
                'options' => [
                    'route' => '/cruise-user[/:action]',
                    'defaults' => [
                        'controller' => Controller\RegistrationController::class,
                        'action' => 'index',
                        //'action' => 'personal-info',
                    ],
                    'constraints' => [
                        'action' => '[a-zA-Z][a-zA-Z0-9_-]*'
                    ],
                ],
            ],
            'refresh' => [
                'type' => Segment::class,
                'options' => [
                    'route' => '/refresh',
                    'defaults' => [
                        'controller' => Controller\RegistrationController::class,
                        'action' => 'refresh',
                    ],

                ],
            ],
            'verifyemail' => [
                'type' => Segment::class,
                'options' => [
                    'route' => '/user[/:action]',
                    'defaults' => [
                        'controller' => Controller\RegistrationController::class,
                        'action' => 'index',
                    ],
                    'constraints' => [
                        'action' => '[a-zA-Z][a-zA-Z0-9_-]*'
                    ],
                ],
            ],
            'dashboard-login' => [
                'type' => Literal::class,
                'options' => [
                    'route' => '/dashboard-login',
                    'defaults' => [
                        'controller' => Controller\IndexController::class,
                        'action' => 'dashboard-login',
                    ],
                ],
            ],
            'api-user-login' => [
                'type' => Literal::class,
                'options' => [
                    'route' => '/api-user-login',
                    'defaults' => [
                        'controller' => Controller\IndexController::class,
                        'action' => 'api-user-login',
                    ],
                ],
            ],
            'checkout' => [
                'type' => Segment::class,
                'options' => [
                    'route' => '/checkout[/:action]',
                    'defaults' => [
                        'controller' => Controller\IndexController::class,
                        'action' => 'checkout',
                    ],
                    'constraints' => [
                        'action' => '[a-zA-Z][a-zA-Z0-9_-]*'
                    ],
                ],
            ],
            'payment-response' => [
                'type' => Segment::class,
                'options' => [
                    'route' => '/payment-response[/:action][/:param]',
                    'defaults' => [
                        'controller' => Controller\IndexController::class,
                        'action' => 'payment-response',
                    ],
                    'constraints' => [
                        'action' => '[a-zA-Z][a-zA-Z0-9_-]*',
                        'param' => '[a-zA-Z0-9]*'
                    ],
                ],
            ],
             'upload-file' => [
                'type' => Segment::class,
                'options' => [
                    'route' => '/upload-file',
                    'defaults' => [
                        'controller' => Controller\RegistrationController::class,
                        'action' => 'uploadfile'
                    ],
                ],
            ],
            'forget-password' => [
                'type' => Literal::class,
                'options' => [
                    'route' => '/forget-password',
                    'defaults' => [
                        'controller' => Controller\IndexController::class,
                        'action' => 'forget-password',
                    ],
                ],
            ],
            'api-user' => [
                'type' => Segment::class,
                'options' => [
                    'route' => '/api-user[/:action]',
                    'defaults' => [
                        'controller' => Controller\RegistrationController::class,
                        'action' => 'api-user',
                    ],
                ],
            ],
            
            'login-user' => [
                'type' => Literal::class,
                'options' => [
                    'route' => '/login-user',
                    'defaults' => [
                        'controller' => Controller\IndexController::class,
                        'action' => 'login-user',
                    ],
                ],
            ],
            
            'remove-user' => [
                'type' => Literal::class,
                'options' => [
                    'route' => '/remove-user',
                    'defaults' => [
                        'controller' => Controller\IndexController::class,
                        'action' => 'remove-user',
                    ],
                ],
            ],
            
            'get-user-list' => [
                'type' => Literal::class,
                'options' => [
                    'route' => '/get-user-list',
                    'defaults' => [
                        'controller' => Controller\IndexController::class,
                        'action' => 'get-user-list',
                    ],
                ],
            ],
            
            'add-new-user' => [
                'type' => Literal::class,
                'options' => [
                    'route' => '/add-new-user',
                    'defaults' => [
                        'controller' => Controller\IndexController::class,
                        'action' => 'add-new-user',
                    ],
                ],
            ],
            
            'add-new-hotel-user' => [
                'type' => Literal::class,
                'options' => [
                    'route' => '/add-new-hotel-user',
                    'defaults' => [
                        'controller' => Controller\IndexController::class,
                        'action' => 'add-new-hotel-user',
                    ],
                ],
            ],
            
            'add-user' => [
                'type' => Segment::class,
                'options' => [
                    'route' => '/user/add-user',
                    'defaults' => [
                        'controller' => Controller\IndexController::class,
                        'action' => 'add-user'

                    ],
                ],
            ],
            
            'add-users' => [
                'type' => Segment::class,
                'options' => [
                    'route' => '/user/add-users',
                    'defaults' => [
                        'controller' => Controller\IndexController::class,
                        'action' => 'add-users'

                    ],
                ],
            ],
            
            'show-services' => [
                'type' => Literal::class,
                'options' => [
                    'route' => '/show-services',
                    'defaults' => [
                        'controller' => Controller\IndexController::class,
                        'action' => 'get-user-services',
                    ],
                ],
            ],
            
            
        ],
    ],
    'controllers' => [
        'factories' => [
            Controller\IndexController::class => InvokableFactory::class,
            Controller\DriverController::class => InvokableFactory::class,
            Controller\VendorController::class => InvokableFactory::class,
            Controller\NormalUserController::class => InvokableFactory::class,
            Controller\CorporateUserController::class => InvokableFactory::class,
            Controller\GuideController::class => InvokableFactory::class,
            Controller\RegistrationController::class => InvokableFactory::class,
        ],
    ],
    'view_manager' => [
        'display_not_found_reason' => true,
        'display_exceptions' => true,
        'doctype' => 'HTML5',
        'not_found_template' => 'error/404',
        'exception_template' => 'error/index',
        'template_map' => [
            'layout/layout' => __DIR__ . '/../view/layout/layout.phtml',
            'user/index/index' => __DIR__ . '/../view/user/index/index.phtml',
            'error/404' => __DIR__ . '/../view/error/404.phtml',
            'error/index' => __DIR__ . '/../view/error/index.phtml',
        ],
        'template_path_stack' => [
            __DIR__ . '/../view',
        ],
        'strategies' => [
            'ViewJsonStrategy',
        ],
    ],
    'moduleLayouts' => [
        'User' => 'layout/user.phtml'
    ],
];
