<?php

namespace PointToPoint\Form;

use Zend\Form\Form;
use Zend\Form\Element\{Checkbox, Text, Submit, Hidden, Password};
use Zend\Validator\{Digits, EmailAddress, NotEmpty, StringLength};
use Zend\InputFilter\InputFilterProviderInterface;


class LoginForm extends Form implements InputFilterProviderInterface {

    public function __construct($name = null) {

        parent::__construct('login-form');


        /**
         * First Name
         */
        $this->add([
            'name' => 'username',
            'type' => Text::class,
            'attributes' => [
                'id' => 'username',
                'class' => 'inputMaterial'
            ],
            'options' => [
                'label' => 'Email / Mobile No<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ]
        ]);



        /**
         * Email ID
         */
        $this->add([
            'name' => 'password',
            'type' => Password::class,
            'attributes' => [
                'id' => 'password',
                'class' => 'inputMaterial'
            ],
            'options' => [
                'label' => 'Password<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         * Terms and conditions
         */
        $this->add([
            'name' => 'agree_terms',
            'type' => Checkbox::class,
            'attributes' => [
                'id' => 'agree-terms',
            ],
            'options' => [
                'label' => 'Accept the Terms and Conditions',
                'checked_value' => '1',
                'unchecked_value' => 'no',
                'use_hidden_element' => true
            ],
        ]);

        /**
         * Traveller Submit
         */
        $this->add([
            'name' => 'login_submit',
            'type' => Submit::class,
            'attributes' => [
                'value' => 'Login',
                'id' => 'login-submit',
                'class' => 'btn btn-primary btn-lg'
            ],
        ]);
    }

        public function getInputFilterSpecification() {
        return [
            'username' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please enter Email Id or Mobile No.',
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'password' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please enter password.',
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'agree_terms' => [
                'required' => true,
                'validators' => [
                    ['name' => 'Digits',
                        'break_chain_on_failure' => true,
                        'options' => [
                            'messages' => [
                                Digits::NOT_DIGITS => 'Please Accept the Terms and Conditions',
                            ],
                        ],
                    ],
                ],
            ],
        ];
    }

}
