<?php

namespace Outstation\Form;

use Zend\Form\Form;
use Zend\Form\Element\{
    Checkbox,
    Text,
    Submit,
    Hidden,
    Select
};
use Zend\Validator\{
    Digits,
    EmailAddress,
    NotEmpty,
    StringLength
};
use Zend\InputFilter\InputFilterProviderInterface;

class TravellerForm extends Form implements InputFilterProviderInterface {

    public function __construct($name = null) {

        parent::__construct('traveller-form');


        /**
         * First Name
         */
        $this->add([
            'name' => 'first_name',
            'type' => Text::class,
            'attributes' => [
                'id' => 'first-name',
                'class' => 'inputMaterial',
                'onkeypress' => "return isAlphaNumber(event)",
                'maxlength' => 35
            ],
            'options' => [
                'label' => 'First Name<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ]
        ]);

        /**
         * Last Name
         */
        $this->add([
            'name' => 'last_name',
            'type' => Text::class,
            'attributes' => [
                'id' => 'last-name',
                'class' => 'inputMaterial',
                'onkeypress' => "return isAlphaNumber(event)",
                'maxlength' => 35
            ],
            'options' => [
                'label' => 'Last Name<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         * Nationality
         */
        $this->add([
            'name' => 'nationality',
            'type' => Text::class,
            'attributes' => [
                'id' => 'nationality',
                'class' => 'inputMaterial country-class'
            ],
            'options' => [
                'label' => 'Nationality<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true],
            ],
        ]);

        /**
         * Mobile No
         */
        $this->add([
            'name' => 'mobile',
            'type' => Text::class,
            'attributes' => [
                'id' => 'mobile',
                'class' => 'inputMaterial',
                'onkeypress' => "return isNumber(event)",
                'maxlength' => 12
            ],
            'options' => [
                'label' => 'Mobile No<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         * Alt Mobile No
         */
        $this->add([
            'name' => 'alt_mobile_number',
            'type' => Text::class,
            'attributes' => [
                'id' => 'alt-mobile-number',
                'class' => 'inputMaterial',
                'onkeypress' => "return isNumber(event)",
                'maxlength' => 12
            ],
            'options' => [
                'label' => 'Alt Mobile No',
            ],
        ]);

        /**
         * Email ID
         */
        $this->add([
            'name' => 'email',
            'type' => Text::class,
            'attributes' => [
                'id' => 'email',
                'class' => 'inputMaterial'
            ],
            'options' => [
                'label' => 'Email ID<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         * Send Email
         */
        $this->add([
            'name' => 'send_email',
            'type' => Checkbox::class,
            'attributes' => [
                'id' => 'send-email',
            ],
            'options' => [
                'label' => '',
                'checked_value' => '1',
                'unchecked_value' => '0',
                'use_hidden_element' => true
            ],
        ]);


        /**
         * Terms and conditions
         */
        $this->add([
            'name' => 'agree_terms',
            'type' => Checkbox::class,
            'attributes' => [
                'id' => 'agree-terms',
            ],
            'options' => [
                'label' => 'Accept the Terms and Conditions',
                'checked_value' => '1',
                'unchecked_value' => 'no',
                'use_hidden_element' => true
            ],
        ]);

        /**
         * Traveller Submit
         */
        $this->add([
            'name' => 'traveller_submit',
            'type' => Submit::class,
            'attributes' => [
                'value' => 'Book Now',
                'id' => 'traveller-submit',
                'class' => 'btn btn-primary btn-lg'
            ],
        ]);
    }

    public function getInputFilterSpecification() {
        return [
            'first_name' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please enter First Name'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'last_name' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please enter Last Name'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            /*'nationality' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please select Nationality'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],*/
            'email' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please enter Email Id',
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ],
                    ['name' => 'EmailAddress',
                        'options' => [
                            'messages' => [
                                EmailAddress::INVALID => 'Please enter Valid Email Id',
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'mobile' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please enter Mobile No.'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ],
                    ['name' => 'Digits',
                        'options' => [
                            'messages' => [
                                Digits::NOT_DIGITS => 'Please enter Numeric value only',
                            ],
                        ],
                        'break_chain_on_failure' => true,
                    ],
                    ['name' => 'StringLength',
                        'options' => [
                            'min' => 10,
                            'max' => 10,
                            'messages' => [
                                StringLength::TOO_LONG => 'Please enter Less than 10 Digits',
                                StringLength::TOO_SHORT => 'Please enter greater than 9 Digits',
                            ],
                        ],
                        'break_chain_on_failure' => true
                    ],
                ]
            ],
            'agree_terms' => [
                'required' => true,
                'validators' => [
                    ['name' => 'Digits',
                        'break_chain_on_failure' => true,
                        'options' => [
                            'messages' => [
                                Digits::NOT_DIGITS => 'Please Accept the Terms and Conditions',
                            ],
                        ],
                    ],
                ],
            ],
        ];
    }

}
