<?php

namespace Outstation\Form;

use Zend\Form\Form;
use Zend\Form\Element\{
    Select,
    Date,
    Number,
    Checkbox,
    Submit,
    Text,
    Hidden
};
use Zend\Validator\{
    NotEmpty,
    Digits
};
use Zend\InputFilter\InputFilterProviderInterface;

class OneWaySearchForm extends Form implements InputFilterProviderInterface {

    public function __construct($name = null) {

        parent::__construct('one-way-vehicle-search-form');
        $this->setAttribute('method', 'post');

        /**
         * Pickup City
         */
        $this->add([
            'name' => 'pickup_city',
            'type' => Text::class,
            'attributes' => [
                'id' => 'pickup-city',
                'class' => 'inputMaterial pickup-city'
            ],
            'options' => [
                'label' => 'From<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true],
                'disable_inarray_validator' => true
            ],
        ]);

        /**
         * Drop City
         */
        $this->add([
            'name' => 'drop_city',
            'type' => Text::class,
            'attributes' => [
                'id' => 'drop-city',
                'class' => 'inputMaterial'
            ],
            'options' => [
                'label' => 'To<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true],
                'disable_inarray_validator' => true
            ],
        ]);



        /**
         * Pickup Date
         */
        $this->add([
            'name' => 'pickup_date',
            'type' => Text::class,
            'attributes' => [
                'id' => 'pickup-date',
                'placeholder' => '',
                'class' => 'inputMaterial datepicker',
            ],
            'options' => [
                'label' => 'Date<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true],
            ],
        ]);


        //Pickup Time
        $this->add([
            'name' => 'pickup_time',
            'type' => Text::class,
            'attributes' => [
                'id' => 'pickup_time',
                'placeholder' => '',
                'class' => 'inputMaterial'
            ],
            'options' => [
                'label' => 'Time<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true],
            ],
        ]);

        /**
         * Number of Adults
         */
        $this->add([
            'name' => 'adults',
            'type' => Number::class,
            'attributes' => [
                'id' => 'adults',
                'class' => 'inputMaterial',
                'min' => 0,
                'max' => 9,
                'step' => 1,
                'value' => 1
            ],
            'options' => [
                'label' => 'Adults',
            ],
        ]);

        /**
         * Number of Childs
         */
        $this->add([
            'name' => 'childs',
            'type' => Number::class,
            'attributes' => [
                'id' => 'childs',
                'class' => 'inputMaterial',
                'min' => 0,
                'max' => 9,
                'step' => 1,
                'value' => 0
            ],
            'options' => [
                'label' => 'Childs',
            ],
        ]);

        /**
         * Number of Luggages
         */
        $this->add([
            'name' => 'luggages',
            'type' => Number::class,
            'attributes' => [
                'id' => 'luggages',
                'class' => 'inputMaterial',
                'min' => 0,
                'max' => 9,
                'step' => 1,
                'value' => 0
            ],
            'options' => [
                'label' => 'Luggages',
            ],
        ]);

        /**
         * Number of Vehicles
         */
        $this->add([
            'name' => 'no_of_vehicles',
            'type' => Number::class,
            'attributes' => [
                'id' => 'no-of-vehicles',
                'class' => 'inputMaterial',
                'min' => 1,
                'max' => 9,
                'step' => 1,
                'value' => 1
            ],
            'options' => [
                'label' => 'Vehicles',
            ],
        ]);

        //coming mode is flight
        $this->add([
            'name' => 'flight_mode',
            'type' => Checkbox::class,
            'attributes' => [
                'id' => 'flight-mode',
            ],
            'options' => [
                'label' => '',
                'checked_value' => '1',
                'unchecked_value' => '0',
                'use_hidden_element' => true,
            ],
        ]);

        //Flight Number
        $this->add([
            'name' => 'flight_number',
            'type' => Text::class,
            'attributes' => [
                'id' => 'flight-number',
                //'placeholder' => 'Flight No',
                'class' => 'inputMaterial',
                'maxlength' => 15,
                'onkeypress' => "return isAlphaNumber(event)"
            ],
            'options' => [
                'label' => 'Flight No',
            ]
        ]);

        //Flight Time
        $this->add([
            'name' => 'flight_time',
            'type' => Text::class,
            'attributes' => [
                'id' => 'flight-time',
                //'placeholder' => 'Flight Time',
                'class' => 'inputMaterial'
            ],
            'options' => [
                'label' => 'Flight Time'
            ]
        ]);

        //Pickup address*
        $this->add([
            'name' => 'pickup_address',
            'type' => Text::class,
            'attributes' => [
                'id' => 'pickup-address',
                'placeholder'=>'',
                'class' => 'inputMaterial'
            ],
            'options' => [
                'label' => 'Pickup address<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        //Terms and conditions
        $this->add([
            'name' => 'agree_terms',
            'type' => Checkbox::class,
            'attributes' => [
                'id' => 'agree-terms',
            ],
            'options' => [
                'label' => 'Accept the Terms and Conditions',
                'checked_value' => '1',
                'unchecked_value' => 'no',
                'use_hidden_element' => true,
            ],
        ]);

        //submit button
        $this->add([
            'name' => 'search_a_car',
            'type' => Submit::class,
            'attributes' => [
                'value' => 'Search a Car',
                'id' => 'search-a-car',
                'class' => 'btn btn-primary btn-lg'
            ],
        ]);

        /**
         * Airport Transfer Going Selected
         */
        $this->add([
            'name' => 'flight_mode_selected',
            'type' => Hidden::class,
            'attributes' => [
                'id' => 'flight-mode-selected',
                'class' => 'inputMaterial'
            ]
        ]);

        /**
         * Form Type
         */
        $this->add([
            'name' => 'module_type',
            'type' => Hidden::class,
            'attributes' => [
                'value' => '',
                'id' => 'module-type'
            ],
        ]);

        $this->add([
            'name' => 'master_package_type',
            'type' => Hidden::class,
            'attributes' => [
                'id' => 'master-package-type',
                'class' => 'inputMaterial'
            ]
        ]);

        $this->add([
            'name' => 'pickcity_id',
            'type' => Hidden::class,
            'attributes' => [
                'id' => 'pickcity-id',
                'class' => 'inputMaterial'
            ]
        ]);

        $this->add([
            'name' => 'dropcity_id',
            'type' => Hidden::class,
            'attributes' => [
                'id' => 'dropcity-id',
                'class' => 'inputMaterial'
            ]
        ]);

        $this->add([
            'name' => 'drop_date',
            'type' => Hidden::class,
            'attributes' => [
                'id' => 'drop-date',
                'class' => 'inputMaterial'
            ]
        ]);

        $this->add([
            'name' => 'drop_time',
            'type' => Hidden::class,
            'attributes' => [
                'id' => 'drop-time',
                'class' => 'inputMaterial'
            ]
        ]);

        $this->add([
            'name' => 'city_latitude',
            'type' => Hidden::class,
            'attributes' => [
                'id' => 'city-latitude',
                'class' => 'inputMaterial'
            ]
        ]);

         $this->add([
            'name' => 'city_longitude',
            'type' => Hidden::class,
            'attributes' => [
                'id' => 'city-longitude',
                'class' => 'inputMaterial'
            ]
        ]);

        /**
         * Nationality
         */
        $this->add([
            'name' => 'nationality',
            'type' => Text::class,
            'attributes' => [
                'id' => 'nationality',
                'class' => 'inputMaterial country-class'
            ],
            'options' => [
                'label' => 'Nationality<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true],
            ],
        ]);
    }

    public function getInputFilterSpecification() {
        return [
            'pickup_city' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please select Pickup City'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'drop_city' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please select Drop City'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'pickup_address' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please select Pickup Address'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'nationality' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please select Nationality'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'pickup_date' => [
                'required' => false,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [

                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please enter Pickup Date'
                            ]
                        ],
                    ],
                    ['name' => 'Date',
                        'options' => [
                             'format'=>'d-m-Y',
                            'messages' => [
                                //Date::INVALID_DATE => '',
                                \Zend\Validator\Date::INVALID_DATE => 'Please enter Valid Date',
                            ],
                        ],
                        'break_chain_on_failure' => true
                    ],
                ]
            ],
            'pickup_time' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please enter Pickup Time'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'flight_number' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Enter Flight No'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'flight_time' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Enter Flight Time'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'adults' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'StringLength',
                        'options' => [
                            'min' => 1,
                            'max' => 9
                        ]
                    ],
                    ['name' => 'Digits',
                        'break_chain_on_failure' => true,
                        'options' => [
                            'messages' => [
                                Digits::NOT_DIGITS => 'Please select Number of Adult'
                            ]
                        ],
                    ],
                ]
            ],
            'childs' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'StringLength',
                        'options' => [
                            'min' => 1,
                            'max' => 9
                        ]
                    ],
                    ['name' => 'Digits',
                        'break_chain_on_failure' => true,
                        'options' => [
                            'messages' => [
                                Digits::NOT_DIGITS => 'Please select Number of Child'
                            ]
                        ],
                    ],
                ]
            ],
            'luggages' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'StringLength',
                        'options' => [
                            'min' => 1,
                            'max' => 9
                        ]
                    ],
                    ['name' => 'Digits',
                        'break_chain_on_failure' => true,
                        'options' => [
                            'messages' => [
                                Digits::NOT_DIGITS => 'Please select Number of Luggage'
                            ]
                        ],
                    ],
                ]
            ],
            'no_of_vehicles' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'StringLength',
                        'options' => [
                            'min' => 1,
                            'max' => 9
                        ]
                    ],
                    ['name' => 'Digits',
                        'break_chain_on_failure' => true,
                        'options' => [
                            'messages' => [
                                Digits::NOT_DIGITS => 'Please select Number of Vehicles'
                            ]
                        ],
                    ],
                ]
            ],
            'agree_terms' => [
                'required' => true,
                'validators' => [
                    ['name' => 'Digits',
                        'break_chain_on_failure' => true,
                        'options' => [
                            'messages' => [
                                Digits::NOT_DIGITS => 'Please Accept the Terms and Conditions',
                            ],
                        ],
                    ],
                ],
            ],
        ];
    }

}
