<?php

namespace Outstation\Form;

use Zend\Form\Form;
use Zend\Form\Element\{
    Submit,
    Checkbox,
    Number,
    Text,
    Hidden
};
use Zend\Validator\{
    NotEmpty,
    Digits
};
use Zend\Hydrator\ClassMethods;
use Zend\InputFilter\InputFilterProviderInterface;
use Outstation\Form\MultiCityFieldset;

// One product is defined by a category and list of items
class MultiCitySearchForm extends Form implements InputFilterProviderInterface {

    /**
     * Attribute manager.
     * @var Fieldset\Service\AttributeManager
     */
    public function __construct($name = null, $options = array()) {

        parent::__construct($name, $options);

        $this->setHydrator(new ClassMethods(false));


        /*         * *CREATE PRODUCT FIELDSET !!!
         * https://framework.zend.com/manual/2.4/en/modules/zend.form.collections.html
         * *** */

        $product = new MultiCityFieldset('new-product', null);

        $this->setOptions(['use_as_base_fieldset' => true]);
        $this->add($product);

        /**
         * Number of Adults
         */
        $this->add([
            'name' => 'adults',
            'type' => Number::class,
            'attributes' => [
                'id' => 'adults',
                'class' => 'inputMaterial',
                'min' => 1,
                'max' => 9,
                'step' => 1,
                'value' => 1
            ],
            'options' => [
                'label' => 'Adults',
            ],
        ]);

        /**
         * Number of Childs
         */
        $this->add([
            'name' => 'childs',
            'type' => Number::class,
            'attributes' => [
                'id' => 'childs',
                'class' => 'inputMaterial',
                'min' => 0,
                'max' => 9,
                'step' => 1,
                'value' => 0
            ],
            'options' => [
                'label' => 'Childs',
            ],
        ]);

        /**
         * Number of Luggages
         */
        $this->add([
            'name' => 'luggages',
            'type' => Number::class,
            'attributes' => [
                'id' => 'luggages',
                'class' => 'inputMaterial',
                'min' => 0,
                'max' => 9,
                'step' => 1,
                'value' => 0
            ],
            'options' => [
                'label' => 'Luggages',
            ],
        ]);

        /**
         * Number of Vehicles
         */
        $this->add([
            'name' => 'no_of_vehicles',
            'type' => Number::class,
            'attributes' => [
                'id' => 'no-of-vehicles',
                'class' => 'inputMaterial',
                'min' => 1,
                'max' => 9,
                'step' => 1,
                'value' => 1
            ],
            'options' => [
                'label' => 'Vehicles',
            ],
        ]);

        //coming mode is flight
        $this->add([
            'name' => 'flight_mode',
            'type' => Checkbox::class,
            'attributes' => [
                'id' => 'flight-mode'
            ],
            'options' => [
                'label' => '',
                'checked_value' => '1',
                'unchecked_value' => '0',
                'use_hidden_element' => true,
            ],
        ]);

        //Flight Number
        $this->add([
            'name' => 'flight_number',
            'type' => Text::class,
            'attributes' => [
                'id' => 'flight-number',
                //'placeholder' => 'Flight No',
                'class' => 'inputMaterial',
                'maxlength' => 15,
                'onkeypress' => "return isAlphaNumber(event)"
            ],
            'options' => [
                'label' => 'Flight No',
            ]
        ]);

        //Flight Time
        $this->add([
            'name' => 'flight_time',
            'type' => Text::class,
            'attributes' => [
                'id' => 'flight-time',
                //'placeholder' => 'Flight Time',
                'class' => 'inputMaterial'
            ],
            'options' => [
                'label' => 'Flight Time'
            ]
        ]);

        //Pickup address*
        $this->add([
            'name' => 'pickup_address',
            'type' => Text::class,
            'attributes' => [
                'id' => 'pickup-address',
                'placeholder'=>'',
                'class' => 'inputMaterial'
            ],
            'options' => [
                'label' => 'Pickup address<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        //Terms and conditions
        $this->add([
            'name' => 'agree_terms',
            'type' => Checkbox::class,
            'attributes' => [
                'id' => 'agree-terms',
            ],
            'options' => [
                'label' => 'Accept the Terms and Conditions',
                'checked_value' => '1',
                'unchecked_value' => 'no',
                'use_hidden_element' => true,
            ],
        ]);

        //submit button
        $this->add([
            'name' => 'search_a_car',
            'type' => Submit::class,
            'attributes' => [
                'value' => 'Search a Car',
                'id' => 'search-a-car',
                'class' => 'btn btn-primary btn-lg'
            ],
        ]);

        /**
         * Airport Transfer Going Selected
         */
        $this->add([
            'name' => 'flight_mode_selected',
            'type' => Hidden::class,
            'attributes' => [
                'id' => 'flight-mode-selected',
                'class' => 'inputMaterial'
            ]
        ]);

        /**
         * Form Type
         */
        $this->add([
            'name' => 'module_type',
            'type' => Hidden::class,
            'attributes' => [
                'value' => '',
                'id' => 'module-type'
            ],
        ]);


        $this->add([
            'name' => 'source_name',
            'type' => Hidden::class,
            'attributes' => [
                'id' => 'source-name',
                'value' => '',
            ],
        ]);

        $this->add([
            'name' => 'destination_name',
            'type' => Hidden::class,
            'attributes' => [
                'id' => 'destination-name',
                'value' => '',
            ],
        ]);

        $this->add([
            'name' => 'master_package_type',
            'type' => Hidden::class,
            'attributes' => [
                'id' => 'master-package-type',
                'class' => 'inputMaterial'
            ]
        ]);

        /**
         * Nationality
         */
        $this->add([
            'name' => 'nationality',
            'type' => Text::class,
            'attributes' => [
                'id' => 'nationality',
                'class' => 'inputMaterial country-class'
            ],
            'options' => [
                'label' => 'Nationality<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true],
            ],
        ]);
    }

    public function getInputFilterSpecification() {
        return [
            'flight_number' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Enter Flight No'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'flight_time' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Enter Flight Time'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'pickup_address' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please select Pickup Address'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'nationality' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please select Nationality'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'adults' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'StringLength',
                        'options' => [
                            'min' => 1,
                            'max' => 9
                        ]
                    ],
                    ['name' => 'Digits',
                        'break_chain_on_failure' => true,
                        'options' => [
                            'messages' => [
                                Digits::NOT_DIGITS => 'Please select Number of Adult'
                            ]
                        ],
                    ],
                ]
            ],
            'childs' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'StringLength',
                        'options' => [
                            'min' => 1,
                            'max' => 9
                        ]
                    ],
                    ['name' => 'Digits',
                        'break_chain_on_failure' => true,
                        'options' => [
                            'messages' => [
                                Digits::NOT_DIGITS => 'Please select Number of Child'
                            ]
                        ],
                    ],
                ]
            ],
            'luggages' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'StringLength',
                        'options' => [
                            'min' => 1,
                            'max' => 9
                        ]
                    ],
                    ['name' => 'Digits',
                        'break_chain_on_failure' => true,
                        'options' => [
                            'messages' => [
                                Digits::NOT_DIGITS => 'Please select Number of Luggage'
                            ]
                        ],
                    ],
                ]
            ],
            'no_of_vehicles' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'StringLength',
                        'options' => [
                            'min' => 1,
                            'max' => 9
                        ]
                    ],
                    ['name' => 'Digits',
                        'break_chain_on_failure' => true,
                        'options' => [
                            'messages' => [
                                Digits::NOT_DIGITS => 'Please select Number of Vehicles'
                            ]
                        ],
                    ],
                ]
            ],
            'agree_terms' => [
                'required' => true,
                'validators' => [
                    ['name' => 'Digits',
                        'break_chain_on_failure' => true,
                        'options' => [
                            'messages' => [
                                Digits::NOT_DIGITS => 'Please Accept the Terms and Conditions',
                            ],
                        ],
                    ],
                ],
            ],
        ];
    }

}
