<?php

namespace Outstation\Form;

use Outstation\Entity\MultiCityItem;
use Zend\Form\Fieldset;
use Zend\Form\Element\{
    Text,
    Date,
    Select,
    Number,
    Time,
    Hidden
};
use Zend\Validator\NotEmpty;
use Zend\InputFilter\InputFilterProviderInterface;
use Zend\Hydrator\ClassMethods;

class MultiCityItemFieldset extends Fieldset implements InputFilterProviderInterface {

    //private $pickupCityList = ['1' => 'Delhi', '2' => 'Noida', '3' => 'Agra', '4' => 'Lucknow', '5' => 'Mathura'];

    public function __construct($name = null, $options = []) {

        parent::__construct($name, $options);

        $this->setHydrator(new ClassMethods(false));
        $this->setObject(new MultiCityItem());

        /**
         * Pickup City
         */
        $this->add([
            'name' => 'pickup_city',
            //'type' => Select::class,
            'type' => Text::class,
            'attributes' => [
                'id' => 'pickup-city',
                //'placeholder' => 'From',
                'class'=> 'multicity-source-list inputMaterial'
            ],
            'options' => [
                //'label' => 'From',
                'empty_option' => '-- Please select --',
                //'value_options' => $this->pickupCityList,
                'disable_inarray_validator' => true
            ],
        ]);

//        $this->add([
//            'name' => 'pickcity_id',
//            'type' => Hidden::class,
//            'attributes' => [
//                'id' => 'pickcity-id',
//                'class' => 'inputMaterial'
//            ]
//        ]);
//
//        $this->add([
//            'name' => 'dropcity_id',
//            'type' => Hidden::class,
//            'attributes' => [
//                'id' => 'dropcity-id',
//                'class' => 'inputMaterial'
//            ]
//        ]);

        /**
         * Drop City
         */
        $this->add([
            'name' => 'drop_city',
            //'type' => Select::class,
            'type' => Text::class,
            'attributes' => [
                'id' => 'drop-city',
                //'placeholder' => 'To',
                'class'=> 'multicity-destination-list inputMaterial'
            ],
            'options' => [
                //'label' => 'Attribute',
                'empty_option' => '-- Please select --',
                //'value_options' => $this->pickupCityList,
                'disable_inarray_validator' => true
            ],
        ]);

        /**
         * Pick up Date
         */
        $this->add([
            'name' => 'pickup_date',
            'type' => Text::class,
            'attributes' => [
                //'id' => 'pickup-date',
                //'placeholder' => 'Pickup Date',
                'class' => 'inputMaterial pickup_date',
            ],
            'options' => [
            ],
        ]);

        /**
         * Pick up Time
         */
        $this->add([
            'name' => 'pickup_time',
            'type' => Text::class,
            'attributes' => [
                'id' => 'pickup-time',
                //'placeholder' => 'Pickup Time',
                'class' => 'inputMaterial clockpicker',
            ],
            'options' => [
            ]
        ]);

        /**
         * Days
         */
        $this->add([
            'name' => 'days',
            'type' => Text::class,
            'attributes' => [
                'id' => 'days',
                 //'placeholder' => 'No of Days',
                'class'=>'inputMaterial',
                'readonly'=>true
            ],
            'options' => [
            ],
        ]);

    }

    public function getInputFilterSpecification() {
        return [
            'pickup_city' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please select City'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'drop_city' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please select City'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'pickup_date' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [

                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please enter Pickup Date'
                            ]
                        ],
                    ],
                    ['name' => 'Date',
                        'options' => [
                             'format'=>'d-m-Y',
                            'messages' => [
                                //Date::INVALID_DATE => '',
                                \Zend\Validator\Date::INVALID_DATE => 'Please enter Valid Date',
                            ],
                        ],
                        'break_chain_on_failure' => true
                    ],
                ]
            ],
            'pickup_time' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please enter Pickup Time'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'days' => [
                'required' => false,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please enter Days'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
        ];
    }

}
