<?php

namespace Outstation;

use Zend\Router\Http\Segment;
use Zend\ServiceManager\Factory\InvokableFactory;

return [
    'router' => [
        'routes' => [
            'outstation' => [
                'type' => Segment::class,
                'options' => [
                    'route' => '/outstation[/:action][/:param]',
                    'defaults' => [
                        'controller' => Controller\IndexController::class,
                        'action' => 'one-way',
                    ],
                    'constraints' => [
                        'action' => '[a-zA-Z][a-zA-Z0-9_-]*',
                        'param' => '[a-zA-Z0-9]*'
                    ],
                ],
            ],
        ],
    ],
    'controllers' => [
        'factories' => [
            Controller\IndexController::class => InvokableFactory::class,
        ],
    ],
    'view_helpers' => [
        'factories' => [
            View\Helper\FormInputTd::class => InvokableFactory::class,
            View\Helper\FormRowTd::class => InvokableFactory::class,
        ],
        'aliases' => [
            'formInputTd' => View\Helper\FormInputTd::class,
            'formRowTd' => View\Helper\FormRowTd::class
        ]
    ],
    'view_manager' => [
        'display_not_found_reason' => true,
        'display_exceptions' => true,
        'doctype' => 'HTML5',
        'not_found_template' => 'error/404',
        'exception_template' => 'error/index',
        'template_map' => [
            'layout/layout' => __DIR__ . '/../view/layout/layout.phtml',
            'outstation/index/index' => __DIR__ . '/../view/outstation/index/index.phtml',
            'error/404' => __DIR__ . '/../view/error/404.phtml',
            'error/index' => __DIR__ . '/../view/error/index.phtml',
        ],
        'template_path_stack' => [
            __DIR__ . '/../view',
        ],
        'strategies' => [
            'ViewJsonStrategy',
        ],
    ],
    'moduleLayouts' => [
        'Outstation' => 'layout/outstation.phtml'
    ],
];
