<?php
namespace Guide\Controller;

use Application\Controller\RestAPIClientController;
use Guide\Form\VehicleSearchForm;
use Guide\Form\TravellerForm;
use Zend\View\Model\{
    ViewModel,
    JsonModel
};
use Zend\Debug\Debug;
use Zend\Session\Container;
use Zend\Json\Json;

class IndexController extends RestAPIClientController
{
    public function indexAction(){
        
        
        
        //create form object
        $form = new VehicleSearchForm();
        
        //get request object          
        $request = $this->getRequest();        
        //if request will be post                
        if($request->isPost()){
            $form->setData($request->getPost());                        
            if($form->isValid()){                 
                $post = $request->getPost()->toArray();                        
                return $this->redirect()->toRoute('guide',  ['action'=>'guide-listing']);    
               }
               else{
            //$aa =   $form->getMessages();
            //echo "<pre>";print_r($aa); exit;
        }
               
        }
         
        $viewModel = new ViewModel([
            'form'=> $form,
            'google_map_url' => $this->config()->getConfig()->google_map->url,
            'google_map_key' => $this->config()->getConfig()->google_map->key,    
                ]);
        return $viewModel;
    }
    
    public function bookingAction(){ 
    
        $viewModel = new ViewModel();
        return $viewModel;
    }
    
    /**
     * 
     * @return ViewModel
     */
    public function addOnServicesAction(){
    
        $viewModel = new ViewModel();
        return $viewModel;
    }
    
    /**
     * 
     * @return ViewModel
     */
    public function reviewAction(){
    
        $viewModel = new ViewModel();
        return $viewModel;
    }
    
    /**
     * 
     * @return ViewModel
     */
    public function travellerAction(){
    
       
        
        $sessionContainer = new Container('vehicle');
        $paymentData = $this->getRequest()->getPost();
        $sessionContainer->vehicleData = $paymentData;
        //echo '<pre>';print_r($paymentData);die();
        $form = new TravellerForm();
        $viewModel = new ViewModel([
            'form' => $form,
            'paymentData' => $paymentData
        ]);
        return $viewModel;
    
        
    }

    public function guideListingAction(){ 
        
    
        
        $form = new VehicleSearchForm();
        

        
        $request = $this->getRequest(); 
        
        //if request will be post                
        if($request->isPost()){
            $form->setData($request->getPost());                        
            if($form->isValid()){                 
                $post = $request->getPost()->toArray();                        
                return $this->redirect()->toRoute('guide-booking',  ['action'=>'guide-listing']);    
               }
               else{
            //$aa =   $form->getMessages();
            //echo "<pre>";print_r($aa); exit;
        }
               
        }
         
        $viewModel = new ViewModel([
            'form'=> $form,
            'google_map_url' => $this->config()->getConfig()->google_map->url,
            'google_map_key' => $this->config()->getConfig()->google_map->key,    
                ]);
           return $viewModel;
     
        
        
    }
    
    public function paymentDetailAction(){
    
        $viewModel = new ViewModel();
        return $viewModel;        
    }
    
    /**
     *
     * @return ViewModel
     */
    public function getCityListAction() {
        $data = [];
        $postData = $this->getRequest()->getPost();
        $term = $postData['term'];
        //$val = '{"where":{"and": [{"city_id": "'.$city.'"},{"area": {"like": "' . $term . '%"}}]},"limit":10}';
        $val = '{"where": {"name": {"like": "' . $term . '%"}},"limit":10}';
        $val = rawurlencode($val);
        $url = $this->apiUrl() . "/city?&filter=" . $val;
        //echo $url; die;
        $resp = $this->get($url);
        $cityJsonData = Json::decode($resp->getBody(), true);
        if (!empty($cityJsonData)) {
            foreach ($cityJsonData as $value) {
                $data[] = ["label" => $value['name'], "city_id" => $value['id']];
            }
        } else {
            $data[] = ["label" => 'Not Exist'];
        }
        $view = new JsonModel($data);
        return $view;
    }
    
    public function getCountryListAction() {
        $data = [];
        $postData = $this->getRequest()->getPost();
        $term = $postData['term'];
        //$val = '{"where":{"and": [{"city_id": "'.$city.'"},{"area": {"like": "' . $term . '%"}}]},"limit":10}';
        $val = '{"where": {"name": {"like": "' . $term . '%"}},"limit":10}';
        $val = rawurlencode($val);
        $url = $this->apiUrl() . "/country?&filter=" . $val;
        //echo $url; die;
        $resp = $this->get($url);
        $countryJsonData = Json::decode($resp->getBody(), true);
        if (!empty($countryJsonData)) {
            foreach ($countryJsonData as $value) {
                $data[] = ["label" => $value['name'], "country_id" => $value['id']];
            }
        } else {
            $data[] = ["label" => 'Not Exist'];
        }
        $view = new JsonModel($data);
        return $view;
    }
    
    public function getGuideLanguageListAction() {
        $data = [];
        $postData = $this->getRequest()->getPost();
        $term = $postData['term'];
        //$val = '{"where":{"and": [{"city_id": "'.$city.'"},{"area": {"like": "' . $term . '%"}}]},"limit":10}';
        $val = '{"where": {"language_name": {"like": "' . $term . '%"}},"limit":10}';
        $val = rawurlencode($val);
        $url = $this->apiUrl() . "/master-language?&filter=" . $val;
        //echo $url; die;
        $resp = $this->get($url);
        $guideLanguageJsonData = Json::decode($resp->getBody(), true);
        if (!empty($guideLanguageJsonData)) {
            foreach ($guideLanguageJsonData as $value) {
                $data[] = ["label" => $value['language_name'], "lang_id" => $value['language_id']];
            }
        } else {
            $data[] = ["label" => 'Not Exist'];
        }
        $view = new JsonModel($data);
        return $view;
    }
    
    
    

    
    
}
