<?php

namespace Dashboard\View\Helper;

use Zend\View\Helper\AbstractHelper;
use Application\Controller\RestAPIClientController;
use Zend\Json\Json;

class DashboardMenu extends AbstractHelper {


     public function getDashboardModule($userTypeId) {
        $config = new \Zend\Config\Config(include BASE_PATH . '/config/autoload/global.php');
        $apiUrl = $config->api->url;
        $api = new RestAPIClientController();
        if($userTypeId > 0){
           $url = $apiUrl . '/role-assign-module/getAssignModuleByusertypeid?&user_type_id='. $userTypeId;
            $resp = $api->get($url);
            $menuData = Json::decode($resp->getBody(), true);

            if (isset($menuData) && !empty($menuData['responsedata'])) {
                 return $this->buildTree($menuData['responsedata']);
            }
        }
    }

    public function getStaffModule($userId,$roleId) {
        $config = new \Zend\Config\Config(include BASE_PATH . '/config/autoload/global.php');
        $apiUrl = $config->api->url;
        $api = new RestAPIClientController();
        if($roleId > 0){
            $url = $apiUrl . '/role-assign-module/getAssignModuleByStaffid?&user_id='. $userId.'&role_id='.$roleId;
            $resp = $api->get($url);
            $menuData = Json::decode($resp->getBody(), true);
            //echo '<pre>';print_r($menuData);//die();
            if (isset($menuData) && !empty($menuData['responsedata'])) {
                 return $this->buildTree($menuData['responsedata']);
            }
        }
    }

    public function getAllMasterModule(){
        $config = new \Zend\Config\Config(include BASE_PATH . '/config/autoload/global.php');
        $apiUrl = $config->api->url;
        $api = new RestAPIClientController();

         $url = $apiUrl . '/module-manager';
            $resp = $api->get($url);
            $menuData = Json::decode($resp->getBody(), true);

            if (isset($menuData) && !empty($menuData)) {
                 return $this->buildTree($menuData);
            }
    }

    public function buildTree($elements, $parentId = 0) {
    $branch = array();

    foreach ($elements as $element) {
        if ($element['parent_id'] == $parentId) {
            $children = $this->buildTree($elements, $element['module_id']);
            if ($children) {
                $element['submenu'] = $children;
            }
            $branch[] = $element;
        }
    }

    return $branch;
   }
   
      
     public function getNotificationList($userId) { 
        $config = new \Zend\Config\Config(include BASE_PATH . '/config/autoload/global.php');
        $apiUrl = $config->api->url;
        $api = new RestAPIClientController();
        //if($userId > 0){
            $url = $apiUrl . '/notification/notificationList?driver_id='.$userId;           
            $resp = $api->get($url);
            $notificationData = Json::decode($resp->getBody(), true);

            if (isset($notificationData) && ($notificationData['responsedata']['status']=='success')) {
                 return $notificationData['responsedata']['data'];
            }
        //}
    }




}
