<?php

/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

namespace Dashboard\Model;

use Application\Controller\RestAPIClientController;
use Zend\Session\Container;
use Zend\Json\Json;

class Vehicle extends RestAPIClientController {

    public function apiUrl() {
        $config = new \Zend\Config\Config(include BASE_PATH . '/config/autoload/global.php');
        return $config->api->url;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-August-2018
     * @description : FUNCTION TO GET VEHICLE TYPE DATA
     * @param $data
     * @returns $responsedata
     */

    public function getVehicleTypeData($data = null) {
        if ($data != "") {
            $url = $this->apiUrl() . "/vehicle-type?&filter=" . $data;
        } else {
            //$val = '{"where": {"status": {"neq": 2}}}';
            $val = '{"where": {"status": {"neq": 2}},"order":"display_order ASC"}';
            $val = rawurlencode($val);
            $url = $this->apiUrl() . "/vehicle-type?&filter=" . $val;
        }
        $resp = $this->get($url);
        $mvehicleList = Json::decode($resp->getBody(), true);
        //echo '<pre>';print_r($mvehicleList);die();
        if ($mvehicleList != "") {
            $val = ["status" => true, "data" => Json::decode($resp->getBody(), true)];
        } else {
            $val = ["status" => false, "data" => Json::decode($resp->getBody(), true)];
        }
        return $val;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-August-2018
     * @description : FUNCTION TO INSERT VEHICLE TYPE
     * @param $data
     * @returns $responsedata
     */

    public function insertVehicleType($data) {
        $url = $this->apiUrl() . "/vehicle-type";
        $resp = $this->post($url, $data);
        $vehicleTypeJsonData = Json::decode($resp->getBody(), true);
        return $vehicleTypeJsonData;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-August-2018
     * @description : FUNCTION TO UPDATE VEHICLE TYPE
     * @param $data
     * @returns $responsedata
     */

    public function updateVehicleType($data) {
        $val = '{"id": "' . $data['id'] . '"}';
        $val = rawurlencode($val);
        $url = $this->apiUrl() . "/vehicle-type/update?where=" . $val;
        $resp = $this->post($url, $data);
        $vehicleTypeJsonData = Json::decode($resp->getBody(), true);
        //Debug::dump($vehicleTypeJsonData); exit;
        return $vehicleTypeJsonData;
    }

    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-August-2018
     * @description : FUNCTION TO UPDATE VEHICLE TYPE STATUS
     * @param $data
     * @returns $responsedata
     */
    
    public function updateVehicleTypeStatus($data) {
        $url = $this->apiUrl() . "/vehicle-type/vehicleTypeStatus"; //die;
        $resp = $this->put($url, $data);
        $data = Json::decode($resp->getBody(), true);
        //echo '<pre>';print_r($data);die();
        return $data;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-August-2018
     * @description : FUNCTION TO DELETE VEHICLE TYPE
     * @param $data
     * @returns $responsedata
     */

    public function deleteVehicleType($data) {
        $url = $this->apiUrl() . "/vehicle-type/deleteVehicleType";
        $resp = $this->put($url, $data);
        $vehicleTypeJsonData = Json::decode($resp->getBody(), true);
        return $vehicleTypeJsonData;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-August-2018
     * @description : FUNCTION TO GET VEHICLE NAME LIST
     * @param $data
     * @returns $responsedata
     */

    public function getVehicleNameList($data = null) {
        $vehicleNameJsonDataArray = [];
        $val = '{"where": {"status": {"neq": 2}}}';
        $val = rawurlencode($val);
        $url = $this->apiUrl() . "/vehicle-model?&filter=" . $val;
        $resp = $this->get($url);
        $vehicleNameJsonData = Json::decode($resp->getBody(), true);
        foreach ($vehicleNameJsonData as $res) {
            $vehicleNameJsonDataArray[$res['id']] = $res['name'];
        }
        return $vehicleNameJsonDataArray;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-August-2018
     * @description : FUNCTION TO GET VEHICLE TYPE LIST
     * @param $data
     * @returns $responsedata
     */

    public function getVehicleTypeList($data = null) {
        $vehicleTypeJsonDataArray = [];
        //$val = '{"where": {"status": {"neq": 2}}}';
        $val = '{"where": {"status": {"neq": 2}}, "order": ["display_order ASC"]}';
        $val = rawurlencode($val);
        $url = $this->apiUrl() . "/vehicle-type?&filter=" . $val;
        $resp = $this->get($url);
        $vehicleTypeJsonData = Json::decode($resp->getBody(), true);
        if($vehicleTypeJsonData['status']=="success"){
        foreach ($vehicleTypeJsonData['data'] as $res) {
            $vehicleTypeJsonDataArray[$res['id']] = $res['vehicle_type'];
        }
        }
        return $vehicleTypeJsonDataArray;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-August-2018
     * @description : FUNCTION TO GET VEHICLE TYPE CLAIM LIST
     * @param $data
     * @returns $responsedata
     */
    
    public function getVehicleTypeClaimList($data = null) {
        $vehicleTypeJsonDataArray = [];
        $val = '{"where": {"status": {"neq": 2}}, "order": ["display_order ASC"]}';
        $val = rawurlencode($val);
        $url = $this->apiUrl() . "/vehicle-type?&filter=" . $val;
        $resp = $this->get($url);
        $vehicleTypeJsonData = Json::decode($resp->getBody(), true);
        if($vehicleTypeJsonData['status']=="success"){
            $vehicleTypeJsonDataArray[] = $vehicleTypeJsonData['data'];
        }
        return $vehicleTypeJsonDataArray;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-August-2018
     * @description : FUNCTION TO GET VEHICLE NAME DATA
     * @param $data
     * @returns $responsedata
     */

    public function getVehicleNameData($data = null) {
        if ($data != "") {
            $url = $this->apiUrl() . "/vehicle-model?&filter=" . $data;
        } else {
            $val = '{"where": {"status": {"neq": 2}}}';
            $val = rawurlencode($val);
            $url = $this->apiUrl() . "/vehicle-model?&filter=" . $val;
        }
        $resp = $this->get($url);
        $mvehicleList = Json::decode($resp->getBody(), true);
        // '<pre>';print_r($mvehicleList);die();
        if ($mvehicleList != "") {
            $val = ["status" => true, "data" => Json::decode($resp->getBody(), true)];
        } else {
            $val = ["status" => false, "data" => Json::decode($resp->getBody(), true)];
        }
        return $val;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-August-2018
     * @description : FUNCTION TO INSERT VEHICLE NAME
     * @param $data
     * @returns $responsedata
     */

    public function insertVehicleName($data) {
        $url = $this->apiUrl() . "/vehicle-model";
        $resp = $this->post($url, $data);
        $vehicleTypeJsonData = Json::decode($resp->getBody(), true);
        return $vehicleTypeJsonData;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-August-2018
     * @description : FUNCTION TO UPDATE VEHICLE NAME
     * @param $data
     * @returns $responsedata
     */

    public function updateVehicleName($data) {
        $val = '{"id": "' . $data['id'] . '"}';
        $val = rawurlencode($val);
        $url = $this->apiUrl() . "/vehicle-model/update?where=" . $val;
        $resp = $this->post($url, $data);
        $vehicleTypeJsonData = Json::decode($resp->getBody(), true);
        return $vehicleTypeJsonData;
    }

    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-August-2018
     * @description : FUNCTION TO UPDATE VEHICLE MODEL
     * @param $data
     * @returns $responsedata
     */
    
    public function updateVehicleModelStatus($data) {
        $url = $this->apiUrl() . "/vehicle-model/vehicleModelStatus"; //die;
        $resp = $this->put($url, $data);
        $data = Json::decode($resp->getBody(), true);
        return $data;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-August-2018
     * @description : FUNCTION TO DELETE VEHICLE NAME
     * @param $data
     * @returns $responsedata
     */

    public function deleteVehicleName($data) {
        $url = $this->apiUrl() . "/vehicle-model/deleteVehicleModel";
        $resp = $this->put($url, $data);
        $vehicleTypeJsonData = Json::decode($resp->getBody(), true);
        return $vehicleTypeJsonData;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-August-2018
     * @description : FUNCTION TO GET VEHCILE AMENITIES LIST
     * @param $data
     * @returns $responsedata
     */

    public function getVehicleAmenitiesList() {
        $amenitiesJsonDataArray = [];
        $val = '{"where": {"status": {"neq": 2}}}';
        $val = rawurlencode($val);
        $url = $this->apiUrl() . "/vehicle-amenities?&filter=" . $val;
        $resp = $this->get($url);
        $amenitiesJsonData = Json::decode($resp->getBody(), true);
        foreach ($amenitiesJsonData as $res) {
            $amenitiesJsonDataArray[$res['id']] = $res['amenities_name'];
        }
        return $amenitiesJsonDataArray;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-August-2018
     * @description : FUNCTION TO GET VEHICLE AMENITIES DATA
     * @param $data
     * @returns $responsedata
     */

    public function getVehicleAmenitiesData($data = null) {
        if($data!=""){
            $url = $this->apiUrl() . "/vehicle-amenities?&filter=".$data;
        }
        else{
            //$val = '{"where": {"status": {"neq": 2}}}';
            $val = '{"where": {"status": {"neq": 2}},"order":"id DESC"}';
            $val = rawurlencode($val);
            $url = $this->apiUrl() . "/vehicle-amenities?&filter=" . $val;
        }
        $resp = $this->get($url);
        $mvehicleList = Json::decode($resp->getBody(), true);
        if ($mvehicleList != "") {
            $val = ["status" => true, "data" => Json::decode($resp->getBody(), true)];
        } else {
            $val = ["status" => false, "data" => Json::decode($resp->getBody(), true)];
        }
        return $val;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-August-2018
     * @description : FUNCTION TO INSERT VEHICLE AMENITIES TYPE
     * @param $data
     * @returns $responsedata
     */

    public function insertVehicleAmenitiesType($data) {
        $url = $this->apiUrl() . "/vehicle-amenities";
        $resp = $this->post($url, $data);
        $vehicleTypeJsonData = Json::decode($resp->getBody(), true);
        return $vehicleTypeJsonData;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-August-2018
     * @description : FUNCTION TO UPDATE VEHICLE AMENITIES TYPE
     * @param $data
     * @returns $responsedata
     */

    public function updateVehicleAmenitiesType($data) {
        $val = '{"id": "' . $data['id'] . '"}';
        $val = rawurlencode($val);
        $url = $this->apiUrl() . "/vehicle-amenities/update?where=" . $val;
        $resp = $this->post($url, $data);
        $vehicleTypeJsonData = Json::decode($resp->getBody(), true);
        return $vehicleTypeJsonData;
    }

    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-August-2018
     * @description : FUNCTION TO UPDATE VEHICLE AMENITIES STATUS
     * @param $data
     * @returns $responsedata
     */
    
    public function updateVehicleAmenitiesStatus($data) {
        $url = $this->apiUrl() . "/vehicle-amenities/vehicleAmenitiesStatus"; //die;
        $resp = $this->put($url, $data);
        $data = Json::decode($resp->getBody(), true);
        return $data;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-August-2018
     * @description : FUNCTION TO DELETE VEHICLE AMENITIES
     * @param $data
     * @returns $responsedata
     */

    public function deleteVehicleAmenities($data) {
        $url = $this->apiUrl() . "/vehicle-amenities/deleteVehicleAmenities";
        $resp = $this->put($url, $data);
        $vehicleTypeJsonData = Json::decode($resp->getBody(), true);
        return $vehicleTypeJsonData;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-August-2018
     * @description : FUNCTION TO UPDATE DRIVER MAPPING
     * @param $data
     * @returns $responsedata
     */

    public function updateVehicleDriverMapping($id,$driverid,$vehiclemasterid,$mapStatus){
         $url = $this->apiUrl() . "/vehicle-master/updateDriverVehicleMap?id=".$id."&user_id=".$driverid."&vehicle_id=" .$vehiclemasterid."&map_status=" .$mapStatus;

        $resp = $this->get($url);
        $data = Json::decode($resp->getBody(), true);
        return $data;

    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-August-2018
     * @description : FUNCTION TO UPLOAD IMAGE
     * @param $data
     * @returns $responsedata
     */

    public function uploadimageapi($arrval = array()) {
        $url = $this->apiUrl() . "/user/uploadImg";
        $val = $this->post($url, $arrval);
        $JsonData = $val->getBody();
        $JsonData = Json::decode($JsonData, true);
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-August-2018
     * @description : FUNCTION TO GET VEHICLE COLOUR
     * @param $data
     * @returns $responsedata
     */

    public function getVehicleColour(){
        $colourDataArray = [];
        $url = $this->apiUrl()."/vehicle-master/vehiclecolour";
        $resp = $this->get($url);
        $colourData = Json::decode($resp->getBody(), true);

        if($colourData['responsedata']['status']=='success'){
            foreach ($colourData['responsedata']['data'] as $res) {
                $colourDataArray[$res['colour_id']] = $res['colour_name'];
            }
        }
        return $colourDataArray;
    }

    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-August-2018
     * @description : FUNCTION TO UPDATE VEHICLE TYPE ORDER
     * @param $data
     * @returns $responsedata
     */
    
    public function updateVehicleTypeOrder($data) {
        $url = $this->apiUrl() . "/vehicle-type/vehicleTypeOrder"; //die;
        $resp = $this->put($url, $data);
        $data = Json::decode($resp->getBody(), true);
        //echo '<pre>';print_r($data);die();
        return $data;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-August-2018
     * @description : FUNCTION TO UPDATE VEHICLE LIST
     * @param $data
     * @returns $responsedata
     */
    
    public function getAllVehicleList($data) {
        $url = $this->apiUrl() . "/vehicle-master/getallvehicle";
        $resp = $this->post($url, $data);
        $vehiclelistJsonData = Json::decode($resp->getBody(), true);
        $vehicleList=[];
        if($vehiclelistJsonData['responsedata']['status']=='success'){
            $vehicleList = $vehiclelistJsonData['responsedata']['data'];
        }        
        if(!empty($vehicleList)){
            $vehiclelistdropdownArr = [];
            foreach($vehicleList as $value){
                $vehicle_id = $value['vehicle_master_id'];
                $vehicle_type_id = $value['vehicle_type_id'];
                $vehiclelistdropdownArr[$vehicle_type_id.'_'.$vehicle_id] = $value['vehicle_model_name'].' ( '.$value['vehicle_type_name'].' - '.$value['vehicle_no'].' )'; 
            }            
        }
        return $vehiclelistdropdownArr;
    }
}