<?php

/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

namespace Dashboard\Model;

use Application\Controller\RestAPIClientController;
use Zend\Session\Container;
use Zend\Json\Json;

class Template extends RestAPIClientController {

    public function apiUrl() {
        $config = new \Zend\Config\Config(include BASE_PATH . '/config/autoload/global.php');
        return $config->api->url;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-January-2020
     * @description : FUNCTION TO FETCH ALL THE MAILS LIST
     * @param $data
     * @returns $responsedata
     */
    
    public function getMailList($id) {
        $val = '{"where": {"company_id": "' . $id . '"}}';
        $val = rawurlencode($val);
        $url = $this->apiUrl() ."/email-templates?filter=" . $val;
        $resp = $this->get($url);
        $tempList = Json::decode($resp->getBody(), true);
        if ($tempList != "") {
            $val = ["status" => true, "data" => Json::decode($resp->getBody(), true)];
        } else {
            $val = ["status" => false, "data" => Json::decode($resp->getBody(), true)];
        }
        return $val;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-April-2020
     * @description : FUNCTION TO ADD MAIL INFO DATA
     * @param $data
     * @returns $responsedata
     */
    
    public function addMailInfo() {
        
        $url = $this->apiUrl() ."/email-templates";
        $resp = $this->get($url);
        $tempList = Json::decode($resp->getBody(), true);
        
        if ($tempList != "") {
            $val = ["status" => true, "data" => Json::decode($resp->getBody(), true)];
        } else {
            $val = ["status" => false, "data" => Json::decode($resp->getBody(), true)];
        }
        return $val;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-April-2020
     * @description : FUNCTION TO INSERT MAIL DETAILS
     * @param $data
     * @returns $responsedata
     */
    
    public function insertMailDetails($data) {
       $sessionContainer = new Container('userlogin');
       $userId = $sessionContainer->user_id;
        if($data !='')
        {       
        $data['created_date']=date('Y-m-d H:i:s');
        $data['ip']=$_SERVER['REMOTE_ADDR'];
        $data['created_by']=$userId;
        $url = $this->apiUrl() . "/email-templates";
        $resp = $this->post($url, $data);
        $vehicleTypeJsonData = Json::decode($resp->getBody(), true);
        }
        return $vehicleTypeJsonData;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-April-2020
     * @description : FUNCTION TO UPDATE THE MAIL DETAILS
     * @param $data
     * @returns $responsedata
     */
    
    public function editMailDetails($post) {
       $sessionContainer = new Container('userlogin');
       $userId = $sessionContainer->user_id;
        
        if($post['id'] !='')
        {
                $val = '{"id": "' .$post['id'] . '"}';
                $val = rawurlencode($val);
                $url = $this->apiUrl() . "/email-templates/update?where=" . $val;
                $post['modified_by']=$userId;
                $val = $this->post($url, $post);
                $JsonData = $val->getBody();
                $JsonData = Json::decode($JsonData, true);
                 
        }
        return $JsonData;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-April-2020
     * @description : FUNCTION TO UPDATE THE MAIL STATUS
     * @param $data
     * @returns $responsedata
     */
    
    public function updateMailStatus($data) {
        
        $url = $this->apiUrl() . "/email-templates/emailStatus?id=".$data['id']."&email_status=".$data['email_status']."&user_id=".$data['user_id']; 
        $resp = $this->get($url);
        $data = Json::decode($resp->getBody(), true);
        return $data;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-April-2020
     * @description : FUNCTION TO GET THE DESCRIPTION.
     * @param $data
     * @returns $responsedata
     */
    
      
    public function getDesc($data) {
        $id=$data['id'];
        if(isset($data['type']) && $data['type']=="sms-template"){
        $url = $this->apiUrl() ."/sms_template/".$id;   
        }else{
        $url = $this->apiUrl() ."/email-templates/".$id;
        }
        $resp = $this->get($url);
        $tempList = Json::decode($resp->getBody(), true);
        if ($tempList != "") {
            $val = ["status" => true, "data" => Json::decode($resp->getBody(), true)];
        } else {
            $val = ["status" => false, "data" => Json::decode($resp->getBody(), true)];
        }
        return $val;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-April-2020
     * @description : FUNCTION TO FETCH THE SMS LIST
     * @param $data
     * @returns $responsedata
     */
    
    public function getSmsList($id) {
        $val = '{"where": {"company_id": "' . $id . '"}}';
        $val = rawurlencode($val);
        $url = $this->apiUrl() ."/sms_template?filter=" . $val;
        $resp = $this->get($url);
        $tempList = Json::decode($resp->getBody(), true);
        
        if ($tempList != "") {
            $val = ["status" => true, "data" => Json::decode($resp->getBody(), true)];
        } else {
            $val = ["status" => false, "data" => Json::decode($resp->getBody(), true)];
        }
        return $val;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-April-2020
     * @description : FUNCTION TO INSERT THE SMS DETAILS
     * @param $data
     * @returns $responsedata
     */
    
    public function insertSmsDetails($data) {
       $sessionContainer = new Container('userlogin');
       $userId = $sessionContainer->user_id;
     
        if($data !='')
        { 
        $data['created_by']=$userId;
        $data['ip']=$_SERVER['REMOTE_ADDR'];
        $url = $this->apiUrl() ."/sms_template/addsmstemplatedetail"; 
        $resp = $this->post($url,$data);
        $vehicleTypeJsonData = Json::decode($resp->getBody(), true);
        }
        return $vehicleTypeJsonData;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-April-2020
     * @description : FUNCTION TO GET THE SMS DETAILS
     * @param $data
     * @returns $responsedata
     */
 
    public function getsmsdetail($id) {
        $val=[];
        if($id !=''){
        $url = $this->apiUrl() ."/sms_template/".$id;
        $resp = $this->get($url);
        $tempList = Json::decode($resp->getBody(), true);
        if ($tempList != "") {
            $val = ["status" => true, "data" => Json::decode($resp->getBody(), true)];
        } else {
            $val = ["status" => false, "data" => Json::decode($resp->getBody(), true)];
        }
        }
        return $val;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-April-2020
     * @description : FUNCTION TO EDIT THE SMS DETAILS
     * @param $data
     * @returns $responsedata
     */
    
    public function editSmsDetails($post) {
       $sessionContainer = new Container('userlogin');
       $userId = $sessionContainer->user_id;   
        if($post['id'] !='')
        {
            
                $post['modified_by']=$userId;
                $post['ip']=$_SERVER['REMOTE_ADDR'];
                $val = '{"id": "' .$post['id'] . '"}';
                $val = rawurlencode($val);
                $url = $this->apiUrl() . "/sms_template/update?where=" . $val;
                $val = $this->post($url, $post);
                $JsonData = $val->getBody();
                $JsonData = Json::decode($JsonData, true);
                 
        }
        return $JsonData;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-April-2020
     * @description : FUNCTION TO UPDATE THE SMS STATUS
     * @param $data
     * @returns $responsedata
     */
    
    public function updateSmsStatus($data) {
        
        $url = $this->apiUrl() . "/sms_template/smsStatus?id=".$data['id']."&sms_status=".$data['sms_status']."&user_id=".$data['user_id'];  
        $resp = $this->get($url);
        $data = Json::decode($resp->getBody(), true);
        return $data;
    }

}