<?php

/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

namespace Dashboard\Model;

use Application\Controller\RestAPIClientController;
use Zend\Session\Container;
use Zend\Json\Json;

class FareManageModel extends RestAPIClientController {

    public function apiUrl() {
        $config = new \Zend\Config\Config(include BASE_PATH . '/config/autoload/global.php');
        return $config->api->url;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-April-2020
     * @description : FUNCTION TO FETCH USER FARE SETTING ALL DATA
     * @param $data
     * @returns $responsedata
     */
  
    public function getUserFareSettingAllData($arrval=array()){
       $user_id       = $arrval['user_id'];
       $booking_type  = $arrval['booking_type'];

       $finalvalue = [];

      $userTaxFareData   =   $this->getUserTaxdetail($user_id,$booking_type);
      if(!empty($userTaxFareData)){
          $finalvalue['userTaxDetailData'] = $userTaxFareData;
      }else{
           $finalvalue['userTaxDetailData'] = '';
      }
      
      $userFareSettingData   =   $this->getUserFareSetting($user_id,$booking_type);
      if(!empty($userFareSettingData)){
          $finalvalue['userFareSettingData'] = $userFareSettingData;
      }else{
          $finalvalue['userFareSettingData'] = '';
      }
       
      $userNightChargeData   =   $this->getUserNightCharge($user_id,$booking_type);
      if(!empty($userNightChargeData)){
          $finalvalue['userNightChargeData'] = $userNightChargeData;
      }else{
          $finalvalue['userNightChargeData'] = '';
      }
      
      $userCancellationfareData   =   $this->getUserCancellationFare($user_id,$booking_type);
      if(!empty($userCancellationfareData)){
          $finalvalue['userCancellationfareData'] = $userCancellationfareData;
      }else{
          $finalvalue['userCancellationfareData'] = '';
      }  
      
       $userWaitingChargeData   =   $this->getUserWaitingCharge($user_id,$booking_type);
      if(!empty($userWaitingChargeData)){
          $finalvalue['userWaitingChargeData'] = $userWaitingChargeData;
      }else{
          $finalvalue['userWaitingChargeData'] = '';
      }
       
      $userPreWaitingChargeData   =   $this->getUserPreWaitingCharge($user_id,$booking_type);
      if(!empty($userPreWaitingChargeData)){
          $finalvalue['userPreWaitingChargeData'] = $userPreWaitingChargeData;
      }else{
          $finalvalue['userPreWaitingChargeData'] = '';
      }
      
      $userPremiumsFareData   =   $this->getUserPremiumsFare($user_id,$booking_type);
      if(!empty($userPremiumsFareData)){
          $finalvalue['userPremiumsFareData'] = $userPremiumsFareData;
      }else{
          $finalvalue['userPremiumsFareData'] = '';
      }
      
       $userPostalCodeData   =   $this->getUserPostalCode($user_id,$booking_type);
      if(!empty($userPostalCodeData)){
          $finalvalue['userPostalCodeData'] = $userPostalCodeData;
      }else{
           $finalvalue['userPostalCodeData'] ='';
      }
       
      $userFixRouteData   =   $this->getUserFixRoute($user_id,$booking_type);
      if(!empty($userFixRouteData)){
          $finalvalue['userFixRouteData'] = $userFixRouteData;
      }else{
          $finalvalue['userFixRouteData'] = '';
      }
      
      $userPeakTimeChargeData   =   $this->getUserPeaktimeCharge($user_id,$booking_type);
      if(!empty($userPeakTimeChargeData)){
          $finalvalue['userPeakTimeChargeData'] = $userPeakTimeChargeData;
      }else{
          $finalvalue['userPeakTimeChargeData'] ='';
      }
      
      $userExtrasChargeData   =   $this->getUserExtrasCharge($user_id,$booking_type);
      if(!empty($userExtrasChargeData)){
          $finalvalue['userExtrasChargeData'] = $userExtrasChargeData;
      }else{
          $finalvalue['userExtrasChargeData']='';
      }
      
      $userCompanyShareData   =   $this->getUserCompanyShare($user_id,$booking_type);
      if(!empty($userCompanyShareData)){
          $finalvalue['userCompanyShareData'] = $userCompanyShareData;
      }else{
          $finalvalue['userCompanyShareData']= '';
      }
      
      
      return $finalvalue;

   } 
   
   /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-April-2020
     * @description : FUNCTION TO FETCH USER TAX DETAILS DATA
     * @param $data
     * @returns $responsedata
     */
     
    public function getUserTaxdetail($user_id, $booking_type) {
        $responsedata = [];
        $url = $this->apiUrl() . "/fare_management/getusertaxdetail?user_id=".$user_id."&booking_type=".$booking_type;
        $resp = $this->get($url);
        $data = Json::decode($resp->getBody(), true);
        if($data['responsedata']['status']=='success'){
            $responsedata =  $data['responsedata']['data'];
        }
        return $responsedata;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-April-2020
     * @description : FUNCTION TO FETCH USER FARE SETTING DATA
     * @param $data
     * @returns $responsedata
     */
    
    public function getUserFareSetting($user_id) {
        $responsedata = [];
        $url = $this->apiUrl() . "/fare_management/getfaresettingdetail?user_id=".$user_id;
        $resp = $this->get($url);
        $data = Json::decode($resp->getBody(), true);
        if($data['responsedata']['status']=='success'){
            $responsedata =  $data['responsedata']['data'];
        }
        return $responsedata;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-April-2020
     * @description : FUNCTION TO FETCH USER NIGHT CHARGE DATA
     * @param $data
     * @returns $responsedata
     */
  
     public function getUserNightCharge($user_id, $booking_type) {
        $responsedata = [];
        $url = $this->apiUrl() . "/fare_management/getusernightcharge?user_id=".$user_id."&booking_type=".$booking_type;
        $resp = $this->get($url);
        $data = Json::decode($resp->getBody(), true);
        if($data['responsedata']['status']=='success'){
            $responsedata =  $data['responsedata']['data'];
        }
        return $responsedata;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-April-2020
     * @description : FUNCTION TO FETCH USER CANCELLATION FARE DATA
     * @param $data
     * @returns $responsedata
     */
    
    public function getUserCancellationFare($user_id, $booking_type) {
        $responsedata = [];
        $url = $this->apiUrl() . "/fare_management/getusercancellationfare?user_id=".$user_id."&booking_type=".$booking_type;
        $resp = $this->get($url);
        $data = Json::decode($resp->getBody(), true);
        if($data['responsedata']['status']=='success'){
            $responsedata =  $data['responsedata']['data'];
        }
        return $responsedata;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-April-2020
     * @description : FUNCTION TO FETCH USER WAITING CHARGE DATA
     * @param $data
     * @returns $responsedata
     */
    
    public function getUserWaitingCharge($user_id, $booking_type) {
            $responsedata = [];
            $url = $this->apiUrl() . "/fare_management/getuserwaitingcharge?user_id=".$user_id."&booking_type=".$booking_type;
            $resp = $this->get($url);
            $data = Json::decode($resp->getBody(), true);
            if($data['responsedata']['status']=='success'){
                $responsedata =  $data['responsedata']['data'];
            }
            return $responsedata;
        }
        
     /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-April-2020
     * @description : FUNCTION TO FETCH USER PRE WAITING CHARGE DATA
     * @param $data
     * @returns $responsedata
     */
    
    public function getUserPreWaitingCharge($user_id, $booking_type) {
        $responsedata = [];
        $url = $this->apiUrl() . "/fare_management/getuserprewaitingcharge?user_id=".$user_id."&booking_type=".$booking_type;
        $resp = $this->get($url);
        $data = Json::decode($resp->getBody(), true);
        if($data['responsedata']['status']=='success'){
            $responsedata =  $data['responsedata']['data'];
        }
        return $responsedata;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-April-2020
     * @description : FUNCTION TO FETCH USER PREMIUMS FARE DATA
     * @param $data
     * @returns $responsedata
     */
    
    public function getUserPremiumsFare($user_id, $booking_type) {
        $responsedata = [];
        $url = $this->apiUrl() . "/fare_management/getuserpremiumsfare?user_id=".$user_id."&booking_type=".$booking_type;
        $resp = $this->get($url);
        $data = Json::decode($resp->getBody(), true);
        if($data['responsedata']['status']=='success'){
            $responsedata =  $data['responsedata']['data'];
        }
        return $responsedata;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-April-2020
     * @description : FUNCTION TO FETCH USER POSTAL CODE DATA
     * @param $data
     * @returns $responsedata
     */
    
    
    public function getUserPostalCode($user_id, $booking_type) {
        $responsedata = [];
        $url = $this->apiUrl() . "/fare_management/getuserpostalcode?user_id=".$user_id."&booking_type=".$booking_type;
        $resp = $this->get($url);
        $data = Json::decode($resp->getBody(), true);
        if($data['responsedata']['status']=='success'){
            $responsedata =  $data['responsedata']['data'];
        }
        return $responsedata;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-April-2020
     * @description : FUNCTION TO FETCH USER FIX ROUTE DATA
     * @param $data
     * @returns $responsedata
     */
    
    public function getUserFixRoute($user_id, $booking_type) {
        $responsedata = [];
        $url = $this->apiUrl() . "/fare_management/getuserfixroute?user_id=".$user_id."&booking_type=".$booking_type;
        $resp = $this->get($url);
        $data = Json::decode($resp->getBody(), true);
        if($data['responsedata']['status']=='success'){
            $responsedata =  $data['responsedata']['data'];
        }
        return $responsedata;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-April-2020
     * @description : FUNCTION TO FETCH USER PEAK TIME CHARGE DATA
     * @param $data
     * @returns $responsedata
     */
    
     public function getUserPeaktimeCharge($user_id, $booking_type) {
        $responsedata = [];
        $url = $this->apiUrl() . "/fare_management/getuserpeaktimecharge?user_id=".$user_id."&booking_type=".$booking_type;
        $resp = $this->get($url);
        $data = Json::decode($resp->getBody(), true);
        if($data['responsedata']['status']=='success'){
            $responsedata =  $data['responsedata']['data'];
        }
        return $responsedata;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-April-2020
     * @description : FUNCTION TO FETCH USER EXTRAS CHARGE DATA
     * @param $data
     * @returns $responsedata
     */
    
    public function getUserExtrasCharge($user_id, $booking_type) {
        $responsedata = [];
        $url = $this->apiUrl() . "/fare_management/getuserextras?user_id=".$user_id."&booking_type=".$booking_type;
        $resp = $this->get($url);
        $data = Json::decode($resp->getBody(), true);
        if($data['responsedata']['status']=='success'){
            $responsedata =  $data['responsedata']['data'];
        }
        return $responsedata;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-April-2020
     * @description : FUNCTION TO FETCH USER COMPANY SHARE DATA
     * @param $data
     * @returns $responsedata
     */
    
    public function getUserCompanyShare($user_id, $booking_type) {
        $responsedata = [];
        $url = $this->apiUrl() . "/fare_management/getusercompanyshare?user_id=".$user_id."&booking_type=".$booking_type;
        $resp = $this->get($url);
        $data = Json::decode($resp->getBody(), true);
        if($data['responsedata']['status']=='success'){
            $responsedata =  $data['responsedata']['data'];
        }
        return $responsedata;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-April-2020
     * @description : FUNCTION TO ADD DISTANCE FARE DATA
     * @param $data
     * @returns $responsedata
     */
    
    public function addDistanceFare($dataArr){
        $url = $this->apiUrl() . "/distance_fares";
        $resp = $this->post($url, $dataArr);
        return $fareData = Json::decode($resp->getBody(), true);
    }  
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-April-2020
     * @description : FUNCTION TO ADD HOURLY FARE DATA
     * @param $data
     * @returns $responsedata
     */
    
    public function addHourlyFare($dataArr){
        $url = $this->apiUrl() . "/hourly-fare";
        $resp = $this->post($url, $dataArr);
        return $fareData = Json::decode($resp->getBody(), true);
    }  
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-April-2020
     * @description : FUNCTION TO ADD DISTANCE HOUR FARE DATA
     * @param $data
     * @returns $responsedata
     */
    
    public function addDistanceHourFare($dataArr){
        $url = $this->apiUrl() . "/distance-hour-fare";
        $resp = $this->post($url, $dataArr);
        return $fareData = Json::decode($resp->getBody(), true);
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-April-2020
     * @description : FUNCTION TO ADD DISTANCE WAITING FARE DATA
     * @param $data
     * @returns $responsedata
     */
    
    public function addDistanceWaitingFare($dataArr){
        $url = $this->apiUrl() . "/distance-waiting-fare";
        $resp = $this->post($url, $dataArr);
        return $fareData = Json::decode($resp->getBody(), true);
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-April-2020
     * @description : FUNCTION TO ADD LOCAL PACKAGE FARE DATA
     * @param $data
     * @returns $responsedata
     */
    
    public function addLocalPackageFare($dataArr){
        $url = $this->apiUrl() . "/local-package-fare";
        $resp = $this->post($url, $dataArr);
        return $fareData = Json::decode($resp->getBody(), true);
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-April-2020
     * @description : FUNCTION TO ADD NIGHT FARE DATA
     * @param $data
     * @returns $responsedata
     */
    
    public function addNightFare($dataArr){
        $url = $this->apiUrl() . "/night-charge";
        $resp = $this->post($url, $dataArr);
        return $fareData = Json::decode($resp->getBody(), true);
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-April-2020
     * @description : FUNCTION TO ADD BASIC TAX DATA
     * @param $data
     * @returns $responsedata
     */
    
    public function addBasicTax($dataArr){
        $url = $this->apiUrl() . "/tax";
        $resp = $this->post($url, $dataArr);
        return $fareData = Json::decode($resp->getBody(), true);
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-April-2020
     * @description : FUNCTION TO ADD CANCELLATION FARE DATA
     * @param $data
     * @returns $responsedata
     */
    
    public function addCancellationFare($dataArr){
        $url = $this->apiUrl() . "/cancellation-fare";
        $resp = $this->post($url, $dataArr);
        return $fareData = Json::decode($resp->getBody(), true);
    }
    
    /** @Created_By : Mohit verma
     *  @Created_Date : 30-May-2020    
     *  @param type 
     *  @return type
     *  @description : Add Waiting charge
     */
    public function addWaitingCharge($dataArr){
         $url = $this->apiUrl() . "/waiting-charge";
         $resp = $this->post($url, $dataArr);
         return $fareData = Json::decode($resp->getBody(), true);        
    } 
    
     /** @Created_By  : Mohit verma
     *  @Created_Date : 30-May-2020    
     *  @param type   : Arr Object
     *  @return type  : Json  
     *  @description  : Add Waiting charge
     */
    public function addPreWaitingCharge($dataArr){
         $url = $this->apiUrl() . "/pre-waiting-charge";
         $resp = $this->post($url, $dataArr);
         return $fareData = Json::decode($resp->getBody(), true);        
    } 
    
}