<?php

/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

namespace Dashboard\Model;

use Application\Controller\RestAPIClientController;
use Zend\Session\Container;
use Zend\View\Model\{
    JsonModel
};
use Zend\Json\Json;

class Bid extends RestAPIClientController {

    public function apiUrl() {
        $config = new \Zend\Config\Config(include BASE_PATH . '/config/autoload/global.php');
        return $config->api->url;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-May-2022
     * @description : FUNCTION TO FETCH BID LISTING
     * @param $data
     * @returns $responsedata
     */

    public function bidlisting($data) {
        $url = $this->apiUrl() . "/bidding/getBidding";
        //echo $url; die;
        //$data = [];
        $resp = $this->post($url, $data);
        $cityJsonData = Json::decode($resp->getBody(), true);
        return $cityJsonData;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-May-2022
     * @description : FUNCTION TO FETCH THE CITY LIST
     * @param $data
     * @returns $responsedata
     */

    public function cityList($postdata) {
        $term = $postdata['term'];
        $val = '{"where": {"name": {"like": "' . $term . '%"}},"limit":10}';
        $val = rawurlencode($val);
        $url = $this->apiUrl() . "/city?&filter=" . $val;
        $resp = $this->get($url);
        $cityJsonData = Json::decode($resp->getBody(), true);
        return $cityJsonData;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-May-2022
     * @description : FUNCTION TO CALCULATE KILOMETER
     * @param $data
     * @returns $responsedata
     */

    public function kiloMeter($postdata) {
        $cityData = [];
        $data = [];
        $source_name = '';
        $destination_name = '';
        $source_id = 0;
        $destination_id = 0;

        $source_name = $postdata['source_name'];
        $destination_name = $postdata['destination_name'];
        $source_id = $postdata['source_id'];
        $destination_id = $postdata['destination_id'];
        if (!empty($source_id) && !empty($destination_id)) {
            $url = $this->apiUrl() . "/city-distance-list/citykilometer?sourcecity=" . $source_id . "&destinationcity=" . $destination_id;
            $resp = $this->get($url);
            $cityData = Json::decode($resp->getBody(), true);
            if ($cityData['status'] == 'success') {
                $cityJsonData = $cityData['data'];
            } else {
                $data = $this->fetchGoogleApiDistance($source_name, $destination_name);
                $data = Json::decode($data, true);
                if ($data['status'] == 'OK') {
                    $distance = round(($data['rows'][0]['elements'][0]['distance']['value'] / 1000));
                    if (!empty($distance)) {
                        $distancedetail = [];
                        $distancedetail = [
                            'source_city' => $source_id,
                            'destination_city' => $destination_id,
                            'distance_km' => $distance
                        ];
                        $url = $this->apiUrl() . "/city-distance-list";
                        $resp = $this->post($url, $distancedetail);
                        $cityDistanceJsonData = Json::decode($resp->getBody(), true);
                        if (!empty($cityDistanceJsonData)) {
                            $url = $this->apiUrl() . "/city-distance-list/citykilometer?sourcecity=" . $source_id . "&destinationcity=" . $destination_id;
                            $resp = $this->get($url);
                            $cityData = Json::decode($resp->getBody(), true);
                            $cityJsonData = $cityData['data'];
                        }
                    }
                }
            }
        }
        return $cityJsonData;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-May-2022
     * @description : FUNCTION TO FETCH THE DISTANCE USING GOOGLE API DATA
     * @param $data
     * @returns $responsedata
     */

    public function fetchGoogleApiDistance($source_name, $destination_name) {
        $config = new \Zend\Config\Config(include BASE_PATH . '/config/autoload/global.php');
        $source_name = str_replace(' ', '+', $source_name);
        $destination_name = str_replace(' ', '+', $destination_name);
        $url = $config->google_map->cityDistUrl . "&origins=" . $source_name . "&destinations=" . $destination_name . "&key=" . $config->google_map->key;
        $curl_handle = curl_init();
        curl_setopt($curl_handle, CURLOPT_URL, $url);
        curl_setopt($curl_handle, CURLOPT_CONNECTTIMEOUT, 10);
        curl_setopt($curl_handle, CURLOPT_RETURNTRANSFER, 1);
        $result = curl_exec($curl_handle);
        $result = curl_exec($curl_handle);
        //echo '<pre>';print_r($result);die();
        if ($result === FALSE) {
            die('Curl failed: ' . curl_error($curl_handle));
        }
        curl_close($curl_handle);
        return $result;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-May-2022
     * @description : FUNCTION TO INSERT THE BID DATA
     * @param $data
     * @returns $responsedata
     */

    public function insertBidInfo($postdata) {

        if ($postdata != '') {
            $url = $this->apiUrl() . "/bidding/addbidding";
            $resp = $this->post($url, $postdata);
            $vehicleTypeJsonData = Json::decode($resp->getBody(), true);
        } else {
            $vehicleTypeJsonData = "";
        }

        return $vehicleTypeJsonData;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-May-2022
     * @description : FUNCTION TO FETCH BIDDING DATA
     * @param $data
     * @returns $responsedata
     */

    public function getBidInfo($data) {
        $url = $this->apiUrl() . "/bidding/getBidding";
        $resp = $this->post($url, $data);
        $response = Json::decode($resp->getBody(), true);
        return $response;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-May-2022
     * @description : FUNCTION TO UPDATE THE BID DATA
     * @param $data
     * @returns $responsedata
     */

    public function updateBidInfo($postdata) {
        if ($postdata != '') {
            $url = $this->apiUrl() . "/bidding/updateBidding";
            $resp = $this->post($url, $postdata);
            $vehicleTypeJsonData = Json::decode($resp->getBody(), true);
        } else {
            $vehicleTypeJsonData = "";
        }

        return $vehicleTypeJsonData;
    }

    /* Comment by mohitverma - Not in Used(6-sep-19)
     * public function getBiddingData($data) {
      $url = $this->apiUrl() . "/bidding/biddingListSearch";
      $resp = $this->post($url, $data);
      $biddingList = Json::decode($resp->getBody(), true);
      $result = [];
      if ($biddingList['responsedata']['status'] == 'success') {
      $result = $biddingList['responsedata']['data'];
      }
      return $result;
      } */

    public function bidStatusUpdation($data) {
        $url = $this->apiUrl() . "/bidding/deleteBidding";
        $resp = $this->post($url, $data);
        $biddingList = Json::decode($resp->getBody(), true);
        $result = [];
        if ($biddingList['responsedata']['status'] == 'success') {
            $result = $biddingList['responsedata']['data'];
        }
        return $result;
    }

}
