<?php

namespace Dashboard\Form;

use Zend\Form\Form;

use Zend\Form\Element\{
    Select,
    File,
    Text,
    Radio,
    Submit,
    Checkbox,
    Email,
    Textarea,
    Date,
    Hidden
};
use Zend\Validator\{
    NotEmpty
};


class WatermarkBaseForm extends Form {

    public static $backround_transparency =[];
    public static $pos_water_mark =[];
    public static $icon_alignment=[];
    public static $vertical_alignment=[];
    public static $jpeg_quality=[];
    public static $text_alignment=[];

    public function __construct($name = null) {

        parent::__construct('watermark-form');

        $this->setAttribute('method', 'post');

         /**
         *
         * Setting the height of the watermark
         */
        $this->add([
            'name' => 'background_color',
            'type' => Text::class,
            'attributes' => [
                'id' => 'background_color-id',
                'placeholder' => '',
                'class' => 'span3',

            ],
            'options' => [
                'label' => 'Setting the height of the watermark <span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         *
         * Setting the background transparency
         */
        $this->add([
            'name' => 'background_transparency',
            'type' => Select::class,
            'attributes' => [
                'id' => 'background_transparency-id',
                'placeholder' => '80',
                'class' => 'form-control'
            ],
            'options' => [
                'label' => 'Setting the background transparency',
                'value_options' => self::$backround_transparency
            ],
        ]);

        /**
         *
         * Setting the height of the watermark
         */
        $this->add([
            'name' => 'watermark_height',
            'type' => Text::class,
            'attributes' => [
                'id' => 'watermark_height',
                'placeholder' => '100',
                'class' => 'form-control',

            ],
            'options' => [
                'label' => 'Setting the height of the watermark <span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         *
         * Setting the position of the watermark
         */
        $this->add([
            'name' => 'watermark_position',
            'type' => Select::class,
            'attributes' => [
                'id' => 'water-position-id',
                'placeholder' => 'bottom',
                'class' => 'form-control'
            ],
            'options' => [
                'label' => 'Setting the position of the watermark',
                'value_options' => self::$pos_water_mark
            ],
        ]);

        /**
         *
         * Watermark Icon Files
         */
        $this->add([
            'name' => 'icon_file',
            'type' => Text::class,
            'attributes' => [
                'id' => 'watermark-icon-file-id',
                'placeholder' => 'reg.png',
                'class' => 'form-control',

            ],
            'options' => [
                'label' => 'Watermark Icon Files<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         *
         * Set Max height percentage
         */
        $this->add([
            'name' => 'max_height_per',
            'type' => Text::class,
            'attributes' => [
                'id' => 'max-height-percentage-id',
                'placeholder' => '150',
                'class' => 'form-control',

            ],
            'options' => [
                'label' => 'Set Max height percentage',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         *
         * Setting the icons alignment
         */
        $this->add([
            'name' => 'icon_alignment',
            'type' => Select::class,
            'attributes' => [
                'id' => 'icon-alignment-id',
                'placeholder' => 'bottom',
                'class' => 'form-control'
            ],
            'options' => [
                'label' => 'Setting the icons alignment',
                'value_options' => self::$icon_alignment
            ],
        ]);

        /**
         *
         * Setting the icons vertical alignment
         */
        $this->add([
            'name' => 'icon_vertical_alignment',
            'type' => Select::class,
            'attributes' => [
                'id' => 'icon-vertical-alignment-id',
                'placeholder' => 'bottom',
                'class' => 'form-control'
            ],
            'options' => [
                'label' => 'Setting the icons vertical alignment',
                'value_options' => self::$vertical_alignment
            ],
        ]);
        /**
         *
         *Setting the icons offset X
         */

        $this->add([
            'name' => 'icon_offset_X',
            'type' => Text::class,
            'attributes' => [
                'id' => 'icon-offset-x-id',
                'placeholder' => '50',
                'class' => 'form-control',

            ],
            'options' => [
                'label' => 'Setting the icons offset X',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         *
         * Setting the icons offset Y
         */
        $this->add([
            'name' => 'icon_offset_Y',
            'type' => Text::class,
            'attributes' => [
                'id' => 'icon-offset-y-id',
                'placeholder' => '50',
                'class' => 'form-control',

            ],
            'options' => [
                'label' => 'Setting the icons offset Y ',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         *
         * Setting the spacing between icons
         */
        $this->add([
            'name' => 'icon_space',
            'type' => Text::class,
            'attributes' => [
                'id' => 'icon-space-id',
                'placeholder' => '50',
                'class' => 'form-control',

            ],
            'options' => [
                'label' => 'Setting the spacing between icons',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         *
         * Setting the JPEG quality
         */
        $this->add([
            'name' => 'jpeg_quality',
            'type' => Select::class,
            'attributes' => [
                'id' => 'jpeg-quality-id',
                'placeholder' => 'bottom',
                'class' => 'form-control'
            ],
            'options' => [
                'label' => 'Setting the JPEG quality',
                'value_options' => self::$jpeg_quality
            ],
        ]);


        /**
         *
         * Watermark Text
         */
        $this->add([
            'name' => 'watermark_text',
            'type' => Text::class,
            'attributes' => [
                'id' => 'watermark-text-id',
                'placeholder' => '50',
                'class' => 'form-control',

            ],
            'options' => [
                'label' => 'Watermark Text',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        /**
         *
         * Setting the text alignment
         */

        $this->add([
            'name' => 'text_alignment',
            'type' => Select::class,
            'attributes' => [
                'id' => 'text-alignment-id',
                'placeholder' => 'bottom',
                'class' => 'form-control'
            ],
            'options' => [
                'label' => 'Setting the text alignment ',
                'value_options' => self::$text_alignment
            ],
        ]);

        /**
         *
         * Setting the text offset X
         */
        $this->add([
            'name' => 'text_offset_X',
            'type' => Text::class,
            'attributes' => [
                'id' => 'text-offset-x-id',
                'placeholder' => '50',
                'class' => 'form-control',

            ],
            'options' => [
                'label' => 'Setting the text offset X',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         *
         * Setting the text offset Y
         */
        $this->add([
            'name' => 'text_offset_Y',
            'type' => Text::class,
            'attributes' => [
                'id' => 'text-offset-y-id',
                'placeholder' => '50',
                'class' => 'form-control ',

            ],
            'options' => [
                'label' => 'Setting the text offset Y',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         *
         * setting the spacing between texts
         */
        $this->add([
            'name' => 'text_spacing',
            'type' => Text::class,
            'attributes' => [
                'id' => 'spacing-between-text-id',
                'placeholder' => '50',
                'class' => 'form-control ',

            ],
            'options' => [
                'label' => 'Setting the spacing between texts',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         *
         * Setting the font directory
         */
        $this->add([
            'name' => 'font_direction',
            'type' => Text::class,
            'attributes' => [
                'id' => 'font-directory-id',
                'placeholder' => '50',
                'class' => 'form-control',

            ],
            'options' => [
                'label' => 'Setting the font directory',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         *
         * Setting the font
         */
        $this->add([
            'name' => 'font_setting',
            'type' => Text::class,
            'attributes' => [
                'id' => 'set-font-id',
                'placeholder' => '50',
                'class' => 'form-control',

            ],
            'options' => [
                'label' => 'Setting the font',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         *
         * Setting the font size
         */
        $this->add([
            'name' => 'font_size',
            'type' => Text::class,
            'attributes' => [
                'id' => 'font-size-id',
                'placeholder' => '50',
                'class' => 'form-control ',

            ],
            'options' => [
                'label' => 'Setting the font size ',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        /**
         *
         * Setting the font size
         */
        $this->add([
            'name' => 'font_color',
            'type' => Text::class,
            'attributes' => [
                'id' => 'font-size-id',
                'placeholder' => '50',
                'class' => 'form-control ',

            ],
            'options' => [
                'label' => 'Setting the font color ',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);


        /**
         *
         * button System Backup
         */
         $this->add([
            'name' => 'system_backup',
            'type' => Submit::class,
            'attributes' => [
                'id' => 'system-backup-id',
                'placeholder' => 'System Backup',
                'class' => 'btn btn-info',
            ],

        ]);

         /**
         *
         * button Restore
         */
          $this->add([
            'name' => 'restore',
            'type' => Submit::class,
            'attributes' => [
                'id' => 'restore-id',
                'placeholder' => 'Restore',
                'class' => 'btn btn-danger',
            ],

        ]);


         /**
         *
         * button reset
         */
          $this->add([
            'name' => 'reset',
            'type' => Submit::class,
            'attributes' => [
                'id' => 'reset-id',
                'placeholder' => 'reset',
                'class' => 'btn btn-success',
            ],

        ]);

        /**
         *
         * save
         */
        $this->add([
            'name' => 'save',
            'type' => Submit::class,
            'attributes' => [
                'id' => 'site-config-save-btn',
                'placeholder' => 'Save',
                'class' => 'save_data_btn btn btn-primary btn-warning pull-right margin-L-1',
                'Value' => 'Save',
                'onclick' => "submitForm('#watermark-form', event);"
            ],
        ]);


    }

}
