<?php

namespace Dashboard\Form;

use Zend\Form\Form;
use Zend\Form\Element\{
    Select,
    File,
    Text,
    Textarea,
    Radio,
    Submit,
    Checkbox,
    Email,
    Hidden
};

use Zend\Validator\{
    NotEmpty,
    Digits
};

use Zend\InputFilter\InputFilterProviderInterface;

class VehicleTypeForm extends Form implements InputFilterProviderInterface {

    public static $vehicletype = [];

    public function __construct($name = null) {

        parent::__construct('cab-type-search-type');

        $this->setAttribute('method', 'post');

         /**
         *
         * status
         */
        $this->add([
            'name' => 'status',
            'type' => Radio::class,
            'attributes' => [
                'id' => 'active',
            ],
            'options' => [
                'label' => '<span class="radio">Active</span>',
                'label_options' => ['disable_html_escape' => true],
                'value_options' => array(
                '1' => 'Active',
                '0' => 'In-Active',
            ),
            ],
        ]);

        /**
         *
         * vehicle type
         */
        $this->add([
            'name' => 'vehicle_type',
            'type' => Select::class,
            'attributes' => [
                'id' => 'vehicle-type-id',
                'placeholder' => '',
                'class' => 'input form-control '
            ],
            'options' => [
                'label' => 'Vehicle Type',
                'value_options' => self::$vehicletype,
                'empty_option' => 'Select Vehicle Type',
            ],
        ]);

        /**
         *
         * vehicle type_name
         */
        $this->add([
            'name' => 'vehicle_type_name',
            'type' => Text::class,
            'attributes' => [
                'id' => 'vehicle-type-name',
                'placeholder' => '',
                'class' => 'input form-control '
            ],
            'options' => [
                'label' => 'Vehicle Type',
            ],
        ]);


        /**
         *
         *
         */
        $this->add([
            'name' => 'seating_capacity',
            'type' => Text::class,
            'attributes' => [
                'id' => 'seating-capacity',
                'placeholder' => '',
                'class' => 'input form-control '
            ],
            'options' => [
                'label' => 'Seating Capacity',
            ],
        ]);

        /**
         *
         * Baggage
         */
        $this->add([
            'name' => 'luggage',
            'type' => Text::class,
            'attributes' => [
                'id' => 'luggage',
                'placeholder' => '',
                'class' => 'input form-control '
            ],
            'options' => [
                'label' => 'Luggage Capacity',
            ],
        ]);
        
        /**
         *
         * Color
         */
        $this->add([
            'name' => 'color',
            'type' => Text::class,
            'attributes' => [
                'id' => 'color',
                'placeholder' => '',
                'class' => 'input form-control '
            ],
            'options' => [
                'label' => 'Color',
            ],
        ]);

        /**
         *
         * Vehicle Image
         */
        $this->add([
            'name' => 'vehicle_image',
            'type' => File::class,
            'attributes' => [
                'id' => 'vehicle-image',
                'class' => 'form-control'
            ],
            'options' => [
                 'label' => 'Vehicle Image',
                'label_options' => ['disable_html_escape' => true]
            ]
        ]);


        /**
         *
         * vehicle type_name
         */
        $this->add([
            'name' => 'vehicle_type_id',
            'type' => Hidden::class,
            'attributes' => [
                'id' => 'vehicle-type-id',
                'placeholder' => '',
                'class' => 'input form-control '
            ],
            'options' => [
                'label' => 'Vehicle Type',
            ],
        ]);




        /**
         *
         * Search Button
         */
        $this->add([
            'name' => 'search_vehicle_type',
            'type' => Submit::class,
            'attributes' => [
                'id' => 'search-vehicle-type',
                'placeholder' => 'Search',
                'class' => 'btn btn-red defaultbtnsearch btn-warning',
                'value' => 'Search'
            ],
        ]);


        $this->add([
            'name' => 'add_vehicle_type',
            'type' => Submit::class,
            'attributes' => [
                'id' => 'addvehicle-type',
                'placeholder' => 'Add Vehicle',
                'class' => 'btn btn-red defaultbtnsearch btn-warning',
                'value' => 'Save'
            ],
        ]);

        $this->add([
            'name' => 'edit_vehicle_type',
            'type' => Submit::class,
            'attributes' => [
                'id' => 'editvehicle-type',
                'placeholder' => 'Add Vehicle',
                'class' => 'btn btn-red defaultbtnsearch btn-warning',
                'value' => 'Save'
            ],
        ]);

        $this->add([
            'name' => 'clear_button',
            'type' => Submit::class,
            'attributes' => [
                'id' => 'clear-button-id',
                'placeholder' => 'Submit',
                'class' => 'btn btn-red btn-warning',
                'value' => 'Clear'
            ],
        ]);
    }

    public function getInputFilterSpecification() {
        return [
            'vehicle_type_name' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please enter Vehicle Type'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'vehicle_type' => [
                'required' => false,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please enter Vehicle Type'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'seating_capacity' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please enter seating capacity'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'luggage' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please enter luggage capacity'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'color' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please enter color'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'vehicle_image' => [
                'required' => false,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please enter Vehicle Image'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],






        ];
    }

}
