<?php

namespace Dashboard\Form;

use Zend\Form\Form;
use Zend\Form\Element\{
    Select,
    File,
    Text,
    Radio,
    Submit,
    Checkbox,
    Email,
    Hidden,
    Button
};
use Zend\Validator\{
    NotEmpty,
    Digits,
    EmailAddress,
    StringLength
};
use Zend\InputFilter\InputFilterProviderInterface;
class VehicleNameForm extends Form implements InputFilterProviderInterface {

    public static $vehicletype = [];
    public static $vehiclename = [];

    public function __construct($name = null) {

        parent::__construct('cab-type-search-name');

        $this->setAttribute('method', 'post');



        /**
         *
         * vehicle type
         */
        $this->add([
            'name' => 'vehicle_type',
            'type' => Select::class,
            'attributes' => [
                'id' => 'vehicle-type-id',
                'placeholder' => '',
                'class' => 'input form-control '
            ],
            'options' => [
                'label' => 'Vehicle Type',
                'value_options' => self::$vehicletype,
                'empty_option' => 'Select Vehicle Type',
                'disable_inarray_validator' => true,
            ],
        ]);
        /**
         *
         * vehicle name
         */
        $this->add([
            'name' => 'vehicle_name',
            'type' => Select::class,
            'attributes' => [
                'id' => 'vehicle-name-id',
                'placeholder' => '',
                'class' => 'input form-control'
            ],
            'options' => [
                'label' => 'Vehicle Name',
                'value_options' => self::$vehiclename,
                'empty_option' => 'Select Vehicle Name',
                'disable_inarray_validator' => false
            ],
        ]);

        /**
         *
         * vehicle type_name
         */
        $this->add([
            'name' => 'vehicle_model_name',
            'type' => Text::class,
            'attributes' => [
                'id' => 'vehicle-model-name',
                'placeholder' => '',
                'class' => 'input form-control ',
            ],
            'options' => [
                'label' => 'Vehicle Name',
                
            ],
        ]);

        /**
         *
         * vehicle type_name
         */
        $this->add([
            'name' => 'vehicle_model_id',
            'type' => Hidden::class,
            'attributes' => [
                'id' => 'vehicle-model-id',
                'placeholder' => '',
                'class' => 'input form-control '
            ],
            'options' => [
                'label' => 'Vehicle Type',
            ],
        ]);


        /**
         *
         * Search Button
         */
        $this->add([
            'name' => 'search_vehicle_name',
            'type' => Submit::class,
            'attributes' => [
                'id' => 'search-vehicle-name',
                'placeholder' => 'Search',
                'class' => 'btn btn-red defaultbtnsearch btn-warning',
                'value' => 'Search'
            ],
        ]);


        $this->add([
            'name' => 'add_vehicle_name',
            'type' => Submit::class,
            'attributes' => [
                'id' => 'addvehicle-name',
                'placeholder' => 'Add Vehicle',
                'class' => 'btn btn-red defaultbtnsearch btn-warning',
                'value' => 'Add Vehicle'
            ],
        ]);

        $this->add([
            'name' => 'edit_vehicle_name',
            'type' => Submit::class,
            'attributes' => [
                'id' => 'editvehicle-name',
                'placeholder' => 'Add Vehicle',
                'class' => 'btn btn-red defaultbtnsearch btn-warning',
                'value' => 'Edit Vehicle'
            ],
        ]);



        $this->add([
            'name' => 'clear_button',
            //'type' => Submit::class,
            'options' => [
            'label' => '<i class="icon icon-foo"></i> Submit',
            'label_options' => [
                'disable_html_escape' => true,
            ]
            ],
            'attributes' => [
                'id' => 'clear-button-id',
                'placeholder' => 'Submit',
                'class' => 'btn btn-red btn-warning',
                'value' => 'Clear'
            ],
        ]);
    }
    
     public function getInputFilterSpecification() {
        return [
            'vehicle_type' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Select Vehicle Type'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ], 
            'vehicle_model_name' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Provide Vehicle Name'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
                
            ],
            
            'vehicle_name' => [
                'required' => false,
            ]
            
            ];
     }

}
