<?php

namespace Dashboard\Form;

use Zend\Form\Form;
use Zend\Form\Element\{
    Select,
    File,
    Date,
    Text,
    Radio,
    Checkbox,
    Email,
    Textarea,
    Submit,
    Hidden
};
use Zend\Validator\{
    NotEmpty,
    Digits,
    StringLength
};
use Zend\InputFilter\InputFilterProviderInterface;

class VehicleDetailAddNewcabForm extends Form implements InputFilterProviderInterface {

    public static $cabType = [];
    public static $ignitionType = [];
    public static $vehicleColor = [];
    public static $amenities = [];
    public static $modelYear = [];


    public function __construct($name = null) {

        parent::__construct('vehicle-detail-add-new-cab');
        $this->setAttribute('method', 'post');

        /**
         *
         * cab Types
         */
        $this->add([
            'name' => 'vehicle_type',
            'type' => Select::class,
            'attributes' => [
                'id' => 'vehicle-type',
                'class' => 'form-control inputchange'
            ],
            'options' => [
                'label' => 'Vehicle Type<span style="color: red"> *</span>',
                'empty_option' => 'Select',
                'value_options' => self::$cabType,
                'label_options' => ['disable_html_escape' => true],
                'disable_inarray_validator' => true,
            ],
        ]);

        /**
         * Name of vehicle
         */
        $this->add([
            'name' => 'vehicle_name',
            'type' => Text::class,
            'attributes' => [
                'id' => 'vehicle-name',
                'placeholder' => 'Vehicle Name',
                'class' => 'form-control inputchange',
                'onkeypress' => "return isAlphaNumber(event)"
            ],
            'options' => [
                'label' => 'Vehicle Name<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        $this->add([
            'name' => 'vehicle_model_id',
            'type' => Hidden::class,
            'attributes' => [
                'id' => 'vehicle-model-id',
                'class' => 'inputMaterial'
            ]
        ]);

        /**
         * Ignition Type
         */
        $this->add([
            'name' => 'ignition_type',
            'type' => Select::class,
            'attributes' => [
                'id' => 'ignition-type',
                'placeholder' => 'Select Ignition Types',
                'class' => 'form-control inputchange'
            ],
            'options' => [
                'label' => 'Ignition Type<span style="color: red"> *</span>',
                'empty_option' => 'Select',
                'value_options' => self::$ignitionType,
                'label_options' => ['disable_html_escape' => true],
                'disable_inarray_validator' => true,
            ],
        ]);

        /**
         * Vehicle Color
         */


        $this->add([
            'name' => 'vehicle_color',
            'type' => Select::class,
            'attributes' => [
                'id' => 'vehicle-color',
                'class' => 'form-control',
                'placeholder' => 'color'
            ],
            'options' => [
                'label' => 'Vehicle Color<span style="color: red"> *</span>',
                'empty_option' => 'Select',
                'value_options' => self::$vehicleColor,
                'label_options' => ['disable_html_escape' => true],
                'disable_inarray_validator' => true,
            ],
        ]);

        /**
         * RC Proof
         */
        $this->add([
            'name' => 'rc_proof',
            'type' => File::class,
            'attributes' => [
                'id' => 'rc-proof',
                'class' => 'form-control inputchange common-upload-file',
                 'data-level-name' => 'rc_proof',
            ],
            'options' => [
                'label' => 'RC Proof<span style="color: red"> </span>',
                'label_options' => ['disable_html_escape' => true]
            ]
        ]);
        
         /**
         * RC Proof
         */
        $this->add([
            'name' => 'front_image',
            'type' => File::class,
            'attributes' => [
                'id' => 'front-image',
                'class' => 'form-control inputchange common-upload-file',
                 'data-level-name' => 'front_image',
            ],
            'options' => [
                'label' => 'Front Side Vehicle Image<span style="color: red"> </span>',
                'label_options' => ['disable_html_escape' => true]
            ]
        ]);
         /**
         * RC Proof
         */
        $this->add([
            'name' => 'back_image',
            'type' => File::class,
            'attributes' => [
                'id' => 'back-image',
                'class' => 'form-control inputchange common-upload-file',
                 'data-level-name' => 'back_image',
            ],
            'options' => [
                'label' => 'Back Side Vehicle Image<span style="color: red"> </span>',
                'label_options' => ['disable_html_escape' => true]
            ]
        ]);
       
         /**
         * RC Proof
         */
        $this->add([
            'name' => 'left_side_image',
            'type' => File::class,
            'attributes' => [
                'id' => 'left-side-image',
                'class' => 'form-control inputchange common-upload-file',
                 'data-level-name' => 'left_side_image',
            ],
            'options' => [
                'label' => 'Left Side Vehicle Image<span style="color: red"> </span>',
                'label_options' => ['disable_html_escape' => true]
            ]
        ]);
         /**
         * RC Proof
         */
        $this->add([
            'name' => 'right_side_image',
            'type' => File::class,
            'attributes' => [
                'id' => 'right-side-image',
                'class' => 'form-control inputchange common-upload-file',
                 'data-level-name' => 'right_side_image',
            ],
            'options' => [
                'label' => 'Right Side Vehicle Image<span style="color: red"> </span>',
                'label_options' => ['disable_html_escape' => true]
            ]
        ]);
        
          /**
         * RC Proof
         */
        $this->add([
            'name' => 'inside_image',
            'type' => File::class,
            'attributes' => [
                'id' => 'rc-proof',
                'class' => 'form-control inputchange common-upload-file',
                 'data-level-name' => 'inside_image',
            ],
            'options' => [
                'label' => 'Inside Vehicle Image<span style="color: red"> </span>',
                'label_options' => ['disable_html_escape' => true]
            ]
        ]);

        /**
         * Owner Name
         */
        $this->add([
            'name' => 'owner_name',
            'type' => text::class,
            'attributes' => [
                'id' => 'owner-name',
                'class' => 'form-control',
                'maxlength'=>60,
                'onkeypress' => "return isAlphaNumber(event)"
            ],
            'options' => [
                'label' => 'Vehicle Owner<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         * Mobile No
         */
        $this->add([
            'name' => 'mobile_number',
            'type' => text::class,
            'attributes' => [
                'id' => 'mobile-number',
                'class' => 'form-control',
                'onkeypress' => "return isNumber(event)",
                'maxlength'=>12
            ],
            'options' => [
                'label' => 'Mobile No.<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         * Permit Expiry date
         */
        $this->add([
            'name' => 'permit_expiry_date',
            'type' => text::class,
            'attributes' => [
                'id' => 'permit-expiry-date',
                'class' => 'form-control datepicker',
                'placeholder' => 'dd/mm/yyyy',
                'readonly'=>'readonly'
            ],
            'options' => [
                'label' => 'Permit Expiry Date<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         * Insurance Validity
         */
        $this->add([
            'name' => 'insurance_validity',
            'type' => text::class,
            'attributes' => [
                'id' => 'insurance-validity',
                'class' => 'form-control datepicker',
                'placeholder' => 'dd/mm/yyyy',
                'readonly'=>'readonly'
            ],
            'options' => [
                'label' => 'Insurance Validity<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         * Model Year
         */
        $this->add([
            'name' => 'model_year',
            'type' => Select::class,
            'attributes' => [
                'id' => 'model-year',
                'placeholder' => 'Select Model Year',
                'class' => 'form-control inputchange'
            ],
            'options' => [
                'label' => 'Model Year<span style="color: red"> *</span>',
                'empty_option' => 'Select',
                'value_options' => self::$modelYear,
                'label_options' => ['disable_html_escape' => true],
                'disable_inarray_validator' => true,
            ],
        ]);

        /**
         * Vehicle No
         */
        $this->add([
            'name' => 'vehicle_number',
            'type' => text::class,
            'attributes' => [
                'id' => 'vehicle-number',
                'class' => 'form-control',
                'placeholder' => 'DL-9898',
                'maxlength'=>60,
                'onkeypress'=>'return isAlphaNumber(event)'
            ],
            'options' => [
                'label' => 'Vehicle No<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         * passengers
         */
        $this->add([
            'name' => 'passengers',
            'type' => text::class,
            'attributes' => [
                'id' => 'passengers',
                'class' => 'form-control',
                'placeholder' => '3+2',
                'onkeypress' => "return isNumber(event)",
                'maxlength'=>2
            ],
            'options' => [
                'label' => 'Passengers<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         * Large suitcase
         */
        $this->add([
            'name' => 'large_suitcase',
            'type' => text::class,
            'attributes' => [
                'id' => 'large-suitcase',
                'class' => 'form-control',
                'placeholder' => '2',
                'onkeypress' => "return isNumber(event)",
                'maxlength'=>2
            ],
            'options' => [
                'label' => 'Large Suitcase<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         * Small suitcase
         */
        $this->add([
            'name' => 'small_suitcase',
            'type' => text::class,
            'attributes' => [
                'id' => 'small-suitcase',
                'class' => 'form-control',
                'placeholder' => '2',
                'onkeypress' => "return isNumber(event)",
                'maxlength'=>2
            ],
            'options' => [
                'label' => 'Small Suitcase<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         * Duty Type
         */
        $this->add([
            'name' => 'vehicle_amenities',
            'type' => Select::class,
            'attributes' => [
                'id' => 'vehicle-amenities',
                'class' => 'demo-default select-state selectized form-control',
                'multiple' => 'multiple',
            ],
            'options' => [
                'label' => 'Amenities<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true],
                'empty_option' => '',
                'value_options' => self::$amenities,
            ],
        ]);

        /**
         * reset
         */
        $this->add([
            'name' => 'reset',
            'type' => Submit::class,
            'attributes' => [
                'value' => 'reset',
                'id' => 'reset',
                'class' => 'btn-new-vehicle'
            ],
        ]);

        /**
         * Save...
         */
        $this->add([
            'name' => 'add_new_vehicle',
            'type' => Submit::class,
            'attributes' => [
                'value' => 'Save',
                'id' => 'add-new-vehicle',
                'class' => 'save_data_btn btn btn-primary btn-new-vehile btn-warning'
            ]
        ]);

        /**
         * Pickup Now Selected
         */
        $this->add([
            'name' => 'vehicle_owned_selected',
            'type' => Hidden::class,
            'attributes' => [
                'id' => 'vehicle-owned-selected',
                'class' => 'inputMaterial'
            ]
        ]);

        /**
         * Pickup Later Selected
         */
        $this->add([
            'name' => 'vehicle_attach_selected',
            'type' => Hidden::class,
            'attributes' => [
                'id' => 'vehicle-attach_selected',
                'class' => 'inputMaterial'
            ]
        ]);

        /**
         * Pickup Later Selected
         */
        $this->add([
            'name' => 'id',
            'type' => Hidden::class,
        ]);
    }

    public function getInputFilterSpecification() {
        return [
            'vehicle_type' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Select Vehicle Type'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'vehicle_name' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Enter Vehicle Model'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'ignition_type' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Select Ignition Type'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'vehicle_color' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Select Vehicle Color'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'owner_name' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Enter Owner Name'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'mobile_number' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Enter Mobile No.'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ],
                    ['name' => 'Digits',
                        'options' => [
                            'messages' => [
                                Digits::NOT_DIGITS => 'Enter Numeric value only',
                            ],
                        ],
                        'break_chain_on_failure' => true,
                    ],
                    ['name' => 'StringLength',
                        'options' => [
                            'min' => 10,
                            'max' => 10,
                            'messages' => [
                                StringLength::TOO_LONG => 'Enter Less than 10 Digits',
                                StringLength::TOO_SHORT => 'Enter Greater than 9 Digits',
                            ],
                        ],
                        'break_chain_on_failure' => true
                    ],
                ]
            ],

            'permit_expiry_date' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Enter Permit Expiry Date'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'insurance_validity' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Enter Insurance Validity'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],

            'model_year' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Select Model Year'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'vehicle_number' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Enter Vehicle No.'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'passengers' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Enter value'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ],
                    ['name' => 'Digits',
                        'options' => [
                            'messages' => [
                                Digits::NOT_DIGITS => 'Enter Numeric value only',
                            ],
                        ],
                        'break_chain_on_failure' => true,
                    ],
                ]
            ],
            'large_suitcase' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Enter value'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ],
                    ['name' => 'Digits',
                        'options' => [
                            'messages' => [
                                Digits::NOT_DIGITS => 'Enter Numeric value only',
                            ],
                        ],
                        'break_chain_on_failure' => true,
                    ],
                ]
            ],
            'small_suitcase' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Enter value'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ],
                    ['name' => 'Digits',
                        'options' => [
                            'messages' => [
                                Digits::NOT_DIGITS => 'Enter Numeric value only',
                            ],
                        ],
                        'break_chain_on_failure' => true,
                    ],
                ]
            ],
            'vehicle_amenities' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Select Amenities'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
        ];
    }

}
