<?php

namespace Dashboard\Form;

use Zend\InputFilter\InputFilter;
use Zend\Validator\Digits;
use Zend\Validator\StringLength;
use Zend\Validator\NotEmpty;
use Zend\Validator\EmailAddress;
use Zend\Validator\Date;

class UserPersonalManagementFormFilter extends InputFilter {
    
    public function __construct() {

        /**
         * First Name...
         */
        $this->add([
            'name' => 'first_name',
            'required' => true,
            'filters' => [
                ['name' => 'StripTags'],
                ['name' => 'StringTrim']
            ],
            'validators' => [
                [   'name' => 'NotEmpty',
                    'options' => [
                        'messages' => [
                            NotEmpty::IS_EMPTY => 'Please enter First Name'
                        ]
                    ],
                    'break_chain_on_failure' => true
                ]
            ]
        ]);

        /**
         * Last Name...
         */
        $this->add([
            'name' => 'last_name',
            'required' => true,
            'filters' => [
                ['name' => 'StripTags'],
                ['name' => 'StringTrim']
            ],
            'validators' => [
                [   'name' => 'NotEmpty',
                    'options' => [
                        'messages' => [
                            NotEmpty::IS_EMPTY => 'Please enter Last Name'
                        ]
                    ],
                    'break_chain_on_failure' => true
                ]
            ]
        ]);
        
        /**
         * Father Name...
         */
        $this->add([
            'name' => 'father_name',
            'required' => true,
            'filters' => [
                ['name' => 'StripTags'],
                ['name' => 'StringTrim']
            ],
            'validators' => [
                [   'name' => 'NotEmpty',
                    'options' => [
                        'messages' => [
                            NotEmpty::IS_EMPTY => 'Please enter Father Name'
                        ]
                    ],
                    'break_chain_on_failure' => true
                ]
            ]
        ]);

        /**
         * Mobile No
         */
        $this->add([
            'name' => 'mobile_number',
            'required' => true,
            'filters' => [
                ['name' => 'StripTags'],
                ['name' => 'StringTrim']
            ],
            'validators' => [
                [   'name' => 'NotEmpty',
                    'options' => [
                        'messages' => [
                            NotEmpty::IS_EMPTY => 'Please enter Mobile No.'
                        ]
                    ],
                    'break_chain_on_failure' => true
                ],
                [   'name' => 'Digits',
                    'options' => [
                        'messages' => [
                            Digits::NOT_DIGITS => 'Please enter Numeric value only',
                        ],
                    ],
                    'break_chain_on_failure' => true,
                ],
                [   'name' => 'StringLength',
                    'options' => [
                        'min' => 10,
                        'max' => 10,
                        'messages' => [
                            StringLength::TOO_LONG => 'Please enter Less than 10 Digits',
                            StringLength::TOO_SHORT => 'Please enter greater than 9 Digits',
                        ],
                    ],
                    'break_chain_on_failure' => true
                ],
            ]
        ]);

        /**
         * Date Of Birth
         */
        $this->add([
            'name' => 'dob',
            'required' => TRUE,
            'filters' => [
                ['name' => 'StripTags'],
                ['name' => 'StringTrim']
            ],
            'validators' => [
                [   'name' => 'NotEmpty',
                    'options' => [
                        'messages' => [
                            NotEmpty::IS_EMPTY => 'Please enter Date Of Birth'
                        ]
                    ],

                ],
                [   'name' => 'Date',
                    'options' => [
                        'messages' => [
                            Date::INVALID_DATE => '',
                        ],
                    ],
                    'break_chain_on_failure' => true
                ],
            ]
        ]);
        
        /**
         * Gender...
         */
        $this->add([
            'name' => 'gender',
            'required' => true,
            'filters' => [
                ['name' => 'StripTags'],
                ['name' => 'StringTrim']
            ],
            'validators' => [
                [   'name' => 'NotEmpty',
                    'options' => [
                        'messages' => [
                            NotEmpty::IS_EMPTY => 'Please enter Gender'
                        ]
                    ],
                    'break_chain_on_failure' => true
                ]
            ]
        ]);

        /**
         * Address...
         */
        $this->add([
            'name' => 'address',
            'required' => true,
            'filters' => [
                ['name' => 'StripTags'],
                ['name' => 'StringTrim']
            ],
            'validators' => [
                [   'name' => 'NotEmpty',
                    'options' => [
                        'messages' => [
                            NotEmpty::IS_EMPTY => 'Please enter Residential Address'
                        ]
                    ],
                    'break_chain_on_failure' => true
                ]
            ]
        ]);        
        
        /**
         *  State
         */
        $this->add([
            'name' => 'state_name',
            'required' => true,
            'filters' => [
                ['name' => 'StripTags'],
                ['name' => 'StringTrim']
            ],
            'validators' => [
                [   'name' => 'NotEmpty',
                    'options' => [
                        'messages' => [
                            NotEmpty::IS_EMPTY => 'Please select State'
                        ]
                    ],
                    'break_chain_on_failure' => true
                ]
            ]
        ]);
        
        /**
         * City
         */
        $this->add([
            'name' => 'city_name',
            'required' => true,
            'filters' => [
                ['name' => 'StripTags'],
                ['name' => 'StringTrim']
            ],
            'validators' => [
                [   'name' => 'NotEmpty',
                    'options' => [
                        'messages' => [
                            NotEmpty::IS_EMPTY => 'Please Select City'
                        ]
                    ],
                    'break_chain_on_failure' => true
                ]
            ]
        ]);
        
        /**
         * Kyc Code
         */
        $this->add([
            'name' => 'kyc',
            'required' => true,
            'filters' => [
                ['name' => 'StripTags'],
                ['name' => 'StringTrim']
            ],
            'validators' => [
                [   'name' => 'NotEmpty',
                    'options' => [
                        'messages' => [
                            NotEmpty::IS_EMPTY => 'Please enter KYC Code'
                        ]
                    ],
                    'break_chain_on_failure' => true
                ]
            ]
        ]);
        
        /**
         * Kyc Upload
         */
        $this->add([
            'name' => 'kyc_upload',
            'required' => TRUE,
            'filters' => [
                ['name' => 'StripTags'],
                ['name' => 'StringTrim']
            ],
            'validators' => [                
                [   'name' => 'NotEmpty',
                    'options' => [
                        'messages' => [
                            NotEmpty::IS_EMPTY => 'File was not uploaded'
                        ]
                    ],
                    'break_chain_on_failure' => true
                ], 
                ['name'    => 'FileUploadFile'],
                [
                    'name'    => 'FileMimeType',                        
                    'options' => [                       
                        'mimeType'  => ['image/gif', 'image/png', 'image/jpg', 'image/jpeg']
                    ],
                    'break_chain_on_failure' => true
                ],
                ['name'    => 'FileIsImage'],
                [
                        'name'    => 'FileImageSize',                        
                        'options' => [                            
                            'minWidth'  => 128,
                            'minHeight' => 128,
                            'maxWidth'  => 4096,
                            'maxHeight' => 4096
                        ]
                ],     
            ]
        ]);
        
        /**
         * Pincode...
         */
        $this->add([
            'name' => 'pincode',
            'required' => true,
            'filters' => [
                ['name' => 'StripTags'],
                ['name' => 'StringTrim']
            ],
            'validators' => [
                [   'name' => 'NotEmpty',
                    'options' => [
                        'messages' => [
                            NotEmpty::IS_EMPTY => 'Please enter Pincode'
                        ]
                    ],
                    'break_chain_on_failure' => true
                ]
            ]
        ]);
        
        /**
         * Company Name...
         */
        $this->add([
            'name' => 'company_name',
            'required' => true,
            'filters' => [
                ['name' => 'StripTags'],
                ['name' => 'StringTrim']
            ],
            'validators' => [
                [   'name' => 'NotEmpty',
                    'options' => [
                        'messages' => [
                            NotEmpty::IS_EMPTY => 'Please enter Company Name'
                        ]
                    ],
                    'break_chain_on_failure' => true
                ]
            ]
        ]);
        
    }

}
