<?php

namespace Dashboard\Form;

use Zend\Form\Form;
use Zend\Form\Element\{
    Select,
    File,
    Text,
    Radio,
    Submit,
    Checkbox,
    Email,
    Hidden,
    Date
};
use Zend\Validator\{
    NotEmpty,
    Digits
};
use Zend\InputFilter\InputFilterProviderInterface;

class UserAddBasicForm extends Form implements InputFilterProviderInterface {

    public static $booking_type = [];
    public static $booking_module = [];

    public function __construct($name = null) {

        parent::__construct('basic-fare');

        $this->setAttribute('method', 'post');

        /**
         *
         * Basic tax
         */
        $this->add([
            'name' => 'sgst',
            'type' => Text::class,
            'attributes' => [
                'id' => 'sgst',
                'placeholder' => '5',
                'class' => 'form-control',
                'maxlength' => 5,
                'onkeypress' => "return isNumberDecimal(event)"
            ],
            'options' => [
                'label' => 'SGST',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         *
         * krishi kalyan cess
         */
        $this->add([
            'name' => 'cgst',
            'type' => Text::class,
            'attributes' => [
                'id' => 'cgst',
                'placeholder' => '5',
                'class' => 'form-control',
                'maxlength' => 5,
                'onkeypress' => "return isNumberDecimal(event)"
            ],
            'options' => [
                'label' => 'CGST',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         *
         * swatch bharat cess
         */
        $this->add([
            'name' => 'igst',
            'type' => Text::class,
            'attributes' => [
                'id' => 'igst',
                'placeholder' => '5',
                'class' => 'form-control',
                'maxlength' => 5,
                'onkeypress' => "return isNumberDecimal(event)"
            ],
            'options' => [
                'label' => 'IGST',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         *
         * booking_type
         */
        $this->add([
            'name' => 'booking_module',
            'type' => Select::class,
            'attributes' => [
                'id' => 'booking-module',
                'placeholder' => '',
                'class' => 'form-control',
                //'data-show-subtext' => 'true',
                //'data-live-search' => 'true'
            ],
            'options' => [
                'label' => 'Booking Module',
                'value_options' => self::$booking_module,
                'disable_inarray_validator' => true,
                'empty_option' => '--Select Booking Module--',
            ],
        ]);
        
        /**
         *
         * booking_type
         */
        $this->add([
            'name' => 'booking_type',
            'type' => Select::class,
            'attributes' => [
                'id' => 'booking-type',
                'placeholder' => '',
                'class' => 'form-control',
                //'data-show-subtext' => 'true',
                //'data-live-search' => 'true'
            ],
            'options' => [
                'label' => 'Booking Type',
                'value_options' => self::$booking_type,
                'disable_inarray_validator' => true,
                'empty_option' => '--Select Booking Type--',
            ],
        ]);


        /**
         *
         * save
         */
        $this->add([
            'name' => 'save',
            'type' => Submit::class,
            'attributes' => [
                'id' => 'basic-fare-btn',
                'placeholder' => 'Save',
                'class' => 'btn btn-info form-control ',
                'Value' => 'Save & Next',
                'onclick' => "submitForm('#basic-fare', event);"
            ],
        ]);

        /**
         * Save
         */
        $this->add([
            'name' => 'tax_save',
            'type' => Submit::class,
            'attributes' => [
                'id' => 'tax-save',
                'value' => 'Save & Next',
                'placeholder' => 'Save',
                'class' => 'save_data_btn btn btn-primary btn-new-vehile profile_save btn-warning'
            ],
        ]);

        /**
         *
         * next
         */
        $this->add([
            'name' => 'next',
            'type' => Submit::class,
            'attributes' => [
                'id' => 'next-id',
                'placeholder' => 'Next',
                'class' => 'btn btn-info form-control margin-bottom10px',
                'value' => 'Next'
            ],
        ]);

        /**
         * Public Fare Selected
         */
        $this->add([
            'name' => 'tax_fare_id',
            'type' => Hidden::class,
          ]);

         $this->add([
            'name' => 'tax_fare_setting_id',
            'type' => Hidden::class,
          ]);


           /**
         * From Date
         */
        $this->add([
            'name' => 'tax_date_from',
            'type' => text::class,
            'attributes' => [
                'id' => 'tax-date-from',
                'readonly'=>true,
                'placeholder' => 'From Date',
                'class' => 'form-control datepicker'
            ],
            'options' => [
                'label' => 'From Date',
            ],
        ]);


        /**
         * To Date (datepicker)
         */
        $this->add([
            'name' => 'tax_date_to',
            'type' => text::class,
            'attributes' => [
                'id' => 'tax-date-to',
                'placeholder' => 'To Date',
                'readonly'=>true,
                'class' => 'form-control datepicker'
            ],
            'options' => [
                'label' => 'To Date',
            ],
        ]);
    }

    public function getInputFilterSpecification() {
        return [
            'sgst' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Enter SGST Tax'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'cgst' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Enter CGST Tax'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'igst' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Enter IGST Tax'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'tax_date_from' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Enter From Date'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'tax_date_to' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Enter To Date'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'booking_type' => [
                 'required' => true,
            'filters' => [
                ['name' => 'StripTags'],
                ['name' => 'StringTrim']
            ],
            'validators' => [
                [   'name' => 'NotEmpty',
                    'options' => [
                        'messages' => [
                            NotEmpty::IS_EMPTY => 'Select Booking Type'
                        ]
                    ],
                    'break_chain_on_failure' => true
                ]
            ]
            ],
            'booking_module' => [
                 'required' => false,
            'filters' => [
                ['name' => 'StripTags'],
                ['name' => 'StringTrim']
            ],
            'validators' => [
                [   'name' => 'NotEmpty',
                    'options' => [
                        'messages' => [
                            NotEmpty::IS_EMPTY => 'Select Booking Type'
                        ]
                    ],
                    'break_chain_on_failure' => true
                ]
            ]
            ],
        ];
    }

}
