<?php

namespace Dashboard\Form;

use Zend\Form\Form;
//use Zend\Form\Element;
//use Zend\Form\Element\Select;
//use Zend\Form\Element\Text;
//use Zend\Form\Element\Textarea;
//use Zend\Form\Element\Submit;

use Zend\Form\Element\{
    Select,
    Date,
    Number,
    Checkbox,
    Text,
    Submit,
    Hidden,
    Textarea
};
use Zend\Validator\{
    NotEmpty,
    Digits
};

use Zend\InputFilter\InputFilterProviderInterface;

class TourTypeAddForm extends Form implements InputFilterProviderInterface {    
   

    public function __construct($name = null) {

        parent::__construct('tour-type-add-form');
        
        /**         
         * 
         * Tour Type...
         */
        $this->add([
            'name' => 'tour_type',
             'type' => Text::class,
            'attributes' => [
                'id' => 'tour-type',  
                'placeholder' => 'Tour Type',
                'class' => 'form-control'
            ],
            'options' => [
                'label' => 'Tour Type<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        /**         
         * 
         * Meta Title...
         */
        $this->add([
            'name' => 'meta_title',
             'type' => Text::class,
            'attributes' => [
                'id' => 'meta-title',      
                'placeholder' => 'Meta Title',
                'class' => 'form-control'
            ],
            'options' => [
                'label' => 'Meta Title<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        /**         
         * 
         * Meta Keywords...
         */
        $this->add([
            'name' => 'meta_keyword',
             'type' => Text::class,
            'attributes' => [
                'id' => 'meta-keyword',   
                'placeholder' => 'Meta Keywords',
                'class' => 'form-control'
            ],
            'options' => [
                'label' => 'Meta Keywords<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        /**         
         * 
         * Meta Description...
         */
        $this->add([
            'name' => 'meta_description',
             'type' => Textarea::class,
            'attributes' => [
                'id' => 'meta-description', 
                'placeholder' => 'Meta Description',
                'class' => 'form-control'
            ],
            'options' => [
                'label' => 'Meta Description<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         * 
         * Save...
         */
        $this->add([
            'name' => 'submit',
            'type' => Submit::class,
            'attributes' => [
                'value' => 'Save',
                'id' => 'submit-button',
                'class' => 'save_data_btn btn btn-primary btn-warning',
               
            ],
        ]);  
        
        //validation here.....
       
    }
    
    
    public function getInputFilterSpecification() {
        return [
            'tour_type' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Kindly Provide Tour Type...'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'meta_title' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Kindly Provide Meta Title...'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'meta_keyword' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Kindly Provide Meta Keywords...'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'meta_description' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Kindly Provide Meta Decription...'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ]
          ];
    }

}
