<?php

namespace Dashboard\Form;

use Zend\Form\Form;
use Zend\Form\Element\{
    Select,
    Date,
    Number,
    Checkbox,
    Text,
    Radio,
    Submit,
    Hidden,
    Textarea,
    File
};
use Zend\Validator\{
    NotEmpty,
    Digits
};

use Zend\InputFilter\InputFilterProviderInterface;

class TestimonialForm extends Form implements InputFilterProviderInterface {    
   

    public function __construct($name = null) {

        parent::__construct('testimonial');
        
      
         /**
         *
         * status
         */
        $this->add([
            'name' => 'status',
            'type' => Radio::class,
            'attributes' => [
                'id' => 'active',
            ],
            'options' => [
                'label' => '<span class="radio">Active</span>',
                'label_options' => ['disable_html_escape' => true],
                'value_options' => array(
                '1' => 'Active',
                '0' => 'In-Active',
            ),
            ],
        ]);
        
        
       /**         
         * 
         *  Id...
         */
         $this->add([
            'name' => 'id',
            'type' => Hidden::class,
            'attributes' => [
                'id' => 'id',
                'class' => 'form-control',
            ],
        ]);
          /**         
         * 
         *  Description...
         */
         $this->add([
            'name' => 'description',
            'type' => Textarea::class,
            'attributes' => [
                'id' => 'description',
                'class' => 'form-control',
            ],
        ]);


        $this->add([
            'name' => 'add_info',
            'type' => Submit::class,
            'attributes' => [
                'id' => 'add-info',
                'placeholder' => 'Save',
                'class' => 'btn btn-red defaultbtnsearch btn-warning',
                'value' => 'Save'
            ],
        ]);
        
         $this->add([
            'name' => 'search',
            'type' => Submit::class,
            'attributes' => [
                'id' => 'search',
                'placeholder' => 'search',
                'class' => 'btn btn-red defaultbtnsearch btn-warning',
                'value' => 'Search'
            ],
        ]);

    }
  public function getInputFilterSpecification() {
        return [   
            
    
            'description' => [
               'required' => true,
               'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
               ],
                'validators' => [
                    ['name' => 'NotEmpty',
                       'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Provide Description'
                            ]
                       ],
                        'break_chain_on_failure' => true
                    ]
                ]
           ],
            
            ];
    

}
}

