<?php

namespace Dashboard\Form;

use Zend\Form\Form;
use Zend\Form\Element\{
    Select,
    File,
    Text,
    Radio,
    Submit,
    Checkbox,
    Email,
    Textarea,
    Hidden,
    Date
};

class StatementOfAccountForm extends Form {
    public static $bookingStatus = [];
    public static $bookingType =[];
    public static $vehicletype =[];

    public function __construct($name = null) {

        parent::__construct('statement-of-account-form');
        $this->setAttribute('method', 'post');

        /**
         *
         * Booking Reference
         */
        $this->add([
            'name' => 'booking_reference',
            'type' => Text::class,
            'attributes' => [
                'id' => 'booking-reference',
                'placeholder' => 'Booking Reference',
                'class' => 'form-control inputchange'
            ],
            'options' => [
                'label' => 'Booking Reference'
            ],
        ]);


        /**
         *
         * Agent Reference
         */
        $this->add([
            'name' => 'agent_reference',
            'type' => Text::class,
            'attributes' => [
                'id' => 'agent-reference',
                'placeholder' => 'Agent Reference',
                'class' => 'form-control inputchange'
            ],
            'options' => [
                'label' => 'Agent Reference'
            ],
        ]);

        /**
         *
         * Booked City
         */

        $this->add([
            'name' => 'city_search',
            'type' => \Zend\Form\Element\Textarea::class,
            'attributes' => [
                'id' => 'city-search',
                //'placeholder' => '',
                'class' => 'form-control',
                'class' => 'demo-default selectized form-control',
                'multiple' => 'multiple',
            ],
            'options' => [
                'label' => 'City'
            ],
        ]);

        $this->add([
            'name' => 'city_search_id',
            'type' => Hidden::class,
            'attributes' => [
                'id' => 'city-search-id',
                'class' => 'form-control',
            ],
        ]);

         /**
         * Booking Status
         */
        $this->add([
            'name' => 'booking_status',
            'type' => Select::class,
            'attributes' => [
                'id' => 'booking-status',
                'class' => 'selectpicker form-control country-select',
                'data-show-subtext' => 'true',
                'data-live-search' => 'true'
            ],
            'options' => [
                'label' => 'Booking Status',
                'value_options' => self::$bookingStatus,
                'empty_option' => 'Select',
            ]
        ]);

        /**
         *
         * Passenger First Name
         */
        $this->add([
            'name' => 'passenger_first_name',
            'type' => Text::class,
            'attributes' => [
                'id' => 'passenger-first-name',
                'placeholder' => 'First Name',
                'class' => 'form-control inputchange'
            ],
            'options' => [
                'label' => 'Passenger Name'
            ],
        ]);

        /**
         *
         * Passenger Last Name
         */
        $this->add([
            'name' => 'passenger_last_name',
            'type' => Text::class,
            'attributes' => [
                'id' => 'passenger-last-name',
                'placeholder' => 'last Name',
                'class' => 'form-control inputchange'
            ],
            'options' => [
                'label' => 'Passenger Name'
            ],
        ]);

        /**
         * Vehicle Tab start
         * Vehicle Type
         */
        $this->add([
            'name' => 'vehicle_type',
            'type' =>Select::class,
            'attributes' => [
                'id' => 'vehicle-type',
                'class' => 'demo-default select-state selectized form-control',
                'multiple' => 'multiple',
            ],
            'options' => [
                'label' => 'Vehicle Type<span style="color: red"> *</span>',
                'empty_option' => 'Select Vehicle Type',
                'value_options' => self::$vehicletype,
            ],
        ]);

        /**
         *
         * booking_type
         */
        $this->add([
            'name' => 'booking_type',
            'type' => Select::class,
            'attributes' => [
                'id' => 'booking-type',
                'placeholder' => '',
                'class' => 'demo-default select-state selectized form-control',
                'multiple' => 'multiple',
            ],
            'options' => [
                'label' => 'Booking Type',
                'value_options' => self::$bookingType,
                'disable_inarray_validator' => true,
                'empty_option' => '--Select Booking Type--',
            ],
        ]);

        /**
         * Initial Request Data Since
         */
        $this->add([
            'name' => 'from_date',
            'type' => Text::class,
            'attributes' => [
                'id' => 'from-date',
                'placeholder' => 'Since',
                'class' => 'form-control inputchange from'
            ],
            'options' => [
                'label' => 'Initial Request Data<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         * Initial Request Data To
         */
        $this->add([
            'name' => 'to_date',
            'type' => Text::class,
            'attributes' => [
                'id' => 'to-date',
                'placeholder' => 'To',
                'class' => 'form-control inputchange to'
            ]
        ]);


        /**
         * Search
         */
        $this->add([
            'name' => 'search',
            'type' => Submit::class,
            'attributes' => [
                'value' => 'Search',
                'id' => 'search',
                'class' => 'btn btn-primary btn-lg'
            ],
        ]);

        /**
         * Clear
         */
        $this->add([
            'name' => 'clear',
            'type' => Submit::class,
            'attributes' => [
                'value' => 'Clear',
                'id' => 'clear',
                'class' => 'btn btn-primary btn-lg'
            ],
        ]);
    }

}
