<?php

namespace Dashboard\Form;
use Zend\Form\Form;
use Zend\Form\Element\{
    Select,
    Date,
    Number,
    Checkbox,
    Text,
    Submit,
    Hidden,
    Textarea,
    File
};
use Zend\Validator\{
    NotEmpty,
    Digits
};

use Zend\InputFilter\InputFilterProviderInterface;

class SmsForm extends Form implements InputFilterProviderInterface {    
   

    public function __construct($name = null) {

        parent::__construct('mail-template');
        
        /**         
         * 
         *  Id...
         */
         $this->add([
            'name' => 'id',
            'type' => Hidden::class,
            'attributes' => [
                'id' => 'id',
                'class' => 'form-control'
            ],
        ]);
        
        /**         
         * 
         *  Message...
         */
         $this->add([
            'name' => 'message',
            'type' => Textarea::class,
            'attributes' => [
                'id' => 'message',
                'class' => 'form-control'
            ],
        ]);
         
         /**         
         * 
         *  Massage Type...
         */
         $this->add([
            'name' => 'msg_type',
            'type' => text::class,
            'attributes' => [
                'id' => 'msg-type',
                'class' => 'form-control'
            ],
        ]);
         
       
         
         /**         
         * 
         *  Massage Sku...
         */
         $this->add([
            'name' => 'msg_sku',
            'type' => Text::class,
            'attributes' => [
                'class' => 'form-control',
                'id' => 'msg-sku'
            ],
        ]);
         
        /**         
         * 
         *  Variables...
         */
         $this->add([
            'name' => 'variables',
            'type' => Textarea::class,
            'attributes' => [
                'class' => 'form-control',
                'id' => 'variables'
            ],
        ]);
         
          /**         
         * 
         *  Text Limit...
         */
         $this->add([
            'name' => 'text_limit',
            'type' => Number::class,
            'attributes' => [
                'id' => 'text-limit',
                'class' => 'form-control',
            ],
        ]);
        
       
 
         /**
         * 
         * Save...
         */
        $this->add([
            'name' => 'submit',
            'type' => Submit::class,
            'options' => [
            'label'   => '<i class="icon icon-foo"></i> Submit',
           // 'icon'    => '<i class="fa fa-save>',
            'disable_html_escape' => true,
    ],
            'attributes' => [
                'value' => 'Save',
                'id' => 'submit-button',
                'class' => 'btn btn-red defaultbtnsearch btn-warning',
            ],
           
            
        ]);   
        
        
        
    }
  public function getInputFilterSpecification() {
        return [   
            
            
             
            'message' => [
               'required' => true,
               'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
               ],
                'validators' => [
                    ['name' => 'NotEmpty',
                       'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => "Please Fill Message"
                            ]
                       ],
                        'break_chain_on_failure' => true
                    ]
                ]
           ],
            
            'msg_type' => [
               'required' => true,
               'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
               ],
                'validators' => [
                    ['name' => 'NotEmpty',
                       'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => "Please Fill Message Type"
                            ]
                       ],
                        'break_chain_on_failure' => true
                    ]
                ]
           ],
            'msg_sku' => [
               'required' => true,
               'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
               ],
                'validators' => [
                    ['name' => 'NotEmpty',
                       'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => "Please Fill Message SKU Name"
                            ]
                       ],
                        'break_chain_on_failure' => true
                    ]
                ]
           ],
            'variables' => [
               'required' => true,
               'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
               ],
                'validators' => [
                    ['name' => 'NotEmpty',
                       'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => "Please Fill Variables Name"
                            ]
                       ],
                        'break_chain_on_failure' => true
                    ]
                ]
           ],
            'text_limit' => [
               'required' => true,
               'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
               ],
                'validators' => [
                    ['name' => 'NotEmpty',
                       'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => "Please Provide Text Limit"
                            ]
                       ],
                        'break_chain_on_failure' => true
                    ]
                ]
           ],
           
            
            ];
    

}
}
