<?php

namespace Dashboard\Form;
use Zend\Form\Form;
use Zend\Form\Element\{
    Textarea,
    Submit,
    Hidden
};
use Zend\Validator\{
    NotEmpty
};
use Zend\InputFilter\InputFilterProviderInterface;

class SignatureForm extends Form implements InputFilterProviderInterface {

    public function __construct($name = null) {
        parent::__construct('signature-form');
        /**
         * User Id
         */
        $this->add([
            'name' => 'user_id',
            'type' => Hidden::class,
            'attributes' => [
                'id' => 'user-id',
                'class' => 'form-control'
            ],
        ]);
        /**
         * Signature
         */
        $this->add([
            'name' => 'signature',
            'type' => Textarea::class,
            'attributes' => [
                'id' => 'signature',
                'placeholder' => 'Content',
                'class' => 'form-control editor'
            ],
            'options' => [
                'label' => 'Signature<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        $this->add([
            'name' => 'submit',
            'type' => Submit::class,
            'attributes' => [
                'id' => 'add-staff-form-btn',
                'class' => 'btn btn-info',
                'value' => 'Submit'
            ],
        ]);
    }

    public function getInputFilterSpecification() {
        return [
            'signature' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please enter Signature'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ]
        ];
    }
}
