<?php
namespace Dashboard\Form;

use Zend\Form\Form;
use Zend\Form\Element\{
    Select,
    File,
    Text,
    Date,
    Radio,
    Submit,
    Checkbox,
    Email,
    Hidden,
    Textarea
};
use Zend\Validator\{
    NotEmpty,
    Digits,
    EmailAddress,
    StringLength
};
use Zend\InputFilter\InputFilterProviderInterface;

class SightseeingTermConditionForm extends Form implements InputFilterProviderInterface {
    public static $country = [];
    public static $state = [];
    public static $city = [];
    public static $payment_structure = [];
    public static $documentation = [];
    public static $cancellation_policy = [];
    public static $refund_policy = [];
    public static $term_policy = [];
    public static $sightseeing_list = [];
    

    public function __construct($name = null) {

        parent::__construct('sightseeing-meta-tag-form');
        
          $this->setAttribute('method', 'post');
          
        /**
         * Sightseeing Name
         */
        
        /**
         * Sightseeing Name
         */
        $this->add([
            'name' => 'sightseeing_name',
            'type' => Select::class,
            'attributes' => [
                'id' => 'sightseeing-name',
                'class' => 'form-control',
                'disable_inarray_validator' => true
            ],
            'options' => [
                'label' => 'Sightseeing Name <span style="color: red"> *</span>',
                'disable_inarray_validator' => true,
                'label_options' => ['disable_html_escape' => true],
                'empty_option' => '--Select Name--',
                'value_options' => self::$sightseeing_list
            ],
        ]);
        
        /**
         * Vendor Name
         */
        
        $this->add([
            'name' => 'vendor_name',
            'type' => Select::class,
            'attributes' => [
                'id' => 'vendor-name',
                'placeholder' => 'Vendor Name',
                'class' => 'form-control inputchange'
            ],
            'options' => [
                'label' => 'Vendor Name<span style="color: red">*</span>',
                'label_options' => ['disable_html_escape' => true],
                'disable_inarray_validator' => true,
                'empty_option' => '--Select Vendor--',
                'value_options' => [
                    'Vendor Name1',
                    'Vendor Name2',
                    'Vendor Name3'
                ]
            ],
        ]);
      
        /**
         * Tours Highlight
         */
        
        $this->add([
            'name' => 'tours_highlight',
            'type' => Text::class,
            'attributes' => [
                'id' => 'tours-highlight',
                'placeholder' => 'Tours highlight',
                'class' => 'form-control inputchange'
            ],
            'options' => [
                'label' => 'Tours Highlight<span style="color: red">*</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        /**
         *
         * City
         */

        $this->add([
            'name' => 'city_search',
            'type' => Text::class,
            'attributes' => [
                'id' => 'city-search',
                //'placeholder' => '',
                'class' => 'form-control',
                'class' => 'demo-default selectized form-control',
                'multiple' => 'multiple',
            ],
            'options' => [
                'label' => 'City'
            ],
        ]);

        $this->add([
            'name' => 'city_search_id',
            'type' => Hidden::class,
            'attributes' => [
                'id' => 'city-search-id',
                'class' => 'form-control',
            ],
        ]);
        
       /**
         * 
         * Payment Structure
         */
        $this->add([
            'name' => 'payment_structure_id',
            'type' => Select::class,
            'attributes' => [
                'id' => 'payment-structure-id',
                'placeholder' => '',
                'class' => 'selectpicker form-control',
                'data-show-subtext' => 'true',
                'data-live-search' => 'true'
            ],
            'options' => [
                'label' => 'Payment Structure<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true],
                'value_options' => self::$payment_structure,
                'disable_inarray_validator' => true,
                'empty_option' => '--Payment Structure--',
            ],
        ]);
        
        /**
         * 
         * Payment Structure Content
         */
        $this->add([
            'name' => 'payment_structure_content',
            'text' => Textarea::class,
            'attributes' => [
                'id' => 'payment-structure-content',
                'class' => 'form-control editor'
            ],
            'options' => [
                'label' => 'Content<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);        
        

        /**
         * 
         * Document Structure
         */
        $this->add([
            'name' => 'document_id',
            'type' => Select::class,
            'attributes' => [
                'id' => 'document-id',
                'placeholder' => '',
                'class' => 'selectpicker form-control',
                'data-show-subtext' => 'true',
                'data-live-search' => 'true'
            ],
            'options' => [
                'label' => 'Documentation<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true],
                'value_options' => self::$documentation,
                'disable_inarray_validator' => true,
                'empty_option' => '--Documentation--',
            ],
        ]);
        
        /**
         * 
         * Documentation Content
         */
        $this->add([
            'name' => 'documentation_content',
            'text' => Textarea::class,
            'attributes' => [
                'id' => 'documentation-content',
                'class' => 'form-control editor'
            ],
            'options' => [
                'label' => 'Content<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);        
        /**
         * 
         * Cancellation Policy
         */
        $this->add([
            'name' => 'cancellation_policy',
            'type' => Select::class,
            'attributes' => [
                'id' => 'cancellation-policy',
                'placeholder' => '',
                'class' => 'selectpicker form-control',
                'data-show-subtext' => 'true',
                'data-live-search' => 'true'
            ],
            'options' => [
                'label' => 'Cancellation Policy<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true],
                'value_options' => self::$cancellation_policy,
                'disable_inarray_validator' => true,
                'empty_option' => '--Cancellation Policy--',
            ],
        ]);
        
        /**
         * 
         * Cancellation Policy Content
         */
        $this->add([
            'name' => 'cancellation_policy_content',
            'text' => Textarea::class,
            'attributes' => [
                'id' => 'cancellation-policy-content',
                'class' => 'form-control editor'
            ],
            'options' => [
                'label' => 'Content<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);      
        
        /**
         * 
         * Refund Policy
         */
        $this->add([
            'name' => 'refund_policy',
            'type' => Select::class,
            'attributes' => [
                'id' => 'refund-policy',
                'placeholder' => '',
                'class' => 'selectpicker form-control',
                'data-show-subtext' => 'true',
                'data-live-search' => 'true'
            ],
            'options' => [
                'label' => 'Refund Policy<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true],
                'value_options' => self::$refund_policy,
                'disable_inarray_validator' => true,
                'empty_option' => '--Refund Policy--',
            ],
        ]);
        
        /**
         * 
         * Refund Policy Content
         */
        $this->add([
            'name' => 'refund_policy_content',
            'text' => Textarea::class,
            'attributes' => [
                'id' => 'refund-policy-content',
                'class' => 'form-control editor'
            ],
            'options' => [
                'label' => 'Content<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);     
        
        /**
         * 
         * Term Policy
         */
        $this->add([
            'name' => 'term_policy',
            'type' => Select::class,
            'attributes' => [
                'id' => 'term-policy',
                'placeholder' => '',
                'class' => 'selectpicker form-control',
                'data-show-subtext' => 'true',
                'data-live-search' => 'true'
            ],
            'options' => [
                'label' => 'Term Policy<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true],
                'value_options' => self::$term_policy,
                'disable_inarray_validator' => true,
                'empty_option' => '--Term Policy--',
            ],
        ]);
        
        /**
         * 
         * Term Policy Content
         */
        $this->add([
            'name' => 'term_policy_content',
            'text' => Textarea::class,
            'attributes' => [
                'id' => 'term-policy-content',
                'class' => 'form-control editor'
            ],
            'options' => [
                'label' => 'Content<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);     
        
         /**
         * Cost Inclusive
         */
        $this->add([
            'name' => 'cost_inclusive',
            'type' => Textarea::class,
            'attributes' => [
                'id' => 'cost-inclusive',
                'placeholder' => 'Cost inclusive',
                'class' => 'form-control editor'
            ],
            'options' => [
                'label' => 'Cost Inclusive <span style="color: red">*</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
         /**
         * Cost Exclusive
         */
        $this->add([
            'name' => 'cost_exclusive',
            'type' => Textarea::class,
            'attributes' => [
                'id' => 'cost-exclusive',
                'placeholder' => 'Cost exclusive',
                'class' => 'form-control editor'
            ],
            'options' => [
                'label' => 'Cost Exclusive <span style="color: red">*</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        /**
         *  Submit
         */
        
        $this->add([
            'name' => 'submit',
            'type' => Submit::class,
            'attributes' => [
                'id' => 'save',
                'placeholder' => 'save',
                'class' => 'btn btn-red defaultbtnsearch btn-warning',
                'value' => 'Save'
            ],
        ]);
        
        $this->add([
            'name' => 'id',
            'type' => Hidden::class,
            'attributes' => [
                'id' => 'id'
            ],
        ]);
    }
    public function getInputFilterSpecification() {
        return [
            'sightseeing_name' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Select Sightseeing Name'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],  
            
            'vendor_name' => [
                'required' => false,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Select Vendor Name'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],  
            
            'city_search' => [
                'required' => false,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Select City'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ], 
             'payment_structure_content' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Enter Payment Structure Content'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'documentation_content' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Enter Documentation Content'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'cancellation_policy_content' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Enter Cancellation Policy Content'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'refund_policy_content' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Enter Refund Policy Content'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'term_policy_content' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Enter Term Policy Content'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'payment_structure_id' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Select Payment Structure'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],  
            
            'document_id' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Select Payment Documentation'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],  
            
            'cancellation_policy' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Select Cancellation Policy'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],  
            
            'refund_policy' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Select Refund Policy'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],  
            
            'term_policy' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Select Term condition'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],  
            
            ];
    }

}
