<?php
namespace Dashboard\Form;

use Zend\Form\Form;
use Zend\Form\Element\{
    Select,
    File,
    Text,
    Date,
    Radio,
    Submit,
    Checkbox,
    Email,
    Hidden,
    Textarea,
    MultiCheckbox
};
use Zend\Validator\{
    NotEmpty,
    Digits,
    EmailAddress,
    StringLength
};
use Zend\InputFilter\InputFilterProviderInterface;

class SightseeingRateForm extends Form implements InputFilterProviderInterface {
  
    public static $vendors= [];
    public static $currency= [];
    public static $languages= [];
    public static $sightseeing_list = [];
    public static $mealPlanList= [];
    public static $weekDaysList= [];

    public function __construct($name = null) {

        parent::__construct('rate-form');
        
          $this->setAttribute('method', 'post');
      
        /**
         * Sightseeing Name
         */
        
        /**
         * Sightseeing Name
         */
        $this->add([
            'name' => 'sightseeing_name',
            'type' => Select::class,
            'attributes' => [
                'id' => 'sightseeing-name',
                'class' => 'form-control',
                'disable_inarray_validator' => true
            ],
            'options' => [
                'label' => 'Sightseeing Name <span style="color: red"> *</span>',
                'disable_inarray_validator' => true,
                'label_options' => ['disable_html_escape' => true],
                'empty_option' => '--Select Name--',
                'value_options' => self::$sightseeing_list
            ],
        ]);

  
        /**
         * 
         *  Vendor Name 

         */
         $this->add([
            'name' => 'vendor_name',
            'type' => Select::class,
            'attributes' => [
                'id' => 'vendor-name',
                'placeholder' => 'Vendor name',
                'class' => 'form-control'
            ],
            'options' => [
                'label' => 'Vendor name <span style="color: red"> *</span>',
                'disable_inarray_validator' => true,
                'label_options' => ['disable_html_escape' => true],
                'empty_option' => '--Select Vendor--',
                'value_options' =>self::$vendors
            ],
        ]);
         
        /**         
         * MEAL PLAN List
         */
        $this->add([
            'name' => 'meal_plan_id',
            'type' => Select::class,
            'attributes' => [
                'id' => 'meal-plan-id',
                'class' => 'demo-default input-tags selectized form-control',
                'multiple' => 'multiple',
            ],
            'options' => [
                'label' => 'Meal Plan<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true],
                'empty_option' => '--Select Meal Plan--',
                'value_options' =>self::$mealPlanList
            ],
        ]);
        
        
         /**         
         * WEEK DAYS List
         */
        $this->add([
            'name' => 'weekdays',
            'type' => Select::class,
            'attributes' => [
                'id' => 'weekdays',
                'class' => 'demo-default select-state selectized form-control',
                'multiple' => 'multiple',
            ],
            'options' => [
                'label' => 'WeekDays<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true],
                'empty_option' => '--Select Week Days--',
                'value_options' =>self::$weekDaysList
            ],
        ]);   
        
         /**
         * Week Calendar
         */
        $this->add([
            'name' => 'weekend[]',
        'type' => Checkbox::class,
            'required' => false,
            'attributes' => [
                'id' => 'weekend',
                'checked' => 'checked',
                'class' => 'form-control inputchange case'
            ],
            'options' => [
                'label' => 'Week Calendar ',
                'disable_inarray_validator' => true,
                'checked_value' => '1',
                'unchecked_value' => 'no',
                'use_hidden_element' => false
            ],
        ]);
        
        
         /**
         * 
         *  Currency 

         */
         $this->add([
            'name' => 'currency[]',
            'type' => Select::class,
            'attributes' => [
                'id' => 'currency',
                'placeholder' => 'Currency',
                'class' => 'form-control'
            ],
            'options' => [
                'label' => 'Currency',
                 'disable_inarray_validator' => true,
                'label_options' => ['disable_html_escape' => true],
                'empty_option' => '--Currency--',
                'value_options' =>self::$currency
            ],
        ]);
         
         /**
         * Adult
         */
        
        $this->add([
            'name' => 'adult[]',
            'type' => Text::class,
            'attributes' => [
                'id' => 'adult',
                'placeholder' => 'Adult',
                'class' => 'form-control inputchange',
                'onkeypress'=>"return isNumber(event)"
            ],
            'options' => [
                'label' => 'Adult <span style="color: red">*</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        /**
         * Child
         */
        
        $this->add([
            'name' => 'child[]',
            'type' => Text::class,
            'attributes' => [
                'id' => 'child',
                'placeholder' => 'Child',
                'class' => 'form-control inputchange',
                'onkeypress'=>"return isNumber(event)"
            ],
            'options' => [
                'label' => 'Child <span style="color: red">*</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        /**
         * Infant
         */
        
        $this->add([
            'name' => 'infant[]',
            'type' => Text::class,
            'attributes' => [
                'id' => 'infant',
                'placeholder' => 'Infant',
                'class' => 'form-control inputchange',
                'onkeypress'=>"return isNumber(event)"
            ],
            'options' => [
                'label' => 'infant <span style="color: red">*</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        /**
         * Senior Citizen
         */
        
        $this->add([
            'name' => 'senior_citizen[]',
            'type' => Text::class,
            'attributes' => [
                'id' => 'senior-citizen',
                'placeholder' => 'Senior citizen',
                'class' => 'form-control inputchange',
                'onkeypress'=>"return isNumber(event)"
            ],
            'options' => [
                'label' => 'Senior citizen <span style="color: red">*</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
         /**
         * 
         * Operating time From
         */
        $this->add([
            'name' => 'operating_time_from',
             'type' => Text::class,
            'attributes' => [
                'id' => 'operating-time-from',                 
                'class' => 'form-control clockpicker',
                'placeholder' =>'HH:MM:SS'
            ],
            'options' => [
                'label' =>'From <span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
         /**
         * 
         * Operating Time To
         */
        $this->add([
            'name' => 'operating_time_to',
             'type' => Text::class,
            'attributes' => [
                'id' => 'operating-time-to',                 
                'class' => 'form-control clockpicker',
                'placeholder' =>'HH:MM:SS'
            ],
            'options' => [
                'label' => 'To <span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
         /**
         * 
         * Duration
         */
        $this->add([
            'name' => 'duration',
             'type' => Text::class,
            'attributes' => [
                'id' => 'duration',                 
                'class' => 'form-control clockpicker',
                'placeholder' =>'HH:MM:SS'
            ],
            'options' => [
                'label' => 'Duration <span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
         /**
         * 
         * Difficulty Level

         */
         $this->add([
            'name' => 'difficulty_level',
            'type' => Select::class,
            'attributes' => [
                'id' => 'difficulty-level',
                'placeholder' => 'Difficulty level',
                'class' => 'form-control'
            ],
            'options' => [
                'label' => 'Difficulty level <span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true],
                'empty_option' => '--Select Level--',
                'value_options' =>[
                             '0' => 'Difficult',
                             '1' => 'Easy',
                             '2' => 'Hard',
                             '3' => 'Moderate',
                     ]
            ],
        ]);
        
       /**
         * From Date
         */
        $this->add([
            'name' => 'valid_from',
            'type' => text::class,
            'attributes' => [
                'id' => 'fare-date-from',
                'placeholder' => 'From Date',
                'class' => 'form-control'
            ],
            'options' => [
                'label' => 'From Date',
            ],
        ]);


        /**
         * To Date 
         */
        $this->add([
            'name' => 'valid_to',
            'type' => text::class,
            'attributes' => [
                'id' => 'fare-date-to',
                'placeholder' => 'To Date',
                'class' => 'form-control'
            ],
            'options' => [
                'label' => 'To Date',
            ],
        ]);

             /**
         * Allowed Age Group From
         */
        
        $this->add([
            'name' => 'allowed_age_group_from',
            'type' => Text::class,
            'attributes' => [
                'id' => 'allowed-age-group-from',
                'placeholder' => 'From',
                'class' => 'form-control inputchange',
                'onkeypress'=>"return isNumber(event)"
            ],
            'options' => [
                'label' => 'From',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        /**
         * Allowed Age Group To
         */
        
        $this->add([
            'name' => 'allowed_age_group_to',
            'type' => Text::class,
            'attributes' => [
                'id' => 'allowed-age-group-to',
                'placeholder' => 'To',
                'class' => 'form-control inputchange',
                'onkeypress'=>"return isNumber(event)"
            ],
            'options' => [
                'label' => 'To',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        /**
         * 
         *  Transfers

         */
         $this->add([
            'name' => 'transfers',
            'type' => Select::class,
            'attributes' => [
                'id' => 'transfers',
                'placeholder' => 'Transfers',
                'class' => 'form-control'
            ],
            'options' => [
                'label' => 'Transfers <span style="color: red"> *</span>',
                'disable_inarray_validator' => true,
                'label_options' => ['disable_html_escape' => true],
                'empty_option' => '--Select Transfers--',
                'value_options' =>[
                             '1' => 'Yes',
                             '2' => 'No'
                     ]
            ],
        ]);
         
           /**
         * Pick Up Point 
         */
        
        $this->add([
            'name' => 'pick_up_point',
            'type' => Text::class,
            'attributes' => [
                'id' => 'pick-up-point',
                'placeholder' => 'Pick Up Point',
                'class' => 'form-control inputchange',
                'onkeypress' => "return isAlpha(event)"
            ],
            'options' => [
                'label' => 'Pick up Point <span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        /**
         * Commission  Value
         */
        
        $this->add([
            'name' => 'commission_value',
            'type' => Text::class,
            'attributes' => [
                'id' => 'commission-value',
                'placeholder' => 'Enter value',
                'class' => 'form-control inputchange',
                'onkeypress'=>"return isNumber(event)"
            ],
            'options' => [
                'label' => 'Commission value<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        /**
         * Commission  Value
         */
        
        $this->add([
            'name' => 'commission_value[]',
            'type' => Text::class,
            'attributes' => [
                'id' => 'commission-value',
                'placeholder' => 'Enter value',
                'class' => 'form-control inputchange',
                'onkeypress'=>"return isNumber(event)"
            ],
            'options' => [
                'label' => 'Commission value<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        
        $this->add([
            'name' => 'tax_value',
            'type' => Text::class,
            'attributes' => [
                'id' => 'tax-value',
                'placeholder' => 'Enter value',
                'class' => 'form-control inputchange',
                'onkeypress'=>"return isNumber(event)"
            ],
            'options' => [
                'label' => 'Tax value<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        /**
         * Allocation 
         */
        
        $this->add([
            'name' => 'allocation',
            'type' => Text::class,
            'attributes' => [
                'id' => 'allocation',
                'placeholder' => 'Allocation',
                'class' => 'form-control inputchange',
                'onkeypress' => "return isAlpha(event)"
            ],
            'options' => [
                'label' => 'Allocation <span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        /**
         * Cut Off Days  
         */
        
        $this->add([
            'name' => 'cut_off_days',
            'type' => Text::class,
            'attributes' => [
                'id' => 'cut-off-days',
                'placeholder' => 'Cut Off Days ',
                'class' => 'form-control inputchange',
                'onkeypress'=>"return isNumber(event)"
            ],
            'options' => [
                'label' => 'Cut Off Days <span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        /**
         *
         * Name of price Plan
         */
        $this->add([
            'name' => 'name_of_price_plan',
            'type' => Text::class,
            'attributes' => [
                'id' => 'name-of-price-plan',
                'placelder' => '40Km',
                'class' => 'form-control allowtext',
                'onkeypress' => "return isAlpha(event)"
            ],
            'options' => [
                'label' => 'Name of price Plan',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
         /**
         *
         * Staying days
         */
        $this->add([
            'name' => 'staying_days[]',
            'type' => Text::class,
            'attributes' => [
                'id' => 'staying-days_1',
                'placeholder' => 'Days',
                'class' => 'form-control allowtext',
                'onkeypress' => "return isAlpha(event)"
            ],
            'options' => [
                'label' => 'Staying days',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        /**
         *
         * Staying amount
         */
        $this->add([
            'name' => 'staying_amount[]',
            'type' => Text::class,
            'attributes' => [
                'id' => 'staying-amount_1',
                 'placeholder' => 'Amount',
                'class' => 'form-control allowtext',
                'onkeypress'=>"return isNumber(event)"
            ],
            'options' => [
                'label' => 'Amount',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        /**
         *
         * Season Name
         */
        $this->add([
            'name' => 'season_name[1]',
            'type' => Text::class,
            'attributes' => [
                'id' => 'Season-name_1',
                'placeholder' => 'Season',
                'class' => 'form-control allowtext',
                'onkeypress' => "return isAlpha(event)"
            ],
            'options' => [
                'label' => 'Season Name',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        /**
         *
         * Season Amount
         */
        $this->add([
            'name' => 'season_amount[1]',
            'type' => Text::class,
            'attributes' => [
                'id' => 'season-amount_1',
                'placeholder'=>'Amount',
                'class' => 'form-control allowtext',
                'onkeypress'=>"return isNumber(event)"
            ],
            'options' => [
                'label' => 'Amount',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
         /**
         * 
         * More Discount Date From
         */
        $this->add([
            'name' => 'more_discount_from[]',
            'type' => Text::class,
            'attributes' => [
                'id' => 'more-discount-from_1',
                'class' => 'form-control text-uppercase datepicker date-valid-format',
                 'placeholder' => 'DD/MM/YYYY'
            ],
            'options' => [
                'label' => 'From<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
         /**
         * 
         *  More Discount To
         */
        $this->add([
            'name' => 'more_discount_to[]',
            'type' => Text::class,
            'attributes' => [
                'id' => 'more-discount-to_1',
                'placeholder' => 'DD/MM/YYYY',
                'class' => 'form-control text-uppercase datepicker date-valid-format'
            ],
            'options' => [
                'label' => 'To Date',
            ],
         ]); 
        
         /**
         * 
         * Season Date From
         */
        $this->add([
            'name' => 'season_date_from[1]',
            'type' => Text::class,
            'attributes' => [
                'id' => 'season-date-from_1',
                'class' => 'form-control text-uppercase datepicker date-valid-format',
                 'placeholder' => 'DD/MM/YYYY'
            ],
            'options' => [
                'label' => 'From<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
         /**
         * 
         * Season Date To
         */
        $this->add([
            'name' => 'season_date_to[1]',
            'type' => Text::class,
            'attributes' => [
                'id' => 'season_date_to_1',
                'placeholder' => 'DD/MM/YYYY',
                'class' => 'form-control text-uppercase datepicker date-valid-format'
            ],
            'options' => [
                'label' => 'To Date',
            ],
         ]);  
        
         /**
         * 
         * Last Booking Date From
         */
        $this->add([
            'name' => 'last_booking_from[]',
            'type' => Text::class,
            'attributes' => [
                'id' => 'last-booking-from_1',
                'class' => 'form-control text-uppercase datepicker date-valid-format',
                 'placeholder' => 'DD/MM/YYYY'
            ],
            'options' => [
                'label' => 'From<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
         /**
         * 
         *  Last Booking To
         */
        $this->add([
            'name' => 'last_booking_to[]',
            'type' => Text::class,
            'attributes' => [
                'id' => 'last-booking-to_1',
                'placeholder' => 'DD/MM/YYYY',
                'class' => 'form-control text-uppercase datepicker date-valid-format'
            ],
            'options' => [
                'label' => 'To Date',
            ],
         ]);  
        
         /**
         * 
         * Early Booking Date From
         */
        $this->add([
            'name' => 'early_booking_from[]',
            'type' => Text::class,
            'attributes' => [
                'id' => 'early-booking-from_1',
                'class' => 'form-control text-uppercase datepicker date-valid-format',
                 'placeholder' => 'DD/MM/YYYY'
            ],
            'options' => [
                'label' => 'From<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
         /**
         * 
         *  Early Booking To
         */
        $this->add([
            'name' => 'early_booking_to[]',
            'type' => Text::class,
            'attributes' => [
                'id' => 'early-booking-to_1',
                'placeholder' => 'DD/MM/YYYY',
                'class' => 'form-control text-uppercase datepicker date-valid-format'
            ],
            'options' => [
                'label' => 'To Date',
            ],
         ]);  
        
        
         /**
         * 
         * Last Minute Booking Hours
         */
        $this->add([
            'name' => 'last_minute_booking_hour[]',
            'type' => Text::class,
            'attributes' => [
                'id' => 'last-minute-booking-hour',
                'placeholder' => 'Hour',
                'class' => 'form-control',
                'onkeypress'=>"return isNumber(event)"
            ],
            'options' => [
                'label' => 'Hours',
            ],
         ]);  
        
        /**
         * 
         * Last Minute Booking Amount
         */
        $this->add([
            'name' => 'last_minute_booking_amount[]',
            'type' => Text::class,
            'attributes' => [
                'id' => 'last-minute-booking-amount',
                'placeholder' => 'Amount',
                'class' => 'form-control',
                'onkeypress'=>"return isNumber(event)"
            ],
            'options' => [
                'label' => 'Amount',
            ],
         ]);  
             
         /**
         * 
         * Early Booking days
         */
        $this->add([
            'name' => 'early_booking_days[]',
            'type' => Text::class,
            'attributes' => [
                'id' => 'early-booking-days',
                'placeholder' => 'Days',
                'class' => 'form-control',
                'onkeypress' => "return isAlpha(event)"
            ],
            'options' => [
                'label' => 'Days',
            ],
         ]);  
        
        /**
         * 
         * Early Booking Amount
         */
        $this->add([
            'name' => 'early_booking_amount[]',
            'type' => Text::class,
            'attributes' => [
                'id' => 'early_booking_amount',
                'placeholder' => 'Amount',
                'class' => 'form-control',
                'onkeypress'=>"return isNumber(event)"
            ],
            'options' => [
                'label' => 'Amount',
            ],
         ]);  
        
       
        
         /**
         * Is Guide
         */
          
             $this->add([
            'name' => 'is_guide[]',
            'type' => Checkbox::class,
            'attributes' => [
                'id' => 'is-guide',
                //'checked' => 'checked',
                'class' => 'form-control inputchange case',
                 'onclick'=>"isguide($(this));",
            ],
            'options' => [
                'label' => 'Is Guide',
                'checked_value' => '1',
                'unchecked_value' => 'no',
                'use_hidden_element' => false
            ],
        ]);
             
        /**
         * Guide Language
         */
        
        $this->add([
            'name' => 'guide_language[]',
            'type' => Select::class,
            'attributes' => [
                'id' => 'guide-language-is-guide',
                'placeholder' => 'Guide language',
                'class' => 'form-control',
                'disable_inarray_validator' => true
            ],
            'options' => [
                'label' => 'Guide Language<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true],
                'empty_option' => '--Languages--',
                'value_options' => self::$languages,
                
            ],
            
        ]);
        
        /**
         * 
         * Guide Cost
         */
        $this->add([
            'name' => 'guide_cost[]',
            'type' => Text::class,
            'attributes' => [
                'id' => 'guide-cost-is-guide',
                'placeholder' => 'Guide cost',
                'class' => 'form-control',
                'onkeypress'=>"return isNumber(event)"
            ],
            'options' => [
                'label' => 'Guide Cost',
            ],
         ]);  
          
        /**
         *  Submit
         */
        
        $this->add([
            'name' => 'submit',
            'type' => Submit::class,
            'attributes' => [
                'id' => 'save',
                'placeholder' => 'save',
                'class' => 'btn btn-red defaultbtnsearch btn-warning',
                'value' => 'Save'
            ],
        ]);
        
       
        
        /**
         * 
         * Day Wish Discount
         */
        $this->add([
            'name' => 'dis_days[]',
            'type' => Text::class,
            'attributes' => [
                'id' => 'dis-day',
                //'placeholder' => 'Days',
                'class' => 'form-control',
                'onkeypress' => "return isAlpha(event)"
            ],
            'options' => [
                'label' => 'Days',
            ],
         ]);  
             
    
       /**
         * 
         * Day Wish From
         */
    
     $this->add([
            'name' => 'day_wise_from[]',
            'type' => Text::class,
            'attributes' => [
                'id' => 'day-wise-from',
                'class' => 'form-control text-uppercase datepicker date-valid-format',
                 'placeholder' => 'DD/MM/YYYY'
            ],
            'options' => [
                'label' => 'From<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
     
       /**
         * 
         * Day Wish To
         */
    
     $this->add([
            'name' => 'day_wise_to[]',
            'type' => Text::class,
            'attributes' => [
                'id' => 'day-wise-to',
                'class' => 'form-control text-uppercase datepicker date-valid-format',
                 'placeholder' => 'DD/MM/YYYY'
            ],
            'options' => [
                'label' => 'From<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
            
      /**
         * 
         * Day Wise Discount Amount
         */
        $this->add([
            'name' => 'day_wise_discount_amount[]',
            'type' => Text::class,
            'attributes' => [
                'id' => 'day-wise-discount-amount',
                'placeholder' => 'Amount',
                'class' => 'form-control',
                'onkeypress'=>"return isNumber(event)"
            ],
            'options' => [
                'label' => 'Amount',
            ],
         ]);  
        
        /**
         * Service Charge  Value
         */
        
        $this->add([
            'name' => 'discount_commission_value',
            'type' => Text::class,
            'attributes' => [
                'id' => 'discount-commission-value',
                'placeholder' => 'Enter value',
                'class' => 'form-control inputchange'
            ],
            'options' => [
                'label' => 'Charge value<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        /**         
         * From Date
         */
        $this->add([
            'name' => 'discount_valid_from',
            'type' => Text::class,
            'attributes' => [
                'id' => 'discount-valid-from',
                'class' => 'form-control datepicker',
                'maxlength' => 15,
            ],
            'options' => [
                'label' => 'Valid From<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        /**         
         * To Date
         */
        $this->add([
            'name' => 'discount_valid_to',
            'type' => Text::class,
            'attributes' => [
                'id' => 'discount_valid-to',
                'class' => 'form-control datepicker',
                'maxlength' => 15,
            ],
            'options' => [
                'label' => 'Valid To<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        /**
         * Service Charge  Value
         */
        
        $this->add([
            'name' => 'service_charge_value',
            'type' => Text::class,
            'attributes' => [
                'id' => 'service-charge-value',
                'placeholder' => 'Enter value',
                'class' => 'form-control inputchange'
            ],
            'options' => [
                'label' => 'Charge value<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
         $this->add([
            'name' => 'id',
            'type' => Hidden::class,
            'attributes' => [
                'id' => 'id'
            ],
        ]);
    }
    public function getInputFilterSpecification() {
        return [
           
            'Sightseeing_name' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Select Sightseeing Name'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],  
            'vendor_name' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Select Vendor Name'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],  
            'valid_from' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Select From Date'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],  
            'valid_to' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Select From To'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],  
            'weekend' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Select Weakends'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],  
            'operating_time_from' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Select Operating Time From'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],  
            'operating_time_to' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Select Operating Time To'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],  
            'allowed_age_group_from' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Provide Age From'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],  
            'allowed_age_group_to' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Provide Age To'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],  
            'transfers' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Select Transfers Type'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],  
            'pick_up_point' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Privide Pickup Point'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],  
            'allocation' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Privide Allocation'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],  
            'cut_off_days' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Privide Cut Off Days'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],  
            'name_of_price_plan' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Privide Price Plan Name'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],  
            'currency[]' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Select currency Type'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],  
            'staying_days[1]' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Provide Days'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],  
            'more_discount_from[1]' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Provide Date From'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],  
            'more_discount_to[1]' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Provide Date To'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],  
            'staying_amount[]' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Provide Amount'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],  
            'season_name[1]' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Provide Name'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],  
            'season_date_from[1]' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Provide Date From'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],  
            'season_date_to[1]' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Provide Date To'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],  
            'season_amount[1]' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Provide Amount'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],  
            'last_minute_booking_hour[1]' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Provide Hours'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],  
            'last_booking_from[]' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Provide Date From'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],  
            'last_booking_to[1]' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Provide Date To'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],  
            'last_minute_booking_amount[1]' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Provide Amount'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],  
            'early_booking_days[]' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Provide Days'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],  
            'early_booking_from[]' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Provide Date Form'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],  
            'early_booking_to[]' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Provide Date To'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],  
            'early_booking_amount[]' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Provide Amount'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],  
            ];
    }

}
