<?php

namespace Dashboard\Form;

use Zend\Form\Form;
use Zend\Form\Element\{
    Select,
    Date,
    Number,
    Checkbox,
    Text,
    Submit,
    Hidden,
    Textarea,
    Radio,
    File,
    Time
};
use Zend\Validator\{
    NotEmpty,
    Digits
};
use Zend\InputFilter\InputFilterProviderInterface;

class SightseeingImageForm extends Form implements InputFilterProviderInterface {

    public function __construct($name = null) {
        parent::__construct('sightseeing-image-form');
        
        /**
         * MAIN IMAGE
         */
        $this->add([
            'name' => 'main_image',
            'type' => File::class,
            'attributes' => [
                'id' => 'main-image',
                'class' => 'form-control common-image-file',
                'data-level-name' => 'main-image',
                'data-type' => 'sightseeing'
            ],
            'options' => [
                'label' => 'Activity Main Image (Multiple)<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        /**
         * GALLERY IMAGE
         */
        $this->add([
            'name' => 'gallery_image',
            'type' => File::class,
            'attributes' => [
                'id' => 'gallery-image',
                'class' => 'form-control common-image-file',
                'data-level-name' => 'gallery-image',
                'data-type' => 'sightseeing'
            ],
            'options' => [
                'label' => 'Activity Gallery Image (Multiple)<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
         $this->add([
            'name' => 'module_id',
            'type' => Hidden::class,
            'attributes' => [
                'id' => 'module-id'
            ],
        ]);
    }

    public function getInputFilterSpecification() {
        return [
            'main_image' => [
                'required' => false,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Select Sightseeing'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'gallery_image' => [
                'required' => false,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Enter Hotel Highlights'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ]           
        ];
    }

}
