<?php

namespace Dashboard\Form;

use Zend\Form\Form;
use Zend\Form\Element\{
    Select,
    File,
    Text,
    Date,
    Radio,
    Submit,
    Password,
    Checkbox,
    Email,
    Hidden
};
use Zend\InputFilter\InputFilterProviderInterface;
use Zend\Validator\{
    NotEmpty,
    Digits,
    StringLength,
    EmailAddress
};
use Zend\Validator\File\Size;

class ProfileCreditRequestForm extends Form implements InputFilterProviderInterface {

    public static $paymentModeList = ['Cheque'=>'Cheque','Cash Deposit'=>'Cash Deposit','Online Transfer'=>'Online Transfer','Demand Draft'=>'Demand Draft'];

    public function __construct($name = null) {

        parent::__construct('profile-credit-request');
        $this->setAttribute('method', 'post');

        /**
         * Deposit Date
         */
        $this->add([
            'name' => 'deposit_date',
            'type' => text::class,
            'attributes' => [
                'id' => 'deposit-date',
                'placeholder' => 'dd/mm/yyyy',
                'class' => 'form-control inputchange datepicker',
                'readonly'=>'readonly'
            ],
            'options' => [
                'label' => 'Deposit Date<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         * Payment Mode
         */
        $this->add([
            'name' => 'payment_mode',
            'type' => Text::class,
            'attributes' => [
                'id' => 'payment-mode',
                'placeholder' => 'Transaction Mode',
                'class' => 'form-control input'
            ],
            'options' => [
                'label' => 'Payment Mode<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        $this->add([
            'name' => 'payment_mode',
            'type' => Select::class,
            'attributes' => [
                'id' => 'payment-mode',
                'class' => 'form-control input'
            ],
            'options' => [
                'label' => 'Payment Mode<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true],
                'value_options' => self::$paymentModeList,
                'disable_inarray_validator' => true,
                'empty_option' => 'Select',
            ],
        ]);

        /**
         * partner bank Accounts
         */
        $this->add([
            'name' => 'partner_bank_accounts',
            'type' => Text::class,
            'attributes' => [
                'id' => 'partner-bank-accounts',
                'placeholder' => 'Partner bank accounts',
                'class' => 'form-control inputchange'
            ],
            'options' => [
                'label' => 'Partner Bank Accounts<span style="color:red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         * Amount
         */
        $this->add([
            'name' => 'amount',
            'type' => Text::class,
            'attributes' => [
                'id' => 'amount',
                'placeholder' => 'Amount',
                'class' => 'form-control inputchange',
                'maxlength' => 8,
                'onkeypress' => "return isDecimalNumber(event)"
            ],
            'options' => [
                'label' => 'Amount<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         * Deposited Bank
         */
        $this->add([
            'name' => 'deposit_bank',
            'type' => Text::class,
            'attributes' => [
                'id' => 'deposit-bank',
                'placeholder' => 'Deposit bank',
                'class' => 'form-control inputchange',
                 'onkeypress' => "return isAlphaNumber(event)"
            ],
            'options' => [
                'label' => 'Deposit Bank<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         * Deposited Branch
         */
        $this->add([
            'name' => 'deposit_branch',
            'type' => Text::class,
            'attributes' => [
                'id' => 'deposit-branch',
                'placeholder' => 'Deposit Branch',
                'class' => 'form-control inputchange'
            ],
            'options' => [
                'label' => 'Deposit Branch<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         * Remark/Request
         */
        $this->add([
            'name' => 'remark_request',
            'type' => Text::class,
            'attributes' => [
                'id' => 'remark-request',
                'placeholder' => '',
                'class' => 'form-control'
            ],
            'options' => [
                'label' => 'Remark',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         * Hidden Field...
         */
        $this->add([
            'name' => 'submit_type',
            'type' => Hidden::class,
            'attributes' => [
                'id' => 'submit-type',
                'class' => 'form-control',
                'value' => 'submit'
            ]
        ]);

        /**
         * Reset
         */
        $this->add([
            'name' => 'credit_reset',
            'type' => Submit::class,
            'attributes' => [
                'id' => 'credit_reset',
                'placeholder' => 'Reset',
                'class' => 'reset_btn btn btn-success btn-new-vehile'
            ],
        ]);

        /**
         * Save
         */
        $this->add([
            'name' => 'credit_submit',
            'type' => Submit::class,
            'attributes' => [
                'id' => 'credit-submit',
                'value' => 'Save',
                'placeholder' => 'Save',
                'class' => 'save_data_btn btn btn-primary btn-new-vehile profile_save btn-warning'
            ],
        ]);

        /**
         * Hidden Field...
         */
        $this->add([
            'name' => 'user_id',
            'type' => Text::class
        ]);

        /**
         * Payment Proof
         */
        $this->add([
            'name' => 'fileupload',
            'type' => File::class,
            'attributes' => [
                'id' => 'fileupload',
                'class' => 'form-control'
            ],
            'options' => [
                'label' => 'Payment Proof',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
    }

    public function getInputFilterSpecification() {
        return [
            'deposit_date' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please enter Deposit Date'
                            ]
                        ],
                    ],
                   /* ['name' => 'Date',
                        'options' => [
                            'messages' => [
                                //Date::INVALID_DATE => '',
                                \Zend\Validator\Date::INVALID_DATE => '',
                            ],
                        ],
                        'break_chain_on_failure' => true
                    ],*/
                ]
            ],
            'payment_mode' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please select Payment Mode'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'partner_bank_accounts' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please enter Partner bank Account'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'amount' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please enter Amount'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ],
                ]
            ],
            'deposit_bank' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please enter Deposit Bank'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'deposit_branch' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please enter Deposit Branch'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
        ];
    }

}
