<?php

namespace Dashboard\Form;

use Zend\Form\Form;
use Zend\Form\Element\{
    Select,
    File,
    Text,
    Textarea,
    Radio,
    Submit,
    Checkbox,
    Email,
    Hidden
};

use Zend\Validator\{
    NotEmpty,
    Digits
};

use Zend\InputFilter\InputFilterProviderInterface;

class PointConversionForm extends Form implements InputFilterProviderInterface {

    public static $booking_type = [];
    public static $user_type = [];
    public static $user_grade = [];

    public function __construct($name = null) {

        parent::__construct('point-search-type');

        $this->setAttribute('method', 'post');

         /**
         *
         * status
         */
        $this->add([
            'name' => 'status',
            'type' => Radio::class,
            'attributes' => [
                'id' => 'active',
            ],
            'options' => [
                'label' => '<span class="radio">Active</span>',
                'label_options' => ['disable_html_escape' => true],
                'value_options' => array(
                '1' => 'Active',
                '0' => 'In-Active',
            ),
            ],
        ]);

        /**
         *
         * booking_type
         */
        $this->add([
            'name' => 'booking_type',
            'type' => Select::class,
            'attributes' => [
                'id' => 'booking-type-id',
                'class' => 'selectpicker form-control',
                'data-show-subtext' => 'true',
                'data-live-search' => 'true'
            ],
            'options' => [
                'label' => 'Booking Type',
                'value_options' => self::$booking_type,
                'disable_inarray_validator' => true,
                'empty_option' => '--Select Booking Type--',
            ],
        ]);


        /**
         *
         * user_type
         */
        $this->add([
            'name' => 'user_type',
            'type' => Select::class,
            'attributes' => [
                'id' => 'user-type-id',
                'class' => 'selectpicker form-control',
                'data-show-subtext' => 'true',
                'data-live-search' => 'true'
            ],
            'options' => [
                'label' => 'User Type',
                'value_options' => self::$user_type,
                'disable_inarray_validator' => true,
                'empty_option' => '--Select User Type--',
            ],
        ]);
        
        /**
         *
         * user_grade
         */
        $this->add([
            'name' => 'user_grade',
            'type' => Select::class,
            'attributes' => [
                'id' => 'user-grade-id',
                'class' => 'selectpicker form-control',
                'data-show-subtext' => 'true',
                'data-live-search' => 'true'
            ],
            'options' => [
                'label' => 'User Grade',
                'value_options' => self::$user_grade,
                'disable_inarray_validator' => true,
                'empty_option' => '--Select User Grade--',
            ],
        ]);
        
         /**
         *
         * Points
         */
        $this->add([
            'name' => 'points',
             'type' => Text::class,
            'attributes' => [
                'id' => 'points',
                'placeholder' => '',
                'class' => 'form-control',
                'maxlength' => 5,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => 'Points<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        /**
         *
         * Points
         */
        $this->add([
            'name' => 'conversion_rate',
             'type' => Text::class,
            'attributes' => [
                'id' => 'conversion-rate',
                'placeholder' => '',
                'class' => 'form-control',
                'maxlength' => 5,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => 'Conversion Rate<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);


        /**
         *
         * vehicle type_name
         */
        $this->add([
            'name' => 'vehicle_type_id',
            'type' => Hidden::class,
            'attributes' => [
                'id' => 'vehicle-type-id',
                'placeholder' => '',
                'class' => 'input form-control '
            ],
            'options' => [
                'label' => 'Vehicle Type',
            ],
        ]);




        /**
         *
         * Search Button
         */
        $this->add([
            'name' => 'search_vehicle_type',
            'type' => Submit::class,
            'attributes' => [
                'id' => 'search-vehicle-type',
                'placeholder' => 'Search',
                'class' => 'btn btn-red defaultbtnsearch btn-warning',
                'value' => 'Search'
            ],
        ]);


        $this->add([
            'name' => 'add_vehicle_type',
            'type' => Submit::class,
            'attributes' => [
                'id' => 'addvehicle-type',
                'placeholder' => 'Add Vehicle',
                'class' => 'btn btn-red defaultbtnsearch btn-warning',
                'value' => 'Save'
            ],
        ]);

        $this->add([
            'name' => 'edit_vehicle_type',
            'type' => Submit::class,
            'attributes' => [
                'id' => 'editvehicle-type',
                'placeholder' => 'Add Vehicle',
                'class' => 'btn btn-red defaultbtnsearch btn-warning',
                'value' => 'Save'
            ],
        ]);

        $this->add([
            'name' => 'clear_button',
            'type' => Submit::class,
            'attributes' => [
                'id' => 'clear-button-id',
                'placeholder' => 'Submit',
                'class' => 'btn btn-red btn-warning',
                'value' => 'Clear'
            ],
        ]);
    }

    public function getInputFilterSpecification() {
        return [
            'booking_type' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please select Booking Type'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'user_type' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please select User Type'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'user_grade' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please select User Grade'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'points' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please enter Points'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'conversion_rate' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please enter Conversion Rate'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ]
        ];
    }

}
