<?php
namespace Dashboard\Form;
use Zend\Form\Form;
use Zend\Form\Element\{
    Select,
    Date,
    Number,
    Checkbox,
    Text,
    Submit,
    Hidden,
    Textarea,
    Radio,
    File,
    Time
};
use Zend\Validator\{
    NotEmpty,
    Digits
};

use Zend\InputFilter\InputFilterProviderInterface;

class PackageAddForm_1 extends Form implements InputFilterProviderInterface{ 
    
    public static $tour_type = [];
    public static $country = [];
    public static $city = [];
    public static $inclusion = [];
    public static $tour_theme = [];
    public static $tour_category = [];
    

    public function __construct($name = null) {
        parent::__construct('package-add-form');        
        /**
         * General Information Tab
         * General Configuration
         * Tour Name
         */
        
        $this->add([
            'name' => 'tours_type',
            'type' => Select::class,
            'attributes' => [
                'id' => 'tours-type',
                'placeholder' => '',
                'class' => 'selectpicker form-control',
                'data-show-subtext' => 'true',
                'data-live-search' => 'true'
            ],
            'options' => [
                'label' => 'Tour Type <span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true],
                'value_options' => self::$tour_type,
                'disable_inarray_validator' => true,
                'empty_option' => '--Select Tour Type--',
            ],
        ]);
        
        $this->add([
            'name' => 'tour_category',
            'type' => Select::class,
            'attributes' => [
                'id' => 'tour-category',
                'placeholder' => '',
                'class' => 'demo-default select-state selectized form-control',
                'data-show-subtext'=>true,
                'data-live-search'=>true,
            ],
            'options' => [
                'label' => 'Tour Categories <span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true],
                'value_options' => self::$tour_category,
                'disable_inarray_validator' => true,
                'empty_option' => '--Select Tour Type--',
            ],
        ]);
        
        /**
         * 
         * Destination Country ...
         */
        $this->add([
            'name' => 'destination_country',
            'type' => Select::class,
            'attributes' => [
                'id' => 'destination-country',
                'placeholder' => '',
                'class' => 'selectpicker form-control',
                'data-show-subtext' => 'true',
                'data-live-search' => 'true'
            ],
            'options' => [
                'label' => 'Destination Country <span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true],
                'value_options' => self::$country,
                'disable_inarray_validator' => true,
                'empty_option' => '--Select Country--',
            ],
        ]);
        
         /**
         * 
         * Destination | Area City
         */
       $this->add([
            'name' => 'destination_city',
             'type' => Text::class,
              'attributes' => [
                'id' => 'destination-city',
                'class' => 'form-control'
            ],
           'options' => [
                'label' => 'Destination City<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
       
       $this->add([
            'name' => 'destination_city_id',
             'type' => Hidden::class,
              'attributes' => [
                'id' => 'destination-city-id',
                'class' => 'form-control'
            ],
        ]);
        
        /**
         * 
         * Destination Post Code
         */
        $this->add([
            'name' => 'destination_post_code',
             'type' => Text::class,
            'attributes' => [
                'id' => 'destination-post-code',
                'class' => 'form-control'                
            ],
            'options' => [
                'label' => 'Destination Post Code<span style="color: red">*</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        /**
         * 
         * 
         * Tour Name
         */
        $this->add([
            'name' => 'tour_name',
             'type' => Text::class,
            'attributes' => [
                'id' => 'tour-name',                  
                'class' => 'form-control'
            ],
            'options' => [
                'label' => 'Tour Name<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        /**
         * 
         * Tours Operator
         */
       
            
        $this->add([
            'name' => 'tours_operator',
             'type' => Select::class,
              'attributes' => [
                'id' => 'tour-operator',
                'class' => 'selectpicker form-control',
                'data-show-subtext'=>true,
                'data-live-search'=>true,
                'style'=>'display: none'
            ],
            'options' => [
                'label' => 'Tour Operator<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true],
                'disable_inarray_validator' => true,
                'empty_option' => ' -- Select Tour Operator -- ',
                'value_options' => [
                    '1' => 'Hello42cab',
                    '2' => 'Regency Tours',
                    '3' => 'Holiday Basket'
                    
                    
                ],
            ],
        ]);
       
        //--------------------Primary Information-------------------------------
        
         /**
         * Tours Features Tab
         * Start City
         */
         $this->add([
            'name' => 'start_city',
            'type' => Textarea::class,
            'attributes' => [
                'id' => 'start-city',
                //'placeholder' => '',
                'class' => 'form-control',
                'class' => 'demo-default selectized form-control',
                'multiple' => 'multiple',
            ],
            'options' => [
                'label' => 'Start City<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);        
        
        $this->add([
            'name' => 'start_city_id',
             'type' => Hidden::class,
              'attributes' => [
                'id' => 'start-city-id',
                'class' => 'form-control'
            ],
        ]);
        
        /**
         * 
         * End City
         */
        
        $this->add([
            'name' => 'end_city',
            'type' => Textarea::class,
            'attributes' => [
                'id' => 'end-city',
                //'placeholder' => '',
                'class' => 'form-control',
                'class' => 'demo-default selectized form-control',
                'multiple' => 'multiple',
            ],
            'options' => [
                'label' => 'End City<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
       
        
        $this->add([
            'name' => 'end_city_id',
             'type' => Hidden::class,
              'attributes' => [
                'id' => 'end-city-id',
                'class' => 'form-control'
            ],
        ]);
        
         /**
         * 
         * Visiting  City
         */
        
         $this->add([
            'name' => 'visiting_cities',
             'type' => Select::class,
              'attributes' => [
                'id' => 'visiting-cities',
                'class' => 'demo-default select-state selectized form-control',
                'data-show-subtext'=>true,
                'data-live-search'=>true,
                'style'=>'display: none'
            ],
            'options' => [
                'disable_inarray_validator' => true,
                'empty_option' => ' -- Select City -- ',
                'value_options' => [
                    '1' => 'Delhi',
                    '2' => 'Mumbai',
                    '3' => 'Agra'
                    
                    
                ],
            ],
        ]);
         /**
         * 
         * Destination covered
         */
         
          $this->add([
            'name' => 'destination_covered',
            'type' => Textarea::class,
            'attributes' => [
                'id' => 'destination-covered',
                //'placeholder' => '',
                'class' => 'form-control',
                'class' => 'demo-default selectized form-control',
                'multiple' => 'multiple',
            ],
            'options' => [
                'label' => 'Destination Covered<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        $this->add([
            'name' => 'destination_covered_id',
             'type' => Hidden::class,
              'attributes' => [
                'id' => 'destination-covered-id',
                'class' => 'form-control'
            ],
        ]);
      
         /**
         * 
         * Inclusion
         */
        
        $this->add([
            'name' => 'inclusion',
             'type' => Select::class,
              'attributes' => [
                'id' => 'inclusion',
                'class' => 'demo-default select-state selectized form-control',
                'data-show-subtext'=>true,
                'data-live-search'=>true,
            ],
             'options' => [
                'label' => 'Inclusion<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true],
                'value_options' => self::$inclusion,
                'disable_inarray_validator' => true,
                'empty_option' => '--Select Inclusion--',
            ],
        ]);
       /**
         * 
         * Theme
         */
        
        $this->add([
            'name' => 'theme',
             'type' => Select::class,
              'attributes' => [
                'id' => 'theme',
                'class' => 'demo-default select-state selectized form-control',
                'data-show-subtext'=>true,
                'data-live-search'=>true,
                'style'=>'display: none'
            ],
            'options' => [
                'label' => 'Theme<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true],              
                'value_options' => self::$tour_theme,
                'disable_inarray_validator' => true,
                'empty_option' => ' -- Select Theme -- ',
              
            ],
        ]);
        
        
         /**
         * 
         * Traveler
         */
        
        $this->add([
            'name' => 'traveler',
             'type' => Select::class,
              'attributes' => [
                'id' => 'traveler',
                'class' => 'selectpicker form-control',
                'data-show-subtext' => 'true',
                'data-live-search' => 'true'
            ],
            'options' => [
                'label' => 'Traveller<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true],
                'disable_inarray_validator' => true,
                'empty_option' => ' -- Select Traveler -- ',
                'value_options' => [
                    '1' => '1',
                    '2' => '2',
                    '3' => '3',
                    '4' => '4',
                    '5' => '5',
                    '6' => '6',
                    '7' => '7'
                ],
            ],
        ]);
        
          /**
         * 
         * package Validity From
         *
         */
        $this->add([
            'name' => 'package_validity_from',
             'type' => text::class,
            'attributes' => [
                'id' => 'package-validity-from',                  
                'class' => 'form-control datepicker'
            ],
            'options' => [
                'disable_inarray_validator' => true,
            ],
        ]);
        
        
         /**
         * 
         * package Validity To
         *
         */
        $this->add([
            'name' => 'package_validity_to',
             'type' => text::class,
            'attributes' => [
                'id' => 'package-validity-to',                  
                'class' => 'form-control datepicker'
            ],
            'options' => [
                'label' => 'Tour Name<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        /**
         * 
         * Tours Package Available From
         *
         */
        $this->add([
            'name' => 'tours_package_available_from',
             'type' => text::class,
            'attributes' => [
                'id' => 'tours-package-available-from',
                'class'=>'form-control datepicker'
            ],
            'options' => [
               // 'label' => 'Tour Name<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
         /**
         * 
         * Tours Package Expire Date
         *
         */
        $this->add([
            'name' => 'tours_package_expire_date',
             'type' => text::class,
            'attributes' => [
                'id' => 'tours-package-expire-date',
                'class'=>'form-control datepicker'
            ],
            'options' => [
                'label' => 'Tour Name<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        
        /**
         * 
         * Booking Validity From
         *
         */
        $this->add([
            'name' => 'booking_validity_from',
             'type' => text::class,
            'attributes' => [
                'id' => 'booking-validity-from ',
                'class'=>'form-control datepicker'
            ],
            'options' => [
                'label' => 'Tour Name<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        /**
         * 
         * Booking Validity To
         *
         */
        $this->add([
            'name' => 'booking_validity_to',
             'type' => text::class,
            'attributes' => [
                'id' => 'booking-validity-to',
                'class'=>'form-control datepicker'
            ],
            'options' => [
                'label' => 'Tour Name<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
         /**
         * 
         * Tour Code
         *
         */
        $this->add([
            'name' => 'tour_code',
             'type' => Date::class,
            'attributes' => [
                'id' => 'tour-code'
            ],
            'options' => [
                'label' => 'Tour Name<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        /**
         * 
         * Number Of Nights
         *
         */
        $this->add([
            'name' => 'number_of_nights',
             'type' => Date::class,
            'attributes' => [
                'id' => 'number-of-nights'
            ],
            'options' => [
                'label' => 'Tour Name<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        /**
         * 
         * Number Of Days
         *
         */
        $this->add([
            'name' => 'number_of_days',
             'type' => Date::class,
            'attributes' => [
                'id' => 'number-of-days'
            ],
            'options' => [
                'label' => 'Tour Name<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]); 
        
         /**
         * 
         * Private tour
         *
         */
       
        
     $this->add([
    'type' => Checkbox::class,
    'name' => 'private_tour',
    'attributes' => [
                'id' => 'private_tour'],
    'options' => [
        'label' => 'A checkbox',
        'use_hidden_element' => true,
        'checked_value' => '1',
        'unchecked_value' => '0',
    ],
]);
        
 /**
         * 
         * Group tour
         *
         */
       
        
        $this->add([
    'type' => Checkbox::class,
    'name' => 'group_tour',
    'attributes' => [
    'id' => 'group-tour'],
    'options' => [
        'label' => 'A checkbox',
        'use_hidden_element' => false,
        'checked_value' => '1',
        'unchecked_value' => '0',
    ],
]);  
        
        /* 
         * Departure Date
         *
         */
       
    $this->add([
    'type' => Date::class,
    'name' => 'departure_date',
    'attributes' => [
    'id' => 'departure-date',
    'class' => 'form-control']
    
]);
         /* 
         * Departure Time
         *
         */
          
        $this->add([
    'type' => Time::class,
    'name' => 'departure_time',
    'attributes' => [
    'id' => 'pickup-time',
        'class' => 'form-control']
    
]);
         /**
         * 
         * Budget
         *
         */
       
        
     $this->add([
    'type' => Checkbox::class,
    'name' => 'budget',
    'attributes' => [
                'id' => 'budget'],
    'options' => [
        'label' => 'A checkbox',
        'use_hidden_element' => true,
        'checked_value' => '1',
        'unchecked_value' => '0',
    ],
]);
     
      /**
         * 
         * Standard
         *
         */
       
        
     $this->add([
    'type' => Checkbox::class,
    'name' => 'standard',
    'attributes' => [
                'id' => 'standard'],
    'options' => [
        'label' => 'A checkbox',
        'use_hidden_element' => true,
        'checked_value' => '1',
        'unchecked_value' => '0',
    ],
]);
     
     
      /** 
         * 
         * Dulexr
         *
         */
       
        
     $this->add([
    'type' => Checkbox::class,
    'name' => 'dulexr',
    'attributes' => [
                'id' => 'dulexr'],
    'options' => [
        'label' => 'A checkbox',
        'use_hidden_element' => true,
        'checked_value' => '1',
        'unchecked_value' => '0',
    ],
]);
     
     
      /**
         * 
         * Luxury
         *
         */
       
        
     $this->add([
    'type' => Checkbox::class,
    'name' => 'luxury',
    'attributes' => [
                'id' => 'luxury'],
    'options' => [
        'label' => 'A checkbox',
        'use_hidden_element' => true,
        'checked_value' => '1',
        'unchecked_value' => '0',
    ],
]);
     
     /**
         * 
         * Premium
         *
         */
       
        
     $this->add([
    'type' => Checkbox::class,
    'name' => 'premium',
    'attributes' => [
                'id' => 'premium'],
    'options' => [
        'label' => 'A checkbox',
        'use_hidden_element' => true,
        'checked_value' => '1',
        'unchecked_value' => '0',
    ],
]);
        
   $this->add([
        'type' => Radio::class,
        'name' => 'specification',
        'attributes' => [
                'id' => 'only-hotel'],
        'options' => [
            'label' => '',
            'value_options' =>[
                
                
            ],
        ],
    ]);   
   
   $this->add([
    'type' => Radio::class,
    'name' => 'Lowest_class_of_hotel',
    'attributes' => [
                'id' => 'lowest-cost',
                //'class' => 'demo-default select-state selectized form-control',
//                'data-show-subtext'=>true,
//                'data-live-search'=>true,
//                'style'=>'display: none'
            ],
    'options' => [
        'label' => 'Do you like chocolate?',
        'value_options' => [
            '0' => 'No',
            '1' => 'Yes',
        ],
    ],
]);
   
   /**
         * 
         * Default Feature
         *
         */
   $this->add([
    'type' => Radio::class,
    'name' => 'default_feature',
    'attributes' => [
                'id' => 'default-feature',
                'style'=>'font-normal'
            ],
    'options' => [
        'label' => 'Do you Choose?',
        'value_options' => [
            '0' => 'Default Pic',
            
        ],
    ],
]);
   
   $this->add([
            'name' => 'Lowest_class_of_hotel',
             'type' => Radio::class,
              'attributes' => [
                'id' => 'lowest-cost',
            ],
            'options' => [
                'disable_inarray_validator' => true,
                'value_options' => [
                    //'1' => '1',
                    
                    
                    
                ],
            ],
        ]);
   
    $this->add([
        'type' => Radio::class,
        'name' => 'meal_plane_wise_hotel',
        'attributes' => [
                'id' => 'meal-plan-cost'],
        'options' => [
            'label' => '',
            'value_options' =>[
                
                
            ],
        ],
    ]);  
   
   $this->add([
        'type' => Textarea::class,
        'name' => 'short_desc',
        'attributes' => [
                'id' => 'page_desc',
                'placeholder' => 'Content',
                'class' => 'form-control editor'
            ],
        'options' => [
            'label' => 'Short Description<span style="color: red"> *</span>',
            'label_options' => ['disable_html_escape' => true]
        ],
    ]); 
      
        
        
        /**
         * 
         * Upload Images
         */
        $this->add([
            'name' => 'image',
             'type' => File::class,
            'attributes' => [
                'id' => 'image',                 
                'class' => 'form-control',
                'multiple'=>'multiple'
            ],
            'options' => [
                'label' => 'Upload Images<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        /**
         * 
         * Meta Image
         */
        $this->add([
            'name' => 'meta_image',
             'type' => File::class,
            'attributes' => [
                'id' => 'meta-image',                 
                'class' => 'form-control',
                'multiple'=>'multiple'
            ],
            'options' => [
                'label' => 'Upload Images<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        /**
         * 
         * Meta Image
         */
        $this->add([
            'name' => 'spots_image',
             'type' => File::class,
            'attributes' => [
                'id' => 'spots-image',                 
                'class' => 'form-control',
                'multiple'=>'multiple'
            ],
            'options' => [
                'label' => 'Upload Images<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        /**
         * 
         * Related Tour
         */
        
         $this->add([
            'name' => 'related_tour_pac',
            'type' => Select::class,
            'attributes' => [
                'id' => 'related-tour',
                'class' => 'form-control',
                'data-show-subtext'=>true,
                'data-live-search'=>true,
                //'style'=>'display: none',
                'multiple'=>'multiple',
                'size'=>'12',
                
            ],
            'options' => [
                'disable_inarray_validator' => true,
                'empty_option' => ' -- Select Related Tour Type -- ',
                'value_options' => [
                    '1' => 'Natural View of Jaflong',
                    '2' => 'Natural beauty of Cox-s Bazar',
                    '3' => '3-Day Bus Tour to Washington D.C. , Philadelphia, Niagara Falls from New York',
                    '4'=>'Amazing Madhabkunda waterfall',
                    '5'=>'Darjeeling Tour Packages',
                    '6'=>'East Coast US from Washington D.CSpots',
                    '7'=>'Enticing Bali',
                    '8'=>'Essence of Kashmir and Ladakh Tour',
                    '9'=>'Grand Canyon Railway Adventure Package',
                    '10'=>'Independent 3-Day Trip to Liverpool including the Beatles Story Experience',
                    '11'=>'Kuala Lumpur &amp; Penang Wonder',
                    '12'=>'Lalbagh fort Tour',
                    '13'=>'leisure and pilgrimage tour  in khagrachari',
                    '14'=>'Masada and the Dead Sea Day Trip from Jerusalem',
                    '15'=>'Niagara Falls Power Pass',
                    '16'=>'Paris City Tour Seine River Cruise and Eiffel Tower',
                    '17'=>'Patenga Beach Tours',
                    '18'=>'Rangamati natural view',
                    '19'=>'Ratargul Swamp Forest',
                    '20'=>'River Kwai with Death Railway in Kanchanaburi - Bangkok Thailand',
                    '21'=>'Spectacular South Island with Sydney',
                    '22'=>'St. Martin-s Island Tours',
                    '23'=>'Sundarban River Cruise',
                    '24'=>'The Heart of China &amp; The Yangtze River with Bangkok',
                    '25'=>'The Original London Sightseeing Tour  Hop-on Hop-off',
                    '26'=>'Vatican Museums Walking Tour including Sistine Chapel, Raphael',
                    
                ],
            ],
        ]);  
        /**
         * Tour Code
         * 
         */
        $this->add([
            'name' => 'tour_code',
            'type' => Text::class,
            'attributes' => [
                'id' => 'tour-code',                 
                'class' => 'form-control'
            ],
            'options' => [
                'label' => 'Tour Code<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        /**
         * No. of Nights
         * 
         */
        $this->add([
            'name' => 'number_of_nights',
             'type' => Text::class,
            'attributes' => [
                'id' => 'number-of-nights',                 
                'class' => 'form-control'
            ],
            'options' => [
                'label' => 'No. of Nights<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        /**
         * 
         * No. of Days
         */
        $this->add([
            'name' => 'number_of_days',
            'type' => Text::class,
            'attributes' => [
                'id' => 'number-of-days',                 
                'class' => 'form-control'
            ],
            'options' => [
                'label' => 'No. of Days<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         * 
         * Rating(s)
         */
        $this->add([
            'name' => 'rating',
            'type' => Text::class,
            'attributes' => [
                'id' => 'rating',                 
                'class' => 'form-control'
            ],
            'options' => [
                'label' => 'Rating(s)<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        /**
         * 
         * Select Related Tours
         */
        $this->add([
            'name' => 'related_tours',
             'type' => Textarea::class,
            'attributes' => [
                'id' => 'related-tours',                 
                'class' => 'form-control'
            ],
            'options' => [
                'label' => 'Select Related Tours<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        /**
         * 
         * Short Overview
         */
        $this->add([
            'name' => 'short_overview',
            'type' => Textarea::class,
            'attributes' => [
                'id' => 'short-overview',                
                'class' => 'form-control'                
            ],
            'options' => [
                'label' => 'Short Overview<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        /**
         * Meta Information
         * Meta Title
         */
        $this->add([
            'name' => 'meta_title',
            'type' => Text::class,
            'attributes' => [
                'id' => 'meta-title',                 
                'class' => 'form-control'                
            ],
            'options' => [
                'label' => 'Meta Title<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        /**
         * 
         * Meta Keywords
         */
        $this->add([
            'name' => 'meta_keywords',
            'type' => Text::class,
            'attributes' => [
                'id' => 'meta-keywords',                
                'class' => 'form-control'                
            ],
            'options' => [
                'label' => 'Meta Keywords<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        
        /**
         * 
         * Destination State
         */
        $this->add([
            'name' => 'destination_state',
             'type' => Select::class,
            'attributes' => [
                'id' => 'destination-state',
                'class' => 'form-control'                
            ],
            'options' => [
                'label' => 'Destination State<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
       
        
       
        
        /**
         * Tour Location
         * Search Location
         */
        $this->add([
            'name' => 'search_location',
             'type' => Text::class,
            'attributes' => [
                'id' => 'search-location',
                'class' => 'form-control'                
            ],
            'options' => [
                'label' => 'Search Location<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        /**
         * 
         * Latitude
         */
        $this->add([
            'name' => 'latitude',
             'type' => Text::class,
            'attributes' => [
                'id' => 'latitude',
                'class' => 'form-control'                
            ],
            'options' => [
                'label' => 'Latitude<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        /**
         * 
         * Longitude
         */
        $this->add([
            'name' => 'longitude',
             'type' => Text::class,
            'attributes' => [
                'id' => 'longitude',
                'class' => 'form-control'                
            ],
            'options' => [
                'label' => 'Longitude<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
       
        
        /**
         * 
         * Visiting Cities
         */
        $this->add([
            'name' => 'visiting_city',
             'type' => Text::class,
            'attributes' => [
                'id' => 'visiting-city',
                'class' => 'form-control'                
            ],
            'options' => [
                'label' => 'Visiting Cities<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        /**
         * 
         * Visiting Cities
         */
        $this->add([
            'name' => 'hotel_city',
             'type' => Text::class,
            'attributes' => [
                'id' => 'hotel-city',
                'class' => 'form-control'                
            ],
            'options' => [
                'label' => 'Visiting Cities<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        /**
         * 
         * Schedules / Operating
         */
        $this->add([
            'name' => 'schedules',
             'type' => Text::class,
            'attributes' => [
                'id' => 'schedules',
                'class' => 'form-control'                
            ],
            'options' => [
                'label' => 'Schedules / Operating<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        /**
         * 
         * Sightseeing
         */
        $this->add([
            'name' => 'sightseeing',
             'type' => Text::class,
            'attributes' => [
                'id' => 'sightseeing',
                'class' => 'form-control'                
            ],
            'options' => [
                'label' => 'Sightseeing<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        /**
         * 
         * Number of Accommodates
         */
        $this->add([
            'name' => 'number_of_accommodates',
            'type' => Text::class,
            'attributes' => [
                'id' => 'number-of-accommodates',
                'class' => 'form-control'                
            ],
            'options' => [
                'label' => 'Number of Accommodates<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        /**
         * 
         * Multilingual guide tape
         */
        $this->add([
            'name' => 'multilingual_guide_tape',
            'type' => Text::class,
            'attributes' => [
                'id' => 'multilingual-guide-tape',
                'class' => 'form-control'                
            ],
            'options' => [
                'label' => 'Multilingual guide tape<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        /**
         * 
         * Pick-up service
         */
        $this->add([
            'name' => 'pickup_service',
            'type' => Text::class,
            'attributes' => [
                'id' => 'pickup-service',
                'class' => 'form-control'                
            ],
            'options' => [
                'label' => 'Pick-up service<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        /**
         * 
         * Supplementary Room addon facilities
         */
        $this->add([
            'name' => 'addon_facility',
            'type' => Text::class,
            'attributes' => [
                'id' => 'addon-facility',
                'class' => 'form-control'                
            ],
            'options' => [
                'label' => 'Supplementary Room addon facilities<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        /**
         * 
         * Drop-off service
         */
        $this->add([
            'name' => 'drop_of_service',
            'type' => Text::class,
            'attributes' => [
                'id' => 'drop-of-service',
                'class' => 'form-control'                
            ],
            'options' => [
                'label' => 'Drop-off service<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        /**
         * 
         * Entertainment
         */
        $this->add([
            'name' => 'entertainment',
            'type' => Text::class,
            'attributes' => [
                'id' => 'entertainment',
                'class' => 'form-control'                
            ],
            'options' => [
                'label' => 'Entertainment<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true,]
            ],
        ]);
        
        /**
         * 
         * View | Location Type
         */
        $this->add([
            'name' => 'location_type',
            'type' => Text::class,
            'attributes' => [
                'id' => 'location-type',
                'class' => 'form-control'                
            ],
            'options' => [
                'label' => 'View | Location Type<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        /**
         * 
         * Transportation1
         */
        $this->add([
            'name' => 'transportation1',
            'type' => Text::class,
            'attributes' => [
                'id' => 'transportation1',
                'class' => 'form-control'                
            ],
            'options' => [
                'label' => 'Transportation1<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        /**
         * Tour Inclusions
         * Airport Transfers
         */
        $this->add([
            'name' => 'airport_transfer',
            'type' => Checkbox::class,
            'attributes' => [
                'id' => 'airport-transfer',
                'class' => 'form-control'                
            ],
            'options' => [
                'label' => 'Airport Transfers<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        /**
         * 
         * Boat Transfers
         */
        $this->add([
            'name' => 'boat_transfer',
            'type' => Checkbox::class,
            'attributes' => [
                'id' => 'boat-transfer',
                'class' => 'form-control'                
            ],
            'options' => [
                'label' => 'Boat Transfers<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        /**
         * 
         * Children allowed (all ages)
         */
        $this->add([
            'name' => 'children_allowed',
            'type' => Checkbox::class,
            'attributes' => [
                'id' => 'children-allowed',
                'class' => 'form-control'                
            ],
            'options' => [
                'label' => 'Children allowed (all ages)<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        /**
         * 
         * Eco-Tour Fee
         */
        $this->add([
            'name' => 'eco_tour_fee',
            'type' => Checkbox::class,
            'attributes' => [
                'id' => 'eco-tour-fee',
                'class' => 'form-control'                
            ],
            'options' => [
                'label' => 'Eco-Tour Fee<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
       
        
        /**
         * 
         * Full Board Mills(Breakfast, Lunch, Dinner)
         */
        $this->add([
            'name' => 'meals',
            'type' => Checkbox::class,
            'attributes' => [
                'id' => 'meals',
                'class' => 'form-control'                
            ],
            'options' => [
                'label' => 'Full Board Mills(Breakfast, Lunch, Dinner)<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        //******Cost Includes******
        /**
         * 
         * Tax Included
         */
    $this->add([
    'type' => Checkbox::class,
    'name' => 'tax_included',
    'attributes' => [
    'id' => 'tax-included',
    'class' => 'form-control',
    'checked'=>'checked',
     'value' => 'yes',
     ],
        
     'options' => [
     'label' => 'Test checkbox',
     'use_hidden_element' => false,
     'checked_value' => 'yes',
     'unchecked_value' => 'no',
    ]
    
     ]);
    
    /**
         * 
         * Children allowed
         */
    $this->add([
    'type' => Checkbox::class,
    'name' => 'children_allowed',
    'attributes' => [
    'id' => 'Children-allowed',
    'class' => 'form-control',
    'checked'=>'checked',
     'value' => 'yes',
     ],
        
     'options' => [
     'label' => 'Test checkbox',
     'use_hidden_element' => false,
     'checked_value' => 'yes',
     'unchecked_value' => 'no',
    ]
    
     ]);
     /**
         * 
         * Eco-Tour Fee
         */
    $this->add([
    'type' => Checkbox::class,
    'name' => 'eco_tour_fee',
    'attributes' => [
    'id' => 'eco-tour-fee',
    'class' => 'form-control',
    'checked'=>'checked',
     'value' => 'yes',
     ],
        
     'options' => [
     'label' => 'Test checkbox',
     'use_hidden_element' => false,
     'checked_value' => 'yes',
     'unchecked_value' => 'no',
    ]
    
     ]);
    
    /**
         * 
         * Boat Transfers
         */
    $this->add([
    'type' => Checkbox::class,
    'name' => 'boat_transfers',
    'attributes' => [
    'id' => 'boat-transfers',
    'class' => 'form-control',
    'checked'=>'checked',
     'value' => 'yes',
     ],
        
     'options' => [
     'label' => 'Test checkbox',
     'use_hidden_element' => false,
     'checked_value' => 'yes',
     'unchecked_value' => 'no',
    ]
    
     ]);
    
    /**
         * 
         * Airport Transfers
         */
    $this->add([
    'type' => Checkbox::class,
    'name' => 'airport_transfers',
    'attributes' => [
    'id' => 'airport-transfers',
    'class' => 'form-control',
    'checked'=>'checked',
     'value' => 'yes',
     ],
        
     'options' => [
     'label' => 'Test checkbox',
     'use_hidden_element' => false,
     'checked_value' => 'yes',
     'unchecked_value' => 'no',
    ]
    
     ]);
     
    /**
         * 
         * Tour guides - multilingual
         */
    $this->add([
    'type' => Checkbox::class,
    'name' => 'tour_guide_multilingual',
    'attributes' => [
    'id' => 'tour-guide-multilingual',
    'class' => 'form-control',
    'checked'=>'checked',
     'value' => 'yes',
     ],
        
     'options' => [
     'label' => 'Test checkbox',
     'use_hidden_element' => false,
     'checked_value' => 'yes',
     'unchecked_value' => 'no',
    ]
    
     ]);
     /**
         * 
         * Full Board Meals (Breakfast, Lunch, Dinner)
         */
    $this->add([
    'type' => Checkbox::class,
    'name' => 'full_board_meals',
    'attributes' => [
    'id' => 'full-board-meals',
    'class' => 'form-control',
    'checked'=>'checked',
     'value' => 'yes',
     ],
        
     'options' => [
     'label' => 'Test checkbox',
     'use_hidden_element' => false,
     'checked_value' => 'yes',
     'unchecked_value' => 'no',
    ]
    
     ]);
        //**************** End ************
    
  //******Cost Includes******
        /**
         * 
         * Tax Included
         */
    $this->add([
    'type' => Checkbox::class,
    'name' => 'ex_tax_included',
    'attributes' => [
    'id' => 'ex-tax-included',
    'class' => 'form-control',
    'checked'=>'checked',
     'value' => 'yes',
     ],
        
     'options' => [
     'label' => 'Test checkbox',
     'use_hidden_element' => false,
     'checked_value' => 'yes',
     'unchecked_value' => 'no',
    ]
    
     ]);
    
    /**
         * 
         * Children allowed
         */
    $this->add([
    'type' => Checkbox::class,
    'name' => 'ex_children_allowed',
    'attributes' => [
    'id' => 'ex-Children-allowed',
    'class' => 'form-control',
    'checked'=>'checked',
     'value' => 'yes',
     ],
        
     'options' => [
     'label' => 'Test checkbox',
     'use_hidden_element' => false,
     'checked_value' => 'yes',
     'unchecked_value' => 'no',
    ]
    
     ]);
     /**
         * 
         * Eco-Tour Fee
         */
    $this->add([
    'type' => Checkbox::class,
    'name' => 'ex_eco_tour_fee',
    'attributes' => [
    'id' => 'ex-eco-tour-fee',
    'class' => 'form-control',
    'checked'=>'checked',
     'value' => 'yes',
     ],
        
     'options' => [
     'label' => 'Test checkbox',
     'use_hidden_element' => false,
     'checked_value' => 'yes',
     'unchecked_value' => 'no',
    ]
    
     ]);
    
    /**
         * 
         * Boat Transfers
         */
    $this->add([
    'type' => Checkbox::class,
    'name' => 'ex_boat_transfers',
    'attributes' => [
    'id' => 'ex-boat-transfers',
    'class' => 'form-control',
    'checked'=>'checked',
     'value' => 'yes',
     ],
        
     'options' => [
     'label' => 'Test checkbox',
     'use_hidden_element' => false,
     'checked_value' => 'yes',
     'unchecked_value' => 'no',
    ]
    
     ]);
    
    /**
         * 
         * Airport Transfers
         */
    $this->add([
    'type' => Checkbox::class,
    'name' => 'ex_airport_transfers',
    'attributes' => [
    'id' => 'ex-airport-transfers',
    'class' => 'form-control',
    'checked'=>'checked',
     'value' => 'yes',
     ],
        
     'options' => [
     'label' => 'Test checkbox',
     'use_hidden_element' => false,
     'checked_value' => 'yes',
     'unchecked_value' => 'no',
    ]
    
     ]);
     
    /**
         * 
         * Tour guides - multilingual
         */
    $this->add([
    'type' => Checkbox::class,
    'name' => 'ex_tour_guide_multilingual',
    'attributes' => [
    'id' => 'ex-tour-guide-multilingual',
    'class' => 'form-control',
    'checked'=>'checked',
     'value' => 'yes',
     ],
        
     'options' => [
     'label' => 'Test checkbox',
     'use_hidden_element' => false,
     'checked_value' => 'yes',
     'unchecked_value' => 'no',
    ]
    
     ]);
     /**
         * 
         * Full Board Meals (Breakfast, Lunch, Dinner)
         */
    $this->add([
    'type' => Checkbox::class,
    'name' => 'ex_full_board_meals',
    'attributes' => [
    'id' => 'ex-full-board-meals',
    'class' => 'form-control',
    'checked'=>'checked',
     'value' => 'yes',
     ],
        
     'options' => [
     'label' => 'Test checkbox',
     'use_hidden_element' => false,
     'checked_value' => 'yes',
     'unchecked_value' => 'no',
    ]
    
     ]);
    
    
        /**
         * 
         * Tour guides-accredited
         */
        $this->add([
            'name' => 'tour_guides_accredited',
            'type' => Checkbox::class,
            'attributes' => [
                'id' => 'tour-guides-accredited',
                'class' => 'form-control'                
            ],
            'options' => [
                'label' => 'Tour guides-accredited<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        /**
         * 
         * Tour guides-multilingual
         */
        $this->add([
            'name' => 'tour_guides_multilingual',
            'type' => Checkbox::class,
            'attributes' => [
                'id' => 'tour-guides-multilingual',
                'class' => 'form-control'                
            ],
            'options' => [
                'label' => 'Tour guides-multilingual<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        /**
         * Price & Payment Info Tab
         * Currency Locale
         */
        $this->add([
            'name' => 'currency_locale',
            'type' => Select::class,
            'attributes' => [
                'id' => 'currency-locale',
                'class' => 'form-control'                
            ],
            'options' => [
                'label' => 'Currency Locale<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        /**
         * 
         * Adult Price
         */
        $this->add([
            'name' => 'adult_price',
            'type' => Text::class,
            'attributes' => [
                'id' => 'adult-price',
                'class' => 'form-control'                
            ],
            'options' => [
                'label' => 'Adult Price<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        /**
         * 
         * Costs of Children
         */
        $this->add([
            'name' => 'cost_of_children',
            'type' => Text::class,
            'attributes' => [
                'id' => 'cost-of-children',
                'class' => 'form-control'                
            ],
            'options' => [
                'label' => 'Costs of Children<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        /**
         * 
         * Infant Price
         */
        $this->add([
            'name' => 'cost_of_infant',
            'type' => Text::class,
            'attributes' => [
                'id' => 'cost-of-infant',
                'class' => 'form-control'                
            ],
            'options' => [
                'label' => 'Infant Price<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        /**
         * 
         * Price Type
         */
        $this->add([
            'name' => 'price_type',
            'type' => Select::class,
            'attributes' => [
                'id' => 'price-type',
                'class' => 'form-control'                
            ],
            'options' => [
                'label' => 'Price Type<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        /**
         * 
         * Payment Description
         */
        $this->add([
            'name' => 'payment_description',
            'type' => Textarea::class,
            'attributes' => [
                'id' => 'payment-description',
                'class' => 'form-control'                
            ],
            'options' => [
                'label' => 'Payment Description<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        /**
         * Terms and Policies Tab
         * Tour Highlights
         */
        $this->add([
            'name' => 'tour_highlights',
            'type' => Textarea::class,
            'attributes' => [
                'id' => 'tour-highlights',
                'class' => 'form-control'                
            ],
            'options' => [
                'label' => 'Tour Highlights<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        /**
         * Information of Availabilities
         * Tour Highlights
         */
        $this->add([
            'name' => 'google_map',
            'type' => Textarea::class,
            'attributes' => [
                'id' => 'google-map',
                'class' => 'form-control'                
            ],
            'options' => [
                'label' => 'Tour Highlights<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        /**
         * Information of Availabilities
         * Tour Highlights
         */
        $this->add([
            'name' => 'tour_highlights2',
            'text' => Textarea::class,
            'attributes' => [
                'id' => 'tour-highlights',
                'class' => 'form-control'                
            ],
            'options' => [
                'label' => 'Tour Highlights<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        /**
         * 
         * Cost Excludes
         */
        $this->add([
            'name' => 'cost_excludes',
            'type' => Textarea::class,
            'attributes' => [
                'id' => 'cost-excludes',
                'class' => 'form-control'                
            ],
            'options' => [
                'label' => 'Cost Excludes<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        /**
         * 
         * Tours Policy
         */
        $this->add([
            'name' => 'tours_policy',
            'type' => Textarea::class,
            'attributes' => [
                'id' => 'tours-policy',
                'class' => 'form-control'                
            ],
            'options' => [
                'label' => 'Tours Policy<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        /**
         * 
         * Terms and condition
         */
        $this->add([
            'name' => 'terms_and_condition',
            'type' => Textarea::class,
            'attributes' => [
                'id' => 'terms-and-condition',
                'class' => 'form-control'                
            ],
            'options' => [
                'label' => 'Terms and condition<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         * 
         * Save
         */
        $this->add([
            'name' => 'submit',
            'type' => Submit::class,
            'attributes' => [
                'value' => 'Save',
                'id' => 'submit-button',
                'class' => 'btn btn-primary btn-lg',
            ],
        ]);        
    
    
    //----------Itinerary Information--------------
    
    
         /**
         * 
         * Visiting  City
         */ 
        
         $this->add([
            'name' => 'city_introduction',
             'type' => Select::class,
              'attributes' => [
                'id' => 'city-introduction',
                'class' => 'form-control',
                'data-show-subtext'=>true,
               'data-live-search'=>true,
               // 'style'=>'display: none'
            ],
            'options' => [
                'disable_inarray_validator' => true,
                'empty_option' => ' -- Select City -- ',
                'value_options' => [
                    '1' => 'Delhi',
                    '2' => 'Mumbai',
                    '3' => 'Agra'
                    
                    
                ],
            ],
        ]);
         
         /**
         * 
         * Introduction Detail
         */ 
         
         $this->add([
            'name' => 'introduction_detail',
             'type' => Textarea::class,
              'attributes' => [
                'id' => 'introduction-detail',
                'class' => 'form-control',
                'data-show-subtext'=>true,
               'data-live-search'=>true,
               // 'style'=>'display: none'
            ],
            
        ]);
         
         /**
         * 
         * Itinerary Title
         */ 
         
         $this->add([
            'name' => 'itinerary_title',
             'type' => Text::class,
              'attributes' => [
                'id' => 'itinerary-title',
                'class' => 'form-control',
                'data-show-subtext'=>true,
               'data-live-search'=>true,
               // 'style'=>'display: none'
            ],
            
        ]);
         
          /**
         * 
         * Detailed Itinerary
         */ 
         
         $this->add([
            'name' => 'detailed_itinerary',
             'type' => Textarea::class,
              'attributes' => [
                'id' => 'detailed-itinerary',
                'class' => 'form-control',
                'data-show-subtext'=>true,
               'data-live-search'=>true,
                //'style'=>'display: none'
            ],
            
        ]);
         
         //-----------Select Hotel ------------
         
         /**
         * 
         * Standard Hotel
         */ 
         
         $this->add([
            'name' => 'standard_hotel',
             'type' => Select::class,
              'attributes' => [
                'id' => 'standard-hotel',
                'class' => 'demo-default select-state selectized form-control',
                'data-show-subtext'=>true,
               'data-live-search'=>true,
              // 'style'=>'display: none'
            ],
             'options' => [
                'disable_inarray_validator' => true,
                'empty_option' => ' -- Select Hotel -- ',
                'value_options' => [
                    '1' => 'Hyatt',
                    '2' => 'The Leela Palace',
                    '3' => 'The Oberoi',
                    
                    
                ],
            ],
        ]);
            
          /**
         * 
         *  Standard Room
         */ 
         
         $this->add([
            'name' => 'standard_room',
             'type' => Select::class,
              'attributes' => [
                'id' => 'standard-room',
                'class' => 'selectpicker form-control',
                'data-show-subtext'=>true,
               'data-live-search'=>true,
              // 'style'=>'display: none'
            ],
             'options' => [
                'disable_inarray_validator' => true,
                'empty_option' => ' -- Select Room -- ',
                'value_options' => [
                    '1' => 'Twin Room',
                    '2' => 'Duble Room',
                    '3' => 'Single Room',
                    
                    
                ],
            ],
        ]);
            
         
          /**
         * 
         * Standard Meal plan Type 
         */ 
         
         $this->add([
            'name' => 'standard_mealplan_type',
             'type' => Select::class,
              'attributes' => [
                'id' => 'standard-mealplan-type',
                'class' => 'selectpicker form-control',
                'data-show-subtext'=>true,
               'data-live-search'=>true,
              // 'style'=>'display: none'
            ],
             'options' => [
                'disable_inarray_validator' => true,
                'empty_option' => ' -- Select Meal Plan type -- ',
                'value_options' => [
                    '1' => 'CP',
                    '2' => 'MP',
                    '3' => 'AP',
                    
                    
                ],
            ],
        ]);
         
         /**
         * 
         * Deluxe Hotel
         */ 
         
         $this->add([
            'name' => 'deluxe_hotel',
             'type' => Select::class,
              'attributes' => [
                'id' => 'deluxe-hotel',
                'class' => 'demo-default select-state selectized form-control',
                'data-show-subtext'=>true,
               'data-live-search'=>true,
              // 'style'=>'display: none'
            ],
             'options' => [
                'disable_inarray_validator' => true,
                'empty_option' => ' -- Select Hotel -- ',
                'value_options' => [
                    '1' => 'Hyatt',
                    '2' => 'The Leela Palace',
                    '3' => 'The Oberoi',
                    
                    
                ],
            ],
        ]);
            
          /**
         * 
         *  Deluxe Room
         */ 
         
         $this->add([
            'name' => 'deluxe_room',
             'type' => Select::class,
              'attributes' => [
                'id' => 'deluxe-room',
                'class' => 'selectpicker form-control',
                'data-show-subtext'=>true,
               'data-live-search'=>true,
              // 'style'=>'display: none'
            ],
             'options' => [
                'disable_inarray_validator' => true,
                'empty_option' => ' -- Select Room -- ',
                'value_options' => [
                    '1' => 'Twin Room',
                    '2' => 'Duble Room',
                    '3' => 'Single Room',
                    
                    
                ],
            ],
        ]);
            
         
          /**
         * 
         *   Deluxe Meal plan Type 
         */ 
         
         $this->add([
            'name' => 'deluxe_mealplan_type',
             'type' => Select::class,
              'attributes' => [
                'id' => 'deluxe-mealplan-type',
                'class' => 'selectpicker form-control',
                'data-show-subtext'=>true,
               'data-live-search'=>true,
              // 'style'=>'display: none'
            ],
             'options' => [
                'disable_inarray_validator' => true,
                'empty_option' => ' -- Select Meal Plan type -- ',
                'value_options' => [
                    '1' => 'CP',
                    '2' => 'MP',
                    '3' => 'AP',
                    
                    
                ],
            ],
        ]);
         
          /**
         * 
         * Luxury Hotel
         */ 
         
         $this->add([
            'name' => 'luxury_hotel',
             'type' => Select::class,
              'attributes' => [
                'id' => 'luxury-hotel',
                'class' => 'demo-default select-state selectized form-control',
                'data-show-subtext'=>true,
               'data-live-search'=>true,
              // 'style'=>'display: none'
            ],
             'options' => [
                'disable_inarray_validator' => true,
                'empty_option' => ' -- Select Hotel -- ',
                'value_options' => [
                    '1' => 'Hyatt',
                    '2' => 'The Leela Palace',
                    '3' => 'The Oberoi',
                    
                    
                ],
            ],
        ]);
            
          /**
         * 
         *  Luxury Room
         */ 
         
         $this->add([
            'name' => 'luxury_room',
             'type' => Select::class,
              'attributes' => [
                'id' => 'luxury-room',
                'class' => 'selectpicker form-control',
                'data-show-subtext'=>true,
               'data-live-search'=>true,
              // 'style'=>'display: none'
            ],
             'options' => [
                'disable_inarray_validator' => true,
                'empty_option' => ' -- Select Room -- ',
                'value_options' => [
                    '1' => 'Twin Room',
                    '2' => 'Duble Room',
                    '3' => 'Single Room',
                    
                    
                ],
            ],
        ]);
            
         
          /**
         * 
         *   Luxury Meal plan Type 
         */ 
         
         $this->add([
            'name' => 'luxury_mealplan_type',
             'type' => Select::class,
              'attributes' => [
                'id' => 'luxury-mealplan-type',
                'class' => 'selectpicker form-control',
                'data-show-subtext'=>true,
               'data-live-search'=>true,
              // 'style'=>'display: none'
            ],
             'options' => [
                'disable_inarray_validator' => true,
                'empty_option' => ' -- Select Meal Plan type -- ',
                'value_options' => [
                    '1' => 'CP',
                    '2' => 'MP',
                    '3' => 'AP',
                    
                    
                ],
            ],
        ]);
         
     //-------------------Price and Payment information-------------------------
         
         
         /**
         * 
         * Detailed Itinerary
         */ 
         
         $this->add([
            'name' => 'markup_amount',
             'type' => Text::class,
              'attributes' => [
                'id' => 'markup_amount',
                'class' => 'form-control',
                'data-show-subtext'=>true,
               'data-live-search'=>true,
                //'style'=>'display: none'
            ],
            
        ]);    
         
         
         /**
         * 
         * Tour Category
         */ 
         
//          $this->add([
//            'name' => 'tour_category',
//             'type' => Select::class,
//              'attributes' => [
//                'id' => 'tour-category',
//                'class' => 'form-control',
//                'data-show-subtext'=>true,
//               'data-live-search'=>true,
//               // 'style'=>'display: none'
//            ],
//            'options' => [
//                'disable_inarray_validator' => true,
//                'empty_option' => ' -- Select City -- ',
//                'value_options' => [
//                    '1' => 'Delhi',
//                    '2' => 'Mumbai',
//                    '3' => 'Agra'
//                    
//                    
//                ],
//            ],
//        ]);
          
          
          
         /**
         * 
         * Hotel Category
         */ 
         
          $this->add([
            'name' => 'hotel_category',
             'type' => Select::class,
              'attributes' => [
                'id' => 'hotel-category',
                'class' => 'form-control',
                'data-show-subtext'=>true,
               'data-live-search'=>true,
               // 'style'=>'display: none'
            ],
            'options' => [
                'disable_inarray_validator' => true,
                'empty_option' => ' -- Select Hotel Categories -- ',
                'value_options' => [
                    '1' => '2 Star',
                    '2' => '4 Star',
                    '3' => '5 Star'
                    
                    
                ],
            ],
        ]);
          
            
         /**
         * 
         * Hotel
         */ 
         
          $this->add([
            'name' => 'tour_hotel1',
             'type' => Select::class,
              'attributes' => [
                'id' => 'tour-hotel1',
                'class' => 'demo-default select-state selectized form-control',
                'data-show-subtext'=>true,
               'data-live-search'=>true,
               // 'style'=>'display: none'
            ],
            'options' => [
                'disable_inarray_validator' => true,
                'empty_option' => ' -- Select Hotel -- ',
                'value_options' => [
                    '1' => 'Hyatt',
                    '2' => 'The Leela Palace',
                    '3' => 'The Oberoi'
                    
                    
                ],
            ],
        ]);
          
          /**
         * 
         * Room Category
         */ 
         
          $this->add([
            'name' => 'room_category',
             'type' => Select::class,
              'attributes' => [
                'id' => 'room-category',
                'class' => 'form-control',
                'data-show-subtext'=>true,
               'data-live-search'=>true,
               // 'style'=>'display: none'
            ],
            'options' => [
                'disable_inarray_validator' => true,
                'empty_option' => ' -- Select Room Category -- ',
                'value_options' => [
                    '1' => 'Standered',
                    '2' => 'Delux',
                    '3' => 'Luxury'
                    
                    
                ],
            ],
        ]);
          
          
           
         /**
         * 
         *Number Of Night
         */ 
         
         $this->add([
            'name' => 'no_of_night',
             'type' => Text::class,
              'attributes' => [
                'id' => 'no-of-night',
                'class' => 'form-control',
                'data-show-subtext'=>true,
               'data-live-search'=>true,
                //'style'=>'display: none'
            ],
            
        ]);  
         
           
         /**
         * 
         *Single
         */ 
         
         $this->add([
            'name' => 'single',
             'type' => Text::class,
              'attributes' => [
                'id' => 'single',
                'class' => 'form-control',
                'data-show-subtext'=>true,
               'data-live-search'=>true,
                //'style'=>'display: none'
            ],
            
        ]); 
         
            
         /**
         * 
         *Twin Sharing
         */ 
         
         $this->add([
            'name' => 'twin_sharing',
             'type' => Text::class,
              'attributes' => [
                'id' => 'twin-sharing',
                'class' => 'form-control',
                'data-show-subtext'=>true,
               'data-live-search'=>true,
                //'style'=>'display: none'
            ],
            
        ]); 
         
         /**
         * 
         *Extra bed
         */ 
         
         $this->add([
            'name' => 'extra_bed',
             'type' => Text::class,
              'attributes' => [
                'id' => 'extra-bed',
                'class' => 'form-control',
                'data-show-subtext'=>true,
               'data-live-search'=>true,
                //'style'=>'display: none'
            ],
            
        ]);  
         /**
         * 
         *Child no bed
         */ 
         
         $this->add([
            'name' => 'child_no_bed',
             'type' => Text::class,
              'attributes' => [
                'id' => 'child-no-bed',
                'class' => 'form-control',
                'data-show-subtext'=>true,
               'data-live-search'=>true,
                //'style'=>'display: none'
            ],
            
        ]); 
         
         /**
         * 
         *Transport Type Vehicle Type
         */ 
         
         $this->add([
            'name' => 'transport_vehicle_type',
             'type' => Text::class,
              'attributes' => [
                'id' => 'transport-vehicle-type',
                'class' => 'form-control',
                'data-show-subtext'=>true,
               'data-live-search'=>true,
                //'style'=>'display: none'
            ],
            
        ]);  
         
        
          
         /**
         * 
         *Transport Service
         */ 
         
         $this->add([
            'name' => 'transport_service',
             'type' => Text::class,
              'attributes' => [
                'id' => 'transport-service',
                'class' => 'form-control',
                'data-show-subtext'=>true,
               'data-live-search'=>true,
                //'style'=>'display: none'
            ],
            
        ]); 
         
          
         /**
         * 
         *Transport City
         */ 
         
         $this->add([
            'name' => 'transport_city',
             'type' => Text::class,
              'attributes' => [
                'id' => 'transport-city',
                'class' => 'form-control',
                'data-show-subtext'=>true,
               'data-live-search'=>true,
                //'style'=>'display: none'
            ],
            
        ]);  
         
         /**
         * 
         *Transport Description
         */ 
         
         $this->add([
            'name' => 'transport_description',
             'type' => Text::class,
              'attributes' => [
                'id' => 'transport-description',
                'class' => 'form-control',
                'data-show-subtext'=>true,
               'data-live-search'=>true,
                //'style'=>'display: none'
            ],
            
        ]);  
         
          /**
         * 
         *Transport Cost
         */ 
         
         $this->add([
            'name' => 'transport_cost',
             'type' => Text::class,
              'attributes' => [
                'id' => 'transport-cost',
                'class' => 'form-control',
                'data-show-subtext'=>true,
               'data-live-search'=>true,
                //'style'=>'display: none'
            ],
            
        ]); 
          
          /**
         * 
         *Transport Markup
         */ 
         
         $this->add([
            'name' => 'transport_markup',
             'type' => Text::class,
              'attributes' => [
                'id' => 'transport-markup',
                'class' => 'form-control',
                'data-show-subtext'=>true,
               'data-live-search'=>true,
                //'style'=>'display: none'
            ],
            
        ]); 
         
          /**
         * 
         * Sightseeing Duration
         */ 
         
         $this->add([
            'name' => 'sightseeing_duration',
             'type' => Text::class,
              'attributes' => [
                'id' => 'sightseeing-duration',
                'class' => 'form-control',
                'data-show-subtext'=>true,
               'data-live-search'=>true,
                //'style'=>'display: none'
            ],
            
        ]); 
         
          /**
         * 
         * Sightseeing description
         */ 
         
         $this->add([
            'name' => 'sightseeing_descrpition',
             'type' => Text::class,
              'attributes' => [
                'id' => 'sightseeing-descrpition',
                'class' => 'form-control',
                'data-show-subtext'=>true,
               'data-live-search'=>true,
                //'style'=>'display: none'
            ],
            
        ]); 
         
          /**
         * 
         * Sightseeing Adult Price
         */ 
         
         $this->add([
            'name' => 'sightseeing_adult_price',
             'type' => Text::class,
              'attributes' => [
                'id' => 'sightseeing-adult-price',
                'class' => 'form-control',
                'data-show-subtext'=>true,
               'data-live-search'=>true,
                //'style'=>'display: none'
            ],
            
        ]); 
         
         
          /**
         * 
         * Sightseeing Child Price
         */ 
         
         $this->add([
            'name' => 'sightseeing_child_price',
             'type' => Text::class,
              'attributes' => [
                'id' => 'sightseeing-child-price',
                'class' => 'form-control',
                'data-show-subtext'=>true,
               'data-live-search'=>true,
                //'style'=>'display: none'
            ],
            
        ]); 
         
          /**
         * 
         * Sightseeing Markup
         */ 
         
         $this->add([
            'name' => 'sightseeing_markup',
             'type' => Text::class,
              'attributes' => [
                'id' => 'sightseeing-markup',
                'class' => 'form-control',
                'data-show-subtext'=>true,
               'data-live-search'=>true,
                //'style'=>'display: none'
            ],
            
        ]); 
         
         
            /**
         * 
         * From Sector
         */ 
         
         $this->add([
            'name' => 'from_sector',
             'type' => Text::class,
              'attributes' => [
                'id' => 'from-sector',
                'class' => 'form-control',
                'data-show-subtext'=>true,
               'data-live-search'=>true,
                //'style'=>'display: none'
            ],
            
        ]); 
         
         /**
         * 
         * To Sector
         */ 
         
         $this->add([
            'name' => 'to_sector',
             'type' => Text::class,
              'attributes' => [
                'id' => 'to-sector',
                'class' => 'form-control',
                'data-show-subtext'=>true,
               'data-live-search'=>true,
                //'style'=>'display: none'
            ],
            
        ]); 
         
         /* 
         *  Airline
         */ 
         
         $this->add([
            'name' => 'airline',
             'type' => Text::class,
              'attributes' => [
                'id' => 'airline',
                'class' => 'form-control',
                'data-show-subtext'=>true,
               'data-live-search'=>true,
                //'style'=>'display: none'
            ],
            
        ]); 
         
          /* 
         *  Sector Description
         */ 
         
         $this->add([
            'name' => 'sector_description',
             'type' => Text::class,
              'attributes' => [
                'id' => 'sector-description',
                'class' => 'form-control',
                'data-show-subtext'=>true,
               'data-live-search'=>true,
                //'style'=>'display: none'
            ],
            
        ]); 
         
           /* 
         *  Adult price
         */ 
         
         $this->add([
            'name' => 'adult_price',
             'type' => Text::class,
              'attributes' => [
                'id' => 'adult-price',
                'class' => 'form-control',
                'data-show-subtext'=>true,
               'data-live-search'=>true,
                //'style'=>'display: none'
            ],
            
        ]); 
         
         
           /* 
         *  Child price
         */ 
         
         $this->add([
            'name' => 'child_price',
             'type' => Text::class,
              'attributes' => [
                'id' => 'child-price',
                'class' => 'form-control',
                'data-show-subtext'=>true,
               'data-live-search'=>true,
                //'style'=>'display: none'
            ],
            
        ]); 
         
           /* 
         *  Sector Markup
         */ 
         
         $this->add([
            'name' => 'Sector_markup',
             'type' => Text::class,
              'attributes' => [
                'id' => 'Sector-markup',
                'class' => 'form-control',
                'data-show-subtext'=>true,
               'data-live-search'=>true,
                //'style'=>'display: none'
            ],
            
        ]); 
     
           /* 
         *   Adult Single Cost Price
         */ 
         
         $this->add([
            'name' => 'adult_single_cost_price',
             'type' => Text::class,
              'attributes' => [
                'id' => 'adult-single-cost-price',
                'class' => 'form-control',
                'data-show-subtext'=>true,
               'data-live-search'=>true,
                //'style'=>'display: none'
            ],
            
        ]);    
         
           /* 
         *   Adult Single Cost Price
         */ 
         
         $this->add([
            'name' => 'adult_single_cost_price',
             'type' => Text::class,
              'attributes' => [
                'id' => 'adult-single-cost-price',
                'class' => 'form-control',
                'data-show-subtext'=>true,
               'data-live-search'=>true,
                //'style'=>'display: none'
            ],
            
        ]);    
         
           /* 
         *   Adult Single Cost Price
         */ 
         
         $this->add([
            'name' => 'adult_single_cost_price',
             'type' => Text::class,
              'attributes' => [
                'id' => 'adult-single-cost-price',
                'class' => 'form-control',
                'data-show-subtext'=>true,
               'data-live-search'=>true,
                //'style'=>'display: none'
            ],
            
        ]);  
         
         /* 
         *   Adult Single Selling Price
         */ 
         
         $this->add([
            'name' => 'adult_single_selling_price',
             'type' => Text::class,
              'attributes' => [
                'id' => 'adult-single-selling-price',
                'class' => 'form-control',
                'data-show-subtext'=>true,
               'data-live-search'=>true,
                //'style'=>'display: none'
            ],
            
        ]);  
         
          /* 
         *   Adult twin Shering Cost Price 
         */ 
         
         $this->add([
            'name' => 'adult_twin_shering_cost_price',
             'type' => Text::class,
              'attributes' => [
                'id' => 'adult-twin-shering-cost-price',
                'class' => 'form-control',
                'data-show-subtext'=>true,
               'data-live-search'=>true,
                //'style'=>'display: none'
            ],
            
        ]);  
         
          /* 
         *   Adult twin Shering Selling Price
         */ 
         
         $this->add([
            'name' => 'adult_twin_shering_selling_price',
             'type' => Text::class,
              'attributes' => [
                'id' => 'adult-twin-shering-selling-price',
                'class' => 'form-control',
                'data-show-subtext'=>true,
               'data-live-search'=>true,
                //'style'=>'display: none'
            ],
            
        ]);  
         
          /* 
         *   Extra bed Cost Price
         */ 
         
         $this->add([
            'name' => 'extra_bed_cost_price',
             'type' => Text::class,
              'attributes' => [
                'id' => 'extra-bed-cost-price',
                'class' => 'form-control',
                'data-show-subtext'=>true,
               'data-live-search'=>true,
                //'style'=>'display: none'
            ],
            
        ]);  
         
          /* 
         *   Extra bed Selling Price
         */ 
         
         $this->add([
            'name' => 'extra_bed_selling_price',
             'type' => Text::class,
              'attributes' => [
                'id' => 'extra-bed-selling-price',
                'class' => 'form-control',
                'data-show-subtext'=>true,
               'data-live-search'=>true,
                //'style'=>'display: none'
            ],
            
        ]);  
         
           /* 
         *   Chield No bed Cost Price
         */ 
         
         $this->add([
            'name' => 'chield_no_bed_cost_price',
             'type' => Text::class,
              'attributes' => [
                'id' => 'chield-no-bed-cost-price',
                'class' => 'form-control',
                'data-show-subtext'=>true,
               'data-live-search'=>true,
                //'style'=>'display: none'
            ],
            
        ]);   
         
          /* 
         *   Chield No bed Selling Price
         */ 
         
         $this->add([
            'name' => 'chield_no_bed_selling_price',
             'type' => Text::class,
              'attributes' => [
                'id' => 'chield-no-bed-selling-price',
                'class' => 'form-control',
                'data-show-subtext'=>true,
               'data-live-search'=>true,
                //'style'=>'display: none'
            ],
            
        ]);
         
         /**
         * 
         * Price Type
         */ 
         
          $this->add([
            'name' => 'price_type',
             'type' => Select::class,
              'attributes' => [
                'id' => 'price-type',
                'class' => 'form-control',
                'data-show-subtext'=>true,
               'data-live-search'=>true,
               // 'style'=>'display: none'
            ],
            'options' => [
                'disable_inarray_validator' => true,
                'empty_option' => ' -- Select Price Type -- ',
                'value_options' => [
                    '1' => 'Per Person',
                    '2' => 'Per Package',
                    
                    
                    
                ],
            ],
        ]);
          
          
          /* 
         *   Chield No bed Selling Price
         */ 
         
         $this->add([
            'name' => 'chield_no_bed_selling_price',
             'type' => Text::class,
              'attributes' => [
                'id' => 'chield-no-bed-selling-price',
                'class' => 'form-control',
                'data-show-subtext'=>true,
               'data-live-search'=>true,
                //'style'=>'display: none'
            ],
            
        ]);
         
          /**
         * 
         * Meta description
         */ 
         
         $this->add([
            'name' => 'meta_descrpition',
             'type' => Text::class,
              'attributes' => [
                'id' => 'meta-descrpition',
                'class' => 'form-control',
                'data-show-subtext'=>true,
               'data-live-search'=>true,
                //'style'=>'display: none'
            ],
            
        ]); 
          /**
         * 
         * Meta description
         */ 
         
         $this->add([
            'name' => 'tour_operator',
             'type' => Text::class,
              'attributes' => [
                'id' => 'tour-operator',
                'class' => 'form-control',
                'data-show-subtext'=>true,
               'data-live-search'=>true,
                //'style'=>'display: none'
            ],
            
        ]); 
          
    }
     public function getInputFilterSpecification() {
        return [     
          'tours_type' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Select Package Type'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            
     
          'destination_country' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Select Destination'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            
            
            
             'destination_city' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Select Destination'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            
            'destination_post_code' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Fill Postal Code'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
         
          'tour_name' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please  Fill Tour Name'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            
            'tours_operator' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please  Select Tour Operator'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
          
            'start_city' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please  Select Start City'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            
            'end_city' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please  Select End City'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'destination_covered' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please  Select Destination covered'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'inclusion' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please  Select Inclusion'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            
             'theme' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please  Select Theme'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
             'traveler' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please  Select Traveler'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
          
           'tour_code' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please  Provide Tour Code'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'number_of_nights' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please  Fill Number of Nights'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'number_of_days' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please  Fill Number of days'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            
            'short_desc' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please  Give short Description..'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'group_tour' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please  Give short Description..'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            
            'visiting_cities' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please  Select Visit Cities'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
             'schedules' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please  Fill Schedule Operation'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'number_of_accommodates' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please  Fill Number Of Accommodates'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'multilingual_guide_tape' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please  Multilingual Guide Yape'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'pickup_service' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Fill  Pickup Service'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'drop_of_service' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Fill Drop Off Service'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            
            'addon_facility' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Fill Addon Facility'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'entertainment' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Fill Entertainment'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
             'location_type' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Fill Location Type'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
             'hotel_city' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Fill hotel City Type'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'meta_image' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Select Images To Upload'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            
            'spots_image' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Select Images To Upload'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'related_tour_pac' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Select Tour'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            
            'meta_title' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Fill Meta Title'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'meta_keywords' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Fill Meta Keywords'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            
            
            
            ];
    

}  

}
