<?php

namespace Dashboard\Form;

use Zend\Form\Form;
use Zend\Form\Element\{Select, Date, Email, Checkbox, File, Text, Textarea, Submit, Button, Hidden};
use Zend\Validator\{
    NotEmpty,
    Digits,
    EmailAddress,
    StringLength
};
use Zend\InputFilter\InputFilterProviderInterface;


class MoreInfoForm extends Form implements InputFilterProviderInterface{
    
    public static $kyctype = [];
    public static $countryprefix = [];
    public function __construct($name = null) {


        parent::__construct('more-info-form');
        
        /**
         * Mobile no Prefix
         */
        $this->add([
            'name' => 'prefix_contact_no',
            'type' => Select::class,
            'attributes' => [
                'id' => 'prefix-contact-no',
                'class' => 'form-control',
                 'value'  => '91',
            ],
            'options' => [
                'label_options' => ['disable_html_escape' => true],
                'value_options' => self::$countryprefix,
                'disable_inarray_validator' => true,
            ],
        ]);
       
        /**
         * User Id
         */
        
           $this->add([
            'name' => 'user_id',
            'type' => Hidden::class,
            'attributes' => [
                'id' => 'user-id',
                'class' => 'form-control'
                
            ],

        ]); 
           
        /**
         * Assign Role Id
         */
           
            $this->add([
            'name' => 'assign_role_id',
            'type' => Hidden::class,
            'attributes' => [
                'id' => 'assign-role-id',
                'class' => 'form-control'
                
            ],

        ]);
            
        /**
         * Email
         */
        $this->add([
            'name' => 'email',
            'type' => Text::class,
            'attributes' => [
                'id' => 'email',
                'placeholder' => 'user@gmail.com',
                'class' => 'form-control input-border inputlowercase personalemail'
            ],
            'options' => [
                'label' => 'Email<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],

        ]);

       
        /**
         * Mobile No
         */
        $this->add([
            'name' => 'contact_no',
            'type' => Text::class,
            'attributes' => [
                'id' => 'contact-no',
                'class' => 'form-control input-border user-contact',
                'min' => 1,
                'max' => 10,
                'maxlength'=>10,
                'onkeypress'=>"return isNumber(event)"
            ],
            'options' => [
                'label' => 'Mobile No<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],

        ]);

        /**
         * Alt Contact No Prefix
         */
        $this->add([
            'name' => 'prefix_alt_contact_no',
            'type' => Text::class,
            'attributes' => [
                'id' => 'prefix-alt-contact-no',
                'value' => '+91',
                'disabled' => true,
                'class' => 'form-control'
            ],
            'options' => [
                'label' => 'Alternate Contact No.'
            ],

        ]);

        
        /**
         * Father`s Name
         */
        $this->add([
            'name' => 'father_name',
            'type' => Text::class,
            'attributes' => [
                'id' => 'father-name',
                'class' => 'form-control inputchange'
            ],
            'options' => [
                'label' => 'Father`s Name',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        /**
         * Phone Number
         */
        $this->add([
            'name' => 'landline_number',
            'type' => Text::class,
            'attributes' => [
                'id' => 'landline-number',
                'class' => 'form-control',
                'maxlength'=> 12,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => 'Landline No.',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        /**
         * Alternate Mobile Number
         */
        $this->add([
            'name' => 'alternate_mobile',
            'type' => Text::class,
            'attributes' => [
                'id' => 'alternate-mobile',
                'placeholder' => 'Alt Mobile',
                'class' => 'form-control',
                'maxlength'=> 12,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => 'Alt Mobile No.'
            ],
        ]);
        
        
         /**
         * Alternate Email
         */
        $this->add([
            'name' => 'alternate_email',
            'type' => Text::class,
            'attributes' => [
                'id' => 'alternate-email',
                'placeholder' => 'user@gmail.com',
                'class' => 'form-control input-border inputlowercase'
            ],
            'options' => [
                'label' => 'Alternate Email',
                'label_options' => ['disable_html_escape' => true]
            ],

        ]);
        
        
        /**
         * Date Of Birth
         */
        $this->add([
            'name' => 'dob',
            'type' => Text::class,
            'attributes' => [
                'id' => 'dob',
                'placeholder' => '',
                'class' => 'form-control dob',
                'readonly'=>'readonly'
            ],
            'options' => [
                'label' => 'DOB',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        /**
         * Address
         */
        $this->add([
            'name' => 'address',
            'type' => Text::class,
            'attributes' => [
                'id' => 'address',
                'placeholder' => '',
                'class' => 'form-control'
            ],
            'options' => [
                'label' => 'Address',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         * State
         */
        $this->add([
            'name' => 'state_name',
            'type' => Text::class,
            'attributes' => [
                'id' => 'state-name',
                'placeholder' => '',
                'class' => 'form-control'
            ],
            'options' => [
                'label' => 'State',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         * State Value
         */
        $this->add([
            'name' => 'state_value',
            'type' => Hidden::class,
            'attributes' => [
                'value' => '',
                'id' => 'state-value'
            ],
        ]);        
        

        /**
         * City
         */
        $this->add([
            'name' => 'city_name',
            'type' => Text::class,
            'attributes' => [
                'id' => 'city-name',
                'placeholder' => '',
                'class' => 'form-control'
            ],
            'options' => [
                'label' => 'City',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         * City Value
         */
        $this->add([
            'name' => 'city_value',
            'type' => Hidden::class,
            'attributes' => [
                'value' => '',
                'id' => 'city-value'
            ],
        ]);
        
        
        /**
         * Pin Code
         */
        $this->add([
            'name' => 'pincode',
            'type' => Text::class,
            'attributes' => [
                'id' => 'pincode',
                'placeholder' => '',
                'class' => 'form-control',
                'maxlength' => 6,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => 'Pin Code',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
         /**
         * KYC Type
         */
        $this->add([
            'name' => 'kyc_type',
            'type' => Select::class,
            'attributes' => [
                'id' => 'kyc-type',
                'placeholder' => '',
                'class' => 'form-control'
            ],
            'options' => [
                'label' => 'KYC Type',
                'label_options' => ['disable_html_escape' => true],
                'value_options' => self::$kyctype,
                'disable_inarray_validator' => true,
                'empty_option' => 'Select KYC',
            ],
        ]);

        /**
         * KYC
         */
        $this->add([
            'name' => 'kyc',
            'type' => Text::class,
            'attributes' => [
                'id' => 'kyc',
                'placeholder' => 'Adhar No./DL No.',
                'class' => 'form-control'
            ],
            'options' => [
                'label' => 'KYC',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        $this->add([
            'name' => 'submit',
            'type' => Submit::class,
            'attributes' => [
                'id' => 'add-staff-form-btn',
                'class' => 'btn btn-info',
                'value' =>'Submit'
            ],

        ]);
        
        
        $this->add([
            'name' => 'registration_type',
            'type' => Hidden::class,
            'attributes' => [
                'id' => 'registration-type',
                'class' => 'form-control',
                 'value' =>'11'
            ],
        ]);


    }

    public function getInputFilterSpecification() {
   return [       
       'father_name' => [
                'required' => false,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please enter Father Name'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],     

       'email' => [
                'required' => false,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please enter Email Id',
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ],
                    ['name' => 'EmailAddress',
                        'options' => [
                            'messages' => [
                                EmailAddress::INVALID => 'Please enter Valid Email Id',
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
           'contact_no'=>[
            'required' => false,
            'filters' => [
                ['name' => 'StripTags'],
                ['name' => 'StringTrim']
            ],
            'validators' => [
                [   'name' => 'NotEmpty',
                    'options' => [
                        'messages' => [
                            NotEmpty::IS_EMPTY => 'Please enter Mobile No.'
                        ]
                    ],
                    'break_chain_on_failure' => true
                ],
                [   'name' => 'Digits',
                    'options' => [
                        'messages' => [
                            Digits::NOT_DIGITS => 'Please enter Numeric value only',
                        ],
                    ],
                    'break_chain_on_failure' => true,
                ],
                [   'name' => 'StringLength',
                    'options' => [
                        'min' => 10,
                        'max' => 10,
                        'messages' => [
                            StringLength::TOO_LONG => 'Please enter Less than 10 Digits',
                            StringLength::TOO_SHORT => 'Please enter greater than 9 Digits',
                        ],
                    ],
                    'break_chain_on_failure' => true
                ],
            ]
        ],

      
       'prefix_contact_no' => [
                'required' => false,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please select Nationality'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],    
       
       'kyc_type' => [
                'required' => false,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please select Nationality'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],     
       

   ];

   }

}
