<?php

namespace Dashboard\Form;

use Zend\Form\Form;
use Zend\Form\Element\{
    Select,
    Text,
    Submit,
    Hidden
};
use Zend\Validator\{
    NotEmpty
};
use Zend\InputFilter\InputFilterProviderInterface;

class MenuGroupForm extends Form implements InputFilterProviderInterface {

    public static $groupposition = [];
    public static $menusno = [];
    public function __construct($name = null) {

        parent::__construct('menu-group-add-form');

        /**
         *
         * Menu Group Position...
         */
        $this->add([
            'name' => 'group_position',
            'type' => Select::class,
            'attributes' => [
                'id' => 'group-position',
                'class' => 'form-control'
            ],
            'options' => [
                'label' => 'Position<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true],
                'value_options' => self::$groupposition,
                'disable_inarray_validator' => true,
                'empty_option' => 'Select',
            ],
        ]);

        /**
         *
         * Menu Group...
         */
        $this->add([
            'name' => 'group_name',
            'type' => Text::class,
            'attributes' => [
                'id' => 'group-name',
                'placeholder' => 'menu_group',
                'class' => 'form-control'
            ],
            'options' => [
                'label' => 'Group Name<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);


        /**
         *
         * Maximum Number of Menu to Display...
         */
        $this->add([
            'name' => 'no_of_menus',
            'type' => Select::class,
            'attributes' => [
                'id' => 'no-of-menus',
                'placeholder' => '100',
                'class' => 'form-control'
            ],
            'options' => [
                'label' => 'Maximum Number of Menu to Display<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true],
                'value_options' => self::$menusno,
                'disable_inarray_validator' => true,
                'empty_option' => 'Select',
            ],
        ]);

        /**
         *
         * Group Id
         */
        $this->add([
            'name' => 'group_id',
            'type' => Hidden::class,
        ]);

        /**
         *
         * save
         */
        $this->add([
            'name' => 'save',
            'type' => Submit::class,
            'attributes' => [
                'id' => 'menu-group-save-btn',
                'placeholder' => 'Save',
                'class' => 'save_data_btn btn btn-primary btn-warning',
                'Value' => 'Save',
            ],
        ]);
    }

    public function getInputFilterSpecification() {
        return [
            'group_position' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Select Position'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'group_name' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Enter Group Name'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'no_of_menus' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Enter No'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],


        ];
    }

}
