<?php

namespace Dashboard\Form;

use Zend\Form\Form;
use Zend\Form\Element\{
    Select,
    Date,
    Number,
    Checkbox,
    Text,
    Submit,
    Hidden,
    Textarea,
    File
};
use Zend\Validator\{
    NotEmpty,
    Digits
};
use Zend\InputFilter\InputFilterProviderInterface;

class MasterModuleForm extends Form implements InputFilterProviderInterface {

    public static $moduleOptions = [];

    public function __construct($name = null) {

        parent::__construct('master-module');

        /**
         *
         *  Id...
         */
        $this->add([
            'name' => 'module_id',
            'type' => Hidden::class,
            'attributes' => [
                'class' => 'form-control',
            ],
        ]);

        /**
         * Module ...
         */
        $this->add([
            'name' => 'parent_module',
            'type' => Select::class,
            'attributes' => [
                'id' => 'module',
                'class' => 'form-control',
                //'class' => 'selectpicker form-control',
                //'data-show-subtext' => true,
                //'data-live-search' => true,
                //'style' => 'display: none'
            ],
            'options' => [
                'label' => 'Parent Modules<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true],
                'disable_inarray_validator' => true,
                'empty_option' => ' -- Select Child Module -- ',
                'value_options' => self::$moduleOptions,
            /* 'value_options'=>array('fruits'=> array('label'=>'Fruits','options'=> array('1'=>'Apple','2'=>'Mango')),
              'animals'=>array('label'=>'Animals','options'=>array('cat'=>'CAT','dog'=>'DOG')),
              'Vegetable'=>array('label'=>'Vegetable','options'=>array('1'=>'asdf'))) */
            ],
        ]);


        /**
         *
         * Module Name ...
         */
        $this->add([
            'name' => 'module_name',
            'type' => Text::class,
            'attributes' => [
                'id' => 'module-name',
                'placeholder' => 'Module name',
                'class' => 'form-control'
            ],
            'options' => [
                'label' => 'Module Name<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         *
         * Name space ...
         */
        $this->add([
            'name' => 'namespace',
            'type' => Text::class,
            'attributes' => [
                'id' => 'namespace',
                'placeholder' => 'Dashboard/ModuleNameController',
                'class' => 'form-control'
            ],
            'options' => [
                'label' => 'Module Namespace <span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         *
         * Controller Name ...
         */
        $this->add([
            'name' => 'controller_name',
            'type' => Text::class,
            'attributes' => [
                'id' => 'controller-name',
                'placeholder' => 'controller name',
                'class' => 'form-control'
            ],
            'options' => [
                'label' => 'Controller Name <span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         *
         * Action ...
         */
        $this->add([
            'name' => 'action',
            'type' => Text::class,
            'attributes' => [
                'id' => 'action',
                'placeholder' => 'action',
                'class' => 'form-control'
            ],
            'options' => [
                'label' => 'Action<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         *
         * Url ...
         */
        $this->add([
            'name' => 'url',
            'type' => Text::class,
            'attributes' => [
                'id' => 'url',
                'placeholder' => 'url',
                'class' => 'form-control'
            ],
            'options' => [
                'label' => 'Url <span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);


        /**
         *
         *  Icon Class...
         */
        $this->add([
            'name' => 'icon_class',
            'type' => Text::class,
            'attributes' => [
                'id' => 'icon_class',
                'placeholder' => 'icon class',
                'class' => 'form-control'
            ],
            'options' => [
                'label' => 'Icon Class<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         *
         *  Icon Class...
         */
        $this->add([
            'name' => 'order',
            'type' => Text::class,
            'attributes' => [
                'id' => 'order',
                'placeholder' => 'order',
                'class' => 'form-control'
            ],
            'options' => [
                'label' => 'Order<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);



        /**
         *
         * Save...
         */
        $this->add([
            'name' => 'save',
            'type' => Submit::class,
            'attributes' => [
                'value' => 'Save',
                'id' => 'submit-button',
                'class' => 'btn btn-red defaultbtnsearch btn-warning',
            ],
        ]);
    }

    public function getInputFilterSpecification() {
        return [
            'parent_module' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Select Parent Module'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'module_name' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Enter Module Name'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'module_name' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Enter Module Name'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'namespace' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Enter NameSpace'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'controller_name' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Enter Controller Name'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'order' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Enter Order'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'action' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Enter Action'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'url' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Enter Url'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'icon_class' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Enter Icon Class'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
        ];
    }

}
