<?php

namespace Dashboard\Form;

use Zend\Form\Form;
use Zend\Form\Element;
use Zend\Form\Element\Select;
use Zend\Form\Element\File;
use Zend\Form\Element\Text;
use Zend\Form\Element\Radio;
use Zend\Form\Element\Submit;
use Zend\Form\Element\Checkbox;
use Zend\Form\Element\Email;

class MarkupForm extends Form {
    
    public static $user_type =[];
    public static $markup_type =[];
    public static $booking_type =[];

    public function __construct($name = null) {

        parent::__construct('markup-form');
        $this->setAttribute('method', 'post');
        
        /**
         * 
         * Driver ID
         */
        $this->add([
            'name' => 'driver_id',
            'type' => Text::class,
            'attributes' => [
                'id' => 'driver-id',                
                'class' => 'form-control',
                'placeholder' => 'Driver Id'
            ],
            'options' => [
                'label' => 'Driver ID<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         * Country
         */
        $this->add([
            'name' => 'country_id',
            'type' => Text::class,
            'attributes' => [
                'id' => 'country-id',
                'class' => 'form-control',
                'placeholder' =>'country'
            ],
            'options' => [
                'label' => 'Country<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         * User Type
         */
        $this->add([
            'name' => 'user_type',
            'type' => Select::class,
            'attributes' => [
                'id' => 'user-type',                
                'class' => 'form-control'
            ],
            'options' => [
                'label' => 'User Type<span style="color: red"> *</span>',
               'value_options' => self::$user_type
            ],
        ]);  
        
        /**
         * Markup Type
         */
        $this->add([
            'name' => 'markup_type',
            'type' => Select::class,
            'attributes' => [
                'id' => 'markup-type',                
                'class' => 'form-control'
            ],
            'options' => [
                'label' => 'Markup Type<span style="color: red"> *</span>',
                'value_options' => self::$markup_type
            ]
            
        ]);
        
        /**
         * Name
         */
        $this->add([
            'name' => 'name',
            'type' => Text::class,
            'attributes' => [
                'id' => 'name',                
                'class' => 'form-control',
                'placeholder' =>'Name'
            ],
            'options' => [
                'label' => 'Name<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ]            
        ]);
        
        /**
         * City
         */
        $this->add([
            'name' => 'city_id',
            'type' => Text::class,
            'attributes' => [
                'id' => 'city-id',                
                'class' => 'form-control',
                'placeholder' => 'city'
            ],
            'options' => [
                'label' => 'City<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ]            
        ]);
        
        /**
         * Booking Type
         */
        $this->add([
            'name' => 'booking_type',
            'type' => Select::class,
            'attributes' => [
                'id' => 'booking-type',                
                'class' => 'form-control'
            ],
            'options' => [
                'label' => 'Booking Type<span style="color: red"> *</span>',
                'value_options' => self::$booking_type
            ]            
        ]);
        
        /**
         * Markup Amount
         */
        $this->add([
            'name' => 'markup_amount',
            'type' => Text::class,
            'attributes' => [
                'id' => 'markup-amount',                
                'class' => 'form-control',
                'placeholder' =>'100'
            ],
            'options' => [
                'label' => 'Markup Amount<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ]            
        ]);
        
       
        /**
         * Clear
         */
        $this->add([
            'name' => 'add_new_markup',
            'type' => Submit::class,
            'attributes' => [
                'value' => 'Add New markup',
                'id' => 'add-new-markup',
                'class' => 'btn btn-primary btn-add-markup'
            ],
            'options' => [
                 'count' => 1,
                'target_element' => [
                    'type' => 'Form\MarkupAddUserForm',
                    ]
            ]  
        ]); 
    }

    
    
    
    
    
    
    
}
