<?php

namespace Dashboard\Form;

use Zend\Form\Form;
use Zend\Form\Element\{
    Select,
    Date,
    Number,
    Checkbox,
    Text,
    Submit,
    Hidden,
    Textarea,
    Radio,
    File,
    Time
};
use Zend\Validator\{
    NotEmpty,
    Digits,
    EmailAddress
};
use Zend\InputFilter\InputFilterProviderInterface;

class HotelRoomRateForm extends Form implements InputFilterProviderInterface {
    
    public static $hotel_list= [];
    public static $vendorTypeList= [];
    public static $hotelRateTypeList= [];
    public static $hotelSeasonNameList= [];
    public static $hotelRateNameList= [];
    public static $vendorNameList= [];
    public static $roomList= [];
    public static $currenyList= [];
    public static $mealPlanList= [];
    public static $weekDaysList= [];
    public static $promotionRateTypeList= [];
    
    public function __construct($name = null) {
        parent::__construct('hotel-room-form');
        
        /**
         *
         * booking_type
         */
        $this->add([
            'name' => 'commission_rate_type[]',
            'type' => Select::class,
            'attributes' => [
                'id' => 'comission-rate-type',
                'placeholder' => '',
                'class' => 'form-control'
            ],
            'options' => [
                'label' => 'Rate Type',
                'value_options' => [
                    'Percentage' => 'Percentage',
                    'Fixed' => 'Fixed'
                ],
                'disable_inarray_validator' => true,
                'empty_option' => '--Select--',
            ],
        ]);
        
        
         /**
         *
         * booking_type
         */
        $this->add([
            'name' => 'netrate_commissionrate[]',
            'type' => Select::class,
            'attributes' => [
                'id' => 'netrate-commission-rate',
                'placeholder' => '',
                'class' => 'form-control cancel-master'
            ],
            'options' => [
                'label' => 'Type',
                'value_options' => [
                    'Commissionable Rate' => 'Commissionable Rate',
                    'Discount Rate' => 'Discount Rate',
                    'Net Rate' => 'Net Rate'
                ],
                'disable_inarray_validator' => true,
                'empty_option' => '--Select--',
            ],
        ]);
        
        /**
         *
         * cancellation fees
         */
          $this->add([
            'name' => 'commission_rate_value[]',
            'type' => Text::class,
            'attributes' => [
                'id' => 'commission-rate-value',
                'placeholder' => '150',
                'class' => 'form-control',
                'maxlength' =>5,
                'onkeypress'=>"return isNumber(event)"

            ],
            'options' => [
                'label' => 'Value',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
          
        
          /**
           * Allocation Tab
         */
        
        $this->add([
            'name' => 'hotel_id',
            'type' => Select::class,
            'attributes' => [
                'id' => 'room-rate-hotel-id',
                'class' => 'form-control',
                //'class' => 'selectpicker form-control',
                //'data-show-subtext' => true,
                //'data-live-search' => true,
            ],
            'options' => [
                'label' => 'Hotel Name <span style="color: red"> *</span>',
                'disable_inarray_validator' => true,
                'label_options' => ['disable_html_escape' => true],
                'empty_option' => '--Select Name--',
                'value_options' =>self::$hotel_list
            ],
        ]);
        
        
        $this->add([
            'name' => 'vendor_type',
            'type' => Select::class,
            'attributes' => [
                'id' => 'vendor-type',
                'class' => 'form-control',
                //'class' => 'selectpicker form-control',
                //'data-show-subtext' => true,
                //'data-live-search' => true,
            ],
            'options' => [
                'label' => 'Vendor Type <span style="color: red"> *</span>',
                'disable_inarray_validator' => true,
                'label_options' => ['disable_html_escape' => true],
                'empty_option' => '--Select Type--',
                'value_options' =>self::$vendorTypeList
            ],
        ]);
        
         /**
         *
         * Basic tax
         */
        $this->add([
            'name' => 'sgst',
            'type' => Text::class,
            'attributes' => [
                'id' => 'sgst',
                'placeholder' => '5',
                'class' => 'form-control',
                'maxlength' => 5,
                'onkeypress' => "return isNumberDecimal(event)"
            ],
            'options' => [
                'label' => 'SGST',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         *
         * krishi kalyan cess
         */
        $this->add([
            'name' => 'cgst',
            'type' => Text::class,
            'attributes' => [
                'id' => 'cgst',
                'placeholder' => '5',
                'class' => 'form-control',
                'maxlength' => 5,
                'onkeypress' => "return isNumberDecimal(event)"
            ],
            'options' => [
                'label' => 'CGST',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         *
         * swatch bharat cess
         */
        $this->add([
            'name' => 'igst',
            'type' => Text::class,
            'attributes' => [
                'id' => 'igst',
                'placeholder' => '5',
                'class' => 'form-control',
                'maxlength' => 5,
                'onkeypress' => "return isNumberDecimal(event)"
            ],
            'options' => [
                'label' => 'IGST',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        /**         
         * Vendor Name
         */
        $this->add([
            'name' => 'vendor_name',
            'type' => Select::class,
            'attributes' => [
                'id' => 'vendor-name',
                'class' => 'form-control',
                //'class' => 'selectpicker form-control',
                //'data-show-subtext' => true,
                //'data-live-search' => true,
            ],
            'options' => [
                'label' => 'Vendor Name <span style="color: red"> *</span>',
                'disable_inarray_validator' => true,
                'label_options' => ['disable_html_escape' => true],
                'empty_option' => '--Select Vendor--',
                'value_options' =>self::$vendorNameList
            ],
        ]);
        
        $this->add([
            'name' => 'room_id',
            'type' => Select::class,
            'attributes' => [
                'id' => 'room-id',
                'class' => 'form-control',
                //'class' => 'selectpicker form-control',
                //'data-show-subtext' => true,
                //'data-live-search' => true,
            ],
            'options' => [
                'label' => 'Room <span style="color: red"> *</span>',
                'disable_inarray_validator' => true,
                'label_options' => ['disable_html_escape' => true],
                'empty_option' => '--Select Name--',
                'value_options' =>self::$roomList
            ],
        ]);
        
        
        $this->add([
            'name' => 'pacakge_room_id[]',
            'type' => Select::class,
            'attributes' => [
                'id' => 'package-room-id',
                'class' => 'form-control package-room-id',
                //'class' => 'selectpicker form-control',
                //'data-show-subtext' => true,
                //'data-live-search' => true,
            ],
            'options' => [
                'label' => 'Room <span style="color: red"> *</span>',
                'disable_inarray_validator' => true,
                'label_options' => ['disable_html_escape' => true],
                'empty_option' => '--Select Name--',
                'value_options' =>self::$roomList
            ],
        ]);
        
        
        $this->add([
            'name' => 'currency',
            'type' => Select::class,
            'attributes' => [
                'id' => 'currency',
                'class' => 'form-control',
                //'class' => 'selectpicker form-control',
                //'data-show-subtext' => true,
                //'data-live-search' => true,
            ],
            'options' => [
                'label' => 'Currency<span style="color: red"> *</span>',
                'disable_inarray_validator' => true,
                'label_options' => ['disable_html_escape' => true],
                'empty_option' => '--Select Name--',
                'value_options' =>self::$currenyList
            ],
        ]);
        
        
        /**         
         * MEAL PLAN List
         */
        $this->add([
            'name' => 'meal_plan_id',
            'type' => Select::class,
            'attributes' => [
                'id' => 'meal-plan-id',
                'class' => 'demo-default input-tags selectized form-control',
                'multiple' => 'multiple',
            ],
            'options' => [
                'label' => 'Meal Plan<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true],
                'empty_option' => '--Select Meal Plan--',
                'value_options' =>self::$mealPlanList
            ],
        ]);
        
        
        /**         
         * Package MEAL PLAN List
         */
        $this->add([
            'name' => 'package_meal_plan_id1',
            'type' => Select::class,
            'attributes' => [
                'id' => 'package-meal-plan-id',
                'class' => 'demo-default input-tags selectized form-control package_meal_plan',
                'multiple' => 'multiple',
            ],
            'options' => [
                'label' => 'Meal Plan<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true],
                'empty_option' => '--Select Meal Plan--',
                'value_options' =>self::$mealPlanList
            ],
        ]);
        
        /**         
         * Package MEAL PLAN List
         */
        $this->add([
            'name' => 'package_meal_plan_id2',
            'type' => Select::class,
            'attributes' => [
                'id' => 'package-meal-plan-id',
                'class' => 'demo-default input-tags selectized form-control package_meal_plan',
                'multiple' => 'multiple',
            ],
            'options' => [
                'label' => 'Meal Plan<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true],
                'empty_option' => '--Select Meal Plan--',
                'value_options' =>self::$mealPlanList
            ],
        ]);
        
        /**         
         * Package MEAL PLAN List
         */
        $this->add([
            'name' => 'package_meal_plan_id3',
            'type' => Select::class,
            'attributes' => [
                'id' => 'package-meal-plan-id',
                'class' => 'demo-default input-tags selectized form-control package_meal_plan',
                'multiple' => 'multiple',
            ],
            'options' => [
                'label' => 'Meal Plan<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true],
                'empty_option' => '--Select Meal Plan--',
                'value_options' =>self::$mealPlanList
            ],
        ]);
        
        
        $this->add([
            'name' => 'hotel_rate_type',
            'type' => Select::class,
            'attributes' => [
                'id' => 'hotel-rate-type',
                'class' => 'demo-default input-tags selectized form-control',
                'multiple' => 'multiple',
            ],
            'options' => [
                'label' => 'Rate Type <span style="color: red"> *</span>',
                'disable_inarray_validator' => true,
                'label_options' => ['disable_html_escape' => true],
                'empty_option' => '--Select Rate Type--',
                'value_options' =>self::$hotelRateTypeList
            ],
        ]);
        
        $this->add([
            'name' => 'hotel_rate_season',
            'type' => Select::class,
            'attributes' => [
                'id' => 'hotel-rate-season',
                'class' => 'form-control',
                //'class' => 'selectpicker form-control',
                //'data-show-subtext' => true,
                //'data-live-search' => true,
            ],
            'options' => [
                'label' => 'Season Name<span style="color: red"> *</span>',
                'disable_inarray_validator' => true,
                'label_options' => ['disable_html_escape' => true],
                'empty_option' => '--Select Season Name--',
                'value_options' =>self::$hotelSeasonNameList
            ],
        ]);
        
        
        $this->add([
            'name' => 'package_rate_season[]',
            'type' => Select::class,
            'attributes' => [
                'id' => 'package-rate-season',
                'class' => 'form-control',
                //'class' => 'selectpicker form-control',
                //'data-show-subtext' => true,
                //'data-live-search' => true,
            ],
            'options' => [
                'label' => 'Season Name<span style="color: red"> *</span>',
                'disable_inarray_validator' => true,
                'label_options' => ['disable_html_escape' => true],
                'empty_option' => '--Select Season Name--',
                'value_options' =>self::$hotelSeasonNameList
            ],
        ]);
        
        $this->add([
            'name' => 'hotel_rate_name',
            'type' => Select::class,
            'attributes' => [
                'id' => 'hotel-rate-name',
                'class' => 'form-control',
                //'class' => 'selectpicker form-control',
                //'data-show-subtext' => true,
                //'data-live-search' => true,
            ],
            'options' => [
                'label' => 'Rate Name<span style="color: red"> *</span>',
                'disable_inarray_validator' => true,
                'label_options' => ['disable_html_escape' => true],
                'empty_option' => '--Select Rate Name--',
                'value_options' =>self::$hotelRateNameList
            ],
        ]);
        
        
        /**         
         * MEAL PLAN List
         */
        $this->add([
            'name' => 'promotion_rate_type',
            'type' => Select::class,
            'attributes' => [
                'id' => 'promotion-rate-type',
                'class' => 'demo-default input-tags selectized form-control',
                'multiple' => 'multiple',
            ],
            'options' => [
                'label' => 'Add Promotion Rate<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true],
                'empty_option' => '--Select Promotion Rate--',
                'value_options' =>self::$promotionRateTypeList
            ],
        ]);
        
        
        $this->add([
            'name' => 'package_promotion_rate_type1',
            'type' => Select::class,
            'attributes' => [
                'id' => 'package-promotion-rate-type',
                'class' => 'demo-default input-tags selectized form-control package-promotion-rate',
                'multiple' => 'multiple',
            ],
            'options' => [
                'label' => 'Add Promotion Rate<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true],
                'empty_option' => '--Select Promotion Rate--',
                'value_options' =>self::$promotionRateTypeList
            ],
        ]);
        
        $this->add([
            'name' => 'package_promotion_rate_type2',
            'type' => Select::class,
            'attributes' => [
                'id' => 'package-promotion-rate-type',
                'class' => 'demo-default input-tags selectized form-control package-promotion-rate',
                'multiple' => 'multiple',
            ],
            'options' => [
                'label' => 'Add Promotion Rate<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true],
                'empty_option' => '--Select Promotion Rate--',
                'value_options' =>self::$promotionRateTypeList
            ],
        ]);
        
        $this->add([
            'name' => 'package_promotion_rate_type3',
            'type' => Select::class,
            'attributes' => [
                'id' => 'package-promotion-rate-type',
                'class' => 'demo-default input-tags selectized form-control package-promotion-rate',
                'multiple' => 'multiple',
            ],
            'options' => [
                'label' => 'Add Promotion Rate<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true],
                'empty_option' => '--Select Promotion Rate--',
                'value_options' =>self::$promotionRateTypeList
            ],
        ]);
        
        /**
         * 
         * Description
         *
         */
        $this->add([
            'type' => Textarea::class,
            'name' => 'description',
            'attributes' => [
                'id' => 'description',
                'placeholder' => 'Content',
                'class' => 'form-control editor'                
            ],
            'options' => [
                'label' => 'Description<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        
        /**         
         * From Date
         */
        $this->add([
            'name' => 'valid_from',
            'type' => Text::class,
            'attributes' => [
                'id' => 'valid-from',
                'class' => 'form-control datepicker',
                'maxlength' => 15,
            ],
            'options' => [
                'label' => 'Valid From<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        /**         
         * To Date
         */
        $this->add([
            'name' => 'valid_to',
            'type' => Text::class,
            'attributes' => [
                'id' => 'valid-to',
                'class' => 'form-control datepicker',
                'maxlength' => 15,
            ],
            'options' => [
                'label' => 'Valid To<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        /**         
         * From Date
         */
        $this->add([
            'name' => 'discount_valid_from',
            'type' => Text::class,
            'attributes' => [
                'id' => 'discount-valid-from',
                'class' => 'form-control datepicker',
                'maxlength' => 15,
            ],
            'options' => [
                'label' => 'Valid From<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        /**         
         * To Date
         */
        $this->add([
            'name' => 'discount_valid_to',
            'type' => Text::class,
            'attributes' => [
                'id' => 'discount_valid-to',
                'class' => 'form-control datepicker',
                'maxlength' => 15,
            ],
            'options' => [
                'label' => 'Valid To<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        /**         
         * From Date
         */
        $this->add([
            'name' => 'package_valid_from[]',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-valid-from',
                'class' => 'form-control datepicker',
                'maxlength' => 15,
            ],
            'options' => [
                'label' => 'Valid From<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        /**         
         * To Date
         */
        $this->add([
            'name' => 'package_valid_to[]',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-valid-to',
                'class' => 'form-control datepicker',
                'maxlength' => 15,
            ],
            'options' => [
                'label' => 'Valid To<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
         /**         
         * WEEK DAYS List
         */
        $this->add([
            'name' => 'weekdays',
            'type' => Select::class,
            'attributes' => [
                'id' => 'weekdays',
                'class' => 'demo-default select-state selectized form-control',
                'multiple' => 'multiple',
            ],
            'options' => [
                'label' => 'WeekDays<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true],
                'empty_option' => '--Select Week Days--',
                'value_options' =>self::$weekDaysList
            ],
        ]);   
        
        
        /**         
         * WEEK DAYS List
         */
        $this->add([
            'name' => 'package_rate_weekdays1',
            'type' => Select::class,
            'attributes' => [
                'id' => 'package-rate-weekdays1',
                'class' => 'demo-default select-state selectized form-control',
                'multiple' => 'multiple',
            ],
            'options' => [
                'label' => 'WeekDays<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true],
                'empty_option' => '--Select Week Days--',
                'value_options' =>self::$weekDaysList
            ],
        ]);   
        
        /**         
         * WEEK DAYS List
         */
        $this->add([
            'name' => 'package_rate_weekdays2',
            'type' => Select::class,
            'attributes' => [
                'id' => 'package-rate-weekdays2',
                'class' => 'demo-default select-state selectized form-control',
                'multiple' => 'multiple',
            ],
            'options' => [
                'label' => 'WeekDays<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true],
                'empty_option' => '--Select Week Days--',
                'value_options' =>self::$weekDaysList
            ],
        ]);   
        
        /**         
         * WEEK DAYS List
         */
        $this->add([
            'name' => 'package_rate_weekdays3',
            'type' => Select::class,
            'attributes' => [
                'id' => 'package-rate-weekdays3',
                'class' => 'demo-default select-state selectized form-control',
                'multiple' => 'multiple',
            ],
            'options' => [
                'label' => 'WeekDays<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true],
                'empty_option' => '--Select Week Days--',
                'value_options' =>self::$weekDaysList
            ],
        ]);   
        
        
        /**
         * Commission  Value
         */
        
        $this->add([
            'name' => 'commission_value',
            'type' => Text::class,
            'attributes' => [
                'id' => 'commission-value',
                'placeholder' => 'Enter value',
                'class' => 'form-control inputchange'
            ],
            'options' => [
                'label' => 'Commission value<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        /**
         * Service Charge  Value
         */
        
        $this->add([
            'name' => 'service_charge_value',
            'type' => Text::class,
            'attributes' => [
                'id' => 'service-charge-value',
                'placeholder' => 'Enter value',
                'class' => 'form-control inputchange'
            ],
            'options' => [
                'label' => 'Charge value<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        /**
         * Service Charge  Value
         */
        
        $this->add([
            'name' => 'discount_commission_value',
            'type' => Text::class,
            'attributes' => [
                'id' => 'discount-commission-value',
                'placeholder' => 'Enter value',
                'class' => 'form-control inputchange'
            ],
            'options' => [
                'label' => 'Charge value<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        /**
         * Package Commission  Value
         */
        
        $this->add([
            'name' => 'package_commission_value[]',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-commission-value',
                'placeholder' => 'Enter value',
                'class' => 'form-control inputchange'
            ],
            'options' => [
                'label' => 'Commission value<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        /**
         * Hotel Package Name
         */
        
        $this->add([
            'name' => 'hotel_package_name',
            'type' => Text::class,
            'attributes' => [
                'id' => 'hotel-package-name',
                'placeholder' => 'Enter Package Name',
                'class' => 'form-control inputchange'
            ],
            'options' => [
                'label' => 'Package Name<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        /**
         * Hotel Package Minimum Nights
         */
        
        $this->add([
            'name' => 'package_minimum_nights',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-minimum-nights',
                'placeholder' => 'Enter Minimum Nights',
                'class' => 'form-control inputchange'
            ],
            'options' => [
                'label' => 'Minimum Nights<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        $this->add([
            'type' => Checkbox::class,
            'name' => 'ep',
            'attributes' => [
                'id' => 'ep',
                'checked' => 'checked',
            ],
            'options' => [
                'label' => 'EP',
                'use_hidden_element' => true,
                'checked_value' => '1',
                'unchecked_value' => '0',
            ]
        ]);
        
        $this->add([
            'type' => Checkbox::class,
            'name' => 'cp',
            'attributes' => [
                'id' => 'cp',
                'checked' => 'checked',
            ],
            'options' => [
                'label' => 'CP',
                'use_hidden_element' => true,
                'checked_value' => '1',
                'unchecked_value' => '0',
            ]
        ]);
        
        $this->add([
            'type' => Checkbox::class,
            'name' => 'map',
            'attributes' => [
                'id' => 'ep',
                'checked' => 'checked',
            ],
            'options' => [
                'label' => 'MAP',
                'use_hidden_element' => true,
                'checked_value' => '1',
                'unchecked_value' => '0',
            ]
        ]);
        
        $this->add([
            'type' => Checkbox::class,
            'name' => 'ap',
            'attributes' => [
                'id' => 'ap',
                'checked' => 'checked',
            ],
            'options' => [
                'label' => 'AP',
                'use_hidden_element' => true,
                'checked_value' => '1',
                'unchecked_value' => '0',
            ]
        ]);
        
        $this->add([
            'type' => Checkbox::class,
            'name' => 'ai',
            'attributes' => [
                'id' => 'ai',
                'checked' => 'checked',
            ],
            'options' => [
                'label' => 'AI',
                'use_hidden_element' => true,
                'checked_value' => '1',
                'unchecked_value' => '0',
            ]
        ]);
        
        $this->add([
            'type' => Checkbox::class,
            'name' => 'jp',
            'attributes' => [
                'id' => 'ep',
                'checked' => 'checked',
            ],
            'options' => [
                'label' => 'JP',
                'use_hidden_element' => true,
                'checked_value' => '1',
                'unchecked_value' => '0',
            ]
        ]);
        
        /**         
         * SGL ATTRIBUTES
         */
        $this->add([
            'name' => 'sgl_pub_rate_ep',
            'type' => Text::class,
            'attributes' => [
                'id' => 'sgl-pub-rate-ep',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        /**         
         * SGL ATTRIBUTES
         */
        $this->add([
            'name' => 'sgl_rate_ep',
            'type' => Text::class,
            'attributes' => [
                'id' => 'sgl-rate-ep',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
  
        $this->add([
            'name' => 'sgl_rate_epai',
            'type' => Text::class,
            'attributes' => [
                'id' => 'sgl-rate-epai',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        $this->add([
            'name' => 'dbl_rate_ep',
            'type' => Text::class,
            'attributes' => [
                'id' => 'dbl-rate-ep',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
  
        $this->add([
            'name' => 'dbl_rate_epai',
            'type' => Text::class,
            'attributes' => [
                'id' => 'dbl-rate-epai',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        $this->add([
            'name' => 'tbl_rate_ep',
            'type' => Text::class,
            'attributes' => [
                'id' => 'tbl-rate-ep',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
  
        $this->add([
            'name' => 'tbl_rate_epai',
            'type' => Text::class,
            'attributes' => [
                'id' => 'tbl-rate-epai',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
         $this->add([
            'name' => 'child_rate_ep',
            'type' => Text::class,
            'attributes' => [
                'id' => 'child-rate-ep',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
  
        $this->add([
            'name' => 'child_rate_epai',
            'type' => Text::class,
            'attributes' => [
                'id' => 'child-rate-epai',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        $this->add([
            'name' => 'child1_rate_ep',
            'type' => Text::class,
            'attributes' => [
                'id' => 'child1-rate-ep',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
  
        $this->add([
            'name' => 'child1_rate_epai',
            'type' => Text::class,
            'attributes' => [
                'id' => 'child1-rate-epai',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
         $this->add([
            'name' => 'extra_bed_rate_ep',
            'type' => Text::class,
            'attributes' => [
                'id' => 'extra-bed-rate-ep',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
  
        $this->add([
            'name' => 'extra_bed_rate_epai',
            'type' => Text::class,
            'attributes' => [
                'id' => 'extra-bed-rate-epai',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        
        
        $this->add([
            'name' => 'sgl_rate_cp',
            'type' => Text::class,
            'attributes' => [
                'id' => 'sgl-rate-cp',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
  
        $this->add([
            'name' => 'sgl_rate_cpai',
            'type' => Text::class,
            'attributes' => [
                'id' => 'sgl-rate-cpai',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        $this->add([
            'name' => 'dbl_rate_cp',
            'type' => Text::class,
            'attributes' => [
                'id' => 'dbl-rate-cp',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
  
        $this->add([
            'name' => 'dbl_rate_cpai',
            'type' => Text::class,
            'attributes' => [
                'id' => 'dbl-rate-cpai',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        $this->add([
            'name' => 'tbl_rate_cp',
            'type' => Text::class,
            'attributes' => [
                'id' => 'tbl-rate-cp',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
  
        $this->add([
            'name' => 'tbl_rate_cpai',
            'type' => Text::class,
            'attributes' => [
                'id' => 'tbl-rate-cpai',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
         $this->add([
            'name' => 'child_rate_cp',
            'type' => Text::class,
            'attributes' => [
                'id' => 'child-rate-cp',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
  
        $this->add([
            'name' => 'child_rate_cpai',
            'type' => Text::class,
            'attributes' => [
                'id' => 'child-rate-cpai',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        $this->add([
            'name' => 'child1_rate_cp',
            'type' => Text::class,
            'attributes' => [
                'id' => 'child1-rate-cp',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
  
        $this->add([
            'name' => 'child1_rate_cpai',
            'type' => Text::class,
            'attributes' => [
                'id' => 'child1-rate-cpai',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
         $this->add([
            'name' => 'extra_bed_rate_cp',
            'type' => Text::class,
            'attributes' => [
                'id' => 'extra-bed-rate-cp',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
  
        $this->add([
            'name' => 'extra_bed_rate_cpai',
            'type' => Text::class,
            'attributes' => [
                'id' => 'extra-bed-rate-cpai',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        
        
        
        
        /////////////
        
        
        
        
        $this->add([
            'name' => 'sgl_rate_map',
            'type' => Text::class,
            'attributes' => [
                'id' => 'sgl-rate-map',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
  
        $this->add([
            'name' => 'sgl_rate_mapai',
            'type' => Text::class,
            'attributes' => [
                'id' => 'sgl-rate-mapai',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        $this->add([
            'name' => 'dbl_rate_map',
            'type' => Text::class,
            'attributes' => [
                'id' => 'dbl-rate-map',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
  
        $this->add([
            'name' => 'dbl_rate_mapai',
            'type' => Text::class,
            'attributes' => [
                'id' => 'dbl-rate-mapai',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        $this->add([
            'name' => 'tbl_rate_map',
            'type' => Text::class,
            'attributes' => [
                'id' => 'tbl-rate-map',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
  
        $this->add([
            'name' => 'tbl_rate_mapai',
            'type' => Text::class,
            'attributes' => [
                'id' => 'tbl-rate-mapai',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
         $this->add([
            'name' => 'child_rate_map',
            'type' => Text::class,
            'attributes' => [
                'id' => 'child-rate-map',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
  
        $this->add([
            'name' => 'child_rate_mapai',
            'type' => Text::class,
            'attributes' => [
                'id' => 'child-rate-mapai',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        $this->add([
            'name' => 'child1_rate_map',
            'type' => Text::class,
            'attributes' => [
                'id' => 'child1-rate-map',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
  
        $this->add([
            'name' => 'child1_rate_mapai',
            'type' => Text::class,
            'attributes' => [
                'id' => 'child1-rate-mapai',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
         $this->add([
            'name' => 'extra_bed_rate_map',
            'type' => Text::class,
            'attributes' => [
                'id' => 'extra-bed-rate-map',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
  
        $this->add([
            'name' => 'extra_bed_rate_mapai',
            'type' => Text::class,
            'attributes' => [
                'id' => 'extra-bed-rate-mapai',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        
                /////////////
        
        
        
        
        $this->add([
            'name' => 'sgl_rate_ap',
            'type' => Text::class,
            'attributes' => [
                'id' => 'sgl-rate-ap',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
  
        $this->add([
            'name' => 'sgl_rate_apai',
            'type' => Text::class,
            'attributes' => [
                'id' => 'sgl-rate-apai',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        $this->add([
            'name' => 'dbl_rate_ap',
            'type' => Text::class,
            'attributes' => [
                'id' => 'dbl-rate-ap',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
  
        $this->add([
            'name' => 'dbl_rate_apai',
            'type' => Text::class,
            'attributes' => [
                'id' => 'dbl-rate-apai',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        $this->add([
            'name' => 'tbl_rate_ap',
            'type' => Text::class,
            'attributes' => [
                'id' => 'tbl-rate-ap',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
  
        $this->add([
            'name' => 'tbl_rate_apai',
            'type' => Text::class,
            'attributes' => [
                'id' => 'tbl-rate-apai',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
         $this->add([
            'name' => 'child_rate_ap',
            'type' => Text::class,
            'attributes' => [
                'id' => 'child-rate-ap',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
  
        $this->add([
            'name' => 'child_rate_apai',
            'type' => Text::class,
            'attributes' => [
                'id' => 'child-rate-apai',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        $this->add([
            'name' => 'child1_rate_ap',
            'type' => Text::class,
            'attributes' => [
                'id' => 'child1-rate-ap',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
  
        $this->add([
            'name' => 'child1_rate_apai',
            'type' => Text::class,
            'attributes' => [
                'id' => 'child1-rate-apai',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
         $this->add([
            'name' => 'extra_bed_rate_ap',
            'type' => Text::class,
            'attributes' => [
                'id' => 'extra-bed-rate-ap',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
  
        $this->add([
            'name' => 'extra_bed_rate_apai',
            'type' => Text::class,
            'attributes' => [
                'id' => 'extra-bed-rate-apai',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        
        ///////////////
        
        $this->add([
            'name' => 'sgl_rate_allinclusive',
            'type' => Text::class,
            'attributes' => [
                'id' => 'sgl-rate-allinclusive',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
  
        $this->add([
            'name' => 'sgl_rate_allinclai',
            'type' => Text::class,
            'attributes' => [
                'id' => 'sgl-rate-allinclai',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        $this->add([
            'name' => 'dbl_rate_allinclusive',
            'type' => Text::class,
            'attributes' => [
                'id' => 'dbl-rate-allinclusive',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
  
        $this->add([
            'name' => 'dbl_rate_allinclai',
            'type' => Text::class,
            'attributes' => [
                'id' => 'dbl-rate-allinclai',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        $this->add([
            'name' => 'tbl_rate_allinclusive',
            'type' => Text::class,
            'attributes' => [
                'id' => 'tbl-rate-allinclusive',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
  
        $this->add([
            'name' => 'tbl_rate_allinclai',
            'type' => Text::class,
            'attributes' => [
                'id' => 'tbl-rate-allinclai',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
         $this->add([
            'name' => 'child_rate_allinclusive',
            'type' => Text::class,
            'attributes' => [
                'id' => 'child-rate-allinclusive',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
  
        $this->add([
            'name' => 'child_rate_allinclai',
            'type' => Text::class,
            'attributes' => [
                'id' => 'child-rate-allinclai',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        $this->add([
            'name' => 'child1_rate_allinclusive',
            'type' => Text::class,
            'attributes' => [
                'id' => 'child1-rate-allinclusive',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
  
        $this->add([
            'name' => 'child1_rate_allinclai',
            'type' => Text::class,
            'attributes' => [
                'id' => 'child1-rate-allinclai',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
         $this->add([
            'name' => 'extra_bed_rate_allinclusive',
            'type' => Text::class,
            'attributes' => [
                'id' => 'extra-bed-rate-allinclusive',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
  
        $this->add([
            'name' => 'extra_bed_rate_allinclai',
            'type' => Text::class,
            'attributes' => [
                'id' => 'extra-bed-rate-allinclai',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        
        
         ///////////
        
        
         $this->add([
            'name' => 'sgl_rate_jungleplan',
            'type' => Text::class,
            'attributes' => [
                'id' => 'sgl-rate-jungleplan',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
  
        
        
        $this->add([
            'name' => 'dbl_rate_jungleplan',
            'type' => Text::class,
            'attributes' => [
                'id' => 'dbl-rate-jungleplan',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
  
        
        
        $this->add([
            'name' => 'tbl_rate_jungleplan',
            'type' => Text::class,
            'attributes' => [
                'id' => 'tbl-rate-jungleplan',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
         
       
        
        
         $this->add([
            'name' => 'child_rate_jungleplan',
            'type' => Text::class,
            'attributes' => [
                'id' => 'child-rate-jungleplan',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
  
       
        
        
        $this->add([
            'name' => 'child1_rate_jungleplan',
            'type' => Text::class,
            'attributes' => [
                'id' => 'child1-rate-jungleplan',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
  
        
         $this->add([
            'name' => 'extra_bed_rate_jungleplan',
            'type' => Text::class,
            'attributes' => [
                'id' => 'extra-bed-rate-jungleplan',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
  
        
        ///////////
        
        
         $this->add([
            'name' => 'sgl_rate_jungleplanai',
            'type' => Text::class,
            'attributes' => [
                'id' => 'sgl-rate-jungleplanai',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
  
        $this->add([
            'name' => 'sgl_rate_allinclai',
            'type' => Text::class,
            'attributes' => [
                'id' => 'sgl-rate-allinclai',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        $this->add([
            'name' => 'dbl_rate_jungleplanai',
            'type' => Text::class,
            'attributes' => [
                'id' => 'dbl-rate-jungleplanai',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
  
        $this->add([
            'name' => 'dbl_rate_allinclai',
            'type' => Text::class,
            'attributes' => [
                'id' => 'dbl-rate-allinclai',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        $this->add([
            'name' => 'tbl_rate_jungleplanai',
            'type' => Text::class,
            'attributes' => [
                'id' => 'tbl-rate-jungleplanai',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
  
        $this->add([
            'name' => 'tbl_rate_allinclai',
            'type' => Text::class,
            'attributes' => [
                'id' => 'tbl-rate-allinclai',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
         $this->add([
            'name' => 'child_rate_jungleplanai',
            'type' => Text::class,
            'attributes' => [
                'id' => 'child-rate-jungleplanai',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
  
        $this->add([
            'name' => 'child_rate_allinclai',
            'type' => Text::class,
            'attributes' => [
                'id' => 'child-rate-allinclai',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        $this->add([
            'name' => 'child1_rate_jungleplanai',
            'type' => Text::class,
            'attributes' => [
                'id' => 'child1-rate-jungleplanai',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
  
        $this->add([
            'name' => 'child1_rate_allinclai',
            'type' => Text::class,
            'attributes' => [
                'id' => 'child1-rate-allinclai',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
         $this->add([
            'name' => 'extra_bed_rate_jungleplanai',
            'type' => Text::class,
            'attributes' => [
                'id' => 'extra-bed-rate-jungleplanai',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
  
        $this->add([
            'name' => 'extra_bed_rate_allinclai',
            'type' => Text::class,
            'attributes' => [
                'id' => 'extra-bed-rate-allinclai',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        /////////////
        
        
        $this->add([
            'name' => 'package_sgl_rate_ep1',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-sgl-rate-ep1',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        $this->add([
            'name' => 'package_sgl_rate_ep2',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-sgl-rate-ep2',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        $this->add([
            'name' => 'package_sgl_rate_ep3',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-sgl-rate-ep3',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
  
        $this->add([
            'name' => 'package_sgl_rate_epai1',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-sgl-rate-epai1',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        $this->add([
            'name' => 'package_sgl_rate_epai2',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-sgl-rate-epai2',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        $this->add([
            'name' => 'package_sgl_rate_epai3',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-sgl-rate-epai3',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        $this->add([
            'name' => 'package_dbl_rate_ep1',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-dbl-rate-ep1',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        $this->add([
            'name' => 'package_dbl_rate_ep2',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-dbl-rate-ep2',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        $this->add([
            'name' => 'package_dbl_rate_ep3',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-dbl-rate-ep3',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
  
        $this->add([
            'name' => 'package_dbl_rate_epai1',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-dbl-rate-epai1',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
         $this->add([
            'name' => 'package_dbl_rate_epai2',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-dbl-rate-epai2',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
         
          $this->add([
            'name' => 'package_dbl_rate_epai3',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-dbl-rate-epai3',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        $this->add([
            'name' => 'package_tbl_rate_ep1',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-tbl-rate-ep1',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        $this->add([
            'name' => 'package_tbl_rate_ep2',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-tbl-rate-ep2',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        $this->add([
            'name' => 'package_tbl_rate_ep3',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-tbl-rate-ep3',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
  
        $this->add([
            'name' => 'package_tbl_rate_epai1',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-tbl-rate-epai1',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        $this->add([
            'name' => 'package_tbl_rate_epai2',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-tbl-rate-epai2',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        $this->add([
            'name' => 'package_tbl_rate_epai3',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-tbl-rate-epai3',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
         $this->add([
            'name' => 'package_child_rate_ep1',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-child-rate-ep1',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
         
         $this->add([
            'name' => 'package_child_rate_ep2',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-child-rate-ep2',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
         
         $this->add([
            'name' => 'package_child_rate_ep3',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-child-rate-ep3',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
  
        $this->add([
            'name' => 'package_child_rate_epai1',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-child-rate-epai1',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        $this->add([
            'name' => 'package_child_rate_epai2',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-child-rate-epai2',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        $this->add([
            'name' => 'package_child_rate_epai3',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-child-rate-epai3',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        $this->add([
            'name' => 'package_child1_rate_ep1',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-child1-rate-ep1',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        $this->add([
            'name' => 'package_child1_rate_ep2',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-child1-rate-ep2',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        $this->add([
            'name' => 'package_child1_rate_ep3',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-child1-rate-ep3',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
  
        $this->add([
            'name' => 'package_child1_rate_epai1',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-child1-rate-epai1',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        $this->add([
            'name' => 'package_child1_rate_epai2',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-child1-rate-epai2',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        $this->add([
            'name' => 'package_child1_rate_epai3',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-child1-rate-epai3',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        $this->add([
            'name' => 'package_extra_bed_rate_ep1',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-extra-bed-rate-ep1',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        $this->add([
            'name' => 'package_extra_bed_rate_ep2',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-extra-bed-rate-ep2',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
         $this->add([
            'name' => 'package_extra_bed_rate_ep3',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-extra-bed-rate-ep3',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
  
        $this->add([
            'name' => 'package_extra_bed_rate_epai1',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-extra-bed-rate-epai1',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        $this->add([
            'name' => 'package_extra_bed_rate_epai2',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-extra-bed-rate-epai2',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        $this->add([
            'name' => 'package_extra_bed_rate_epai3',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-extra-bed-rate-epai3',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        
        
        $this->add([
            'name' => 'package_sgl_rate_cp1',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-sgl-rate-cp1',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
         $this->add([
            'name' => 'package_sgl_rate_cp2',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-sgl-rate-cp2',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
         
          $this->add([
            'name' => 'package_sgl_rate_cp3',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-sgl-rate-cp3',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
  
        $this->add([
            'name' => 'package_sgl_rate_cpai1',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-sgl-rate-cpai1',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        $this->add([
            'name' => 'package_sgl_rate_cpai2',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-sgl-rate-cpai2',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        $this->add([
            'name' => 'package_sgl_rate_cpai3',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-sgl-rate-cpai3',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        $this->add([
            'name' => 'package_dbl_rate_cp1',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-dbl-rate-cp1',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        $this->add([
            'name' => 'package_dbl_rate_cp2',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-dbl-rate-cp2',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        $this->add([
            'name' => 'package_dbl_rate_cp3',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-dbl-rate-cp3',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
  
        $this->add([
            'name' => 'package_dbl_rate_cpai1',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-dbl-rate-cpai1',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
         $this->add([
            'name' => 'package_dbl_rate_cpai2',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-dbl-rate-cpai2',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
         
          $this->add([
            'name' => 'package_dbl_rate_cpai3',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-dbl-rate-cpai3',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        $this->add([
            'name' => 'package_tbl_rate_cp1',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-tbl-rate-cp1',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        $this->add([
            'name' => 'package_tbl_rate_cp2',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-tbl-rate-cp2',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        $this->add([
            'name' => 'package_tbl_rate_cp3',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-tbl-rate-cp3',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
  
        $this->add([
            'name' => 'package_tbl_rate_cpai1',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-tbl-rate-cpai1',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        $this->add([
            'name' => 'package_tbl_rate_cpai2',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-tbl-rate-cpai2',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        $this->add([
            'name' => 'package_tbl_rate_cpai3',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-tbl-rate-cpai3',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
         $this->add([
            'name' => 'package_child_rate_cp1',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-child-rate-cp1',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
         
         $this->add([
            'name' => 'package_child_rate_cp2',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-child-rate-cp2',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
         
         $this->add([
            'name' => 'package_child_rate_cp3',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-child-rate-cp3',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
  
        $this->add([
            'name' => 'package_child_rate_cpai1',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-child-rate-cpai1',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        $this->add([
            'name' => 'package_child_rate_cpai2',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-child-rate-cpai2',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        $this->add([
            'name' => 'package_child_rate_cpai3',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-child-rate-cpai3',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        $this->add([
            'name' => 'package_child1_rate_cp1',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-child1-rate-cp1',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        $this->add([
            'name' => 'package_child1_rate_cp2',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-child1-rate-cp2',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        $this->add([
            'name' => 'package_child1_rate_cp3',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-child1-rate-cp3',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
  
        $this->add([
            'name' => 'package_child1_rate_cpai1',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-child1-rate-cpai1',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        $this->add([
            'name' => 'package_child1_rate_cpai2',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-child1-rate-cpai2',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        $this->add([
            'name' => 'package_child1_rate_cpai3',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-child1-rate-cpai3',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
         $this->add([
            'name' => 'package_extra_bed_rate_cp1',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-extra-bed-rate-cp1',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
         
         $this->add([
            'name' => 'package_extra_bed_rate_cp2',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-extra-bed-rate-cp2',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
         
         $this->add([
            'name' => 'package_extra_bed_rate_cp3',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-extra-bed-rate-cp3',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
  
        $this->add([
            'name' => 'package_extra_bed_rate_cpai1',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-extra-bed-rate-cpai1',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        $this->add([
            'name' => 'package_extra_bed_rate_cpai2',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-extra-bed-rate-cpai2',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        $this->add([
            'name' => 'package_extra_bed_rate_cpai3',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-extra-bed-rate-cpai3',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        
        
        
        
        /////////////
        
        
        
        
        $this->add([
            'name' => 'package_sgl_rate_map1',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-sgl-rate-map1',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        $this->add([
            'name' => 'package_sgl_rate_map2',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-sgl-rate-map2',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        $this->add([
            'name' => 'package_sgl_rate_map3',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-sgl-rate-map3',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
  
        $this->add([
            'name' => 'package_sgl_rate_mapai1',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-sgl-rate-mapai1',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        $this->add([
            'name' => 'package_sgl_rate_mapai2',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-sgl-rate-mapai2',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
         $this->add([
            'name' => 'package_sgl_rate_mapai3',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-sgl-rate-mapai3',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        $this->add([
            'name' => 'package_dbl_rate_map1',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-dbl-rate-map1',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        $this->add([
            'name' => 'package_dbl_rate_map2',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-dbl-rate-map2',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        $this->add([
            'name' => 'package_dbl_rate_map3',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-dbl-rate-map3',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
  
        $this->add([
            'name' => 'package_dbl_rate_mapai1',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-dbl-rate-mapai1',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        $this->add([
            'name' => 'package_dbl_rate_mapai2',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-dbl-rate-mapai2',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        $this->add([
            'name' => 'package_dbl_rate_mapai3',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-dbl-rate-mapai3',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        $this->add([
            'name' => 'package_tbl_rate_map1',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-tbl-rate-map1',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        $this->add([
            'name' => 'package_tbl_rate_map2',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-tbl-rate-map2',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        $this->add([
            'name' => 'package_tbl_rate_map3',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-tbl-rate-map3',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
  
        $this->add([
            'name' => 'package_tbl_rate_mapai1',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-tbl-rate-mapai1',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        $this->add([
            'name' => 'package_tbl_rate_mapai2',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-tbl-rate-mapai2',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        $this->add([
            'name' => 'package_tbl_rate_mapai3',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-tbl-rate-mapai3',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
         $this->add([
            'name' => 'package_child_rate_map1',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-child-rate-map1',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
         
         $this->add([
            'name' => 'package_child_rate_map2',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-child-rate-map2',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
         
         $this->add([
            'name' => 'package_child_rate_map3',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-child-rate-map3',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
  
        $this->add([
            'name' => 'package_child_rate_mapai1',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-child-rate-mapai1',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        $this->add([
            'name' => 'package_child_rate_mapai2',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-child-rate-mapai2',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        $this->add([
            'name' => 'package_child_rate_mapai3',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-child-rate-mapai3',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        $this->add([
            'name' => 'package_child1_rate_map1',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-child1-rate-map1',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        $this->add([
            'name' => 'package_child1_rate_map2',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-child1-rate-map2',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        $this->add([
            'name' => 'package_child1_rate_map3',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-child1-rate-map3',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
  
        $this->add([
            'name' => 'package_child1_rate_mapai1',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-child1-rate-mapai1',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        $this->add([
            'name' => 'package_child1_rate_mapai2',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-child1-rate-mapai2',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        $this->add([
            'name' => 'package_child1_rate_mapai3',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-child1-rate-mapai3',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
         $this->add([
            'name' => 'package_extra_bed_rate_map1',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-extra-bed-rate-map1',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
         
         $this->add([
            'name' => 'package_extra_bed_rate_map2',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-extra-bed-rate-map2',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
         
         $this->add([
            'name' => 'package_extra_bed_rate_map3',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-extra-bed-rate-map3',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
  
        $this->add([
            'name' => 'package_extra_bed_rate_mapai1',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-extra-bed-rate-mapai1',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
         $this->add([
            'name' => 'package_extra_bed_rate_mapai2',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-extra-bed-rate-mapai2',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
         
          $this->add([
            'name' => 'package_extra_bed_rate_mapai3',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-extra-bed-rate-mapai3',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        
                /////////////
        
        
        
        
        $this->add([
            'name' => 'package_sgl_rate_ap1',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-sgl-rate-ap1',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        $this->add([
            'name' => 'package_sgl_rate_ap2',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-sgl-rate-ap2',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        $this->add([
            'name' => 'package_sgl_rate_ap3',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-sgl-rate-ap2',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
  
        $this->add([
            'name' => 'package_sgl_rate_apai1',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-sgl-rate-apai1',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        $this->add([
            'name' => 'package_sgl_rate_apai2',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-sgl-rate-apai2',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        $this->add([
            'name' => 'package_sgl_rate_apai3',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-sgl-rate-apai3',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        $this->add([
            'name' => 'package_dbl_rate_ap1',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-dbl-rate-ap1',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        $this->add([
            'name' => 'package_dbl_rate_ap2',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-dbl-rate-ap2',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        $this->add([
            'name' => 'package_dbl_rate_ap3',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-dbl-rate-ap3',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
  
        $this->add([
            'name' => 'package_dbl_rate_apai1',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-dbl-rate-apai1',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
         $this->add([
            'name' => 'package_dbl_rate_apai2',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-dbl-rate-apai2',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
         
          $this->add([
            'name' => 'package_dbl_rate_apai3',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-dbl-rate-apai3',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
       
        
        $this->add([
            'name' => 'package_tbl_rate_ap1',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-tbl-rate-ap1',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        $this->add([
            'name' => 'package_tbl_rate_ap2',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-tbl-rate-ap2',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);       
         
        
        $this->add([
            'name' => 'package_tbl_rate_ap3',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-tbl-rate-ap3',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
  
        $this->add([
            'name' => 'package_tbl_rate_apai1',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-tbl-rate-apai1',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
         $this->add([
            'name' => 'package_tbl_rate_apai2',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-tbl-rate-apai2',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
         
          $this->add([
            'name' => 'package_tbl_rate_apai3',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-tbl-rate-apai3',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
         $this->add([
            'name' => 'package_child_rate_ap1',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-child-rate-ap1',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
         
         $this->add([
            'name' => 'package_child_rate_ap2',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-child-rate-ap2',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
         
         $this->add([
            'name' => 'package_child_rate_ap3',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-child-rate-ap3',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
  
        $this->add([
            'name' => 'package_child_rate_apai1',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-child-rate-apai1',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        $this->add([
            'name' => 'package_child_rate_apai2',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-child-rate-apai2',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        $this->add([
            'name' => 'package_child_rate_apai3',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-child-rate-apai3',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        $this->add([
            'name' => 'package_child1_rate_ap1',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-child1-rate-ap1',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        $this->add([
            'name' => 'package_child1_rate_ap2',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-child1-rate-ap2',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        $this->add([
            'name' => 'package_child1_rate_ap3',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-child1-rate-ap3',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
  
        $this->add([
            'name' => 'package_child1_rate_apai1',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-child1-rate-apai1',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        $this->add([
            'name' => 'package_child1_rate_apai2',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-child1-rate-apai2',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        $this->add([
            'name' => 'package_child1_rate_apai3',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-child1-rate-apai3',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
         $this->add([
            'name' => 'package_extra_bed_rate_ap1',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-extra-bed-rate-ap1',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
         
         $this->add([
            'name' => 'package_extra_bed_rate_ap2',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-extra-bed-rate-ap2',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
         
         $this->add([
            'name' => 'package_extra_bed_rate_ap3',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-extra-bed-rate-ap3',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
  
        $this->add([
            'name' => 'package_extra_bed_rate_apai1',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-extra-bed-rate-apai1',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        $this->add([
            'name' => 'package_extra_bed_rate_apai2',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-extra-bed-rate-apai2',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        $this->add([
            'name' => 'package_extra_bed_rate_apai3',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-extra-bed-rate-apai3',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        
        ///////////////
        
        $this->add([
            'name' => 'package_sgl_rate_allinclusive1',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-sgl-rate-allinclusive1',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        $this->add([
            'name' => 'package_sgl_rate_allinclusive2',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-sgl-rate-allinclusive2',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        $this->add([
            'name' => 'package_sgl_rate_allinclusive3',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-sgl-rate-allinclusive3',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
  
        $this->add([
            'name' => 'package_sgl_rate_allinclai1',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-sgl-rate-allinclai1',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        $this->add([
            'name' => 'package_sgl_rate_allinclai2',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-sgl-rate-allinclai2',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        $this->add([
            'name' => 'package_sgl_rate_allinclai3',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-sgl-rate-allinclai3',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        $this->add([
            'name' => 'package_dbl_rate_allinclusive1',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-dbl-rate-allinclusive1',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        $this->add([
            'name' => 'package_dbl_rate_allinclusive2',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-dbl-rate-allinclusive2',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        $this->add([
            'name' => 'package_dbl_rate_allinclusive3',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-dbl-rate-allinclusive3',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
  
        $this->add([
            'name' => 'package_dbl_rate_allinclai1',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-dbl-rate-allinclai1',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
         $this->add([
            'name' => 'package_dbl_rate_allinclai2',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-dbl-rate-allinclai2',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
         
          $this->add([
            'name' => 'package_dbl_rate_allinclai3',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-dbl-rate-allinclai3',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        $this->add([
            'name' => 'package_tbl_rate_allinclusive1',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-tbl-rate-allinclusive1',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        $this->add([
            'name' => 'package_tbl_rate_allinclusive2',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-tbl-rate-allinclusive2',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        $this->add([
            'name' => 'package_tbl_rate_allinclusive3',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-tbl-rate-allinclusive3',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
  
        $this->add([
            'name' => 'package_tbl_rate_allinclai1',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-tbl-rate-allinclai1',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        $this->add([
            'name' => 'package_tbl_rate_allinclai2',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-tbl-rate-allinclai2',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        $this->add([
            'name' => 'package_tbl_rate_allinclai3',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-tbl-rate-allinclai3',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
         $this->add([
            'name' => 'package_child_rate_allinclusive1',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-child-rate-allinclusive1',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
         
         $this->add([
            'name' => 'package_child_rate_allinclusive2',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-child-rate-allinclusive2',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
         
         $this->add([
            'name' => 'package_child_rate_allinclusive3',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-child-rate-allinclusive3',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
  
        $this->add([
            'name' => 'package_child_rate_allinclai1',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-child-rate-allinclai1',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        $this->add([
            'name' => 'package_child_rate_allinclai2',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-child-rate-allinclai2',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        $this->add([
            'name' => 'package_child_rate_allinclai3',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-child-rate-allinclai3',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        $this->add([
            'name' => 'package_child1_rate_allinclusive1',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-child1-rate-allinclusive1',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        $this->add([
            'name' => 'package_child1_rate_allinclusive2',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-child1-rate-allinclusive2',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        $this->add([
            'name' => 'package_child1_rate_allinclusive3',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-child1-rate-allinclusive3',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
  
        $this->add([
            'name' => 'package_child1_rate_allinclai1',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-child1-rate-allinclai1',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        $this->add([
            'name' => 'package_child1_rate_allinclai2',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-child1-rate-allinclai2',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        $this->add([
            'name' => 'package_child1_rate_allinclai3',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-child1-rate-allinclai3',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
         $this->add([
            'name' => 'package_extra_bed_rate_allinclusive1',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-extra-bed-rate-allinclusive1',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
         
         $this->add([
            'name' => 'package_extra_bed_rate_allinclusive2',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-extra-bed-rate-allinclusive2',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
         
         $this->add([
            'name' => 'package_extra_bed_rate_allinclusive3',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-extra-bed-rate-allinclusive3',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
  
        $this->add([
            'name' => 'package_extra_bed_rate_allinclai1',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-extra-bed-rate-allinclai1',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        $this->add([
            'name' => 'package_extra_bed_rate_allinclai2',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-extra-bed-rate-allinclai2',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        $this->add([
            'name' => 'package_extra_bed_rate_allinclai3',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-extra-bed-rate-allinclai3',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        
        
         ///////////
        
        
         $this->add([
            'name' => 'package_sgl_rate_jungleplan1',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-sgl-rate-jungleplan1',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
         
         $this->add([
            'name' => 'package_sgl_rate_jungleplan2',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-sgl-rate-jungleplan2',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
         
         $this->add([
            'name' => 'package_sgl_rate_jungleplan3',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-sgl-rate-jungleplan3',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
  
        
        
        $this->add([
            'name' => 'package_dbl_rate_jungleplan1',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-dbl-rate-jungleplan1',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        $this->add([
            'name' => 'package_dbl_rate_jungleplan2',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-dbl-rate-jungleplan2',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        $this->add([
            'name' => 'package_dbl_rate_jungleplan3',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-dbl-rate-jungleplan3',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
  
        
        
        $this->add([
            'name' => 'package_tbl_rate_jungleplan1',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-tbl-rate-jungleplan1',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        $this->add([
            'name' => 'package_tbl_rate_jungleplan2',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-tbl-rate-jungleplan2',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        $this->add([
            'name' => 'package_tbl_rate_jungleplan3',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-tbl-rate-jungleplan3',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
         
       
        
        
         $this->add([
            'name' => 'package_child_rate_jungleplan1',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-child-rate-jungleplan1',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
         
         $this->add([
            'name' => 'package_child_rate_jungleplan2',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-child-rate-jungleplan2',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
         
         $this->add([
            'name' => 'package_child_rate_jungleplan3',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-child-rate-jungleplan3',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
  
       $this->add([
            'name' => 'package_child1_rate_jungleplan1',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-child1-rate-jungleplan1',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
       
       $this->add([
            'name' => 'package_child1_rate_jungleplan2',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-child1-rate-jungleplan2',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        $this->add([
            'name' => 'package_child1_rate_jungleplan3',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-child1-rate-jungleplan3package_child1_rate_jungleplanai1',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
  
        
         $this->add([
            'name' => 'package_extra_bed_rate_jungleplan1',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-extra-bed-rate-jungleplan1',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
         
         $this->add([
            'name' => 'package_extra_bed_rate_jungleplan2',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-extra-bed-rate-jungleplan2',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
         
         $this->add([
            'name' => 'package_extra_bed_rate_jungleplan3',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-extra-bed-rate-jungleplan3',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
  
        
        ///////////
        
        
         $this->add([
            'name' => 'package_sgl_rate_jungleplanai1',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-sgl-rate-jungleplanai1',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
         
         
         $this->add([
            'name' => 'package_sgl_rate_jungleplanai2',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-sgl-rate-jungleplanai2',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
         
         
         $this->add([
            'name' => 'package_sgl_rate_jungleplanai3',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-sgl-rate-jungleplanai3',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
  

        
        
        $this->add([
            'name' => 'package_dbl_rate_jungleplanai1',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-dbl-rate-jungleplanai1',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        $this->add([
            'name' => 'package_dbl_rate_jungleplanai2',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-dbl-rate-jungleplanai2',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        $this->add([
            'name' => 'package_dbl_rate_jungleplanai3',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-dbl-rate-jungleplanai3',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
  
        $this->add([
            'name' => 'package_dbl_rate_allinclai',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-dbl-rate-allinclai',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        $this->add([
            'name' => 'package_tbl_rate_jungleplanai1',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-tbl-rate-jungleplanai1',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        $this->add([
            'name' => 'package_tbl_rate_jungleplanai2',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-tbl-rate-jungleplanai2',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        $this->add([
            'name' => 'package_tbl_rate_jungleplanai3',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-tbl-rate-jungleplanai3',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
  

        
         $this->add([
            'name' => 'package_child_rate_jungleplanai1',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-child-rate-jungleplanai1',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
         
         
         $this->add([
            'name' => 'package_child_rate_jungleplanai2',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-child-rate-jungleplanai2',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
         
         
         $this->add([
            'name' => 'package_child_rate_jungleplanai3',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-child-rate-jungleplanai3',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        

        
        $this->add([
            'name' => 'package_child1_rate_jungleplanai1',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-child1-rate-jungleplanai1',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        $this->add([
            'name' => 'package_child1_rate_jungleplanai2',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-child1-rate-jungleplanai2',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        $this->add([
            'name' => 'package_child1_rate_jungleplanai3',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-child1-rate-jungleplanai3',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
  

        
         $this->add([
            'name' => 'package_extra_bed_rate_jungleplanai1',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-extra-bed-rate-jungleplanai1',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
         
         $this->add([
            'name' => 'package_extra_bed_rate_jungleplanai2',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-extra-bed-rate-jungleplanai2',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
         
         $this->add([
            'name' => 'package_extra_bed_rate_jungleplanai3',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-extra-bed-rate-jungleplanai3',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        

        
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        $this->add([
            'name' => 'sgl_pub_rate_cp',
            'type' => Text::class,
            'attributes' => [
                'id' => 'sgl-pub-rate-cp',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        
        $this->add([
            'name' => 'sgl_pub_rate_map',
            'type' => Text::class,
            'attributes' => [
                'id' => 'sgl-pub-rate-map',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
       
        
        $this->add([
            'name' => 'sgl_pub_rate_ap',
            'type' => Text::class,
            'attributes' => [
                'id' => 'sgl-pub-rate-ap',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);   
        
        
        
        $this->add([
            'name' => 'sgl_pub_rate_ai',
            'type' => Text::class,
            'attributes' => [
                'id' => 'sgl-pub-rate-ai',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        
        $this->add([
            'name' => 'sgl_pub_rate_jp',
            'type' => Text::class,
            'attributes' => [
                'id' => 'sgl-pub-rate-jp',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        $this->add([
            'name' => 'sgl_pub_tax_per_ep',
            'type' => Text::class,
            'attributes' => [
                'id' => 'sgl-pub-tax-per-ep',
                'class' => 'form-control ep_pub_tax',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        
        $this->add([
            'name' => 'sgl_pub_tax_per_cp',
            'type' => Text::class,
            'attributes' => [
                'id' => 'sgl-pub-tax-per-cp',
                'class' => 'form-control cp_pub_tax',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        
        
        $this->add([
            'name' => 'sgl_pub_tax_per_map',
            'type' => Text::class,
            'attributes' => [
                'id' => 'sgl-pub-tax-per-map',
                'class' => 'form-control map_pub_tax',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        
        $this->add([
            'name' => 'sgl_pub_tax_per_ap',
            'type' => Text::class,
            'attributes' => [
                'id' => 'sgl-pub-tax-per-ap',
                'class' => 'form-control ap_pub_tax',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        
        
        $this->add([
            'name' => 'sgl_pub_tax_per_ai',
            'type' => Text::class,
            'attributes' => [
                'id' => 'sgl-pub-tax-per-ai',
                'class' => 'form-control ai_pub_tax',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        $this->add([
            'name' => 'sgl_pub_tax_per_jp',
            'type' => Text::class,
            'attributes' => [
                'id' => 'sgl-pub-tax-per-jp',
                'class' => 'form-control jp_pub_tax',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        
        
        $this->add([
            'name' => 'sgl_net_rate_ep',
            'type' => Text::class,
            'attributes' => [
                'id' => 'sgl-net-rate-ep',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        $this->add([
            'name' => 'sgl_net_rate_cp',
            'type' => Text::class,
            'attributes' => [
                'id' => 'sgl-net-rate-cp',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        $this->add([
            'name' => 'sgl_net_rate_map',
            'type' => Text::class,
            'attributes' => [
                'id' => 'sgl-net-rate-map',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        
        $this->add([
            'name' => 'sgl_net_rate_ap',
            'type' => Text::class,
            'attributes' => [
                'id' => 'sgl-net-rate-ap',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        $this->add([
            'name' => 'sgl_net_rate_ai',
            'type' => Text::class,
            'attributes' => [
                'id' => 'sgl-net-rate-ai',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        
        $this->add([
            'name' => 'sgl_net_rate_jp',
            'type' => Text::class,
            'attributes' => [
                'id' => 'sgl-net-rate-jp',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);       
        
        
        $this->add([
            'name' => 'sgl_net_tax_per_ep',
            'type' => Text::class,
            'attributes' => [
                'id' => 'sgl-net-tax-per-ep',
                'class' => 'form-control ep_net_tax',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        $this->add([
            'name' => 'sgl_net_tax_per_cp',
            'type' => Text::class,
            'attributes' => [
                'id' => 'sgl-net-tax-per-cp',
                'class' => 'form-control cp_net_tax',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        $this->add([
            'name' => 'sgl_net_tax_per_map',
            'type' => Text::class,
            'attributes' => [
                'id' => 'sgl-net-tax-per-map',
                'class' => 'form-control map_net_tax',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        $this->add([
            'name' => 'sgl_net_tax_per_ap',
            'type' => Text::class,
            'attributes' => [
                'id' => 'sgl-net-tax-per-ap',
                'class' => 'form-control ap_net_tax',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        $this->add([
            'name' => 'sgl_net_tax_per_ai',
            'type' => Text::class,
            'attributes' => [
                'id' => 'sgl-net-tax-per-ai',
                'class' => 'form-control ai_net_tax',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        $this->add([
            'name' => 'sgl_net_tax_per_jp',
            'type' => Text::class,
            'attributes' => [
                'id' => 'sgl-net-tax-per-jp',
                'class' => 'form-control jp_net_tax',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        /**         
         * DBL ATTRIBUTES
         */
        $this->add([
            'name' => 'dbl_pub_rate_ep',
            'type' => Text::class,
            'attributes' => [
                'id' => 'dbl-pub-rate-ep',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
                
        $this->add([
            'name' => 'dbl_pub_rate_cp',
            'type' => Text::class,
            'attributes' => [
                'id' => 'dbl-pub-rate-cp',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
               
        
        $this->add([
            'name' => 'dbl_pub_rate_map',
            'type' => Text::class,
            'attributes' => [
                'id' => 'dbl-pub-rate-map',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        $this->add([
            'name' => 'dbl_pub_rate_ap',
            'type' => Text::class,
            'attributes' => [
                'id' => 'dbl-pub-rate-ap',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        
        $this->add([
            'name' => 'dbl_pub_rate_ai',
            'type' => Text::class,
            'attributes' => [
                'id' => 'dbl-pub-rate-ai',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        
        $this->add([
            'name' => 'dbl_pub_rate_jp',
            'type' => Text::class,
            'attributes' => [
                'id' => 'dbl-pub-rate-jp',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);              
        
        
        $this->add([
            'name' => 'dbl_pub_tax_per_ep',
            'type' => Text::class,
            'attributes' => [
                'id' => 'dbl-pub-tax-per-ep',
                'class' => 'form-control ep_pub_tax',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
                
        
        $this->add([
            'name' => 'dbl_pub_tax_per_cp',
            'type' => Text::class,
            'attributes' => [
                'id' => 'dbl-pub-tax-per-cp',
                'class' => 'form-control cp_pub_tax',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        
        $this->add([
            'name' => 'dbl_pub_tax_per_map',
            'type' => Text::class,
            'attributes' => [
                'id' => 'dbl-pub-tax-per-map',
                'class' => 'form-control map_pub_tax',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        $this->add([
            'name' => 'dbl_pub_tax_per_ap',
            'type' => Text::class,
            'attributes' => [
                'id' => 'dbl-pub-tax-per-ap',
                'class' => 'form-control ap_pub_tax',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        $this->add([
            'name' => 'dbl_pub_tax_per_ai',
            'type' => Text::class,
            'attributes' => [
                'id' => 'dbl-pub-tax-per-ai',
                'class' => 'form-control ai_pub_tax',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        $this->add([
            'name' => 'dbl_pub_tax_per_jp',
            'type' => Text::class,
            'attributes' => [
                'id' => 'dbl-pub-tax-per-jp',
                'class' => 'form-control jp_pub_tax',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        $this->add([
            'name' => 'dbl_net_rate_ep',
            'type' => Text::class,
            'attributes' => [
                'id' => 'dbl-net-rate-ep',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        $this->add([
            'name' => 'dbl_net_rate_cp',
            'type' => Text::class,
            'attributes' => [
                'id' => 'dbl-net-rate-cp',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        $this->add([
            'name' => 'dbl_net_rate_map',
            'type' => Text::class,
            'attributes' => [
                'id' => 'dbl-net-rate-map',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        $this->add([
            'name' => 'dbl_net_rate_ap',
            'type' => Text::class,
            'attributes' => [
                'id' => 'dbl-net-rate-ap',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
       
        $this->add([
            'name' => 'dbl_net_rate_ai',
            'type' => Text::class,
            'attributes' => [
                'id' => 'dbl-net-rate-ai',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);        
        
        
        $this->add([
            'name' => 'dbl_net_rate_jp',
            'type' => Text::class,
            'attributes' => [
                'id' => 'dbl-net-rate-jp',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        $this->add([
            'name' => 'dbl_net_tax_per_ep',
            'type' => Text::class,
            'attributes' => [
                'id' => 'dbl-net-tax-per-ep',
                'class' => 'form-control ep_net_tax',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        $this->add([
            'name' => 'dbl_net_tax_per_cp',
            'type' => Text::class,
            'attributes' => [
                'id' => 'dbl-net-tax-per-cp',
                'class' => 'form-control cp_net_tax',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
       
        $this->add([
            'name' => 'dbl_net_tax_per_map',
            'type' => Text::class,
            'attributes' => [
                'id' => 'dbl-net-tax-per-map',
                'class' => 'form-control map_net_tax',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        $this->add([
            'name' => 'dbl_net_tax_per_ap',
            'type' => Text::class,
            'attributes' => [
                'id' => 'dbl-net-tax-per-ap',
                'class' => 'form-control ap_net_tax',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
       
        $this->add([
            'name' => 'dbl_net_tax_per_ai',
            'type' => Text::class,
            'attributes' => [
                'id' => 'dbl-net-tax-per-ai',
                'class' => 'form-control ai_net_tax',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        $this->add([
            'name' => 'dbl_net_tax_per_jp',
            'type' => Text::class,
            'attributes' => [
                'id' => 'dbl-net-tax-per-jp',
                'class' => 'form-control jp_net_tax',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        
        /**         
         * TBL ATTRIBUTES
         */
        $this->add([
            'name' => 'tbl_pub_rate_ep',
            'type' => Text::class,
            'attributes' => [
                'id' => 'tbl-pub-rate-ep',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        $this->add([
            'name' => 'tbl_pub_rate_cp',
            'type' => Text::class,
            'attributes' => [
                'id' => 'tbl-pub-rate-cp',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        $this->add([
            'name' => 'tbl_pub_rate_map',
            'type' => Text::class,
            'attributes' => [
                'id' => 'tbl-pub-rate-map',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        $this->add([
            'name' => 'tbl_pub_rate_ap',
            'type' => Text::class,
            'attributes' => [
                'id' => 'tbl-pub-rate-ap',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        $this->add([
            'name' => 'tbl_pub_rate_ai',
            'type' => Text::class,
            'attributes' => [
                'id' => 'tbl-pub-rate-ai',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        
        $this->add([
            'name' => 'tbl_pub_rate_jp',
            'type' => Text::class,
            'attributes' => [
                'id' => 'tbl-pub-rate-jp',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        $this->add([
            'name' => 'tbl_pub_tax_per_ep',
            'type' => Text::class,
            'attributes' => [
                'id' => 'tbl-pub-tax-per-ep',
                'class' => 'form-control ep_pub_tax',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        $this->add([
            'name' => 'tbl_pub_tax_per_cp',
            'type' => Text::class,
            'attributes' => [
                'id' => 'tbl-pub-tax-per-cp',
                'class' => 'form-control cp_pub_tax',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        $this->add([
            'name' => 'tbl_pub_tax_per_map',
            'type' => Text::class,
            'attributes' => [
                'id' => 'tbl-pub-tax-per-map',
                'class' => 'form-control map_pub_tax',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
       
        
        $this->add([
            'name' => 'tbl_pub_tax_per_ap',
            'type' => Text::class,
            'attributes' => [
                'id' => 'tbl-pub-tax-per-ap',
                'class' => 'form-control ap_pub_tax',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        
        $this->add([
            'name' => 'tbl_pub_tax_per_ai',
            'type' => Text::class,
            'attributes' => [
                'id' => 'tbl-pub-tax-per-ai',
                'class' => 'form-control ai_pub_tax',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        $this->add([
            'name' => 'tbl_pub_tax_per_jp',
            'type' => Text::class,
            'attributes' => [
                'id' => 'tbl-pub-tax-per-jp',
                'class' => 'form-control jp_pub_tax',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        $this->add([
            'name' => 'tbl_net_rate_ep',
            'type' => Text::class,
            'attributes' => [
                'id' => 'tbl-net-rate-ep',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);     
        
                
        $this->add([
            'name' => 'tbl_net_rate_cp',
            'type' => Text::class,
            'attributes' => [
                'id' => 'tbl-net-rate-cp',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);        
        
        
        $this->add([
            'name' => 'tbl_net_rate_map',
            'type' => Text::class,
            'attributes' => [
                'id' => 'tbl-net-rate-map',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
       
        $this->add([
            'name' => 'tbl_net_rate_ap',
            'type' => Text::class,
            'attributes' => [
                'id' => 'tbl-net-rate-ap',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        
        $this->add([
            'name' => 'tbl_net_rate_ai',
            'type' => Text::class,
            'attributes' => [
                'id' => 'tbl-net-rate-ai',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        
        $this->add([
            'name' => 'tbl_net_rate_jp',
            'type' => Text::class,
            'attributes' => [
                'id' => 'tbl-net-rate-jp',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        
        
        $this->add([
            'name' => 'tbl_net_tax_per_ep',
            'type' => Text::class,
            'attributes' => [
                'id' => 'tbl-net-tax-per-ep',
                'class' => 'form-control ep_net_tax',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
       
        $this->add([
            'name' => 'tbl_net_tax_per_cp',
            'type' => Text::class,
            'attributes' => [
                'id' => 'tbl-net-tax-per-cp',
                'class' => 'form-control cp_net_tax',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        $this->add([
            'name' => 'tbl_net_tax_per_map',
            'type' => Text::class,
            'attributes' => [
                'id' => 'tbl-net-tax-per-map',
                'class' => 'form-control map_net_tax',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        $this->add([
            'name' => 'tbl_net_tax_per_ap',
            'type' => Text::class,
            'attributes' => [
                'id' => 'tbl-net-tax-per-ap',
                'class' => 'form-control ap_net_tax',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        $this->add([
            'name' => 'tbl_net_tax_per_ai',
            'type' => Text::class,
            'attributes' => [
                'id' => 'tbl-net-tax-per-ai',
                'class' => 'form-control ai_net_tax',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        $this->add([
            'name' => 'tbl_net_tax_per_jp',
            'type' => Text::class,
            'attributes' => [
                'id' => 'tbl-net-tax-per-jp',
                'class' => 'form-control jp_net_tax',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        
        
        /**         
         * CHILD (2-12) ATTRIBUTES
         */
        $this->add([
            'name' => 'child_pub_rate_ep',
            'type' => Text::class,
            'attributes' => [
                'id' => 'child-pub-rate-ep',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        $this->add([
            'name' => 'child_pub_rate_cp',
            'type' => Text::class,
            'attributes' => [
                'id' => 'child-pub-rate-cp',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        $this->add([
            'name' => 'child_pub_rate_map',
            'type' => Text::class,
            'attributes' => [
                'id' => 'child-pub-rate-map',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        
        $this->add([
            'name' => 'child_pub_rate_ap',
            'type' => Text::class,
            'attributes' => [
                'id' => 'child-pub-rate-ap',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        $this->add([
            'name' => 'child_pub_rate_ai',
            'type' => Text::class,
            'attributes' => [
                'id' => 'child-pub-rate-ai',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);        
        
        $this->add([
            'name' => 'child_pub_rate_jp',
            'type' => Text::class,
            'attributes' => [
                'id' => 'child-pub-rate-jp',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        $this->add([
            'name' => 'child_pub_tax_per_ep',
            'type' => Text::class,
            'attributes' => [
                'id' => 'child-pub-tax-per-ep',
                'class' => 'form-control ep_pub_tax',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        $this->add([
            'name' => 'child_pub_tax_per_cp',
            'type' => Text::class,
            'attributes' => [
                'id' => 'child-pub-tax-per-cp',
                'class' => 'form-control cp_pub_tax',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        $this->add([
            'name' => 'child_pub_tax_per_map',
            'type' => Text::class,
            'attributes' => [
                'id' => 'child-pub-tax-per-map',
                'class' => 'form-control map_pub_tax',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        $this->add([
            'name' => 'child_pub_tax_per_ap',
            'type' => Text::class,
            'attributes' => [
                'id' => 'child-pub-tax-per-ap',
                'class' => 'form-control ap_pub_tax',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        $this->add([
            'name' => 'child_pub_tax_per_ai',
            'type' => Text::class,
            'attributes' => [
                'id' => 'child-pub-tax-per-ai',
                'class' => 'form-control ai_pub_tax',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
                
        $this->add([
            'name' => 'child_pub_tax_per_jp',
            'type' => Text::class,
            'attributes' => [
                'id' => 'child-pub-tax-per-jp',
                'class' => 'form-control jp_pub_tax',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);        
                
        $this->add([
            'name' => 'child_net_rate_ep',
            'type' => Text::class,
            'attributes' => [
                'id' => 'child-net-rate-ep',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        $this->add([
            'name' => 'child_net_rate_cp',
            'type' => Text::class,
            'attributes' => [
                'id' => 'child-net-rate-cp',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        $this->add([
            'name' => 'child_net_rate_map',
            'type' => Text::class,
            'attributes' => [
                'id' => 'child-net-rate-map',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        $this->add([
            'name' => 'child_net_rate_ap',
            'type' => Text::class,
            'attributes' => [
                'id' => 'child-net-rate-ap',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        $this->add([
            'name' => 'child_net_rate_ai',
            'type' => Text::class,
            'attributes' => [
                'id' => 'child-net-rate-ai',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        
        $this->add([
            'name' => 'child_net_rate_jp',
            'type' => Text::class,
            'attributes' => [
                'id' => 'child-net-rate-jp',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        
        
        $this->add([
            'name' => 'child_net_tax_per_ep',
            'type' => Text::class,
            'attributes' => [
                'id' => 'child-net-tax-per-ep',
                'class' => 'form-control ep_net_tax',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        $this->add([
            'name' => 'child_net_tax_per_cp',
            'type' => Text::class,
            'attributes' => [
                'id' => 'child-net-tax-per-cp',
                'class' => 'form-control cp_net_tax',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        $this->add([
            'name' => 'child_net_tax_per_map',
            'type' => Text::class,
            'attributes' => [
                'id' => 'child-net-tax-per-map',
                'class' => 'form-control map_net_tax',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        $this->add([
            'name' => 'child_net_tax_per_ap',
            'type' => Text::class,
            'attributes' => [
                'id' => 'child-net-tax-per-ap',
                'class' => 'form-control ap_net_tax',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        $this->add([
            'name' => 'child_net_tax_per_ai',
            'type' => Text::class,
            'attributes' => [
                'id' => 'child-net-tax-per-ai',
                'class' => 'form-control ai_net_tax',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        $this->add([
            'name' => 'child_net_tax_per_jp',
            'type' => Text::class,
            'attributes' => [
                'id' => 'child-net-tax-per-jp',
                'class' => 'form-control jp_net_tax',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
       
        /**         
         * CHILD (12-16) ATTRIBUTES
         */
        $this->add([
            'name' => 'child1_pub_rate_ep',
            'type' => Text::class,
            'attributes' => [
                'id' => 'child1-pub-rate-ep',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        $this->add([
            'name' => 'child1_pub_rate_cp',
            'type' => Text::class,
            'attributes' => [
                'id' => 'child1-pub-rate-cp',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);       
       
        
        $this->add([
            'name' => 'child1_pub_rate_map',
            'type' => Text::class,
            'attributes' => [
                'id' => 'child1-pub-rate-map',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        
        $this->add([
            'name' => 'child1_pub_rate_ap',
            'type' => Text::class,
            'attributes' => [
                'id' => 'child1-pub-rate-ap',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        $this->add([
            'name' => 'child1_pub_rate_ai',
            'type' => Text::class,
            'attributes' => [
                'id' => 'child1-pub-rate-ai',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        $this->add([
            'name' => 'child1_pub_rate_jp',
            'type' => Text::class,
            'attributes' => [
                'id' => 'child1-pub-rate-jp',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        $this->add([
            'name' => 'child1_pub_tax_per_ep',
            'type' => Text::class,
            'attributes' => [
                'id' => 'child1-pub-tax-per-ep',
                'class' => 'form-control ep_pub_tax',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        $this->add([
            'name' => 'child1_pub_tax_per_cp',
            'type' => Text::class,
            'attributes' => [
                'id' => 'child1-pub-tax-per-cp',
                'class' => 'form-control cp_pub_tax',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
               
        
        $this->add([
            'name' => 'child1_pub_tax_per_map',
            'type' => Text::class,
            'attributes' => [
                'id' => 'child1-pub-tax-per-map',
                'class' => 'form-control map_pub_tax',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);        
        
        $this->add([
            'name' => 'child1_pub_tax_per_ap',
            'type' => Text::class,
            'attributes' => [
                'id' => 'child1-pub-tax-per-ap',
                'class' => 'form-control ap_pub_tax',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        $this->add([
            'name' => 'child1_pub_tax_per_ai',
            'type' => Text::class,
            'attributes' => [
                'id' => 'child1-pub-tax-per-ai',
                'class' => 'form-control ai_pub_tax',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);      
        
        
        $this->add([
            'name' => 'child1_pub_tax_per_jp',
            'type' => Text::class,
            'attributes' => [
                'id' => 'child1-pub-tax-per-jp',
                'class' => 'form-control jp_pub_tax',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        $this->add([
            'name' => 'child1_net_rate_ep',
            'type' => Text::class,
            'attributes' => [
                'id' => 'child1-net-rate-ep',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
                
        $this->add([
            'name' => 'child1_net_rate_cp',
            'type' => Text::class,
            'attributes' => [
                'id' => 'child1-net-rate-cp',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
       
        $this->add([
            'name' => 'child1_net_rate_map',
            'type' => Text::class,
            'attributes' => [
                'id' => 'child1-net-rate-map',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
               
        $this->add([
            'name' => 'child1_net_rate_ap',
            'type' => Text::class,
            'attributes' => [
                'id' => 'child1-net-rate-ap',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        $this->add([
            'name' => 'child1_net_rate_ai',
            'type' => Text::class,
            'attributes' => [
                'id' => 'child1-net-rate-ai',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        $this->add([
            'name' => 'child1_net_rate_jp',
            'type' => Text::class,
            'attributes' => [
                'id' => 'child1-net-rate-jp',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        $this->add([
            'name' => 'child1_net_tax_per_ep',
            'type' => Text::class,
            'attributes' => [
                'id' => 'child1-net-tax-per-ep',
                'class' => 'form-control ep_net_tax',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        $this->add([
            'name' => 'child1_net_tax_per_cp',
            'type' => Text::class,
            'attributes' => [
                'id' => 'child1-net-tax-per-cp',
                'class' => 'form-control cp_net_tax',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        $this->add([
            'name' => 'child1_net_tax_per_map',
            'type' => Text::class,
            'attributes' => [
                'id' => 'child1-net-tax-per-map',
                'class' => 'form-control map_net_tax',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        $this->add([
            'name' => 'child1_net_tax_per_ap',
            'type' => Text::class,
            'attributes' => [
                'id' => 'child1-net-tax-per-ap',
                'class' => 'form-control ap_net_tax',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        $this->add([
            'name' => 'child1_net_tax_per_ai',
            'type' => Text::class,
            'attributes' => [
                'id' => 'child1-net-tax-per-ai',
                'class' => 'form-control ai_net_tax',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        $this->add([
            'name' => 'child1_net_tax_per_jp',
            'type' => Text::class,
            'attributes' => [
                'id' => 'child1-net-tax-per-jp',
                'class' => 'form-control jp_net_tax',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        /**         
         * EXTRA WITH BED ATTRIBUTES
         */
        $this->add([
            'name' => 'extra_bed_pub_rate_ep',
            'type' => Text::class,
            'attributes' => [
                'id' => 'extra_bed-pub-rate-ep',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        $this->add([
            'name' => 'extra_bed_pub_rate_cp',
            'type' => Text::class,
            'attributes' => [
                'id' => 'extra_bed-pub-rate-cp',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        $this->add([
            'name' => 'extra_bed_pub_rate_map',
            'type' => Text::class,
            'attributes' => [
                'id' => 'extra_bed-pub-rate-map',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        $this->add([
            'name' => 'extra_bed_pub_rate_ap',
            'type' => Text::class,
            'attributes' => [
                'id' => 'extra_bed-pub-rate-ap',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        $this->add([
            'name' => 'extra_bed_pub_rate_ai',
            'type' => Text::class,
            'attributes' => [
                'id' => 'extra_bed-pub-rate-ai',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        $this->add([
            'name' => 'extra_bed_pub_rate_jp',
            'type' => Text::class,
            'attributes' => [
                'id' => 'extra_bed-pub-rate-jp',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        $this->add([
            'name' => 'extra_bed_pub_tax_per_ep',
            'type' => Text::class,
            'attributes' => [
                'id' => 'extra_bed-pub-tax-per-ep',
                'class' => 'form-control ep_pub_tax',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        $this->add([
            'name' => 'extra_bed_pub_tax_per_cp',
            'type' => Text::class,
            'attributes' => [
                'id' => 'extra_bed-pub-tax-per-cp',
                'class' => 'form-control cp_pub_tax',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        $this->add([
            'name' => 'extra_bed_pub_tax_per_map',
            'type' => Text::class,
            'attributes' => [
                'id' => 'extra_bed-pub-tax-per-map',
                'class' => 'form-control map_pub_tax',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);       
        
        
        $this->add([
            'name' => 'extra_bed_pub_tax_per_ap',
            'type' => Text::class,
            'attributes' => [
                'id' => 'extra_bed-pub-tax-per-ap',
                'class' => 'form-control ap_pub_tax',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        $this->add([
            'name' => 'extra_bed_pub_tax_per_ai',
            'type' => Text::class,
            'attributes' => [
                'id' => 'extra_bed-pub-tax-per-ai',
                'class' => 'form-control ai_pub_tax',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        $this->add([
            'name' => 'extra_bed_pub_tax_per_jp',
            'type' => Text::class,
            'attributes' => [
                'id' => 'extra_bed-pub-tax-per-jp',
                'class' => 'form-control jp_pub_tax',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
       
                
        $this->add([
            'name' => 'extra_bed_net_rate_ep',
            'type' => Text::class,
            'attributes' => [
                'id' => 'extra_bed-net-rate-ep',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
      
        $this->add([
            'name' => 'extra_bed_net_rate_cp',
            'type' => Text::class,
            'attributes' => [
                'id' => 'extra_bed-net-rate-cp',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        
        $this->add([
            'name' => 'extra_bed_net_rate_map',
            'type' => Text::class,
            'attributes' => [
                'id' => 'extra_bed-net-rate-map',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        $this->add([
            'name' => 'extra_bed_net_rate_ap',
            'type' => Text::class,
            'attributes' => [
                'id' => 'extra_bed-net-rate-ap',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
       
        $this->add([
            'name' => 'extra_bed_net_rate_ai',
            'type' => Text::class,
            'attributes' => [
                'id' => 'extra_bed-net-rate-ai',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
       
        
        $this->add([
            'name' => 'extra_bed_net_rate_jp',
            'type' => Text::class,
            'attributes' => [
                'id' => 'extra_bed-net-rate-jp',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        
        $this->add([
            'name' => 'extra_bed_net_tax_per_ep',
            'type' => Text::class,
            'attributes' => [
                'id' => 'extra_bed-net-tax-per-ep',
                'class' => 'form-control ep_net_tax',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);        
       
        $this->add([
            'name' => 'extra_bed_net_tax_per_cp',
            'type' => Text::class,
            'attributes' => [
                'id' => 'extra_bed-net-tax-per-cp',
                'class' => 'form-control cp_net_tax',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);        
        
        $this->add([
            'name' => 'extra_bed_net_tax_per_map',
            'type' => Text::class,
            'attributes' => [
                'id' => 'extra_bed-net-tax-per-map',
                'class' => 'form-control map_net_tax',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);        
        
        $this->add([
            'name' => 'extra_bed_net_tax_per_ap',
            'type' => Text::class,
            'attributes' => [
                'id' => 'extra_bed-net-tax-per-ap',
                'class' => 'form-control ap_net_tax',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);        
        
        $this->add([
            'name' => 'extra_bed_net_tax_per_ai',
            'type' => Text::class,
            'attributes' => [
                'id' => 'extra_bed-net-tax-per-ai',
                'class' => 'form-control ai_net_tax',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);        
       
        $this->add([
            'name' => 'extra_bed_net_tax_per_jp',
            'type' => Text::class,
            'attributes' => [
                'id' => 'extra_bed-net-tax-per-jp',
                'class' => 'form-control jp_net_tax',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);      
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        /**         
         * SGL ATTRIBUTES
         */
        $this->add([
            'name' => 'package_sgl_pub_rate_ep',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-sgl-pub-rate-ep',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        
        $this->add([
            'name' => 'package_sgl_pub_rate_cp',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-sgl-pub-rate-cp',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        
        $this->add([
            'name' => 'package_sgl_pub_rate_map',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-sgl-pub-rate-map',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
       
        
        $this->add([
            'name' => 'package_sgl_pub_rate_ap',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-sgl-pub-rate-ap',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);   
        
        
        
        $this->add([
            'name' => 'package_sgl_pub_rate_ai',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-sgl-pub-rate-ai',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        
        $this->add([
            'name' => 'package_sgl_pub_rate_jp',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-sgl-pub-rate-jp',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        $this->add([
            'name' => 'package_sgl_pub_tax_per_ep',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-sgl-pub-tax-per-ep',
                'class' => 'form-control ep_pub_tax',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        
        $this->add([
            'name' => 'package_sgl_pub_tax_per_cp',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-sgl-pub-tax-per-cp',
                'class' => 'form-control cp_pub_tax',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        
        
        $this->add([
            'name' => 'package_sgl_pub_tax_per_map',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-sgl-pub-tax-per-map',
                'class' => 'form-control map_pub_tax',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        
        $this->add([
            'name' => 'package_sgl_pub_tax_per_ap',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-sgl-pub-tax-per-ap',
                'class' => 'form-control ap_pub_tax',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        
        
        $this->add([
            'name' => 'package_sgl_pub_tax_per_ai',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-sgl-pub-tax-per-ai',
                'class' => 'form-control ai_pub_tax',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        $this->add([
            'name' => 'package_sgl_pub_tax_per_jp',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-sgl-pub-tax-per-jp',
                'class' => 'form-control jp_pub_tax',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        
        
        $this->add([
            'name' => 'package_sgl_net_rate_ep',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-sgl-net-rate-ep',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        $this->add([
            'name' => 'package_sgl_net_rate_cp',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-sgl-net-rate-cp',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        $this->add([
            'name' => 'package_sgl_net_rate_map',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-sgl-net-rate-map',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        
        $this->add([
            'name' => 'package_sgl_net_rate_ap',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-sgl-net-rate-ap',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        $this->add([
            'name' => 'package_sgl_net_rate_ai',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-sgl-net-rate-ai',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        
        $this->add([
            'name' => 'package_sgl_net_rate_jp',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-sgl-net-rate-jp',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);       
        
        
        $this->add([
            'name' => 'package_sgl_net_tax_per_ep',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-sgl-net-tax-per-ep',
                'class' => 'form-control ep_net_tax',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        $this->add([
            'name' => 'package_sgl_net_tax_per_cp',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-sgl-net-tax-per-cp',
                'class' => 'form-control cp_net_tax',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        $this->add([
            'name' => 'package_sgl_net_tax_per_map',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-sgl-net-tax-per-map',
                'class' => 'form-control map_net_tax',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        $this->add([
            'name' => 'package_sgl_net_tax_per_ap',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-sgl-net-tax-per-ap',
                'class' => 'form-control ap_net_tax',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        $this->add([
            'name' => 'package_sgl_net_tax_per_ai',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-sgl-net-tax-per-ai',
                'class' => 'form-control ai_net_tax',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        $this->add([
            'name' => 'package_sgl_net_tax_per_jp',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-sgl-net-tax-per-jp',
                'class' => 'form-control jp_net_tax',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        
        
        
        
                /**         
         * DBL ATTRIBUTES
         */
        $this->add([
            'name' => 'package_dbl_pub_rate_ep',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-dbl-pub-rate-ep',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        
        $this->add([
            'name' => 'package_dbl_pub_rate_cp',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-dbl-pub-rate-cp',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        
        $this->add([
            'name' => 'package_dbl_pub_rate_map',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-dbl-pub-rate-map',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
       
        
        $this->add([
            'name' => 'package_dbl_pub_rate_ap',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-dbl-pub-rate-ap',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);   
        
        
        
        $this->add([
            'name' => 'package_dbl_pub_rate_ai',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-dbl-pub-rate-ai',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        
        $this->add([
            'name' => 'package_dbl_pub_rate_jp',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-dbl-pub-rate-jp',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        $this->add([
            'name' => 'package_dbl_pub_tax_per_ep',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-dbl-pub-tax-per-ep',
                'class' => 'form-control ep_pub_tax',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        
        $this->add([
            'name' => 'package_dbl_pub_tax_per_cp',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-dbl-pub-tax-per-cp',
                'class' => 'form-control cp_pub_tax',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        
        
        $this->add([
            'name' => 'package_dbl_pub_tax_per_map',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-dbl-pub-tax-per-map',
                'class' => 'form-control map_pub_tax',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        
        $this->add([
            'name' => 'package_dbl_pub_tax_per_ap',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-dbl-pub-tax-per-ap',
                'class' => 'form-control ap_pub_tax',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        
        
        $this->add([
            'name' => 'package_dbl_pub_tax_per_ai',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-dbl-pub-tax-per-ai',
                'class' => 'form-control ai_pub_tax',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        $this->add([
            'name' => 'package_dbl_pub_tax_per_jp',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-dbl-pub-tax-per-jp',
                'class' => 'form-control jp_pub_tax',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        
        
        $this->add([
            'name' => 'package_dbl_net_rate_ep',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-dbl-net-rate-ep',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        $this->add([
            'name' => 'package_dbl_net_rate_cp',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-dbl-net-rate-cp',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        $this->add([
            'name' => 'package_dbl_net_rate_map',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-dbl-net-rate-map',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        
        $this->add([
            'name' => 'package_dbl_net_rate_ap',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-dbl-net-rate-ap',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        $this->add([
            'name' => 'package_dbl_net_rate_ai',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-dbl-net-rate-ai',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        
        $this->add([
            'name' => 'package_dbl_net_rate_jp',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-dbl-net-rate-jp',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);       
        
        
        $this->add([
            'name' => 'package_dbl_net_tax_per_ep',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-dbl-net-tax-per-ep',
                'class' => 'form-control ep_net_tax',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        $this->add([
            'name' => 'package_dbl_net_tax_per_cp',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-dbl-net-tax-per-cp',
                'class' => 'form-control cp_net_tax',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        $this->add([
            'name' => 'package_dbl_net_tax_per_map',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-dbl-net-tax-per-map',
                'class' => 'form-control map_net_tax',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        $this->add([
            'name' => 'package_dbl_net_tax_per_ap',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-dbl-net-tax-per-ap',
                'class' => 'form-control ap_net_tax',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        $this->add([
            'name' => 'package_dbl_net_tax_per_ai',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-dbl-net-tax-per-ai',
                'class' => 'form-control ai_net_tax',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        $this->add([
            'name' => 'package_dbl_net_tax_per_jp',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-dbl-net-tax-per-jp',
                'class' => 'form-control jp_net_tax',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        
        
        
                /**         
         * TBL ATTRIBUTES
         */
        $this->add([
            'name' => 'package_tbl_pub_rate_ep',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-tbl-pub-rate-ep',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        
        $this->add([
            'name' => 'package_tbl_pub_rate_cp',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-tbl-pub-rate-cp',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        
        $this->add([
            'name' => 'package_tbl_pub_rate_map',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-tbl-pub-rate-map',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
       
        
        $this->add([
            'name' => 'package_tbl_pub_rate_ap',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-tbl-pub-rate-ap',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);   
        
        
        
        $this->add([
            'name' => 'package_tbl_pub_rate_ai',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-tbl-pub-rate-ai',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        
        $this->add([
            'name' => 'package_tbl_pub_rate_jp',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-tbl-pub-rate-jp',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        $this->add([
            'name' => 'package_tbl_pub_tax_per_ep',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-tbl-pub-tax-per-ep',
                'class' => 'form-control ep_pub_tax',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        
        $this->add([
            'name' => 'package_tbl_pub_tax_per_cp',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-tbl-pub-tax-per-cp',
                'class' => 'form-control cp_pub_tax',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        
        
        $this->add([
            'name' => 'package_tbl_pub_tax_per_map',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-tbl-pub-tax-per-map',
                'class' => 'form-control map_pub_tax',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        
        $this->add([
            'name' => 'package_tbl_pub_tax_per_ap',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-tbl-pub-tax-per-ap',
                'class' => 'form-control ap_pub_tax',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        
        
        $this->add([
            'name' => 'package_tbl_pub_tax_per_ai',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-tbl-pub-tax-per-ai',
                'class' => 'form-control ai_pub_tax',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        $this->add([
            'name' => 'package_tbl_pub_tax_per_jp',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-tbl-pub-tax-per-jp',
                'class' => 'form-control jp_pub_tax',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        
        
        $this->add([
            'name' => 'package_tbl_net_rate_ep',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-tbl-net-rate-ep',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        $this->add([
            'name' => 'package_tbl_net_rate_cp',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-tbl-net-rate-cp',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        $this->add([
            'name' => 'package_tbl_net_rate_map',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-tbl-net-rate-map',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        
        $this->add([
            'name' => 'package_tbl_net_rate_ap',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-tbl-net-rate-ap',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        $this->add([
            'name' => 'package_tbl_net_rate_ai',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-tbl-net-rate-ai',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        
        $this->add([
            'name' => 'package_tbl_net_rate_jp',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-tbl-net-rate-jp',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);       
        
        
        $this->add([
            'name' => 'package_tbl_net_tax_per_ep',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-tbl-net-tax-per-ep',
                'class' => 'form-control ep_net_tax',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        $this->add([
            'name' => 'package_tbl_net_tax_per_cp',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-tbl-net-tax-per-cp',
                'class' => 'form-control cp_net_tax',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        $this->add([
            'name' => 'package_tbl_net_tax_per_map',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-tbl-net-tax-per-map',
                'class' => 'form-control map_net_tax',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        $this->add([
            'name' => 'package_tbl_net_tax_per_ap',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-tbl-net-tax-per-ap',
                'class' => 'form-control ap_net_tax',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        $this->add([
            'name' => 'package_tbl_net_tax_per_ai',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-tbl-net-tax-per-ai',
                'class' => 'form-control ai_net_tax',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        $this->add([
            'name' => 'package_tbl_net_tax_per_jp',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-tbl-net-tax-per-jp',
                'class' => 'form-control jp_net_tax',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        
        
        
        
        
        
        
        /**         
         * CHILS ATTRIBUTES
         */
        $this->add([
            'name' => 'package_child_pub_rate_ep',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-child-pub-rate-ep',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        
        $this->add([
            'name' => 'package_child_pub_rate_cp',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-child-pub-rate-cp',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        
        $this->add([
            'name' => 'package_child_pub_rate_map',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-child-pub-rate-map',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
       
        
        $this->add([
            'name' => 'package_child_pub_rate_ap',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-child-pub-rate-ap',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);   
        
        
        
        $this->add([
            'name' => 'package_child_pub_rate_ai',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-child-pub-rate-ai',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        
        $this->add([
            'name' => 'package_child_pub_rate_jp',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-child-pub-rate-jp',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        $this->add([
            'name' => 'package_child_pub_tax_per_ep',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-child-pub-tax-per-ep',
                'class' => 'form-control ep_pub_tax',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        
        $this->add([
            'name' => 'package_child_pub_tax_per_cp',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-child-pub-tax-per-cp',
                'class' => 'form-control cp_pub_tax',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        
        
        $this->add([
            'name' => 'package_child_pub_tax_per_map',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-child-pub-tax-per-map',
                'class' => 'form-control map_pub_tax',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        
        $this->add([
            'name' => 'package_child_pub_tax_per_ap',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-child-pub-tax-per-ap',
                'class' => 'form-control ap_pub_tax',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        
        
        $this->add([
            'name' => 'package_child_pub_tax_per_ai',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-child-pub-tax-per-ai',
                'class' => 'form-control ai_pub_tax',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        $this->add([
            'name' => 'package_child_pub_tax_per_jp',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-child-pub-tax-per-jp',
                'class' => 'form-control jp_pub_tax',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        
        
        $this->add([
            'name' => 'package_child_net_rate_ep',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-child-net-rate-ep',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        $this->add([
            'name' => 'package_child_net_rate_cp',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-child-net-rate-cp',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        $this->add([
            'name' => 'package_child_net_rate_map',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-child-net-rate-map',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        
        $this->add([
            'name' => 'package_child_net_rate_ap',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-child-net-rate-ap',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        $this->add([
            'name' => 'package_child_net_rate_ai',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-child-net-rate-ai',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        
        $this->add([
            'name' => 'package_child_net_rate_jp',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-child-net-rate-jp',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);       
        
        
        $this->add([
            'name' => 'package_child_net_tax_per_ep',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-child-net-tax-per-ep',
                'class' => 'form-control ep_net_tax',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        $this->add([
            'name' => 'package_child_net_tax_per_cp',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-child-net-tax-per-cp',
                'class' => 'form-control cp_net_tax',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        $this->add([
            'name' => 'package_child_net_tax_per_map',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-child-net-tax-per-map',
                'class' => 'form-control map_net_tax',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        $this->add([
            'name' => 'package_child_net_tax_per_ap',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-child-net-tax-per-ap',
                'class' => 'form-control ap_net_tax',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        $this->add([
            'name' => 'package_child_net_tax_per_ai',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-child-net-tax-per-ai',
                'class' => 'form-control ai_net_tax',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        $this->add([
            'name' => 'package_child_net_tax_per_jp',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-child-net-tax-per-jp',
                'class' => 'form-control jp_net_tax',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        
        /**         
         * CHILD1 ATTRIBUTES
         */
        $this->add([
            'name' => 'package_child1_pub_rate_ep',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-child1-pub-rate-ep',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        
        $this->add([
            'name' => 'package_child1_pub_rate_cp',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-child1-pub-rate-cp',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        
        $this->add([
            'name' => 'package_child1_pub_rate_map',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-child1-pub-rate-map',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
       
        
        $this->add([
            'name' => 'package_child1_pub_rate_ap',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-child1-pub-rate-ap',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);   
        
        
        
        $this->add([
            'name' => 'package_child1_pub_rate_ai',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-child1-pub-rate-ai',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        
        $this->add([
            'name' => 'package_child1_pub_rate_jp',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-child1-pub-rate-jp',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        $this->add([
            'name' => 'package_child1_pub_tax_per_ep',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-child1-pub-tax-per-ep',
                'class' => 'form-control ep_pub_tax',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        
        $this->add([
            'name' => 'package_child1_pub_tax_per_cp',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-child1-pub-tax-per-cp',
                'class' => 'form-control cp_pub_tax',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        
        
        $this->add([
            'name' => 'package_child1_pub_tax_per_map',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-child1-pub-tax-per-map',
                'class' => 'form-control map_pub_tax',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        
        $this->add([
            'name' => 'package_child1_pub_tax_per_ap',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-child1-pub-tax-per-ap',
                'class' => 'form-control ap_pub_tax',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        
        
        $this->add([
            'name' => 'package_child1_pub_tax_per_ai',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-child1-pub-tax-per-ai',
                'class' => 'form-control ai_pub_tax',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        $this->add([
            'name' => 'package_child1_pub_tax_per_jp',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-child1-pub-tax-per-jp',
                'class' => 'form-control jp_pub_tax',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        
        
        $this->add([
            'name' => 'package_child1_net_rate_ep',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-child1-net-rate-ep',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        $this->add([
            'name' => 'package_child1_net_rate_cp',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-child1-net-rate-cp',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        $this->add([
            'name' => 'package_child1_net_rate_map',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-child1-net-rate-map',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        
        $this->add([
            'name' => 'package_child1_net_rate_ap',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-child1-net-rate-ap',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        $this->add([
            'name' => 'package_child1_net_rate_ai',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-child1-net-rate-ai',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        
        $this->add([
            'name' => 'package_child1_net_rate_jp',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-child1-net-rate-jp',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);       
        
        
        $this->add([
            'name' => 'package_child1_net_tax_per_ep',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-child1-net-tax-per-ep',
                'class' => 'form-control ep_net_tax',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        $this->add([
            'name' => 'package_child1_net_tax_per_cp',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-child1-net-tax-per-cp',
                'class' => 'form-control cp_net_tax',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        $this->add([
            'name' => 'package_child1_net_tax_per_map',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-child1-net-tax-per-map',
                'class' => 'form-control map_net_tax',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        $this->add([
            'name' => 'package_child1_net_tax_per_ap',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-child1-net-tax-per-ap',
                'class' => 'form-control ap_net_tax',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        $this->add([
            'name' => 'package_child1_net_tax_per_ai',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-child1-net-tax-per-ai',
                'class' => 'form-control ai_net_tax',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        $this->add([
            'name' => 'package_child1_net_tax_per_jp',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-child1-net-tax-per-jp',
                'class' => 'form-control jp_net_tax',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        /**         
         * EXTRA ATTRIBUTES
         */
        $this->add([
            'name' => 'package_extra_bed_pub_rate_ep',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-extra_bed-pub-rate-ep',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        
        $this->add([
            'name' => 'package_extra_bed_pub_rate_cp',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-extra_bed-pub-rate-cp',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        
        $this->add([
            'name' => 'package_extra_bed_pub_rate_map',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-extra_bed-pub-rate-map',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
       
        
        $this->add([
            'name' => 'package_extra_bed_pub_rate_ap',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-extra_bed-pub-rate-ap',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);   
        
        
        
        $this->add([
            'name' => 'package_extra_bed_pub_rate_ai',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-extra_bed-pub-rate-ai',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        
        $this->add([
            'name' => 'package_extra_bed_pub_rate_jp',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-extra_bed-pub-rate-jp',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        $this->add([
            'name' => 'package_extra_bed_pub_tax_per_ep',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-extra_bed-pub-tax-per-ep',
                'class' => 'form-control ep_pub_tax',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        
        $this->add([
            'name' => 'package_extra_bed_pub_tax_per_cp',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-extra_bed-pub-tax-per-cp',
                'class' => 'form-control cp_pub_tax',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        
        
        $this->add([
            'name' => 'package_extra_bed_pub_tax_per_map',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-extra_bed-pub-tax-per-map',
                'class' => 'form-control map_pub_tax',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        
        $this->add([
            'name' => 'package_extra_bed_pub_tax_per_ap',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-extra_bed-pub-tax-per-ap',
                'class' => 'form-control ap_pub_tax',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        
        
        $this->add([
            'name' => 'package_extra_bed_pub_tax_per_ai',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-extra_bed-pub-tax-per-ai',
                'class' => 'form-control ai_pub_tax',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        $this->add([
            'name' => 'package_extra_bed_pub_tax_per_jp',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-extra_bed-pub-tax-per-jp',
                'class' => 'form-control jp_pub_tax',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        
        
        $this->add([
            'name' => 'package_extra_bed_net_rate_ep',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-extra_bed-net-rate-ep',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        $this->add([
            'name' => 'package_extra_bed_net_rate_cp',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-extra_bed-net-rate-cp',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        $this->add([
            'name' => 'package_extra_bed_net_rate_map',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-extra_bed-net-rate-map',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        
        $this->add([
            'name' => 'package_extra_bed_net_rate_ap',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-extra_bed-net-rate-ap',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        $this->add([
            'name' => 'package_extra_bed_net_rate_ai',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-extra_bed-net-rate-ai',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        
        $this->add([
            'name' => 'package_extra_bed_net_rate_jp',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-extra_bed-net-rate-jp',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);       
        
        
        $this->add([
            'name' => 'package_extra_bed_net_tax_per_ep',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-extra_bed-net-tax-per-ep',
                'class' => 'form-control ep_net_tax',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        $this->add([
            'name' => 'package_extra_bed_net_tax_per_cp',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-extra_bed-net-tax-per-cp',
                'class' => 'form-control cp_net_tax',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        $this->add([
            'name' => 'package_extra_bed_net_tax_per_map',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-extra_bed-net-tax-per-map',
                'class' => 'form-control map_net_tax',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        $this->add([
            'name' => 'package_extra_bed_net_tax_per_ap',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-extra_bed-net-tax-per-ap',
                'class' => 'form-control ap_net_tax',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        $this->add([
            'name' => 'package_extra_bed_net_tax_per_ai',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-extra_bed-net-tax-per-ai',
                'class' => 'form-control ai_net_tax',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        $this->add([
            'name' => 'package_extra_bed_net_tax_per_jp',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-extra_bed-net-tax-per-jp',
                'class' => 'form-control jp_net_tax',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        
       
        
        
        /**         
         * EXTRA MEAL ATTRIBUTES
         */        
        
        $this->add([
            'name' => 'extra_meal_adult_sgl',
            'type' => Text::class,
            'attributes' => [
                'id' => 'extra-meal-adult-sgl',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]); 
        
        $this->add([
            'name' => 'extra_meal_child_sgl',
            'type' => Text::class,
            'attributes' => [
                'id' => 'extra-meal-child-sgl',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]); 
        
        
        $this->add([
            'name' => 'extra_meal_adult_dbl',
            'type' => Text::class,
            'attributes' => [
                'id' => 'extra-meal-adult-dbl',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]); 
        
        $this->add([
            'name' => 'extra_meal_child_dbl',
            'type' => Text::class,
            'attributes' => [
                'id' => 'extra-meal-child-dbl',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        $this->add([
            'name' => 'extra_meal_adult_tbl',
            'type' => Text::class,
            'attributes' => [
                'id' => 'extra-meal-adult-tbl',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]); 
        
        $this->add([
            'name' => 'extra_meal_child_tbl',
            'type' => Text::class,
            'attributes' => [
                'id' => 'extra-meal-child-tbl',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        $this->add([
            'name' => 'extra_meal_adult_child',
            'type' => Text::class,
            'attributes' => [
                'id' => 'extra-meal-adult-child',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]); 
        
        $this->add([
            'name' => 'extra_meal_child_child',
            'type' => Text::class,
            'attributes' => [
                'id' => 'extra-meal-child-child',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        $this->add([
            'name' => 'extra_meal_adult_child1',
            'type' => Text::class,
            'attributes' => [
                'id' => 'extra-meal-adult-child1',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]); 
        
        $this->add([
            'name' => 'extra_meal_child_child1',
            'type' => Text::class,
            'attributes' => [
                'id' => 'extra-meal-child-child1',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        $this->add([
            'name' => 'extra_meal_adult_extra_bed',
            'type' => Text::class,
            'attributes' => [
                'id' => 'extra-meal-adult-extra-bed',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]); 
        
        $this->add([
            'name' => 'extra_meal_child_extra_bed',
            'type' => Text::class,
            'attributes' => [
                'id' => 'extra-meal-child-extra-bed',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        
        
        
        
        
        
        
         /**         
         * EXTRA MEAL Package ATTRIBUTES
         */        
        
        $this->add([
            'name' => 'extra_meal_adult_sgl_package[]',
            'type' => Text::class,
            'attributes' => [
                'id' => 'extra-meal-adult-sgl-package',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]); 
        
        $this->add([
            'name' => 'extra_meal_child_sgl_package',
            'type' => Text::class,
            'attributes' => [
                'id' => 'extra-meal-child-sgl-package',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]); 
        
        
        $this->add([
            'name' => 'extra_meal_adult_dbl_package[]',
            'type' => Text::class,
            'attributes' => [
                'id' => 'extra-meal-adult-dbl-package',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]); 
        
        $this->add([
            'name' => 'extra_meal_child_dbl_package',
            'type' => Text::class,
            'attributes' => [
                'id' => 'extra-meal-child-dbl-package',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        $this->add([
            'name' => 'extra_meal_adult_tbl_package[]',
            'type' => Text::class,
            'attributes' => [
                'id' => 'extra-meal-adult-tbl-package',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]); 
        
        $this->add([
            'name' => 'extra_meal_child_tbl_package',
            'type' => Text::class,
            'attributes' => [
                'id' => 'extra-meal-child-tbl-package',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        $this->add([
            'name' => 'extra_meal_adult_child_package',
            'type' => Text::class,
            'attributes' => [
                'id' => 'extra-meal-adult-child-package',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]); 
        
        $this->add([
            'name' => 'extra_meal_child_child_package[]',
            'type' => Text::class,
            'attributes' => [
                'id' => 'extra-meal-child-child-package',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        $this->add([
            'name' => 'extra_meal_adult_child1_package',
            'type' => Text::class,
            'attributes' => [
                'id' => 'extra-meal-adult-child1-package',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]); 
        
        $this->add([
            'name' => 'extra_meal_child_child1_package[]',
            'type' => Text::class,
            'attributes' => [
                'id' => 'extra-meal-child-child1-package',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        $this->add([
            'name' => 'extra_meal_adult_extra_bed_package',
            'type' => Text::class,
            'attributes' => [
                'id' => 'extra-meal-adult-extra-bed-package',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]); 
        
        $this->add([
            'name' => 'extra_meal_child_extra_bed_package[]',
            'type' => Text::class,
            'attributes' => [
                'id' => 'extra-meal-child-extra-bed-package',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        /**
         *
         * Name of price Plan
         */
        $this->add([
            'name' => 'package_name_of_price_plan[]',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-name-of-price-plan',
                'placelder' => '40Km',
                'class' => 'form-control allowtext',
            ],
            'options' => [
                'label' => 'Name of price Plan',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        /**
         *
         * Name of price Plan
         */
        $this->add([
            'name' => 'name_of_price_plan',
            'type' => Text::class,
            'attributes' => [
                'id' => 'name-of-price-plan',
                'placelder' => '40Km',
                'class' => 'form-control allowtext',
            ],
            'options' => [
                'label' => 'Name of price Plan',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        /**
         *
         * Staying days
         */
        $this->add([
            'name' => 'staying_days[]',
            'type' => Text::class,
            'attributes' => [
                'id' => 'staying-days_1',
                'placeholder' => 'Days',
                'class' => 'form-control allowtext',
            ],
            'options' => [
                'label' => 'Staying days',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        /**
         * 
         * More Discount Date From
         */
        $this->add([
            'name' => 'more_discount_from[]',
            'type' => Text::class,
            'attributes' => [
                'id' => 'more-discount-from_1',
                'class' => 'form-control text-uppercase datepicker date-valid-format',
                 'placeholder' => 'DD/MM/YYYY'
            ],
            'options' => [
                'label' => 'From<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        /**
         * 
         *  More Discount To
         */
        $this->add([
            'name' => 'more_discount_to[]',
            'type' => Text::class,
            'attributes' => [
                'id' => 'more-discount-to_1',
                'placeholder' => 'DD/MM/YYYY',
                'class' => 'form-control text-uppercase datepicker date-valid-format'
            ],
            'options' => [
                'label' => 'To Date',
            ],
         ]); 
        
        
        /**
         *
         * Staying amount
         */
        $this->add([
            'name' => 'staying_amount[]',
            'type' => Text::class,
            'attributes' => [
                'id' => 'staying-amount_1',
                 'placeholder' => 'Amount',
                'class' => 'form-control allowtext',
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => 'Amount',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
         /**
         *
         * Staying days
         */
        $this->add([
            'name' => 'package_staying_days[1]',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-staying-days_1',
                'placeholder' => 'Days',
                'class' => 'form-control allowtext',
            ],
            'options' => [
                'label' => 'Staying days',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        /**
         * 
         * More Discount Date From
         */
        $this->add([
            'name' => 'package_more_discount_from[1]',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-more-discount-from_1',
                'class' => 'form-control text-uppercase datepicker date-valid-format',
                 'placeholder' => 'DD/MM/YYYY'
            ],
            'options' => [
                'label' => 'From<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        /**
         * 
         *  More Discount To
         */
        $this->add([
            'name' => 'package_more_discount_to[1]',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-more-discount-to_1',
                'placeholder' => 'DD/MM/YYYY',
                'class' => 'form-control text-uppercase datepicker date-valid-format'
            ],
            'options' => [
                'label' => 'To Date',
            ],
         ]); 
        
        
        /**
         *
         * Staying amount
         */
        $this->add([
            'name' => 'package_staying_amount[1]',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-staying-amount_1',
                 'placeholder' => 'Amount',
                'class' => 'form-control allowtext',
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => 'Amount',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        /**
         *
         * No Of Rooms
         */
        $this->add([
            'name' => 'kids_package_name[]',
            'type' => Text::class,
            'attributes' => [
                'id' => 'kids-package-name_1',
                'placeholder' => 'Package Name',
                'class' => 'form-control allowtext',
            ],
            'options' => [
                'label' => 'Package Name',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        /**
         *
         * No Of Rooms
         */
        $this->add([
            'name' => 'kids_rooms[]',
            'type' => Text::class,
            'attributes' => [
                'id' => 'kids-rooms_1',
                'placeholder' => 'Rooms',
                'class' => 'form-control allowtext',
            ],
            'options' => [
                'label' => 'Rooms',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
         /**
         *
         * No Of Rooms
         */
        $this->add([
            'name' => 'kids_nights[]',
            'type' => Text::class,
            'attributes' => [
                'id' => 'kids-nights_1',
                'placeholder' => 'Nights',
                'class' => 'form-control allowtext',
            ],
            'options' => [
                'label' => 'Nights',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        /**
         * 
         * More Discount Date From
         */
        $this->add([
            'name' => 'kids_discount_from[]',
            'type' => Text::class,
            'attributes' => [
                'id' => 'kids-discount-from_1',
                'class' => 'form-control text-uppercase datepicker date-valid-format',
                 'placeholder' => 'DD/MM/YYYY'
            ],
            'options' => [
                'label' => 'From<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        /**
         * 
         *  More Discount To
         */
        $this->add([
            'name' => 'kids_discount_to[]',
            'type' => Text::class,
            'attributes' => [
                'id' => 'kids-discount-to_1',
                'placeholder' => 'DD/MM/YYYY',
                'class' => 'form-control text-uppercase datepicker date-valid-format'
            ],
            'options' => [
                'label' => 'To Date',
            ],
         ]); 
        
        
        
        
         /**
         *
         * No Of Rooms
         */
        $this->add([
            'name' => 'package_kids_package_name[]',
            'type' => Text::class,
            'attributes' => [
                'id' => 'pakage-kids-package-name_1',
                'placeholder' => 'Package Name',
                'class' => 'form-control allowtext',
            ],
            'options' => [
                'label' => 'Package Name',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        /**
         *
         * No Of Rooms
         */
        $this->add([
            'name' => 'package_kids_rooms[]',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-kids-rooms_1',
                'placeholder' => 'Rooms',
                'class' => 'form-control allowtext',
            ],
            'options' => [
                'label' => 'Rooms',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
         /**
         *
         * No Of Rooms
         */
        $this->add([
            'name' => 'package_kids_nights[]',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-kids-nights_1',
                'placeholder' => 'Nights',
                'class' => 'form-control allowtext',
            ],
            'options' => [
                'label' => 'Nights',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        /**
         * 
         * More Discount Date From
         */
        $this->add([
            'name' => 'package_kids_discount_from[]',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-kids-discount-from_1',
                'class' => 'form-control text-uppercase datepicker date-valid-format',
                 'placeholder' => 'DD/MM/YYYY'
            ],
            'options' => [
                'label' => 'From<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        /**
         * 
         *  More Discount To
         */
        $this->add([
            'name' => 'package_kids_discount_to[]',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-kids-discount-to_1',
                'placeholder' => 'DD/MM/YYYY',
                'class' => 'form-control text-uppercase datepicker date-valid-format'
            ],
            'options' => [
                'label' => 'To Date',
            ],
         ]); 
        
        
        /**
         *
         * No Of Rooms
         */
        $this->add([
            'name' => 'night_package_name[]',
            'type' => Text::class,
            'attributes' => [
                'id' => 'night-package-name_1',
                'placeholder' => 'Package Name',
                'class' => 'form-control allowtext',
            ],
            'options' => [
                'label' => 'Package Name',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        /**
         *
         * No Of Rooms
         */
        $this->add([
            'name' => 'night_rooms[]',
            'type' => Text::class,
            'attributes' => [
                'id' => 'night-rooms_1',
                'placeholder' => 'Rooms',
                'class' => 'form-control allowtext',
            ],
            'options' => [
                'label' => 'Rooms',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
         /**
         *
         * No Of Rooms
         */
        $this->add([
            'name' => 'night_nights[]',
            'type' => Text::class,
            'attributes' => [
                'id' => 'night-nights_1',
                'placeholder' => 'Nights',
                'class' => 'form-control allowtext',
            ],
            'options' => [
                'label' => 'Nights',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        /**
         * 
         * More Discount Date From
         */
        $this->add([
            'name' => 'night_discount_from[]',
            'type' => Text::class,
            'attributes' => [
                'id' => 'night-discount-from_1',
                'class' => 'form-control text-uppercase datepicker date-valid-format',
                 'placeholder' => 'DD/MM/YYYY'
            ],
            'options' => [
                'label' => 'From<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        /**
         * 
         *  More Discount To
         */
        $this->add([
            'name' => 'night_discount_to[]',
            'type' => Text::class,
            'attributes' => [
                'id' => 'night-discount-to_1',
                'placeholder' => 'DD/MM/YYYY',
                'class' => 'form-control text-uppercase datepicker date-valid-format'
            ],
            'options' => [
                'label' => 'To Date',
            ],
         ]); 
        
        
        
        
        
        
        
        
         /**
         *
         * No Of Rooms
         */
        $this->add([
            'name' => 'package_night_package_name[1]',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-night-package-name_1',
                'placeholder' => 'Package Name',
                'class' => 'form-control allowtext',
            ],
            'options' => [
                'label' => 'Package Name',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        /**
         *
         * No Of Rooms
         */
        $this->add([
            'name' => 'package_night_rooms[1]',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-night-rooms_1',
                'placeholder' => 'Rooms',
                'class' => 'form-control allowtext',
            ],
            'options' => [
                'label' => 'Rooms',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
         /**
         *
         * No Of Rooms
         */
        $this->add([
            'name' => 'package_night_nights[1]',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-night-nights_1',
                'placeholder' => 'Nights',
                'class' => 'form-control allowtext',
            ],
            'options' => [
                'label' => 'Nights',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        /**
         * 
         * More Discount Date From
         */
        $this->add([
            'name' => 'package_night_discount_from[1]',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-night-discount-from_1',
                'class' => 'form-control text-uppercase datepicker date-valid-format',
                 'placeholder' => 'DD/MM/YYYY'
            ],
            'options' => [
                'label' => 'From<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        /**
         * 
         *  More Discount To
         */
        $this->add([
            'name' => 'package_night_discount_to[1]',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-night-discount-to_1',
                'placeholder' => 'DD/MM/YYYY',
                'class' => 'form-control text-uppercase datepicker date-valid-format'
            ],
            'options' => [
                'label' => 'To Date',
            ],
         ]); 
        
        
        
        
        
        
        
        
        
        
        
        
        
        /**
         *
         * No Of Rooms
         */
        $this->add([
            'name' => 'room_package_name[]',
            'type' => Text::class,
            'attributes' => [
                'id' => 'room-package-name_1',
                'placeholder' => 'Package Name',
                'class' => 'form-control allowtext',
            ],
            'options' => [
                'label' => 'Package Name',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        /**
         *
         * No Of Rooms
         */
        $this->add([
            'name' => 'room_rooms[]',
            'type' => Text::class,
            'attributes' => [
                'id' => 'room-rooms_1',
                'placeholder' => 'Rooms',
                'class' => 'form-control allowtext',
            ],
            'options' => [
                'label' => 'Rooms',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
         /**
         *
         * No Of Rooms
         */
        $this->add([
            'name' => 'room_nights[]',
            'type' => Text::class,
            'attributes' => [
                'id' => 'room-nights_1',
                'placeholder' => 'Nights',
                'class' => 'form-control allowtext',
            ],
            'options' => [
                'label' => 'Nights',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        /**
         * 
         * More Discount Date From
         */
        $this->add([
            'name' => 'room_discount_from[]',
            'type' => Text::class,
            'attributes' => [
                'id' => 'room-discount-from_1',
                'class' => 'form-control text-uppercase datepicker date-valid-format',
                 'placeholder' => 'DD/MM/YYYY'
            ],
            'options' => [
                'label' => 'From<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        /**
         * 
         *  More Discount To
         */
        $this->add([
            'name' => 'room_discount_to[]',
            'type' => Text::class,
            'attributes' => [
                'id' => 'room-discount-to_1',
                'placeholder' => 'DD/MM/YYYY',
                'class' => 'form-control text-uppercase datepicker date-valid-format'
            ],
            'options' => [
                'label' => 'To Date',
            ],
         ]); 
        
        
        
        
        
        
        
        
        
        
        /**
         *
         * No Of Rooms
         */
        $this->add([
            'name' => 'package_room_package_name[1]',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-room-package-name_1',
                'placeholder' => 'Package Name',
                'class' => 'form-control allowtext',
            ],
            'options' => [
                'label' => 'Package Name',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        /**
         *
         * No Of Rooms
         */
        $this->add([
            'name' => 'package_room_rooms[1]',
            'type' => Text::class,
            'attributes' => [
                'id' => 'packae-room-rooms_1',
                'placeholder' => 'Rooms',
                'class' => 'form-control allowtext',
            ],
            'options' => [
                'label' => 'Rooms',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
         /**
         *
         * No Of Rooms
         */
        $this->add([
            'name' => 'package_room_nights[1]',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-room-nights_1',
                'placeholder' => 'Nights',
                'class' => 'form-control allowtext',
            ],
            'options' => [
                'label' => 'Nights',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        /**
         * 
         * More Discount Date From
         */
        $this->add([
            'name' => 'package_room_discount_from[1]',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-room-discount-from_1',
                'class' => 'form-control text-uppercase datepicker date-valid-format',
                 'placeholder' => 'DD/MM/YYYY'
            ],
            'options' => [
                'label' => 'From<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        /**
         * 
         *  More Discount To
         */
        $this->add([
            'name' => 'package_room_discount_to[1]',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-room-discount-to_1',
                'placeholder' => 'DD/MM/YYYY',
                'class' => 'form-control text-uppercase datepicker date-valid-format'
            ],
            'options' => [
                'label' => 'To Date',
            ],
         ]); 
        
        
        
        
        
        
        
        
        
        
        
        
        
        
       
        
        /**
         *
         * Season Name
         */
        $this->add([
            'name' => 'season_name[1]',
            'type' => Text::class,
            'attributes' => [
                'id' => 'Season-name_1',
                'placeholder' => 'Season',
                'class' => 'form-control allowtext',
            ],
            'options' => [
                'label' => 'Season Name',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
         /**
         * 
         * Season Date From
         */
        $this->add([
            'name' => 'season_date_from[1]',
            'type' => Text::class,
            'attributes' => [
                'id' => 'season-date-from_1',
                'class' => 'form-control text-uppercase datepicker date-valid-format',
                 'placeholder' => 'DD/MM/YYYY'
            ],
            'options' => [
                'label' => 'From<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        /**
         * 
         * Season Date To
         */
        $this->add([
            'name' => 'season_date_to[1]',
            'type' => Text::class,
            'attributes' => [
                'id' => 'season_date_to_1',
                'placeholder' => 'DD/MM/YYYY',
                'class' => 'form-control text-uppercase datepicker date-valid-format'
            ],
            'options' => [
                'label' => 'To Date',
            ],
         ]);  
        
        
        /**
         *
         * Season Amount
         */
        $this->add([
            'name' => 'season_amount[1]',
            'type' => Text::class,
            'attributes' => [
                'id' => 'season-amount_1',
                'placeholder'=>'Amount',
                'class' => 'form-control allowtext',
            ],
            'options' => [
                'label' => 'Amount',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        /**
         * 
         * Last Minute Booking Hours
         */
        $this->add([
            'name' => 'last_minute_booking_hour[]',
            'type' => Text::class,
            'attributes' => [
                'id' => 'last-minute-booking-hour',
                'placeholder' => 'Hour',
                'class' => 'form-control'
            ],
            'options' => [
                'label' => 'Hours',
            ],
         ]);  
        
        
        /**
         * 
         * Last Booking Date From
         */
        $this->add([
            'name' => 'last_booking_from[]',
            'type' => Text::class,
            'attributes' => [
                'id' => 'last-booking-from_1',
                'class' => 'form-control text-uppercase datepicker date-valid-format',
                 'placeholder' => 'DD/MM/YYYY'
            ],
            'options' => [
                'label' => 'From<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
         /**
         * 
         *  Last Booking To
         */
        $this->add([
            'name' => 'last_booking_to[]',
            'type' => Text::class,
            'attributes' => [
                'id' => 'last-booking-to_1',
                'placeholder' => 'DD/MM/YYYY',
                'class' => 'form-control text-uppercase datepicker date-valid-format'
            ],
            'options' => [
                'label' => 'To Date',
            ],
         ]);  
        
        /**
         * 
         * Last Minute Booking Amount
         */
        $this->add([
            'name' => 'last_minute_booking_amount[]',
            'type' => Text::class,
            'attributes' => [
                'id' => 'last-minute-booking-amount',
                'placeholder' => 'Amount',
                'class' => 'form-control'
            ],
            'options' => [
                'label' => 'Amount',
            ],
         ]);  
        
        
        
        
        
        
        
        /**
         * 
         * Last Minute Booking Hours
         */
        $this->add([
            'name' => 'package_last_minute_booking_hour[1]',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-last-minute-booking-hour',
                'placeholder' => 'Hour',
                'class' => 'form-control'
            ],
            'options' => [
                'label' => 'Hours',
            ],
         ]);  
        
        
        /**
         * 
         * Last Booking Date From
         */
        $this->add([
            'name' => 'package_last_booking_from[1]',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-last-booking-from_1',
                'class' => 'form-control text-uppercase datepicker date-valid-format',
                 'placeholder' => 'DD/MM/YYYY'
            ],
            'options' => [
                'label' => 'From<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
         /**
         * 
         *  Last Booking To
         */
        $this->add([
            'name' => 'package_last_booking_to[1]',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-last-booking-to_1',
                'placeholder' => 'DD/MM/YYYY',
                'class' => 'form-control text-uppercase datepicker date-valid-format'
            ],
            'options' => [
                'label' => 'To Date',
            ],
         ]);  
        
        /**
         * 
         * Last Minute Booking Amount
         */
        $this->add([
            'name' => 'package_last_minute_booking_amount[1]',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-last-minute-booking-amount',
                'placeholder' => 'Amount',
                'class' => 'form-control'
            ],
            'options' => [
                'label' => 'Amount',
            ],
         ]);  
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        
         /**
         * 
         * Early Booking days
         */
        $this->add([
            'name' => 'early_booking_days[]',
            'type' => Text::class,
            'attributes' => [
                'id' => 'early-booking-days',
                'placeholder' => 'Days',
                'class' => 'form-control'
            ],
            'options' => [
                'label' => 'Days',
            ],
         ]);  
        
        
        /**
         * 
         * Early Booking Date From
         */
        $this->add([
            'name' => 'early_booking_from[]',
            'type' => Text::class,
            'attributes' => [
                'id' => 'early-booking-from_1',
                'class' => 'form-control text-uppercase datepicker date-valid-format',
                 'placeholder' => 'DD/MM/YYYY'
            ],
            'options' => [
                'label' => 'From<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
         /**
         * 
         *  Early Booking To
         */
        $this->add([
            'name' => 'early_booking_to[]',
            'type' => Text::class,
            'attributes' => [
                'id' => 'early-booking-to_1',
                'placeholder' => 'DD/MM/YYYY',
                'class' => 'form-control text-uppercase datepicker date-valid-format'
            ],
            'options' => [
                'label' => 'To Date',
            ],
         ]);  
        
        
        /**
         * 
         * Early Booking Amount
         */
        $this->add([
            'name' => 'early_booking_amount[]',
            'type' => Text::class,
            'attributes' => [
                'id' => 'early_booking_amount',
                'placeholder' => 'Amount',
                'class' => 'form-control'
            ],
            'options' => [
                'label' => 'Amount',
            ],
         ]);  
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        /**
         * 
         * Early Booking days
         */
        $this->add([
            'name' => 'package_early_booking_days[1]',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-early-booking-days',
                'placeholder' => 'Days',
                'class' => 'form-control'
            ],
            'options' => [
                'label' => 'Days',
            ],
         ]);  
        
        
        /**
         * 
         * Early Booking Date From
         */
        $this->add([
            'name' => 'package_early_booking_from[1]',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-early-booking-from_1',
                'class' => 'form-control text-uppercase datepicker date-valid-format',
                 'placeholder' => 'DD/MM/YYYY'
            ],
            'options' => [
                'label' => 'From<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
         /**
         * 
         *  Early Booking To
         */
        $this->add([
            'name' => 'package_early_booking_to[1]',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-early-booking-to_1',
                'placeholder' => 'DD/MM/YYYY',
                'class' => 'form-control text-uppercase datepicker date-valid-format'
            ],
            'options' => [
                'label' => 'To Date',
            ],
         ]);  
        
        
        /**
         * 
         * Early Booking Amount
         */
        $this->add([
            'name' => 'package_early_booking_amount[1]',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package_early_booking_amount',
                'placeholder' => 'Amount',
                'class' => 'form-control'
            ],
            'options' => [
                'label' => 'Amount',
            ],
         ]); 
        
        
        
        
        /**
         * 
         * Day Wish Discount
         */
        $this->add([
            'name' => 'dis_days[]',
            'type' => Text::class,
            'attributes' => [
                'id' => 'dis-day',
                //'placeholder' => 'Days',
                'class' => 'form-control'
            ],
            'options' => [
                'label' => 'Days',
            ],
         ]);  
        
        
        /**
         * 
         * Day Wish From
         */
    
     $this->add([
            'name' => 'day_wise_from[]',
            'type' => Text::class,
            'attributes' => [
                'id' => 'day-wise-from',
                'class' => 'form-control text-uppercase datepicker date-valid-format',
                 'placeholder' => 'DD/MM/YYYY'
            ],
            'options' => [
                'label' => 'From<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
     
       /**
         * 
         * Day Wish To
         */
    
     $this->add([
            'name' => 'day_wise_to[]',
            'type' => Text::class,
            'attributes' => [
                'id' => 'day-wise-to',
                'class' => 'form-control text-uppercase datepicker date-valid-format',
                 'placeholder' => 'DD/MM/YYYY'
            ],
            'options' => [
                'label' => 'From<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
     
     
      /**
         * 
         * Day Wise Discount Amount
         */
        $this->add([
            'name' => 'day_wise_discount_amount[]',
            'type' => Text::class,
            'attributes' => [
                'id' => 'day-wise-discount-amount',
                'placeholder' => 'Amount',
                'class' => 'form-control'
            ],
            'options' => [
                'label' => 'Amount',
            ],
         ]);  
        
        
        
        
        
        
        
        
        /**
         * 
         * Day Wish Discount
         */
        $this->add([
            'name' => 'package_dis_days[]',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-dis-day',
                //'placeholder' => 'Days',
                'class' => 'form-control'
            ],
            'options' => [
                'label' => 'Days',
            ],
         ]);  
        
        
        /**
         * 
         * Day Wish From
         */
    
     $this->add([
            'name' => 'package_day_wise_from[]',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-day-wise-from',
                'class' => 'form-control text-uppercase datepicker date-valid-format',
                 'placeholder' => 'DD/MM/YYYY'
            ],
            'options' => [
                'label' => 'From<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
     
       /**
         * 
         * Day Wish To
         */
    
     $this->add([
            'name' => 'package_day_wise_to[]',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-day-wise-to',
                'class' => 'form-control text-uppercase datepicker date-valid-format',
                 'placeholder' => 'DD/MM/YYYY'
            ],
            'options' => [
                'label' => 'From<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
     
     
      /**
         * 
         * Day Wise Discount Amount
         */
        $this->add([
            'name' => 'package_day_wise_discount_amount[]',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-day-wise-discount-amount',
                'placeholder' => 'Amount',
                'class' => 'form-control'
            ],
            'options' => [
                'label' => 'Amount',
            ],
         ]);  
        
        
        
        
        
        
        
        
        
        
        
        
        
        /**
         * 
         * Contract Rate Description
         */
        $this->add([
            'name' => 'contract_rate_desc',
            'text' => Textarea::class,
            'attributes' => [
                'id' => 'contract-rate-desc',
                'class' => 'form-control editor'
            ],
            'options' => [
                'label' => 'Description<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);        
        
        
        /**
         * 
         * Package Rate Highlights
         */
        $this->add([
            'name' => 'package_rate_desc[]',
            'text' => Textarea::class,
            'attributes' => [
                'id' => 'package-rate-desc',
                'class' => 'form-control editor'
            ],
            'options' => [
                'label' => 'Description<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);        
        
        
        
        
        
        
        
        
        
        

        
        $this->add([
            'name' => 'id',
            'type' => Hidden::class,
            'attributes' => [
                'id' => 'id'
            ],
        ]);
        
        /**
         * 
         * Normal Rate
         */
        $this->add([
            'name' => 'normal_rate',
            'type' => Checkbox::class,
            'attributes' => [
                'id' => 'normal-rate',
                'class' => 'form-control'                
            ],
            'options' => [
                'label' => 'Normal Rate<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        
        $this->add([
        'type' => Checkbox::class,
        'name' => 'normal_rate',
        'attributes' => [
            'id' => 'normal-rate',
            'class' => 'form-control', 
            'value' => 'Normal Rate'
            ],
        'options' => [
            'label' => 'A checkbox',
            'use_hidden_element' => false,
            'checked_value' => '1',
            'unchecked_value' => '0',
        ],
        ]);  
        
        /**
         * 
         * Contract Rate
         */
        $this->add([
            'name' => 'package_rate',
            'type' => Checkbox::class,
            'attributes' => [
                'id' => 'package-rate',
                'class' => 'form-control',                
            ],
            'options' => [
                'label' => 'Package Rate<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        

        /**
         * 
         * Save
         */
        $this->add([
            'name' => 'submit',
            'type' => Submit::class,
            'attributes' => [
                'value' => 'Save',
                'id' => 'submit-button',
                'class' => 'btn btn-primary btn-lg',
            ],
        ]);
    }

    public function getInputFilterSpecification() {
        return [
            'hotel_id' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Select Hotel'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'category_id' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Select Room Category'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'room_type_id' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Select Room Type'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'facility_type_id' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Select Room Facility'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'name' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Enter Room Name'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'minimum_staying' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Enter Minimum Staying'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'maximum_adult' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Enter Maximum Adult'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'maximum_children' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Enter Maximum Children'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'extra_bed' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Enter Extra Bed'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
           
            'description' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Enter Description'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ]           
        ];
    }

}
