<?php

namespace Dashboard\Form;

use Zend\Form\Form;
use Zend\Form\Element\{
    Select,
    Date,
    Number,
    Checkbox,
    Text,
    Submit,
    Hidden,
    Textarea,
    Radio,
    File,
    Time
};
use Zend\Validator\{
    NotEmpty,
    Digits,
    EmailAddress
};
use Zend\InputFilter\InputFilterProviderInterface;

class HotelPaymentFeatureForm extends Form implements InputFilterProviderInterface {
    
    public static $hotel_list= [];
    public static $currenyList= [];
    public static $paymentOptionList= [];
    public static $facilityList= [];
    public static $sportsRecreationList= [];
    public static $extraHotelInfoList= [];
    
    public function __construct($name = null) {
        parent::__construct('hotel-payment-feature-form');
        
          /**
           * Allocation Tab
         */
        
        $this->add([
            'name' => 'hotel_id',
            'type' => Select::class,
            'attributes' => [
                'id' => 'payment-feature-hotel-id',
                'class' => 'form-control',
                'class' => 'selectpicker form-control',
                'data-show-subtext' => true,
                'data-live-search' => true,
            ],
            'options' => [
                'label' => 'Hotel Name <span style="color: red"> *</span>',
                'disable_inarray_validator' => true,
                'label_options' => ['disable_html_escape' => true],
                'empty_option' => '--Select Name--',
                'value_options' =>self::$hotel_list
            ],
        ]);
        
        
        /**         
         * Facility List
         */
        $this->add([
            'name' => 'facility_name_id',
            'type' => Select::class,
            'attributes' => [
                'id' => 'facility-name-id',
                'class' => 'demo-default select-state selectized form-control',
                'multiple' => 'multiple',
            ],
            'options' => [
                'label' => 'Facility<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true],
                'empty_option' => '--Select Name--',
                'value_options' =>self::$facilityList
            ],
        ]);
        
        /**         
         * Sports and Recreation List
         */
        $this->add([
            'name' => 'sports_recreation_id',
            'type' => Select::class,
            'attributes' => [
                'id' => 'sports-recreation-id',
                'class' => 'demo-default select-state selectized form-control',
                'multiple' => 'multiple',
            ],
            'options' => [
                'label' => 'Sports & Recreation<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true],
                'empty_option' => '--Select Name--',
                'value_options' =>self::$sportsRecreationList
            ],
        ]);
        
        /**         
         * Extra Info List
         */
        $this->add([
            'name' => 'extra_info_id',
            'type' => Select::class,
            'attributes' => [
                'id' => 'extra-info-id',
                'class' => 'demo-default select-state selectized form-control',
                'multiple' => 'multiple',
            ],
            'options' => [
                'label' => 'Extra Hotel Info<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true],
                'empty_option' => '--Select Name--',
                'value_options' =>self::$extraHotelInfoList
            ],
        ]);
        
        
        $this->add([
            'name' => 'currency',
            'type' => Select::class,
            'attributes' => [
                'id' => 'currency',
                'class' => 'form-control',
                'class' => 'selectpicker form-control',
                'data-show-subtext' => true,
                'data-live-search' => true,
            ],
            'options' => [
                'label' => 'Currency<span style="color: red"> *</span>',
                'disable_inarray_validator' => true,
                'label_options' => ['disable_html_escape' => true],
                'empty_option' => '--Select Name--',
                'value_options' =>self::$currenyList
            ],
        ]);
        
        /**         
         * Payment Option
         */
        $this->add([
            'name' => 'payment_option_id',
            'type' => Select::class,
            'attributes' => [
                'id' => 'payment-option-id',
                'class' => 'demo-default select-state selectized form-control',
                'multiple' => 'multiple',
            ],
            'options' => [
                'label' => 'Payment Option<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true],
                'empty_option' => '--Select Name--',
                'value_options' =>self::$paymentOptionList
            ],
        ]);
        
        /**
         * 
         * 
         * Allocation
         */
        $this->add([
            'name' => 'payment_description',
            'type' => Textarea::class,
            'attributes' => [
                'id' => 'payment-description',
                'class' => 'form-control editor'
            ],
            'options' => [
                'label' => 'Payment Description<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);       
       
        
        
        $this->add([
            'name' => 'id',
            'type' => Hidden::class,
            'attributes' => [
                'id' => 'id'
            ],
        ]);

        /**
         * 
         * Save
         */
        $this->add([
            'name' => 'submit',
            'type' => Submit::class,
            'attributes' => [
                'value' => 'Save',
                'id' => 'submit-button',
                'class' => 'btn btn-primary btn-lg',
            ],
        ]);
    }

    public function getInputFilterSpecification() {
        return [
            'hotel_id' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Select Hotel'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'currency' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Select Currency'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'facility_name_id' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Select Facility'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'sports_recreation_id' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Select Sports & Recreation'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'extra_info_id' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Select Extra Hotel Info'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'payment_option_id' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Select Payment Option'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'payment_description' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Enter Payment Description'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ]           
        ];
    }

}
