<?php
namespace Dashboard\Form;

use Zend\Form\Form;
use Zend\Form\Element\{
    Select,
    File,
    Text,
    Date,
    Radio,
    Submit,
    Checkbox,
    Email,
    Hidden,
    Textarea
};
use Zend\Validator\{
    NotEmpty,
    Digits,
    EmailAddress,
    StringLength
};
use Zend\InputFilter\InputFilterProviderInterface;

class HotelMetaTagForm extends Form implements InputFilterProviderInterface {
     public static $hotel_list= [];
   

    public function __construct($name = null) {

        parent::__construct('hotel-meta-tag-form');
        
          $this->setAttribute('method', 'post');
          
          
         /**
           * Allocation Tab
         */
        
        $this->add([
            'name' => 'hotel_id',
            'type' => Select::class,
            'attributes' => [
                'id' => 'metatag-hotel-id',
                'class' => 'form-control',
                'class' => 'selectpicker form-control',
                'data-show-subtext' => true,
                'data-live-search' => true,
            ],
            'options' => [
                'label' => 'Hotel Name <span style="color: red"> *</span>',
                'disable_inarray_validator' => true,
                'label_options' => ['disable_html_escape' => true],
                'empty_option' => '--Select Name--',
                'value_options' =>self::$hotel_list
            ],
        ]);
        
  
        
      
        /**
         * 
         * Tours

         */
         $this->add([
            'name' => 'realted_tours',
            'type' => Select::class,
            'attributes' => [
                'id' => 'realted-tours',
                'placeholder' => 'tours',
                'class' => 'demo-default input-tags selectized form-control',
                'multiple' => 'multiple',
            ],
            'options' => [
                'label' => 'Select Related tours <span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true],
                'empty_option' => '--Select tours--',
                'value_options' => [
                    '1' => '3-Day Bus Tour to Washington D.C. , Philadelphia, Niagara Falls from New York',
                    '2' => 'Amazing Madhabkunda waterfall',
                    '3' => 'Darjeeling Tour Packages',
                    '4' => 'East Coast US from Washington D.CSpots',
                    '5' => 'Enticing Bali',
                    '6' => 'Essence of Kashmir and Ladakh Tour',
                    '7' => 'Grand Canyon Railway Adventure Package',
                    '8' => 'Independent 3-Day Trip to Liverpool including the Beatles Story Experience',
                    '9' => 'Kuala Lumpur &amp; Penang Wonder',
                    '10' => 'Lalbagh fort Tour'
                ]
            ],
        ]);



        /**
         * Brochure Title
         */
        
        $this->add([
            'name' => 'brochure_title',
            'type' => Text::class,
            'attributes' => [
                'id' => 'brochure-title',
                'placeholder' => 'Brochure title',
                'class' => 'form-control inputchange'
            ],
            'options' => [
                'label' => 'Brochure Title<span style="color: red">*</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        /**
         * Brochure Description
         */
        
        $this->add([
            'name' => 'brochure_description',
            'type' => Textarea::class,
            'attributes' => [
                'id' => 'brochure-description',
                'placeholder' => 'Brochure description',
                'class' => 'form-control editor'
            ],
            'options' => [
                'label' => 'Brochure Description<span style="color: red">*</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        /**
         * Meta Title
         */
        
        $this->add([
            'name' => 'meta_title',
            'type' => Text::class,
            'attributes' => [
                'id' => 'meta-title',
                'placeholder' => 'Meta title',
                'class' => 'form-control '
            ],
            'options' => [
                'label' => 'Meta Title<span style="color: red">*</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        /**
         * Meta Keywords
         */
        
        $this->add([
            'name' => 'meta_keywords',
            'type' => Text::class,
            'attributes' => [
                'id' => ' meta_keywords',
                'placeholder' => ' Meta keywords',
                'class' => 'form-control'
            ],
            'options' => [
                'label' => 'Meta Keywords <span style="color: red">*</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        /**
         * Meta Description
         */
        
        $this->add([
            'name' => 'meta_description',
            'type' => Textarea::class,
            'attributes' => [
                'id' => 'meta-description',
                'placeholder' => 'Meta description',
                'class' => 'form-control editor'
            ],
            'options' => [
                'label' => 'Meta Description<span style="color: red">*</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        $this->add([
            'name' => 'id',
            'type' => Hidden::class,
            'attributes' => [
                'id' => 'id'
            ],
        ]);
        
        
        /**
         *  Submit
         */
        
        $this->add([
            'name' => 'submit',
            'type' => Submit::class,
            'attributes' => [
                'id' => 'save',
                'placeholder' => 'save',
                'class' => 'btn btn-red defaultbtnsearch btn-warning',
                'value' => 'Save'
            ],
        ]);

          
    }
    public function getInputFilterSpecification() {
        return [
            'realted_tours' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Select tours'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],  
            
            'brochure_title' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Provide Brochure Title'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],  
            
            'brochure_description' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Provide Brochure Description'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],  
            
            'meta_keywords' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Provide Meta Keywords'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ], 
            
            'meta_title' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Provide Meta Title'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],  
            
            'meta_description' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Provide Meta Description'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],  
            
            ];
    }

}
