<?php

namespace Dashboard\Form;

use Zend\Form\Form;
use Zend\Form\Element\{
    Select,
    Date,
    Number,
    Checkbox,
    Text,
    Submit,
    Hidden,
    Textarea,
    Radio,
    File,
    Time
};
use Zend\Validator\{
    NotEmpty,
    Digits,
    EmailAddress
};
use Zend\InputFilter\InputFilterProviderInterface;

class HotelContactForm extends Form implements InputFilterProviderInterface {
    
    public static $hotel_list= [];

    public function __construct($name = null) {
        parent::__construct('hotel-contact-form');
        
          /**
           * Contact Information Tab
         * Sightseeing Name
         */
        
        $this->add([
            'name' => 'hotel_id',
            'type' => Select::class,
            'attributes' => [
                'id' => 'hotel-id',
                'class' => 'form-control',
                'class' => 'selectpicker form-control',
                'data-show-subtext' => true,
                'data-live-search' => true,
            ],
            'options' => [
                'label' => 'Hotel Name <span style="color: red"> *</span>',
                'disable_inarray_validator' => true,
                'label_options' => ['disable_html_escape' => true],
                'empty_option' => '--Select Name--',
                'value_options' =>self::$hotel_list
            ],
        ]);
        
        

       

        
        $this->add([
            'name' => 'id',
            'type' => Hidden::class,
            'attributes' => [
                'id' => 'id'
            ],
        ]);

        /**
         * 
         * Save
         */
        $this->add([
            'name' => 'submit',
            'type' => Submit::class,
            'attributes' => [
                'value' => 'Save',
                'id' => 'submit-button',
                'class' => 'btn btn-primary btn-lg',
            ],
        ]);
        
        /**
         * 
         * 
         * Sales Person Name
         */
        $this->add([
            'name' => 'sales_person_name',
            'type' => Text::class,
            'attributes' => [
                'id' => 'sales-person-name',
                'class' => 'form-control'
            ],
            'options' => [
                'label' => 'Sales Person Name',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        /**
         * 
         * 
         * Reservation Person Name
         */
        $this->add([
            'name' => 'reservation_person_name',
            'type' => Text::class,
            'attributes' => [
                'id' => 'reservation-person-name',
                'class' => 'form-control'
            ],
            'options' => [
                'label' => 'Reservation Person Name',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        /**         
         * Sales Person Landline No
         */
        $this->add([
            'name' => 'sales_person_landline_no',
            'type' => Text::class,
            'attributes' => [
                'id' => 'sales-person-landline-no',
                'class' => 'form-control',
                'maxlength' => 15,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => 'Sales Landline No.',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        /**         
         * Reservation Person Landline No
         */
        $this->add([
            'name' => 'reservation_person_landline_no',
            'type' => Text::class,
            'attributes' => [
                'id' => 'reservation-person-landline-no',
                'class' => 'form-control',
                'maxlength' => 15,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => 'Reservation Landline No.',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
         /**         
         * Sales Person Mobile No
         */
        $this->add([
            'name' => 'sales_person_mobile_no',
            'type' => Text::class,
            'attributes' => [
                'id' => 'sales-person-mobile-no',
                'class' => 'form-control',
                'maxlength' => 15,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => 'Sales Mobile No.',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        /**         
         * Reservation Person Mobile No
         */
        $this->add([
            'name' => 'reservation_person_mobile_no',
            'type' => Text::class,
            'attributes' => [
                'id' => 'reservation-person-mobile-no',
                'class' => 'form-control',
                'maxlength' => 15,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => 'Reservation Mobile No.',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        /**
         * 
         * 
         * SALES Email Address
         */
        $this->add([
            'name' => 'sales_person_email',
            'type' => Text::class,
            'attributes' => [
                'id' => 'sales-person-email',
                'class' => 'form-control'
            ],
            'options' => [
                'label' => 'Sales Email',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        /**
         * 
         * 
         * RESERVATION Person Email Address
         */
        $this->add([
            'name' => 'reservation_person_email',
            'type' => Text::class,
            'attributes' => [
                'id' => 'reservation-person-email',
                'class' => 'form-control'
            ],
            'options' => [
                'label' => 'Reservation Email',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);       
        
    }

    public function getInputFilterSpecification() {
        return [
            'hotel_id' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Select Hotel'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'sales_person_name' => [
                'required' => false,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Enter Telephone'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'sales_person_landline_no' => [
                'required' => false,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Enter Telephone'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'sales_person_mobile_no' => [
                'required' => false,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Enter Telephone'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'sales_person_email' => [
                'required' => false,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Enter Telephone'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'reservation_person_name' => [
                'required' => false,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Enter Telephone'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'reservation_person_landline_no' => [
                'required' => false,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Enter Telephone'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'reservation_person_mobile_no' => [
                'required' => false,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Enter Telephone'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'reservation_person_email' => [
                'required' => false,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Enter Telephone'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
        ];
    }

}
