<?php

namespace Dashboard\Form;

use Zend\Form\Form;
use Zend\Form\Element;
use Zend\Form\Element\Select;
use Zend\Form\Element\File;
use Zend\Form\Element\Text;
use Zend\Form\Element\Radio;
use Zend\Form\Element\Submit;
use Zend\Form\Element\Checkbox;
use Zend\Form\Element\Email;
use Zend\Form\Element\Hidden;

class HotelCancellationFeesForm extends Form {

    public static $roomList= [];
    public static $vendorTypeList= [];
    public static $vendorNameList= [];
    public static $hotelRateTypeList= [];
    public static $hotelRateNameList= [];
    public static $cancellation_type = [];
    public static $booking_type = [];
    public static $hotel_list= []; 
    public static $currenyList= [];

     public function __construct($name = null) {

        parent::__construct('hotel-cancellation-fees');
        
        $this->setAttribute('method', 'post');
        
        $this->add([
            'name' => 'vendor_type',
            'type' => Select::class,
            'attributes' => [
                'id' => 'vendor-type',
                'class' => 'form-control',
                //'class' => 'selectpicker form-control',
                //'data-show-subtext' => true,
                //'data-live-search' => true,
            ],
            'options' => [
                'label' => 'Vendor Type <span style="color: red"> *</span>',
                'disable_inarray_validator' => true,
                'label_options' => ['disable_html_escape' => true],
                'empty_option' => '--Select Type--',
                'value_options' =>self::$vendorTypeList
            ],
        ]);
        
        /**         
         * Vendor Name
         */
        $this->add([
            'name' => 'vendor_name',
            'type' => Select::class,
            'attributes' => [
                'id' => 'vendor-name',
                'class' => 'form-control',
                //'class' => 'selectpicker form-control',
                //'data-show-subtext' => true,
                //'data-live-search' => true,
            ],
            'options' => [
                'label' => 'Vendor Name <span style="color: red"> *</span>',
                'disable_inarray_validator' => true,
                'label_options' => ['disable_html_escape' => true],
                'empty_option' => '--Select Vendor--',
                'value_options' =>self::$vendorNameList
            ],
        ]);
        
        $this->add([
            'name' => 'room_id',
            'type' => Select::class,
            'attributes' => [
                'id' => 'room-id',
                'class' => 'form-control',
                //'class' => 'selectpicker form-control',
                //'data-show-subtext' => true,
                //'data-live-search' => true,
            ],
            'options' => [
                'label' => 'Room <span style="color: red"> *</span>',
                'disable_inarray_validator' => true,
                'label_options' => ['disable_html_escape' => true],
                'empty_option' => '--Select Name--',
                'value_options' =>self::$roomList
            ],
        ]);
        
        $this->add([
            'name' => 'currency',
            'type' => Select::class,
            'attributes' => [
                'id' => 'currency',
                'class' => 'form-control',
                //'class' => 'selectpicker form-control',
                //'data-show-subtext' => true,
                //'data-live-search' => true,
            ],
            'options' => [
                'label' => 'Currency<span style="color: red"> *</span>',
                'disable_inarray_validator' => true,
                'label_options' => ['disable_html_escape' => true],
                'empty_option' => '--Select Name--',
                'value_options' =>self::$currenyList
            ],
        ]);
        
        $this->add([
            'name' => 'hotel_rate_name',
            'type' => Select::class,
            'attributes' => [
                'id' => 'hotel-rate-name',
                'class' => 'form-control',
                //'class' => 'selectpicker form-control',
                //'data-show-subtext' => true,
                //'data-live-search' => true,
            ],
            'options' => [
                'label' => 'Rate Name<span style="color: red"> *</span>',
                'disable_inarray_validator' => true,
                'label_options' => ['disable_html_escape' => true],
                'empty_option' => '--Select Rate Name--',
                'value_options' =>self::$hotelRateNameList
            ],
        ]);


        $this->add([
            'name' => 'cancellation_fees_id',
            'type' => Hidden::class,
          ]);
        
        $this->add([
            'name' => 'hotel_id',
            'type' => Hidden::class,
            'attributes' => [
                'id' => 'hotel-id'
            ],
        ]);
        
        $this->add([
            'name' => 'rate_type_id',
            'type' => Hidden::class,
            'attributes' => [
                'id' => 'rate-type-id'
            ],
        ]);


        /**
         *
         * cancellation fees
         */
          $this->add([
            'name' => 'cancellation_fees[]',
            'type' => Text::class,
            'attributes' => [
                'id' => 'cancellation_fees',
                'placeholder' => '150',
                'class' => 'form-control',
                'maxlength' =>5,
                'onkeypress'=>"return isNumber(event)"

            ],
            'options' => [
                'label' => 'Fees',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
          
           /**
         * 
         * Save
         */
        $this->add([
            'name' => 'submit',
            'type' => Submit::class,
            'attributes' => [
                'value' => 'Save',
                'id' => 'submit-button',
                'class' => 'btn btn-primary btn-lg',
            ],
        ]);


         /**
         *
         * save
         */
              $this->add([
            'name' => 'save',
            'type' => Submit::class,
            'attributes' => [
                'id' => 'cancellation-fees-btn',
                'placeholder' => 'Save',
                'value' =>'Save & Next',
                'class' => 'btn btn-primary btn-warning'
            ],

        ]);

          /**
         * From Date
         */
        $this->add([
            'name' => 'cancel_date_from',
            'type' => text::class,
            'attributes' => [
                'id' => 'cancel-date-from',
                'placeholder' => 'From Date',
                'class' => 'form-control datepicker',
                'readonly'=>true,
            ],
            'options' => [
                'label' => 'From Date',
            ],
        ]);


        /**
         * To Date (datepicker)
         */
        $this->add([
            'name' => 'cancel_date_to',
            'type' => text::class,
            'attributes' => [
                'id' => 'cancel-date-to',
                'placeholder' => 'To Date',
                'class' => 'form-control datepicker',
                'readonly'=>true,
            ],
            'options' => [
                'label' => 'To Date',
            ],
        ]);

        /**
         *
         * booking_type
         */
        $this->add([
            'name' => 'cancellation_master_id[]',
            'type' => Select::class,
            'attributes' => [
                'id' => 'cancellation-master-id',
                'placeholder' => '',
                'class' => 'form-control cancel-master'
            ],
            'options' => [
                'label' => 'Cancellation',
                'value_options' => self::$cancellation_type,
                'disable_inarray_validator' => true,
                'empty_option' => '--Select--',
            ],
        ]);

         /**
         *
         * booking_type
         */
        $this->add([
            'name' => 'cancellation_type[]',
            'type' => Select::class,
            'attributes' => [
                'id' => 'cancellation-type',
                'placeholder' => '',
                'class' => 'form-control'
            ],
            'options' => [
                'label' => 'Type',
                'value_options' => [
                    'Value' => 'Value',
                    '%' => '%'
                ],
                'disable_inarray_validator' => true,
                'empty_option' => '--Select--',
            ],
        ]);
        
        $this->add([
            'name' => 'booking_type',
            'type' => Select::class,
            'attributes' => [
                'id' => 'booking-type',
                'placeholder' => '',
                'class' => 'form-control',
                'data-show-subtext' => 'true',
                'data-live-search' => 'true'
            ],
            'options' => [
                'label' => 'Booking Type',
                'value_options' => self::$booking_type,
                'disable_inarray_validator' => true,
                'empty_option' => '--Select--',
            ],
        ]);

        /**
         *
         * booking_type
         */
        $this->add([
            'name' => 'cancel_booking_type[]',
            'type' => Select::class,
            'attributes' => [
                'id' => 'cancel-booking-type',
                'placeholder' => '',
                'class' => 'form-control',
                'data-show-subtext' => 'true',
                'data-live-search' => 'true'
            ],
            'options' => [
                'label' => 'Booking Type',
                'value_options' => self::$booking_type,
                'disable_inarray_validator' => true,
                'empty_option' => '--Select--',
            ],
        ]);
        
         /**
         *
         * booking_type
         */
        $this->add([
            'name' => 'waiting_booking_type[]',
            'type' => Select::class,
            'attributes' => [
                'id' => 'waiting-booking-type',
                'placeholder' => '',
                'class' => 'form-control',
                'data-show-subtext' => 'true',
                'data-live-search' => 'true'
            ],
            'options' => [
                'label' => 'Booking Type',
                'value_options' => self::$booking_type,
                'disable_inarray_validator' => true,
                'empty_option' => '--Select--',
            ],
        ]);
        
         /**
         *
         * booking_type
         */
        $this->add([
            'name' => 'prewaiting_booking_type[]',
            'type' => Select::class,
            'attributes' => [
                'id' => 'prewaiting-booking-type',
                'placeholder' => '',
                'class' => 'form-control',
                'data-show-subtext' => 'true',
                'data-live-search' => 'true'
            ],
            'options' => [
                'label' => 'Booking Type',
                'value_options' => self::$booking_type,
                'disable_inarray_validator' => true,
                'empty_option' => '--Select--',
            ],
        ]);

  }
}