<?php

namespace Dashboard\Form;

use Zend\Form\Form;
use Zend\Form\Element;

use Zend\Form\Element\Select;
use Zend\Form\Element\File;
use Zend\Form\Element\Text;
use Zend\Form\Element\Radio;
use Zend\Form\Element\Submit;
use Zend\Form\Element\Checkbox;
use Zend\Form\Element\Email;

class FaremanagementFareSearchForm extends Form {
 
    public static $state =[];
    public static $city =[];
    public static $booking_type =[];
    public static $cab_type =[];
    
    public function __construct($name = null) {
        

        parent::__construct('profile-personal');

        $this->setAttribute('method', 'post');
        
        
        /**
         * 
         * Public Fare
         */
        $this->add([
            'name' => 'public_fare',
            'type' => Radio::class,
            'attributes' => [
                'id' => 'public-fare-id',  
                'placeholder' => '',
                
            ],
            'options' => [
                'label' => 'Public fare',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        
        /**
         * 
         * Clientwise Fare
         */
           $this->add([
            'name' => 'clientwise_fare',
            'type' => Radio::class,
            'attributes' => [
                'id' => 'client-wise-id',  
                'placeholder' => '',
               
            ],
            'options' => [
                'label' => 'Clientwise fare',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

           
           /**
         * 
         * State
         */
           $this->add([
            'name' => 'state',
            'type' => Select::class,
            'attributes' => [
                'id' => 'state-id',  
                'placeholder' => '',
                'class' => 'input form-control'
            ],
            'options' => [
                'label' => 'State',
                'value_options' => self::$state
            ],
        ]);
           
           /**
         * 
         * City
         */
            $this->add([
            'name' => 'city',
            'type' => Select::class,
            'attributes' => [
                'id' => 'city-id',  
                'placeholder' => '',
                'class' => 'input form-control'
            ],
            'options' => [
                'label' => 'City',
                'value_options' => self::$city
            ],
        ]);

             /**
         * 
         * Booking Type
         */
           $this->add([
            'name' => 'booking_type',
            'type' => Select::class,
            'attributes' => [
                'id' => 'booking-type-id',  
                'placeholder' => '',
                'class' => 'input form-control'
            ],
            'options' => [
                'label' => 'Booking Type<span style="color: red"> *</span>',
                'value_options' => self::$booking_type
            ],
        ]);

            /**
         * 
         * Cab Type
         */
           $this->add([
            'name' => 'cab_type',
             'type' => Select::class,
            'attributes' => [
                'id' => 'booking-id',  
                'placeholder' => '',
                'class' => 'input form-control'
            ],
            'options' => [
                'label' => 'Cab Type<span style="color: red"> *</span>',
                'value_options' => self::$cab_type
            ],
        ]);
           
           /**
         * 
         * Active
         */
            $this->add([
            'name' => 'active',
             'type' => radio::class,
            'attributes' => [
                'id' => 'active-id',  
                'placeholder' => '',
                
            ],
            'options' => [
                'label' => 'Active',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
            
            
            /**
         * 
         * De-Active
         */
            $this->add([
            'name' => 'de_active',
             'type' => Radio::class,
            'attributes' => [
                'id' => 'de-active-id',  
                'placeholder' => '',
                
            ],
            'options' => [
                'label' => 'De-active',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

         /**
         * 
         * reset
         */
         $this->add([
            'name' => 'fare_search__reset',
            'type' => Submit::class,
            'attributes' => [
                'id' => 'fare-search-reset-id',    
                'placeholder' => 'reset',
                'class' => 'reset_btn btn btn-success btn-new-vehile',
            ],
           
        ]);
         
         /**
         * 
         * search
         */
         $this->add([
            'name' => 'fare_search_submit',
            'type' => Submit::class,
            'attributes' => [
                'id' => 'fare_search-submit-id',    
                'placeholder' => 'Search',
                'class' => 'publish_all btn btn-orange btn-warning',
            ],
            
        ]);
        
        
    }

}
