<?php

namespace Dashboard\Form;

use Zend\Form\Form;
use Zend\Form\Element\{
    Select,
    File,
    Text,
    Textarea,
    Date,
    Radio,
    Submit,
    Password,
    Checkbox,
    Email,
    Hidden
};
use Zend\InputFilter\InputFilterProviderInterface;
use Zend\Validator\{
    NotEmpty,
    Digits,
    StringLength,
    EmailAddress
};
use Zend\Validator\File\Size;

class CronForm extends Form implements InputFilterProviderInterface {
    
    public function __construct($name = null) {

        parent::__construct('cron-form');
        $this->setAttribute('method', 'post');

        /**
         * Payment Ref No
         */
        $this->add([
            'name' => 'name',
            'type' => Text::class,
            'attributes' => [
                'id' => 'name',
                'placeholder' => 'Name',
                'class' => 'form-control inputchange'
            ],
            'options' => [
                'label' => 'Name',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

     
        /**
         * Remark/Request
         */
        $this->add([
            'name' => 'description',
            'type' => Textarea::class,
            'attributes' => [
                'id' => 'description',
                'placeholder' => '',
                'class' => 'form-control'
            ],
            'options' => [
                'label' => 'Description<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

       


        /**
         * Search
         */
        $this->add([
            'name' => 'id',
            'type' => Hidden::class,
        ]);

      
       /**
         *
         * save
         */
        $this->add([
            'name' => 'submit',
            'type' => Submit::class,
            'attributes' => [
                'id' => 'submit',
                'placeholder' => 'Save',
                'class' => 'btn btn-primary pull-right',
                'Value' => 'Save',
            ],
        ]);
    }

    public function getInputFilterSpecification() {
        return [
            'name' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please enter Name'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'description' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please enter Description'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ]
        ];
    }

}
